<?php

/**
 * Class object_watcher_core
 *
 * Creates and handles watchers for actions done on any object
 */
class ObjectWatcherCore
{
    public function __construct()
    {
        // Load all watchers here
        //$this->loadWatcher("ClassName");
        $this->loadWatcher("WaybillWatcher");

    }

    /**
     * @param string $objectCode Object reference code
     * @param string|int $objectId Object ID
     * @param string $newStatus Object new status
     * @return void
     */
    public function createWatcher($objectCode, $objectId, $newStatus){
        // Switch on objects types
        switch (strtoupper($objectCode)){
            case "WAYBILL":
                (new WaybillWatcher())->createWatcher($objectId, $newStatus);
                break;
        }
        //@todo Log the watcher creation
    }

    /**
     * @param string $objectCode Object reference code
     * @param string|int $objectId Object ID
     * @param string $newStatus Object new status (ACTION)
     * @return string
     * @throws Exception
     */
    public function handleWatcher($objectCode, $objectId, $newStatus){
        // Switch on objects types
        switch (strtoupper($objectCode)){
            case "WAYBILL":
                return (new WaybillWatcher())->handleWatcher($objectId, $newStatus);

        }
        throw new Exception("No handler was defined for the object code $objectCode");
    }

    /**
     * @param string $objectCode Object reference code
     * @param string|int $objectId Object ID
     * @param string $newStatus Object new status (ACTION)
     * @return bool true if validator pass
     */
    public function validate($objectCode, $objectId, $newStatus){
        // Switch on objects types
        switch (strtoupper($objectCode)){
            case "WAYBILL":
                return (new WaybillWatcher())->validate($objectId, $newStatus);
        }

        return false;
    }


    /**
     * Required a watcher in the class
     * @param string $watcherClassName ClassName without the extension (.php)
     */
    private function loadWatcher($watcherClassName){
        require_once(dirname(__FILE__) . "/watchers/". $watcherClassName .".php");
    }

}