<?php

// import required classes
require_once (dirname(__FILE__)."/notification_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../user/user_core.php");

 
class Notification_interface extends API{

    private $_request = array();
    private $_notificationCore;

    public function __construct(){
        
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();      

        // init the object
        $this->_notificationCore = new NotificationCore();
 
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    
    // -------------------------------------------------------------------------------------- //
    // --------------------- save google notification token in user bean -------------------- //
    // --------------------- subscribe to personal topic ------------------------------------ //
    // -------------------------------------------------------------------------------------- //
    function saveNotificationToken(){

        $userCore = new UserCore();

        if(!$_SESSION['user_id']){
            throw new Exception("Invalid Session");    
        }

        // get the user bean
        $userBean = $userCore->getUserBasic($_SESSION['u_id'],$_SESSION['user_id']);

        // prepare the phone info array
        $phone_array = $userBean->phone_array[0];

        $phone_info = new stdClass();
        $phone_info = $userCore->generatePhoneArrayObject($phone_array->imei,
                                                          $phone_array->phone,
                                                          $phone_array->email,
                                                          $phone_array->verification_method,
                                                          $this->_request->token,
                                                          $_SESSION['user_id']);

        $userBean->phone_array = $phone_info;

        // update the phone array
        $userCore->updateUserInfo($userBean, $_SESSION['u_id'], $_SESSION['user_id']);
        
        try {
            // insert record in user_notification
            $userCore->insertNotificationRecord($userBean->id,$this->_request->token,'ACTIVE');
        } catch (Exception $e) {}
        

        // subscribe to personal topic
        // $result  = $this->_notificationCore->subscribeToTopic($this->_request->token, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

// -------------------------------------------------------------------------------------- //
    // --------------------- save google notification token in user bean -------------------- //
    // --------------------- subscribe to personal topic ------------------------------------ //
    // -------------------------------------------------------------------------------------- //
    function subscribeToTopic(){

        try{


            $userCore = new UserCore();

            // get the user bean
            $userBean = $userCore->getUserBasic($_SESSION['user_id'],$_SESSION['user_id']);

            // prepare the phone info array
            $phone_array = $userBean->phone_array[0];

            $phone_info = new stdClass();
            $phone_info = $userCore->generatePhoneArrayObject($phone_array->imei,
                                                            $phone_array->phone,
                                                            $phone_array->email,
                                                            $phone_array->verification_method,
                                                            $this->_request->token,
                                                            $_SESSION['user_id']);

            $userBean->phone_array = $phone_info;

            // update the phone array
            $userCore->updateUserInfo($userBean, $_SESSION['user_id'], $_SESSION['user_id']);

            // subscribe to personal topic
            $result  = $this->_notificationCore->subscribeToTopic($this->_request->token, 'all');

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
            parent::response($Result);
        }catch(Exception $e){

        }
    }

    // -------------------------------------------------------------------------------------- //
    // --------------------- unsubscribe from Topic for web/mobile client ----------------------- //
    // -------------------------------------------------------------------------------------- //
    function unsubscribeFromTopic(){
        $result  = $this->_notificationCore->unsubscribeFromTopic($this->_request->token, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------ //
    // --------------------- get subscription info for a certain token -------------------------- //
    // ------------------------------------------------------------------------------------------ //
    function getSubscriptionInfo(){
        $result  = $this->_notificationCore->getSubscriptionInfo($this->_request->token);
        parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // --------------------- TODO: REMOVE THIS API send notification to web/mobile client by sending to topic-------------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    function sendNotification(){

        $payload = $this->_request->payload;
        $payload = json_decode($payload);

        $result  = $this->_notificationCore->sendNotification($this->_request->user_id,
                                                              $this->_request->title,
                                                              $this->_request->msg,
                                                              $payload);
        parent::response($result);
    }


    // ------------------------------------------------------------------------------------------------------------------- //
    // --------------------- TODO: REMOVE THIS API send Data notification to web/mobile client  -------------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    function sendDataNotification(){

        $type = $this->_request->type;
        $user_id = $this->_request->user_id;

        switch ($type) {
            case 'logout':
            $payload = new stdClass();
            $payload->user_id = $user_id;
            $payload->type = "logout";
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'get_GPS_location':
            $payload = new stdClass();
            $payload->type = "get_GPS_location";
            $payload->user_id = $user_id;
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'HB':
            $payload = new stdClass();
            $payload->type = "HB";
            $payload->user_id = $user_id;
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'refresh_config':
            $payload = new stdClass();
            $payload->type = "refresh_config";
            $payload->user_id = $user_id;
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'refresh_userProfile':
            $payload = new stdClass();
            $payload->type = "refresh_userProfile";
            $payload->user_id = $user_id;
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'set_notification':
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = 1;
            $payload->message = "set_notification message";
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;

        case 'set_sticky_notification':
            $payload = new stdClass();
            $payload->type = "set_sticky_notification";
            $payload->id = 1;
            $payload->message = "set_sticky_notification message";
            $this->_notificationCore->sendDataMessage($user_id,$payload);
            break;
        }
    }

}

$notification_interface = new Notification_interface();

