<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php"); 
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../taskQueues/taskQueues_core.php");

class NotificationCore {

    public function __construct(){
        DBConnection::getInstance();
    } 

    // ------------------------------------------------------------------ //
    // --------------------- subscribe to topic-------------------------- //
    // ------------------------------------------------------------------ //
    function subscribeToTopic($token, $user_id){

        // if($user_id == 'all' || $user_id == 'all_dev'){
        //     $topic_name = $user_id;
        // }else{
        //     // hash the user_id
        //     $topic_name = hash('md5' , $user_id);
        // }

        // //FCM subscribe API end-point
        // $url = 'https://iid.googleapis.com/iid/v1/'.$token.'/rel/topics/'.$topic_name;

        // //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
        // $server_key = 'AAAAbYW4JPc:APA91bFrO3WcyPRzA20RYO902d3stEqFlJlbZfSOrbiitBU4Wh_eS2HU4RN9ytbdQ4vPiaLWkqS5uzjkbSc3UfVZQ4B0dOmEOcUg-6kd58--VJCOU5KnVNtH0dKrXwP7a4n8D3HMC-c7';
        // //header with content_type api key
        // $headers = array(
        //     'Content-Type:application/json',
        //     'Authorization: key=' . $server_key,
        //     'Content-Length: 0'
        // );

        // //CURL request to route notification to FCM connection server (provided by Google)
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // $result = curl_exec($ch);
        // if ($result === FALSE) {
        //     // sending notification is failed
        // }

        // curl_close($ch);

        // return $result;
    }


    // ---------------------------------------------------------------------- //
    // --------------------- unsubscribe from topic-------------------------- //
    // ---------------------------------------------------------------------- //
    function unsubscribeFromTopic($token,$user_id){
        // // hash the user_id
        // $topic_name = hash('md5' , $user_id);

        // //FCM subscribe API end-point
        // $url = 'https://iid.googleapis.com/iid/v1:batchRemove';

        // //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
        // $server_key = 'AAAAbYW4JPc:APA91bFrO3WcyPRzA20RYO902d3stEqFlJlbZfSOrbiitBU4Wh_eS2HU4RN9ytbdQ4vPiaLWkqS5uzjkbSc3UfVZQ4B0dOmEOcUg-6kd58--VJCOU5KnVNtH0dKrXwP7a4n8D3HMC-c7';
        // //header with content_type api key
        // $headers = array(
        //     'Content-Type:application/json',
        //     'Authorization: key=' . $server_key
        // );

        // $json_data = [
        //     "to" => "/topics/".$topic_name,
        //     "registration_tokens" => [$token]
        // ];
        // $data = json_encode($json_data);

        // //CURL request to route notification to FCM connection server (provided by Google)
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        // $result = curl_exec($ch);
        // if ($result === FALSE) {
        //     // sending notification is failed
        //     echo('fail');
        // }

        // curl_close($ch);

        // return $result;
    }

    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- send notification to web/mobile client by sending to topic-------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    function sendNotification($user_id, $title, $body, $payload){

        // $topic_name = hash('md5' , $user_id);

        // $json_data = [
        //     "to" => "/topics/".$topic_name,
        //     "notification" => [
        //         "body" => $body,
        //         "title" => $title,
        //         "icon" => ''
        //     ],
        //     "data" => $payload
        // ];

        // $data = json_encode($json_data);
        // //FCM API end-point
        // $url = 'https://fcm.googleapis.com/fcm/send';
        // //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
        // $server_key = 'AAAAbYW4JPc:APA91bFrO3WcyPRzA20RYO902d3stEqFlJlbZfSOrbiitBU4Wh_eS2HU4RN9ytbdQ4vPiaLWkqS5uzjkbSc3UfVZQ4B0dOmEOcUg-6kd58--VJCOU5KnVNtH0dKrXwP7a4n8D3HMC-c7';
        // //header with content_type api key
        // $headers = array(
        //     'Content-Type:application/json',
        //     'Authorization:key='.$server_key
        // );
        // //CURL request to route notification to FCM connection server (provided by Google)
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        // $result = curl_exec($ch);
        // if ($result === FALSE) {
        //     // sending notification is failed
        // }

        // curl_close($ch);

        // return $result;
    }

    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- query to get the reg-ids of the receipents and split them to arrays of 1000, then -- //
    // --------------------- push each packet of 1000 to task queue --------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    function broadcastNotification($title, $body){

        // init
        $taskQueuesCore = new TaskQueuesCore();

        // prepare message
        $payload = new stdClass();
        $payload->type = "set_notification";
        $payload->id = 1;
        $payload->title = $title;
        $payload->message = $body;

        // get all users with notification_token
        $db_query = "
                    SELECT
                    id,
                    JSON_UNQUOTE(JSON_EXTRACT(phone_array, '$[0].notification_token')) notification_token
                FROM
                    waybill.user
                WHERE
                    JSON_UNQUOTE(JSON_EXTRACT(phone_array, '$[0].notification_token')) != ''
                    ";

        $result =  DBConnection::runDatabaseQuery($db_query);

        // loop on all recipients to extract tokens
        $fullRegistration_ids = [];
        foreach ($result as $recipient) {
            array_push($fullRegistration_ids,$recipient->notification_token);
        }

        // split array to multi arrays each 100 at max, because task queue size cant be larger than 100KB at the time of writing this code
        $chunk_reg_array = array_chunk($fullRegistration_ids,100);

        foreach ($chunk_reg_array as $registration_ids) {
           // push the 1000 reg_id to system notification queue
           $taskQueuesCore->creatSystemNotificationTask($registration_ids,$payload);
        }
    }

    // ------------------------------------------------------------------------------------------ //
    // --------------------- get subscription info for a certain token -------------------------- //
    // ------------------------------------------------------------------------------------------ //
    function getSubscriptionInfo($token){

        //  //FCM subscribe API end-point
        //  $url = 'https://iid.googleapis.com/iid/info/'.$token.'?details=true';


        //  //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
        //  $server_key = 'AAAAbYW4JPc:APA91bFrO3WcyPRzA20RYO902d3stEqFlJlbZfSOrbiitBU4Wh_eS2HU4RN9ytbdQ4vPiaLWkqS5uzjkbSc3UfVZQ4B0dOmEOcUg-6kd58--VJCOU5KnVNtH0dKrXwP7a4n8D3HMC-c7';
        //  //header with content_type api key
        //  $headers = array(
        //      'Content-Type:application/json',
        //      'Authorization: key=' . $server_key ,
        //      'Content-Length: 0'
        //  );

        //  //CURL request to route notification to FCM connection server (provided by Google)
        //  $ch = curl_init();
        //  curl_setopt($ch, CURLOPT_URL, $url);
        //  curl_setopt($ch, CURLOPT_POST, true);
        //  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        //  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        //  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //  $result = curl_exec($ch);
        //  if ($result === FALSE) {
        //      // sending notification is failed
        //  }

        //  curl_close($ch);

        //  return $result;

    }


    // ----------------------------------------------------------------------------------- //
    // --------------------- Send Data Message to single device -------------------------- //
    // ----------------------------------------------------------------------------------- //
    function sendDataMessage($user_id, $payload , $notification=null){

        //get the token from user
        $userCore = new UserCore();

        // get the user bean
        $userBean = $userCore->getUserBasic($user_id,0);
        $phone_array = $userBean->phone_array[0];

        if(!isset($phone_array->notification_token)){
            $phone_array->notification_token = $userCore->getUserToken($user_id);
        }

        if(isset($phone_array->notification_token)){
            $token = $phone_array->notification_token;
            $registration_ids = [$token];

            $json_data = [
                "registration_ids" => $registration_ids,
                "notification" => $notification,
                "data" => $payload
            ];
 
            $data = json_encode($json_data);
            //FCM API end-point
            $url = 'https://fcm.googleapis.com/fcm/send';

            //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
            $server_key = 'AAAA9frkPno:APA91bG21Duxxl7WAYqOfAfCsDbrn3R3rsg4ZMk7xkWu5hBYSOt9UiJgMBYCWRpjJWaPOZ9ijO-_8XkSOxtOHUP6IKIl5aM3irAQzsDrFlNTI_xYHqezrr2W9OD25k2n3dd9MSEN_peL';

            //header with content_type api key
            $headers = array(
                'Content-Type:application/json',
                'Authorization:key='.$server_key
            );
            //CURL request to route notification to FCM connection server (provided by Google)
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $result = curl_exec($ch);

            if ($result === FALSE) {
                // sending notification is failed
            }

            curl_close($ch);

            return $result;
        }

    }



}