<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/add_notes_core.php");
require_once (dirname(__FILE__)."/../waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../queue/queue_core.php");


class Add_notes_interface extends API{
    
    // the request of each call
    private $_request = array();
    private $_add_notes_core;
    private $_waybillCore;
    private $_queueCore;

    public function __construct(){
        
        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();
        
        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the object
        $this->_add_notes_core = new Add_notes_core();
        $this->_waybillCore = new WaybillCore();
        $this->_queueCore = new QueueCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ----------------------------------------------------------------------- //
    // --------------------- add notes on a certain object ------------------- //
    // ----------------------------------------------------------------------- //
    public function add_notes(){
 
        $tableName = $this->_request->table_name;
        $object_id = $this->_request->id;
        $notes = $this->_request->notes;
 
        $this->_add_notes_core->addNotes($tableName, $object_id, $notes , $_SESSION['user_id'] );

        if($tableName=="waybill"){
            $this->_waybillCore->logActivity($object_id,
                "إضافة شروحات",
                $notes ,
                "ADD_NOTES", $_SESSION['u_id'] );
        }
        if($tableName=="queue"){
            $this->_queueCore->logActivity($object_id,
                "إضافة شروحات",
                $notes ,
                "ADD_NOTES", $_SESSION['u_id'] );
        }
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "NOTES.SUCCESS_OPERATION";
        parent::response($Result);

       
    }
}

$add_notes_interface = new Add_notes_interface();
