<?php 

class TokenValidator {

    static $projectId = "waybill-system";

    public static function validateToken($idTokenString){

        $url = "https://us-central1-waybill-system.cloudfunctions.net/validateToken";
        $data = array("idToken" => $idTokenString);
 
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data, '', '&') );
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($result);      

        if($result->decodedToken){

            if($result->decodedToken->phone_number){
                $google_result['login_method'] = "phone_number";
                $google_result['phone_number'] = $result->decodedToken->phone_number;
                return $google_result;
            }
            if($result->decodedToken->email){
                $google_result['login_method'] = "email";
                $google_result['email'] = $result->decodedToken->email;
                return $google_result;
            }
        }
        else{
             return TokenValidator::validateToken_socialFirebase($idTokenString);
            //throw new Exception("LOGIN.INAVLID_ID_TOKEN",500);
        }
    }


    // this method validates the token using the old project (social)
    public static function validateToken_socialFirebase($idTokenString){

        $url = "https://europe-west1-minagate-social.cloudfunctions.net/validateToken";
        $data = array("idToken" => $idTokenString);

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data, '', '&') );
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($curl);
        curl_close($curl);
 
        $result = json_decode($result);

        if($result->decodedToken){

            if($result->decodedToken->phone_number){
                $google_result['login_method'] = "phone_number";
                $google_result['phone_number'] = $result->decodedToken->phone_number;
                return $google_result;
            }
            if($result->decodedToken->email){
                $google_result['login_method'] = "email";
                $google_result['email'] = $result->decodedToken->email;
                return $google_result;
            } 
        }
        else{
            throw new Exception("LOGIN.INAVLID_ID_TOKEN",500);
        }
    }
}