<?php
 
require_once (dirname(__FILE__)."/login_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../company_employee/company_employee_core.php");
include_once (dirname(__FILE__).'/QR_Authenticator/src/FixedBitNotation.php');
include_once (dirname(__FILE__).'/QR_Authenticator/src/GoogleAuthenticator.php');

class Login_interface extends API{

    // the request of each call
    private $_request = array();
    private $_loginCore;
    private $_userCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        // init thr loginCore object
        $this->_loginCore = new LoginCore();
        $this->_userCore = new UserCore();
        $this->_company_employee = new CompanyEmployeeCore();
 
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ------------------------------------------------------------------------ //
    // --------------------- logout the user and clear the IMIE --------------- //
    // ------------------------------------------------------------------------ //
    public function logoutUser(){

        try{
            session_start();

            $this->_loginCore->logoutUser($_SESSION);

            // Unset all of the session variables.
            $_SESSION = array();

            // If it's desired to kill the session, also delete the session cookie.
            // Note: This will destroy the session, and not just the session data!
            if (ini_get("session.use_cookies")) {
                $params = session_get_cookie_params();
                setcookie(session_name(), '', time() - 42000,
                    $params["path"], $params["domain"],
                    $params["secure"], $params["httponly"]
                );
            }

            // Finally, destroy the session.
            session_destroy();

            $Result['MESSAGE'] = "LOGOUT.SUCCESSFUL";
            $Result['SESSION'] = $_SESSION;
            parent::response($Result);

        }catch(Exception $e) {
            throw $e;
        }

    }



    // ------------------------------------------------------------------------ //
    // --------------------- gather Ip info of the user session --------------- //
    // ------------------------------------------------------------------------ //
    private function getIpAddressInfo(){
        //step1
        $cSession = curl_init(); 
        //step2
        curl_setopt($cSession,CURLOPT_URL,"https://ipinfo.io/".$_SERVER['REMOTE_ADDR']."/json");
        curl_setopt($cSession,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($cSession,CURLOPT_HEADER, false); 
        //step3
        $result=curl_exec($cSession);
        //step4
        curl_close($cSession);
        //step5
        return (json_decode($result));
       
    }


    // ------------------------------------------------------------ //
    // --------------------- Generate Login QR code --------------- //
    // ------------------------------------------------------------ //
    public function generateLoginQR(){

        $g = new \Google\Authenticator\GoogleAuthenticator();

        session_start();
        $secret = $this->_request->uuid;
        $code = $g->getCode($secret);
        $base64 = $g->getURL($code, 'minagate.com', $secret);

        $Result['image'] = $base64;
        parent::response($Result);
    }

    // ------------------------------------------------------------ //
    // --------------------- validate Login QR code --------------- //
    // ------------------------------------------------------------ //
    public function validateLoginQR(){

        $g = new \Google\Authenticator\GoogleAuthenticator();

        $check_this_code = $this->_request->code;
        $secret = $this->_request->secret;
        $idToken = $this->_request->refresh_token;

        if ($g->checkCode($secret, $check_this_code)) {

            // send idToken to ws_id
            $url = 'http://misc.minagate.com:3000/sendMessage?id='.$secret.'&msg='.$idToken."&type=id_token";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = curl_exec($ch);
            curl_close($ch);

            $Result['ERRORCODE'] = "200";
            $Result['MESSAGE'] = "LOGIN.SUCCESS";
            parent::response($Result);

        } else {

            $msg = "expire_QR";
            $url = 'http://misc.minagate.com:3000/sendMessage?id='.$secret.'&msg='.$msg."&type=expire_QR";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = curl_exec($ch);
            curl_close($ch);

            $Result['ERRORCODE'] = "500";
            $Result['MESSAGE'] = "LOGIN.INVALID_QR_LOGIN";
            parent::response($Result);

        }
    }

    // --------------------------------------------------------------------------------------------------------------------------------------- //
    // --------------------- Swicth user profile by creating new session in database and re-init session in memory --------------------------- //
    // --------------------------------------------------------------------------------------------------------------------------------------- //
    public function switchProfile(){

        // get incoming params
        $company_id = $this->_request->company_id;
        $user_id = $this->_request->user_id;
        if(!$company_id && !$user_id){
            throw new Exception("company_id or user_id is required");            
        }

        // get old session info
        $oldSession = parent::getSession($_SESSION['user_id']);         
        
        if(!$oldSession){
            throw new Exception("Invalid session");            
        }

        // if user want the indevudual profile
        if($user_id){
            // init session record
            $initSession = new stdClass();
            $initSession->user_id = $_SESSION['u_id'];
            $session_id = parent::initPersonalSession($initSession);

            $profile = $this->_userCore->getUserProfile($_SESSION['user_id'],$user_id);     
            $profile['session_id'] = $session_id;
            parent::fillUserSession($profile);

        }else {

            // do noting in this case
            // if($_SESSION['company_id'] == $company_id){
            //     $Result=[];
            //     $Result['ERRORCODE'] = '0';
            //     $Result['MESSAGE'] = 'SESSION.SUCCESS_OPERATION';
            //     parent::response($Result);
            //     die;
            // }

            // get employee company profile to fill in session
            $u_id = $_SESSION['u_id'] ;      

            $profile = $this->_company_employee->searchCompanyEmployeeProfile($company_id, $u_id , $_SESSION['user_id']);

            // create new session record in database
            $initSessionObj = new stdClass();
            $initSessionObj->details = new stdClass();
            $initSessionObj->details->type = "corporate";
            $initSessionObj->details->ca_id = $profile['ca_info']->id;         
            $initSessionObj->details->company_id = $company_id;
            $initSessionObj->details->pa_id =$profile['pa_info']->id;         
            $initSessionObj->details->sa_id =$profile['sa_info']->id;
            $initSessionObj->details->co_id =$profile['co_info']->id;
            $initSessionObj->details->company_name = $profile['tc_info']->name;
            $initSessionObj->details->truck_owner_id = $profile['truck_owner_info']->id;
            $initSessionObj->details->company_employee_id = $profile['company_employee_info']->id;
            $initSessionObj->details->trucking_company_id = $profile['tc_info']->id;
            $initSessionObj->details->id = $profile['user_info']->id; 
            $initSessionObj->token = $oldSession->google_token;
            $initSessionObj->phone = $oldSession->phone_number;
            $initSessionObj->email = $oldSession->email;

            $session_id = parent::initCorporateSession($initSessionObj);
            $profile['session_id'] = $session_id;

            // fill session object
            parent::fillCompanySession($profile);
        }

        if(!$profile){
            throw new Exception("Invalid company");            
        }

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'SESSION.SUCCESS_OPERATION';
        parent::response($Result);
    }
}

$login_interface = new Login_interface();

