<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php"); 
require_once (dirname(__FILE__)."/tokenValidator.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../login/login_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");

class LoginCore {
 
    public function __construct(){
        DBConnection::getInstance();
    } 

    // ------------------------------------------------------------------------ //
    // --------------------- Attemp to log in the user ------------------------ //
    // ------------------------------------------------------------------------ //
    function loginUser($imei="",$sim_id="",$brand="", $idTokenString){


        DBConnection::startTransaction();

            //validate the token with google , then get the user phone or email from it
            $user_identifier = TokenValidator::validateToken($idTokenString);
            $userCore = new UserCore();
            
            // in case user logged in using mobile number
            if($user_identifier['login_method'] == "phone_number"){

                $phone = $user_identifier['phone_number'];

                // search for the user record localy using (phone)                               
                $searchFilter = [['key'=>'phone','val' => $phone ]                            ];
                $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System User

                // if no user is found register new one
                if ($searchUserResult->found_rows == 0) {

                    // prepare data
                    $phone = convertToInternational($phone);
                    $sim_id =  $sim_id ? $sim_id : 0;
                    $imei = $imei ?  $imei : 0;
                    $brand = $brand ?  $brand : 0;
                    $email = "";
                    $verification_method= "GOOGLE";
                    $token = "";

                    // prepare phone_array object
                    $phone_info = new stdClass();
                    $phone_info = $userCore->generatePhoneArrayObject($imei,$phone,$email, $verification_method, $token);

                    // create new user
                    $userBean = new stdClass();
                    $userBean->phone_array = $phone_info;
                    $user_id = $userCore->registerNewUser($userBean,0);

                }else{

                    // if user exists in DB, update its phone_array object with new fresh data, because its data is cleared when logged out
                    // but keep data that does not change like email, token
                    $userQry = $searchUserResult->data[0];
                    $phoneInfo = json_decode($userQry->phone_array)[0];
                    if (property_exists($phoneInfo, "email")){$email = $phoneInfo->email;}else{ $email = ""; }
                    if (property_exists($phoneInfo, "token")){$token = $phoneInfo->token;}else{ $token = ""; }
                    if (property_exists($phoneInfo, "integration_token")){$token = $phoneInfo->integration_token;}else{ $token = ""; }

                    $verification_method = 'GOOGLE';

                    // validate if user is allowed to login
                    $USER_ROLES = $userQry->role;
                    $userStatus = $userQry->status;

                    DBConnection::has_authority($userQry->id,'USER','LOGIN',$userStatus,$userStatus);
                
                    // build phone_array object
                    $phone_info = new stdClass();
                    $phone_info = $userCore->generatePhoneArrayObject($imei, $phone, $email, $verification_method, $token);

                    // save the new data in user table
                    $user_id = $userQry->id;
                    $userBean = new stdClass();
                    $userBean->phone_array = $phone_info;
                    $userBean->user_id = $user_id;
                    $userCore->updateUserInfo($userBean,$userBean->user_id,0);
                }
                // create struct with user Info
                $userInfo['user_id'] = $user_id;
                $userInfo['phone_number'] = $phone;
            }

            // this login method is for minagate users only
            if($user_identifier['login_method'] == "email"){

                // search for the user record localy using (email)
                $email = $user_identifier['email'];
 
                $searchFilter = [['key'=>'phone_array','val' => $email ,'op' => 'like']];
                $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System User

                if ($searchUserResult->found_rows > 0) {

                    // extract user data
                    $userQry = $searchUserResult->data[0];

                    // keep the integration token
                    $phoneInfo = json_decode($userQry->phone_array)[0];
                    if (property_exists($phoneInfo, "integration_token")){$token = $phoneInfo->integration_token;}else{ $token = ""; }
                    $verification_method = "GOOGLE";

                    // build phone_array object
                    $phone_info = new stdClass();
                    $phone = convertToInternational($searchUserResult->data[0]->phone);
                    $imei = $imei ?  $imei : 0;

                    $phone_info = $userCore->generatePhoneArrayObject($imei, $phone, $email, $verification_method, $token);

                    // save the new data in user table
                    $user_id = $userQry->id;
                    $userBean = new stdClass();
                    $userBean->phone_array = $phone_info;
                    $userBean->user_id = $user_id;
                    $userCore->updateUserInfo($userBean,$userBean->user_id,0);
                    

                    // create struct with user Info
                    $userInfo['user_id'] = $userQry->id;
                    $userInfo['email'] = $email;
                    $userInfo['name'] = $userQry->name;
                    $userInfo['phone_number'] = $userQry->phone;
                    
                }else{
                    throw new Exception("طريقة الدخول بواسطة الايميل متوفرة فقط لموظفي Minagate");
                }

            }

            DBConnection::commitTransaction();
            return $userInfo;
    }

    // ------------------------------------------------------------------------ //
    // --------------------- logout the user and clear the IMIE --------------- //
    // ------------------------------------------------------------------------ //
    function logoutUser($session){

        // search for user
        $user_id = $session['u_id'];
        $searchFilter = [['key'=>'id','val' => $user_id ,'op' => '=']];
        $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System 
        
        // extract phone info
        $userQry = $searchUserResult->data[0];
        $phoneInfo = json_decode($userQry->phone_array)[0];

        // clear IMIE and token
        $userObj = new UserCore();
        $phoneBean = new stdClass();
        $phoneBean->imei = "";
        $phoneBean->notification_token = "";
        $phoneBean->sim = $phoneInfo->sim;
        $phoneBean->phone = $phoneInfo->phone;
        if (property_exists($phoneInfo, "verification_method")){
            $phoneBean->verification_method = $phoneInfo->verification_method;
        }
        if($phoneInfo->email){
            $phoneBean->email = $phoneInfo->email;
        }
        if($phoneInfo->integration_token){
            $phoneBean->integration_token = $phoneInfo->integration_token;
        }
        if($phoneInfo->company_id){
            $phoneBean->company_id = $phoneInfo->company_id;
        }

        $userBean = new stdClass();
        $phone_array[0] = $phoneBean;
        $userBean->phone_array = json_decode(json_encode($phone_array)) ;
        $userBean->user_id = $userQry->id;
 

        try{
            $userObj->updateUserInfo($userBean,$user_id,0);

            // end session record in database
            $sqlQuery = "update session set end_session = now() where id = ?";
            $param = [$session['id']];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery,$param);

        }
        catch (Exception $e) {
            // if key not found, do nothing and continue
        }
        
    }

}

?>