<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/location_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");

require_once(dirname(__FILE__) . "/../../includes/Captions.php");

class Location_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_locationCore;
    private $_userCore;
    private $_tenderCore;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // init the object
        $this->_locationCore = new LocationCore();
        $this->_userCore = new UserCore();
        $this->_tenderCore = new TenderCore();
        

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter
    private function prepareFilter()
    {
        $locationFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                $tempArr = ['key' => $key, 'val' => $value];
                array_push($locationFilter, $tempArr);
            }
        }
        return $locationFilter;
    }

    // -------------------------------------------------------------- //
    // --------------------- get Location info----------------------- //
    // -------------------------------------------------------------- //
    public function getLocation()
    {
        // get the location info
        $locationBean = $this->_locationCore->getLocation($this->_request->id, $_SESSION['user_id']);

        parent::response($locationBean);
    }

    // ---------------------------------------------------- //
    // -------------------Create new location ------------- //
    // ---------------------------------------------------- //
    public function create()
    {

        //parse incoming params
        $name = $this->_request->name;
        $parent_id = $this->_request->parent_id;

        // call the super create
        $this->_locationCore->create($name, $parent_id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "LOCATION.SUCCESSFULL_OPERATION";
        parent::response($Result, 200);
    }



    // ------------------------------------------------------------------------------- //
    // --------------------- get list of locations based on search filter --------------- //
    // ------------------------------------------------------------------------------- //
    public function searchLocation()
    {
        $filter = $this->prepareFilter();
        // call the core search
        $location_qry = $this->_locationCore->searchLocation($filter, 1000, $this->_request->offset, $_SESSION['user_id']);

        foreach ($location_qry->data as &$location) {
            if ($location->parent_id == null) {
                $location->radius = 200000;
            } else {
                $location->radius = 2000;
            }
        }
        parent::response($location_qry);
    }


    // ------------------------------------------------------------------------------------ //
    // --------------------- get list of available users (location based roles) ----------- //
    // ------------------------------------------------------------------------------------ //
    public function locationUserAutoComplete()
    {

        $search_value = convertToInternational($this->_request->search_value);

        // search for user
        $searchFilter = [['key' => 'phone', 'val' => $search_value]];
        $user_qry = $this->_userCore->searchUser($searchFilter, 1, 0, $_SESSION['user_id']);

        // filter the roles of the found user , only location based roles are allowed
        $isLocationBased = false;
        foreach ($user_qry->data as &$user) {
            $user_roles = explode(",", $user->role);
            if (in_array("GATE_OPERATOR", $user_roles) || in_array("LOCATION_OPERATOR", $user_roles)) {
                $isLocationBased = true;
            }
        }
        if (!$isLocationBased) {
            throw new Exception('LOCATION.USER_IS_NOT_LOCATION_BASED');
        }

        // get user current location
        foreach ($user_qry->data as $user) {
            $searchFilter = [['key' => 'user_id', 'val' => $user->id], ['key' => 'status', 'val' => 'ACTIVE']];
            $users_qry = $this->_locationCore->searchLocationUsers($searchFilter, 1000, $this->_request->offset, $_SESSION['user_id']);
            $currentLocationArr = [];
            foreach ($users_qry->data as $userLocation) {
                array_push($currentLocationArr, $userLocation->location_id);
            }
            $user->current_location_id = $currentLocationArr;
        }
        parent::response($user_qry);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of users defined on certain location ----------- //
    // ------------------------------------------------------------------------------- //
    public function searchLocationUsers()
    {
        $filter = $this->prepareFilter();

        // call the core search
        $users_qry = $this->_locationCore->searchLocationUsers($filter, 1000, $this->_request->offset, $_SESSION['user_id']);

        foreach ($users_qry->data as &$user) {
            // get the user name and user roles
            $searchFilter = [['key' => 'id', 'val' => $user->user_id]];
            $user_qry = $this->_userCore->searchUser($searchFilter, 1, 0, $_SESSION['user_id'])->data[0];

            $user->name = $user_qry->name;
            $user->role = $user_qry->role;
        }
        parent::response($users_qry);
    }


    // --------------------------------------------------------------- //
    // --------------------- define user on a new location ----------- //
    // --------------------------------------------------------------- //
    public function addUserToLocation()
    {
        $user_id = $this->_request->user_id;
        $location_id = $this->_request->location_id;

        // validate if the user is already defined on the same location, throw error
        $searchFilter = [
            ['key' => 'user_id', 'val' => $user_id],
            ['key' => 'location_id', 'val' => $location_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $users_qry = $this->_locationCore->searchLocationUsers($searchFilter, 1000, $this->_request->offset, $_SESSION['user_id']);
        if ($users_qry->found_rows > 0) {
            throw new Exception('LOCATION.USER_ALREADY_ADDED');
        }

        // validate the new user is location based user
        $searchFilter = [['key' => 'id', 'val' => $user_id]];
        $user_qry = $this->_userCore->searchUser($searchFilter, 1, 0, $_SESSION['user_id']);
        $isLocationBased = false;
        foreach ($user_qry->data as &$user) {
            $user_roles = explode(",", $user->role);
            if (in_array("GATE_OPERATOR", $user_roles) || in_array("LOCATION_OPERATOR", $user_roles)) {
                $isLocationBased = true;
            }
        }
        if (!$isLocationBased) {
            throw new Exception('LOCATION.USER_IS_NOT_LOCATION_BASED');
        }

        // call the core add
        $this->_locationCore->addUserToLocation($user_id, $location_id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "LOCATION.SUCCESSFULL_OPERATION";
        $Result['ID'] = $this->_request->location_id;
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------- //
    // --------------------- remove user from a location ----------- //
    // ------------------------------------------------------------- //
    public function deactivateUserLocation()
    {
        $id = $this->_request->id;

        // call the core search
        $this->_locationCore->deactivateUserLocation($id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "LOCATION.SUCCESSFULL_OPERATION";
        $Result['ID'] = $id;
        parent::response($Result, 200);
    }

    // ----------------------------------------------------------------------------- //
    // --------------------- update GPS Coordinates for certain location ----------- //
    // ----------------------------------------------------------------------------- //
    public function updateLocationCoordinates()
    {

        $locationBean = new stdClass();
        $locationBean->longitude = $this->_request->longitude;
        $locationBean->latitude = $this->_request->latitude;

        $this->_locationCore->updateLocation(
            $locationBean,
            $this->_request->id,
            $_SESSION['user_id']
        );


        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "LOCATION.SUCCESSFULL_OPERATION";
        $Result['ID'] = $this->_request->id;
        parent::response($Result, 200);
    }


    // ----------------------------------------------------------------------- //
    // --------------------- SWearch for locations child locations ----------- //
    // ----------------------------------------------------------------------- //
    public function searchChildLocations()
    {

        $result = [];


        $locations = $this->_request->id;
        if ($locations == 91000000) { // 91000000=الأردن
            $locations = getJordanCities();
        }
        $locationsArr = explode(",", $locations);

        // loop on the request locations, and get its child locations
        foreach ($locationsArr as $location_id) {

            $locationBean = new stdClass();
            $childLocations = $this->_locationCore->searchChildLocations($location_id);

            // search childLocations to get the paranet
            $index = 0;
            foreach ($childLocations as $child) {
                if ($child->id == $location_id) {
                    $locationBean = $child;
                    unset($childLocations[$index]);
                    break;
                }
                $index++;
            }

            $childrens = [];
            foreach ($childLocations as $c) {
                $childrens[] = $c;
            }
            $locationBean->children = $childrens;
            array_push($result, $locationBean);
        }

        //return reponse
        if ($this->_request->id == 91000000) { // 91000000=الأردن
            $jordanObj = new stdClass();
            $jordanObj->id = 91000000;
            $jordanObj->value = 91000000;
            $jordanObj->label = "الأردن";
            $jordanObj->pId = 0;
            $jordanObj->children = $result;
            parent::response([$jordanObj], 200);
        } else {
            parent::response($result, 200);
        }
    }

    public function searchTendersLocations()
    {

        $filter = [];
        $tender_query = $this->_tenderCore->searchTender($filter, 100, 0, $_SESSION['user_id']);
        $tender_ids = [0];
        foreach ($tender_query->data as $tender) {
            $tender_ids[] = $tender->id;
        }
        $tender_ids = implode(",",$tender_ids);
        
        $locations = $this->_locationCore->searchLocationsBulk($tender_ids);

        foreach ($locations as &$raw) {
            $queues = json_decode($raw->queues);
            foreach ($queues as &$q) {
                $q->value = $q->id;
                $q->label = $q->name;
            }
            $raw->queues = json_encode($queues, JSON_UNESCAPED_UNICODE);

            $destinationOptions = json_decode($raw->destinations);
            if ($destinationOptions) {
                foreach ($destinationOptions as &$q) {
                    $q->value = $q->id;
                    $q->label = $q->name;
                }
            }

            $raw->destinations = json_encode($destinationOptions, JSON_UNESCAPED_UNICODE);
        }
        parent::response($locations);
    }
}


$location_interface = new Location_interface();
