<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");

class LocationCore {
    
    public function __construct(){
        DBConnection::getInstance();
    }

    // -------------------------------------------------------------------------- //
    // -------------------Create Location bean and fill it from DB  ------------- //
    // -------------------------------------------------------------------------- //
    public function getLocation($id,$user_id){
        
        $locationInfo = DBConnection::getObjectBean("location",$id,$user_id);
        return $locationInfo;
    }

    // -------------------------------------------------------------------------- //
    // -------------------Create Location bean and fill it from DB  ------------- //
    // -------------------------------------------------------------------------- //
    public function getLocationBasic($id,$user_id){

        $locationInfo = DBConnection::getBasicObjectBean("location",$id,$user_id);
        return $locationInfo;
    }

    // ---------------------------------------------------- //
    // -------------------Create new location ------------- //
    // ---------------------------------------------------- //
    public function create($name, $parent_id,$user_id){

        // generate the id of the new location by selecting the maximum id for the parent id child and increase it by 1
        $sqlQuery = " SELECT
                        max(id)+1 location_id
                    FROM
                        location
                    where parent_id = ?";

        $param = [$parent_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery,$param);

        // create the location
        $locationBean = new stdClass();
        $locationBean->id = $result[0]->location_id;
        $locationBean->name = $name;
        $locationBean->parent_id = $parent_id;
        $locationBean->longitude = 0;
        $locationBean->latitude = 0;
        $locationBean->status = "ACTIVE";

        $createLocationResult = DBConnection::insertDB("location",$locationBean,$user_id);

    }

    // -------------------------------------------------------------------------- //
    // -------------------Create Location bean and fill it from DB  ------------- //
    // -------------------------------------------------------------------------- //
    public function getBasicLocation($id,$user_id){

        $locationInfo = DBConnection::getBasicObjectBean("location",$id,$user_id);
        return $locationInfo;
    }


    // -------------------------------------------------------------------------- //
    // -------------------search for location using any search filter ----------- //
    // -------------------------------------------------------------------------- //
    public function searchLocation($searchFilter, $limit, $offset, $user_id, $order_by = null){

        $searchLocationResult = DBConnection::searchDB("location",$searchFilter, $limit, $offset,$user_id, $order_by);
        return $searchLocationResult;
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of users defined on certain location ----------- //
    // ------------------------------------------------------------------------------- //
    public function searchLocationUsers($searchFilter, $limit, $offset, $user_id, $order_by=null){

        $searchLocationResult = DBConnection::searchDB("user_location",$searchFilter, $limit, $offset,$user_id,$order_by);
        return $searchLocationResult;
    }





    // ------------------------------------------------------------- //
    // --------------------- remove user from a location ----------- //
    // ------------------------------------------------------------- //
    public function addUserToLocation($user_id, $location_id, $done_by){

        // insert new location for user
        $result = new stdClass();
        $result->user_id = $user_id;
        $result->location_id = $location_id;
        $result->updated_by = $done_by;
        $result->status = 'ACTIVE';

        $createTruckContractResult = DBConnection::insertDB("user_location",(object)$result,$done_by);
    }

    // ------------------------------------------------------------- //
    // --------------------- remove user from a location ----------- //
    // ------------------------------------------------------------- //
    public function deactivateUserLocation($user_location_id, $user_id){

        try{
            DBConnection::startTransaction();

            // change the end date
            $updateStruct = new stdClass();
            $updateStruct->id = $user_location_id;
            $updateStruct->end_date = DBConnection::getSystemDate();
            DBConnection::updateDB("user_location",$updateStruct,$user_id);

            // change the status
            $updateStruct = new stdClass();
            $updateStruct->id = $user_location_id;
            $updateStruct->status = 'INACTIVE';
            DBConnection::updateDB("user_location",$updateStruct,$user_id);

            DBConnection::commitTransaction();

        }catch(Exception $e){
            DBConnection::rollBackTransaction();
            throw $e;
        }

    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update location info in DB---------------------- //
    // ---------------------------------------------------------------------- //
    function updateLocation($locationBean,$location_id, $updated_by){

        // fill update struct and set the target user id
        $locationBean->id = $location_id;

        // get basic object bean without any activites
        $DB_Bean = $this->getBasicLocation($location_id,$updated_by);

        // map all the new values into the DB_bean
        $locationBean = mapBeanToDBBean($locationBean,$DB_Bean);

        // fill update struct and set the target user id
        DBConnection::updateDB("location",$locationBean,$updated_by);

    }


    // public function searchChildLocations($location_id){
    //     $pattern = '/(?=[0-9]{2}|[0-9]{4}|[0-9]{6})00(?=[0-9]{2}$|[0-9]{4}$|[0-9]{6}|$)/i';
    //     $replacement = '__';
    //     $baseLocationId = preg_replace($pattern, $replacement, $location_id);
    //     //
    //     // search database locations
    //     $searchFilter = [['key'=>'id','val' =>$baseLocationId, 'op'=>'like'],
    //                      ['key'=>'status','val' =>'ACTIVE' ]];
    //     $locationQry = $this->searchLocation($searchFilter,1000,0, 0);
    //     foreach ($locationQry->data as $location) {
    //         $location->value = $location->id;
    //         $location->label = $location->name;
    //         $location->pId = $location->parent_id;
    //     }
    //     return $locationQry->data;
    // }

    // ---------------------------------------------------------------------- //
    // --------------------- Search for locations child locations ----------- //
    // ---------------------------------------------------------------------- //
    public function searchChildLocations($location_id){

        // convert location_id to characters array
        $array  = array_map('intval', str_split($location_id));

        // reverese it
        $array  = array_reverse($array) ;
        $result = [];
        $startChunk = false;
        // start loop on array

        for ($i=0; $i < sizeOf($array); $i += 2){

            $number1 = $array[$i];
            $number2 = $array[$i+1];

            if($number1 == 0 && $number2 == 0){
                array_push($result,"__");
            }else{
                array_push($result,$number1);
                array_push($result,$number2);
            }
        }

        // reverese it back
        $result  = array_reverse($result) ;


        // convert array to string
        $baseLocationId = implode("",$result);

        // search database locations
        $searchFilter = [['key'=>'id','val' =>$baseLocationId, 'op'=>'like'],
                         ['key'=>'status','val' =>'ACTIVE' ]];

        $locationQry = $this->searchLocation($searchFilter,1000,0, 0);
        foreach ($locationQry->data as $location) {
            $location->value = $location->id;
            $location->label = $location->name;
            $location->pId = $location->parent_id;
        }
        return $locationQry->data;
    }

    public function searchLocationsBulk($tender_ids)
    {
        $Q = "  select  tender.id as tender_id ,
                CAST(tender.manifest->>'$.name' AS CHAR CHARSET UTF8) as tender_name,
                CAST(tender.manifest->'$.questionnaire[0].options' AS CHAR CHARSET UTF8) as destinations,
                CAST(tender.manifest->'$.queues' AS CHAR CHARSET UTF8) as queues
                from tender
                where    status = 'ACTIVE'
                and id in ($tender_ids);
            ";
        $result = DBConnection::runBindDatabaseQuery($Q, []);
 
        return $result;
    }
}