<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");


class LandtripCore
{

    private $_con;
    private $_userCore;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_con = new Container();
        $this->_userCore = new UserCore();

        $this->_htmlHeader = '<html>
    <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
    <head>
    <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
    <style>
        .MinagateFont {
            font-family: DroidArabicKufiRegular;
            font-weight: lighter;
            font-style: normal;
            color: #807d7d;
            font-size: 11px;
            margin-top: 22px;
        }
        .labelStyle {
            text-align: right;
            padding-right: 25px;
        }
        .headerStyle {
            text-align: right;
            padding-right: 25px;
            color: #97c666;
        }
        .valueStyle {
            text-align: right;
            color: rgb(74, 163, 222);
        }
        .divStyle {
            padding: 4px;
            border-bottom: solid 0.5px #ccc;
        }
        .financial-box{
            box-shadow: 0px 0px 3px #888888;
            padding: 12px;
            margin: 7px;
        }
    </style><link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css"></head>';
    }
    private function getIntegrationToken()
    {
        return '123';
    }

    private function curl($url, $fields, $method, $user_id)
    {

        if ($user_id == 0) {
            $user_id = 3;
        }

        $ch = curl_init();
        $fields->integration_token = $this->getIntegrationToken();
        $fields->session_id = $user_id;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result, 1);

        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }

    public function updateLandTrip($bl)
    {
    }

    public function getLandTrip($data, $user_id)
    {
        $url = Config::$con_url . "/landtrip";
        $data->method = "getLandTrip";
        // call the remote endpoint
        $response = $this->curl($url, $data, 'POST', $user_id);

        return  $response;
    }
    public function searchLandTrips($filters)
    {
    }
    public function changeStatusLandTrips($id, $new_status)
    {
    }


    // create discharge report
    public function createContainerDischargeReport($land_trip_id, $answers, $user_id)
    {

        // get landtrip bean
        $data = new stdClass();
        $data->id = $land_trip_id;
        $result = $this->_con->getLandTrip($data, 0);

        if (gettype($answers) == "string") {
            $answers = is_string($answers) ? json_decode($answers, true) : $answers;
        }

        $user =  $this->_userCore->getUserBasic($user_id, 0);
        $remarks = $answers[sizeof($answers) - 2]['value'];
        $attachments = [];
        foreach ($answers as $answer) {
            if (strpos($answer['value'], "storage.googleapis.com") !== false) {
                $attachments[] = $answer['value'];
            }
        }

        // save the discharge report
        $discharge_report = [
            "attachments" => $attachments,
            'remarks' => $remarks,
            'done_by' => $user_id,
            'done_by_name' => $user->name,
            'time_stamp' => DBConnection::getSystemDate()
        ];

 
        // save in landTrip
        $upd_data = new stdClass();
        $upd_data->id = $land_trip_id;
        $upd_data->discharge_report = $discharge_report;
        $result = $this->_con->updateLandTripBean($upd_data, 0);
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render crude oil waybill info   ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderContainerLandTrip($landtripBean)
    {

        $landtripBean->document = json_decode($landtripBean->document);


        $html = $this->_htmlHeader . '<body>
        <div class="MinagateFont">
          <form>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->declaration->ca->name . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : اسم المخلص
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' .  $landtripBean->document->container->iso . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : ISO
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->declaration->number . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : رقم الرحلة
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->carrier[0]->driver->name . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : اسم السائق
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->carrier[0]->driver->phone . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : رقم هاتف السائق
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->carrier[0]->truck->tn . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : رقم الشاحنة</label
              >
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->carrier[0]->trailer->tn . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : رقم المقطورة
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->container->cid . '</label
              >
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : رقم الحاوية</label
              >
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->origin->name . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : موقع التحميل
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->destination->name . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : موقع التفريغ
              </label>
            </div>
            <div class="form-group divStyle col-sm-12 col-xs-12 col-md-12">
              <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle">
                ' . $landtripBean->document->trip_type->caption . '
              </label>
              <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle">
                : نوع الرحلة
              </label>
            </div>            
          </form>
        </div>
      </body>

</html>';

        return $html;
    }
}
