<?php

require_once dirname(__FILE__) . "/../../core/waybill/waybill_core.php";
require_once dirname(__FILE__) . "/invoices_core.php";
require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/../../core/company/trucking_company/trucking_company_core.php";

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
class invoices_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_waybillCore;
    private $_invoicesCore;
    private $_truckingCompanyCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_waybillCore = new WaybillCore();
        $this->_invoicesCore = new invoices_core();
        $this->_truckingCompanyCore = new TruckingCompanyCore();

        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest()
    {

        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int) method_exists($this, $func) > 0) {
        $this->$func();
        } else {
            parent::response('Error code 404, method not found', 404);
    }
        // If the method not exist with in this class, response would be "Page not found".
    }

    private function callCURL($url)
    {
        $url = str_replace(' ', '', $url);
        // $url = urlencode($url);
        $ch = curl_init();

        $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
        curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER , false);

        $json = curl_exec($ch);
        curl_close($ch);

        return $json;

    }

    private function prepareFilter()
    {
        $invoicesFilter = [];

        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key' => $key, 'val' => $value];
                array_push($invoicesFilter, $tempArr);
            }
        }
        return $invoicesFilter;
    }

    public function getPDF()
    {
        $date = $this->_request->date;
        $company_id = $this->_request->company_id;
        if (!isset($date)) {
            throw new Exception("التاريخ غير محدد");
        }
        if (isset($company_id)) {
            //extract the month and year from date
            $dateArray = explode('-', $date);

            $invoiceYear = $dateArray[0];
            $invoiceMonth = $dateArray[1];
            // $fileContent=  $this->callCURL("https://storage.googleapis.com/minagate_config/CONTRACT_TYPES.json");
            $fileContent = base64_encode($this->callCURL("https://storage.googleapis.com/minagate_invoices/$invoiceYear/$invoiceMonth/$company_id/invoices-copy-test.pdf"));
            $result = new stdClass();
            $result->data=$fileContent;
            parent::response($result, 200);
        }
    }

    public function createInvoice()
    {

        $company_id = $this->_request->company_id;

        if (!$company_id) {
            throw new Exception('أسم الشركه غير محدد');
        }
        $date = json_decode($this->_request->filter, true)['date'];
        if (!isset($date)) {
            throw new Exception('الشهر غير محدد');
        }
        $tender_id = json_decode($this->_request->filter, true)['tender_id'];
        if (!isset($tender_id)) {
            throw new Exception('المشروع غير محدد');
        }

        //gets company name from id recieved in the request
        $companyFilter = [['key' => 'id', 'val' => $company_id]];
        $companyResult = $this->_truckingCompanyCore->searchTruckingCompany($companyFilter, 1, 0, $_SESSION['user_id']);
        $companyResult = $companyResult->data;

        //copy the invoice template and gets the id of the new file
        // 1gkHGzmU1Q_5mjnYMqiaId9REnTg_qNH7-kDDbndEKgw = id of the saved template
        // TODO: invoiceName must be generated by system
        $invoiceName = $this->_request->invoice_name;
        if (!isset($invoiceName)) {
            throw new Exception('اسم الفاتورة غير محدد');
        }

        $id = $this->_invoicesCore->copyFile("1gkHGzmU1Q_5mjnYMqiaId9REnTg_qNH7-kDDbndEKgw", $invoiceName);
        if (!isset($id)) {
            throw new Exception('spreadsheet id can not be generated');
        }


        //extract the date in format mm/yy and writes the date on the excel
        $range = "'cover'!E2"; // range = where to write on the sheet
        $dateArray = explode('-', $date);

        $invoiceYear = $dateArray[0];
        $invoiceMonth = $dateArray[1];
        $invoiceHeaderDate = $invoiceMonth . '/' . $invoiceYear;
        $value = [
            [$invoiceHeaderDate],
        ];
        // write the date in the cover page
        $this->_invoicesCore->writeData($id, $value, $range);

        //writes the company name on the excel
        $range = "'cover'!E4";
        $value = [
            [$companyResult[0]->name],
        ];
        $this->_invoicesCore->writeData($id, $value, $range);

        //TODO write invoice id to the excel
        // $range = "'cover'!E6";
        // $value = [
        //     ['453455'],
        // ];
        // $this->_invoicesCore->writeData($id, $value, $range);

        // create the report body data (waybills info)
        $data = [];
        $filter = $this->prepareFilter();
        $waybill_invoices = $this->_waybillCore->createWaybillInvoiceJson('', '', $filter);
        $waybill_invoices = $waybill_invoices->body;

        // loop on raw data, clean any empty data and generate array of array containing the data
        foreach ($waybill_invoices as $key => $value) {

            if (!isset($waybill_invoices[$key]->id)) {
                $waybill_invoices[$key]->id = '-';
            }
            if (!isset($waybill_invoices[$key]->wn)) {
                $waybill_invoices[$key]->wn = '-';
            }
            if (!isset($waybill_invoices[$key]->tn)) {
                $waybill_invoices[$key]->tn = '-';
            }
            if (!isset($waybill_invoices[$key]->driver)) {
                $waybill_invoices[$key]->driver = '-';
            }
            if (!isset($waybill_invoices[$key]->cargo)) {
                $waybill_invoices[$key]->cargo = '-';
            }
            if (!isset($waybill_invoices[$key]->destination)) {
                $waybill_invoices[$key]->destination = '-';
            }
            if (!isset($waybill_invoices[$key]->weight)) {
                $waybill_invoices[$key]->weight = '-';
            }

            array_push($data, [
                $waybill_invoices[$key]->id,
                $waybill_invoices[$key]->wn,
                $waybill_invoices[$key]->tn,
                $waybill_invoices[$key]->driver,
                $waybill_invoices[$key]->cargo,
                $waybill_invoices[$key]->origin,
                $waybill_invoices[$key]->destination,
                $waybill_invoices[$key]->weight,
            ]);
        }

        // write report body data in details page and save it
        $range = "'details'!A2";
        $this->_invoicesCore->writeData($id, $data, $range);

        // convert report to pdf then copy it from google drive into google pucket
        $invoicePath = "$invoiceYear/$invoiceMonth/$company_id/$invoiceName";
        $this->_invoicesCore->generatePDF($id, $invoicePath);

        // TODO: copy the pdf into any other index folders

        parent::response("تمت بنجاح", 200);
    }

}
$invoices_interface = new invoices_interface();
