<?php
require_once (dirname(__FILE__)."/../../vendor/autoload.php");

class invoices_core
{

    public function __construct()
    {
        $client = $this->getClient();
        $this->sheetService = new Google_Service_Sheets($client);
        $this->driveService = new Google_Service_Drive($client);
    }

    private function getClient()
    {
        $client = new Google_Client();
        $client->setApplicationName('Google Drive API PHP Quickstart');
        $client->setScopes(Google_Service_Drive::DRIVE, Google_Service_Sheets::SPREADSHEETS);

        $credintialPath = 'gs://minagate_config/credentials.json';
        $credintial_json = file_get_contents($credintialPath);
        $client->setAuthConfig($credintialPath);
        
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');

        // Load previously authorized token from a file, if it exists.

        $tokenPath = 'gs://minagate_config/token.json';
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            $client->setAccessToken($accessToken);
        }

        // If there is no previous token or it's expired.
        if ($client->isAccessTokenExpired()) {
            // Refresh the token if possible, else fetch a new one.
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            } else {
                // Request authorization from the user.
                $authUrl = $client->createAuthUrl();
                $authCode = trim(fgets(STDIN));

                // Exchange authorization code for an access token.
                $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
                $client->setAccessToken($accessToken);

                // Check to see if there was an error.
                if (array_key_exists('error', $accessToken)) {
                    throw new Exception(join(', ', $accessToken));
                }
            }
            // Save the token to a file.
            file_put_contents($tokenPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }


    public function generatePDF($fileId, $invoicePath)
    {
        // Get the API client and construct the service object.
        $service = $this->driveService;

        // get file as pdf
        $response = $service->files->export($fileId, 'application/pdf', array(
            'alt' => 'media'));
        $content = $response->getBody()->getContents();
        //write pdf to a file

        $reportPath = "gs://minagate_invoices/$invoicePath _" . rand() . '.pdf';
        file_put_contents($reportPath , $content);

        return $reportPath;
    }


    public function writeData($id, $values, $range)
    {
        $service = $this->sheetService;
        $values = $values;
        $range = $range;

        $body = new Google_Service_Sheets_ValueRange([
            'values' => $values,
        ]);
        $params = [
            'valueInputOption' => "USER_ENTERED",
        ];
        $result = $service->spreadsheets_values->update($id, $range,
            $body, $params);
    }

    public function copyFile($originFileId, $copyTitle)
    {
        try {
            $service = $this->driveService;
            $copiedFile = new Google_Service_Drive_DriveFile();
            $copiedFile->setName($copyTitle);
            $copy = $service->files->copy($originFileId, $copiedFile);
            return $copy['id'];
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        return null;
    }

}
