<?php
require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/invoice_core.php";

class Invoice_interface extends API
{
    private $_waybillCore;
    public function __construct()
    {
        // call the super constructur

        $this->_request = parent::__construct();
        $this->_invoiceCore = new InvoiceCore();
        $this->_waybillCore = new WaybillCore();
        // validate the session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }
    // ------------------------------------------------------------------------ //
    // -------------------   get Invoice bean   ------------------------------- //
    // ------------------------------------------------------------------------ //
    public function getInvoice()
    {
        try {
            //recive request
            $id = $this->_request->id;
            $result = $this->_invoiceCore->getInvoice($id, $_SESSION['user_id']);

            $result->invoice_date = date_format(date_create($result->invoice_date), "Y/m/d") . " - " .
                date_create($result->invoice_date)->format('Y/m/t');

            $Result = [];
            $Result['data'] = $result;
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Invoice bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function validateInvoice($bean)
    {

        if ($bean->details->beneficiary_name == null) {
            throw new Exception("الرجاء ادخال اسم المستفيد");
        }
        if ($bean->details->total_amount == null) {
            throw new Exception("الرجاء ادخال قيمة الفاتورة");
        }
        if ($bean->details->tender_id == null && $this->_request->invoice_type != 'FREE') {
            throw new Exception("الرجاء اختيار المشروع");
        }
    }
    public function getInvoiceType()
    {
        $result = [
            ['label' => 'فاتورة مستندات البواخر الشهرية', 'value' => 'VESSELLS_WAYBILL'],
            ['label' => 'فاتورة خدمات البواخر الشهرية', 'value' => 'VESSELLS_SERVICES'],
            ['label' => 'فاتورة خدمات التموين', 'value' => 'VESSELLS_GRANS_SERVICES'],
            ['label' => 'فاتورة انجاز الشهرية', 'value' => 'INJAZ_SERVICES'],
            ['label' => 'فاتورة الصرف الاكتروني للنفط الخام', 'value' => 'CRUDE_OIL_E_PAYMENT'],
            ['label' => 'فاتورة تسريب النفط الخام', 'value' => 'CRUDE_OIL_WAYBILLS'],
            ['label' => 'الفاتورة الشهرية للفيول', 'value' => 'FUEL_WAYBILLS'],
            ['label' => 'الفاتورة الشهرية لبرج الحياة', 'value' => 'BURJ_ALHAYAT_WAYBILLS'],
            ['label' => 'اخرى', 'value' => 'FREE'],

        ];
        $Result = [];
        $Result['data'] = $result;
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Invoice bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function createInvoice()
    {
        try {
            DBConnection::startTransaction();

            // validation if invoice exsist
            // if true and flage false throw exaption
            // if true and flage true change status to inactive
            if (gettype($this->_request->items) == "string") {
                $this->_request->items = json_decode($this->_request->items);
            }
            $filter = [];
            $invoice_type = ['key' => 'details->>"$.invoice_type"', 'val' => $this->_request->invoice_type];
            $invoice_date = ['key' => 'invoice_date', 'val' => $this->_request->invoice_date];
            $status = ['key' => 'status', 'val' => 'NEW'];
            array_push($filter, $invoice_type);
            array_push($filter, $invoice_date);
            array_push($filter, $status);
            $result = $this->_invoiceCore->searchInvoice($filter, 1000, 0, $_SESSION['user_id']);

            if (sizeof($result->data) > 0) {
                if ($this->_request->confirm == true) {
                    $bean = new stdClass();
                    $bean->status = 'INACTIVE';
                    $bean->id = $result->data[0]->id;
                    $this->_invoiceCore->changeStatus($bean, $_SESSION['user_id']);
                } else {
                    throw new Exception("the invoice already exist", 1);
                }
            }

            if ($this->_request->invoice_type == 'VESSELLS_WAYBILL') {
                //فاتورة مستندات البواخر الشهرية
                $bean = $this->getWaybillVessellsInvoiceDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'VESSELLS_SERVICES') {
                //فاتورة خدمات البواخر الشهرية
                $bean = $this->getVessellsServicesInvoiceDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'VESSELLS_GRANS_SERVICES') {

                //فاتورة خدمات التموين
                $bean = $this->getVessellsGransServicesInvoiceDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'INJAZ_SERVICES') {
                //فاتورة انجاز الشهرية
                $bean = $this->getInjazServicesInvoiceDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'CRUDE_OIL_E_PAYMENT') {
                // فاتورة الصرف الاكتروني للنفط الخام
                $bean = $this->getCrudeOilEPaymentDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'CRUDE_OIL_WAYBILLS') {
                //فاتورة تسريب النفط الخام
                $bean = $this->getCrudeOilWaybillDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'FUEL_WAYBILLS') {
                //فاتورة الفشهرية للفيول
                $bean = $this->getFuelWaybillDetails($this->_request->invoice_date);
            } else if ($this->_request->invoice_type == 'BURJ_ALHAYAT_WAYBILLS') {
                //الفاتورة الشهرية لبرج الحياة
                $bean = $this->getBurjAlhayatWaybillDetails($this->_request->invoice_date);
            } else {
                $bean = new stdClass();
                $details = new stdClass();
                $bean->details = $details;
                $bean->name = $this->_request->name;
                $bean->details->amount = $this->_request->amount;
                $bean->details->items = $this->_request->items;
                $invoice_amount = 0;
                foreach ($this->_request->items as $value) {
                    $invoice_amount += doubleval($value->total);
                }
                $bean->details->tax_amount = $this->_request->tax ? doubleval($this->_request->amount * 0.16) : 0;
                $bean->details->total_amount = $this->_request->amount + $bean->details->tax_amount;
                $bean->details->tender_name = $this->_request->tender_name ? $this->_request->tender_name : null;
                $bean->details->beneficiary_name = $this->_request->beneficiary_name;
                $bean->details->tender_id = $this->_request->tender_id ? $this->_request->tender_id : null;
                $bean->invoice_date = $this->_request->invoice_date;
                $bean->print_template = ['minagate_invoice'];
                $bean->details->confirm = $this->_request->confirm ? $this->_request->confirm : false;
                $bean->details->payment_method = $this->_request->payment_method;
                $bean->details->tax = $this->_request->tax;
                $bean->details->invoice_type = $this->_request->invoice_type;
                $bean->details->secandName = $this->_request->secandName;
                $bean->status = "NEW";
                $bean->serial_number = $this->generateSerialNumber();
            }
            //validate data in invoice
            $this->validateInvoice($bean);

            // add activity
            $bean->details->activity = [];
            $activity = new stdClass();
            $activity->u_id = $_SESSION['u_id'];
            $activity->notes = "انشاء فاتورة";
            $activity->action_code = "ADD_NOTE";
            $activity->activity_date = DBConnection::getSystemDate();
            $bean->details->activity[] = $activity;

            $result = $this->_invoiceCore->createInvoice($bean, $_SESSION['user_id']);
            DBConnection::commitTransaction();
            $Result = [];
            $Result['invoice_id'] = $result;
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }
    // ------------------------------------------------------------------------ //
    // ------------------- search Invoice bean -------------------------------- //
    // ------------------------------------------------------------------------ //
    public function searchInvoice()
    {
        $filter = $this->prepareFilter();
        $result = $this->_invoiceCore->searchInvoice($filter, 1000, 0, $_SESSION['user_id']);
        $Result = [];
        $Result["data"] = $result->data;
        $Result["found_rows"] = $result->found_rows;
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);
    }

    // ------------------------------------------------------------------------ //
    // ------------------- prepareFilter Invoice bean ------------------------- //
    // ------------------------------------------------------------------------ //

    private function prepareFilter()
    {
        $result = [];
        if ($this->_request->filter) {
            if (gettype($this->_request->filter) == 'string') {
                $filter = json_decode($this->_request->filter, true);
            } else {
                $filter = $this->_request->filter;
            }
            // dump(json_decode($this->_request->filter));
            // die;
            foreach ($filter as $key => $value) {

                if ($value) {
                    if ($key == 'invoice_type') {
                        $tempArr = ['key' => 'details->>"$.invoice_type"', 'val' => [$value], 'op' => 'in'];
                    } else
                    if ($key == 'serial_number') {
                        $tempArr = ['key' => 'serial_number', 'val' => $value];
                    } else
                    if ($key == 'tender_id') {
                        $tempArr = ['key' => 'details->>"$.tender_id"', 'val' => $value];
                    } else
                    if ($key == 'beneficiary_name') {
                        $tempArr = ['key' => 'details->>"$.beneficiary_name"', 'val' => $value, 'op' => 'like'];
                    } else if (strpos($value, ',') !== false) {
                        $valueArr = explode(",", $value);
                        $tempArr = ['key' => $key, 'val' => $valueArr, 'op' => 'in'];
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value, 'op' => '='];
                    }

                    array_push($result, $tempArr);
                }
            }
        }

        return $result;
    }

    // ------------------------------------------------------------------------ //
    // ------------------- generateSerialNumber Invoice bean ------------------ //
    // ------------------------------------------------------------------------ //

    public function generateSerialNumber()
    {
        $sqlQuery = "SELECT COUNT(id) + 1 as nextSerial
                FROM
                    waybill.invoice
                WHERE
                                YEAR(invoice_date) = YEAR(NOW());";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, []);

        $current_year = date("y");
        $newSerial = $current_year . "000" .  str_pad($result[0]->nextSerial, 2, "0", STR_PAD_LEFT);

        return $newSerial;
    }

    // ----------------------------------------------------------------------- //
    // ------------------- changeStatus Invoice bean ------------------------- //
    // ----------------------------------------------------------------------- //

    public function changeStatus()
    {
        try {
            $id = $this->_request->invoice_id;
            $result = $this->_invoiceCore->getInvoice($id, $_SESSION['user_id']);
            if (gettype($this->_request->remarks) == "string") {
                $this->_request->remarks = json_decode($this->_request->remarks);
            }

            if($this->_request->new_status == "INACTIVE"){
                $title = "الغاء فاتورة";
            }
            if($this->_request->new_status == "COMPLETE"){
                $title = "تسديد فاتورة";
            }

            $activity = $result->details->activity;
            $activity[] =
                [
                    'u_id' => $_SESSION['u_id'],
                    'activity_date' => DBConnection::getSystemDate(),
                    'notes' => $title . " - " . $this->_request->remarks,
                    'action_code' => 'ADD_NOTE'
                ];
            $bean = new stdClass();
            $bean->details = $result->details;

            $bean->status = $this->_request->new_status;
            $bean->id = $this->_request->invoice_id;
            $bean->details->activity = $activity;
            $this->_invoiceCore->changeStatus($bean, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ------------------- updateInvoice Invoice bean ------------------------- //
    // ----------------------------------------------------------------------- //

    public function updateInvoice()
    {
        try {
            $id = $this->_request->id;
            $bean = new stdClass();
            //todo
            //change details

            $result = $this->_invoiceCore->getInvoice($id, $_SESSION['user_id'])->details;
            $bean->details = $result;

            if ($this->_request->amount) {
                $bean->details->amount = $this->_request->amount;
            }
            if ($this->_request->beneficiary_name) {
                $bean->details->beneficiary_name = $this->_request->beneficiary_name;
            }
            if ($this->_request->name) {
                $bean->name = $this->_request->name;
            }
            if ($this->_request->print_template) {
                $bean->print_template = $this->_request->print_template;
            }
            $bean->id = $id;
            $this->_invoiceCore->updateInvoice($bean, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // -------------------------------------------------------------------------- //
    // -------------------getWaybillVessellsInvoiceDetails for Invoice  -------- //
    // -------------------------------------------------------------------------- //
    private function getWaybillVessellsInvoiceDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT
                    count(wn) as cnt ,
                    document->>'$.cargo[0].cargo.name' as cargo_name
                    FROM
                        waybill_view w
                    WHERE
                        status NOT IN ('INACTIVE' , 'REVOKED')
                            AND create_date >= ?
                            AND create_date < ? + INTERVAL 1 MONTH
                            AND tender_id = 3
                            AND EXISTS( SELECT
                                id
                            FROM
                                activity a
                            WHERE
                                w.id = a.waybill_id
                                    AND a.action_code = 'CHANGE_STATUS'
                                    AND a.object_status_code = 'NEW'
                                    AND a.object_new_status_code = 'APPROVED')
                    group by document->>'$.cargo[0].cargo.name'";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);

        $invoice_amount = 0;

        foreach ($result as $key) {
            $invoice_amount += $key->cnt * 1.25;
            $itemObject = new stdClass();
            $itemObject->name = "بدل تنظيم واصدار وتجهيز وثائق النقل ، " . $key->cargo_name;
            $itemObject->price = 1.25;
            $itemObject->total_price = 1.25 * $key->cnt;
            $itemObject->files = explode('.', strval($itemObject->total_price))[1] ? explode('.', strval($itemObject->total_price))[1] : '00';
            $itemObject->jd = explode('.', strval($itemObject->total_price))[0] ? explode('.', strval($itemObject->total_price))[0] : '00';

            $itemObject->number = $key->cnt;
            array_push($items, $itemObject);
        }

        $bean->details->items = $items;
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->tax_amount = 0;

        $bean->name = " فاتورة مستندات الشحن لشهر" .  date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = $invoice_amount;
        $bean->details->amount = $invoice_amount;
        $bean->details->tender_name = "البواخر";
        $bean->details->beneficiary_name = ' السادة شركة عدل للخدمات اللوجستية المحترمين';
        $bean->details->tender_id = 3;
        $bean->invoice_date = $invoice_date;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->payment_method = $this->_request->payment_method;

        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    // -------------------------------------------------------------------------- //
    // -------------------getVessellsServicesInvoiceDetails for Invoice  ------//
    // ------------------------------------------------------------------------ //
    private function getVessellsServicesInvoiceDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT
                    count(wn) as cnt
                    FROM
                        waybill_view w
                    WHERE
                        status NOT IN ('INACTIVE' , 'REVOKED')
                            AND create_date >= ?
                            AND create_date < ? + INTERVAL 1 MONTH
                            AND tender_id = 3
                            AND EXISTS( SELECT
                                id
                            FROM
                                activity a
                            WHERE
                                w.id = a.waybill_id
                                    AND a.action_code = 'CHANGE_STATUS'
                                    AND a.object_status_code = 'NEW'
                                    AND a.object_new_status_code = 'APPROVED')  ";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);
        $invoice_amount = 0;
        foreach ($result as $key) {
            $invoice_amount += $key->cnt;
            $itemObject = new stdClass();
            $itemObject->name = "بدل تقديم وثيقة نقل واصدار تصريح (عطاء البواخر + التصاريح الخارجية)";
            $itemObject->price = 1;
            $itemObject->number = $key->cnt;
            $itemObject->files = explode('.', strval($key->cnt))[1] ? explode('.', strval($key->cnt))[1] : '00';
            $itemObject->jd = explode('.', strval($key->cnt))[0] ? explode('.', strval($key->cnt))[0] : '00';
            array_push($items, $itemObject);
        }
        $bean->details->items = $items;
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->tax_amount = 0;
        $bean->name =  " فاتورة الخدمات لشهر" . date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = $invoice_amount;
        $bean->details->amount = $invoice_amount;
        $bean->details->tender_name = "البواخر";
        $bean->details->beneficiary_name = ' السادة شركة عدل للخدمات اللوجستية المحترمين';
        $bean->details->tender_id = 3;
        $bean->invoice_date = $invoice_date;
        $bean->details->payment_method = $this->_request->payment_method;

        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getVessellsGransServicesInvoiceDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT
                count(id) as cnt
                from waybill
                where
                tender_id = 13
                AND create_date >= ?
                AND create_date < ? + INTERVAL 1 MONTH
                AND status not in ('INACTIVE','REVOKED','REJECTED')";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);
        $itemObject = new stdClass();
        $itemObject->name = "بدل اصدار وثيقة نقل وتقديم تصريح (عطاء التموين)";
        $itemObject->price = 1;
        $itemObject->number = $result[0]->cnt;
        $itemObject->files = explode('.', strval($result[0]->cnt))[1] ? explode('.', strval($result[0]->cnt))[1] : '00';
        $itemObject->jd = explode('.', strval($result[0]->cnt))[0] ? explode('.', strval($result[0]->cnt))[0] : '00';
        $bean->details->items = [$itemObject];
        $bean->name = " فاتورة خدمات التموين لشهر" . date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = $result[0]->cnt;
        $bean->details->tender_name = "التموين";
        $bean->details->beneficiary_name = ' السادة شركة عدل للخدمات اللوجستية المحترمين';
        $bean->details->tender_id = 13;
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->payment_method = $this->_request->payment_method;
        $bean->details->tax_amount = 0;
        $bean->details->amount = $result[0]->cnt;

        $bean->invoice_date = $invoice_date;
        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getInjazServicesInvoiceDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT count(id) as cnt from waybill_draft where tender_id = 18 and create_date >= ? and create_date < ? + INTERVAL 1 MONTH and status not in ('INACTIVE','REVOKED','REJECTED')";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);
        $itemObject = new stdClass();
        $itemObject->name = " بدل تنظيم واصدار وتجهيز وثائق النقل";
        $itemObject->price = 1;
        $itemObject->number = $result[0]->cnt;
        $itemObject->files = explode('.', strval($result[0]->cnt))[1] ? explode('.', strval($result[0]->cnt))[1] : '00';
        $itemObject->jd = explode('.', strval($result[0]->cnt))[0] ? explode('.', strval($result[0]->cnt))[0] : '00';
        $bean->details->items = [$itemObject];
        $bean->name =  " فاتورة انجاز لشهر" .  date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = $result[0]->cnt;
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->payment_method = $this->_request->payment_method;
        $bean->details->tax_amount = 0;
        $bean->details->tender_name = "انجاز";
        $bean->details->beneficiary_name = 'السادة انجاز للخدمات اللوجستية المحترمين';
        $bean->details->tender_id = 18;
        $bean->invoice_date = $invoice_date;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->amount = $result[0]->cnt;

        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getCrudeOilEPaymentDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT count(id) as cnt from waybill where tender_id = 11 and create_date >= ? and create_date < ? + INTERVAL 1 MONTH and loading_date is not null";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);
        $amount = $result[0]->cnt * 2.8706898;
        $itemObject = new stdClass();
        $itemObject->name = " عمولة صرف أجور نقل نفط خام";
        $itemObject->price = 2.8706898;
        $itemObject->number = $result[0]->cnt;
        $itemObject->files = explode('.', strval($amount))[1] ? explode('.', strval(number_format($amount, 3)))[1] : 000;
        $itemObject->jd = explode('.', strval($amount))[0] ? explode('.', strval($amount))[0] : 000;
        $bean->details->items = [$itemObject];

        $bean->name =  " فاتورة الصرف الاكتروني للنفط الخام لشهر" . date("Y-m", strtotime($invoice_date));
        $tax_amount = $amount * 0.16;
        $bean->details->tax_amount = number_format($tax_amount, 3);
        $bean->details->amount = $result[0]->cnt * 2.8706898;
        $bean->details->total_amount = $amount + $tax_amount;
        $bean->details->tender_name = "النفط الخام";
        $bean->details->beneficiary_name = 'السادة شركة مصفاة البترول الأردنية المحترمين المحترمين';
        $bean->details->tender_id = 11;
        $bean->invoice_date = $invoice_date;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->payment_method = $this->_request->payment_method;
        $bean->details->tax = true;
        $bean->details->invoice_type = $this->_request->invoice_type;

        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getCrudeOilWaybillDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $sqlQuery = "SELECT sum(document->>'$.cargo[0].weights.loading.net_weight') as cnt from waybill
                    where tender_id = 11
                    and loading_date is not null
                    and loading_date >= ?
                    and loading_date < ? + INTERVAL 1 MONTH
                    and status not in ('INACTIVE','REVOKED')
                    ";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$invoice_date, $invoice_date]);

        $itemObject = new stdClass();
        $itemObject->name = " بدل تنظيم واصدار وتجهيز وثائق النقل";
        $itemObject->price = 1;
        $item_amount = ($result[0]->cnt * 0.028) / 1000;
        $itemObject->number = $result[0]->cnt;
        $itemObject->files = explode('.', strval(number_format($item_amount, 3)))[1] ? explode('.', strval(number_format($item_amount, 3)))[1] : '00';
        $itemObject->jd = explode('.', strval(number_format($item_amount, 3)))[0] ? explode('.', strval(number_format($item_amount, 3)))[0] : '00';
        $bean->details->items = [$itemObject];
        $bean->name =  " فاتورة تسريب النفط الخام لشهر" . date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = number_format($item_amount, 3);
        $bean->details->tender_name = "النفط الخام";
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->tax_amount = 0;
        $bean->details->amount = number_format($item_amount, 3);

        $bean->details->beneficiary_name = 'السادة شركة مصفاة البترول الأردنية المحترمين';
        $bean->details->tender_id = 11;
        $bean->invoice_date = $invoice_date;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->payment_method = $this->_request->payment_method;

        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getFuelWaybillDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();

        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => 12],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => "not in"],
            ['key' => 'create_date', 'val' => date("Y-m-t 23:59:59", strtotime($invoice_date)), 'op' => 'date less than'],
            ['key' => 'create_date', 'val' => date("Y-m-d 00:00:00", strtotime($invoice_date)), 'op' => 'date greater than'],
        ];
        // dump($waybillFilter);die;
        $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, 0);

        $itemObject = new stdClass();
        $itemObject->name = " بدل تنظيم واصدار وتجهيز وثائق النقل";
        $itemObject->price = 1;
        $itemObject->number = $waybills->found_rows * 2;
        $itemObject->files = '00';
        $itemObject->jd = $waybills->found_rows * 2;
        $bean->details->items = [$itemObject];
        $bean->name =   " الفاتورة الشهرية للفيول لشهر" . date("Y-m", strtotime($invoice_date));

        $bean->details->total_amount = $waybills->found_rows * 2;
        $bean->details->tender_name = "النفط الخام";
        $bean->details->beneficiary_name = ' السادة شركة مصفاة البترول الأردنية المحترمين';
        $bean->details->tender_id = 11;
        $bean->details->amount = $waybills->found_rows * 2;

        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->confirm = $this->_request->confirm || false;
        $bean->details->payment_method = $this->_request->payment_method;
        $bean->details->tax_amount = 0;
        $bean->invoice_date = $invoice_date;
        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
    private function getBurjAlhayatWaybillDetails($invoice_date)
    {
        $bean = new stdClass();
        $details = new stdClass();
        $items = [];
        $bean->details = $details;
        $bean->details->items = $items;

        $itemObject = new stdClass();
        $itemObject->name = " بدل تنظيم واصدار وتجهيز وثائق النقل";
        $itemObject->price = 1;
        $itemObject->number = 2000;
        $itemObject->files = '00';
        $itemObject->jd = 2000;
        $bean->details->items = [$itemObject];
        $bean->name =  " الفاتورة الشهرية للفيول لشهر" . date("Y-m", strtotime($invoice_date));
        $bean->details->total_amount = 2000;
        $bean->details->tender_name = "النفط الخام";
        $bean->details->beneficiary_name = ' السادة شركة برج الحياة المحترمين';
        $bean->details->tender_id = 11;
        $bean->invoice_date = $invoice_date;
        $bean->details->invoice_type = $this->_request->invoice_type;
        $bean->details->confirm = $this->_request->confirm ? $this->_request->confirm : false;
        $bean->details->payment_method = $this->_request->payment_method;
        $bean->details->tax_amount = 0;
        // $bean->print_template = $this->_request->print_template;
        $bean->print_template = ['minagate_invoice'];
        $bean->status = "NEW";
        $bean->serial_number = $this->generateSerialNumber();
        return $bean;
    }
}
$Invoice_interface = new Invoice_interface();
