<?php

// import objects
require_once dirname(__FILE__) . "/../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../user/user_core.php";
require_once dirname(__FILE__) . "/../../includes/util.php";
class InvoiceCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }
    // ------------------------------------------------------------------------ //
    // -------------------Get Invoice bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getInvoice($id, $user_id)
    {
        $invoiceInfo = DBConnection::getBasicObjectBean("invoice", $id, $user_id);
        return $invoiceInfo;
    }
    // ------------------------------------------------------------------------ //
    // -------------------Create Invoice bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function createInvoice($invoiceBean, $user_id)
    {
        // Create Truck record in database  in case the TN is not exist
        $createInvoiceResult = DBConnection::insertDB("invoice", $invoiceBean, $user_id);
        $invoice_ID = $createInvoiceResult[0]['@id'];
        return $invoice_ID;
    }

    // -------------------------------------------------------------------------- //
    // -------------------search for Invoice using any search filter ----------- //
    // -------------------------------------------------------------------------- //
    public function searchInvoice($searchFilter, $limit, $offset, $user_id)
    {

        $searchInvoiceResult = DBConnection::searchDB("invoice", $searchFilter, $limit, $offset, $user_id);
        return $searchInvoiceResult;
    }

    // -------------------------------------------------------------------------- //
    // -------------------changeStatus for Invoice  ----------------------------- //
    // -------------------------------------------------------------------------- //
    public function changeStatus($invoice_bean, $user_id)
    {
        // change the status
        return DBConnection::updateDB("invoice", $invoice_bean, $user_id);
    }

    // -------------------------------------------------------------------------- //
    // -------------------updateInvoice for Invoice  ----------------------------- //
    // -------------------------------------------------------------------------- //
    public function updateInvoice($invoice_bean, $user_id)
    {
        // change the status
        return DBConnection::updateDB("invoice", $invoice_bean, $user_id);
    }

}
