<?php


require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../../core/payment/payment_core.php");
require_once (dirname(__FILE__)."/../../core/route_wage/route_wage_core.php");
require_once (dirname(__FILE__)."/../../core/tender_company/tender_company_core.php");
require_once (dirname(__FILE__)."/../../core/tender_claim/tender_claim_core.php");
require_once (dirname(__FILE__)."/../../core/payment/payment_core.php");
require_once (dirname(__FILE__)."/../../core/route_wage/route_wage_core.php");


class tender_claim_import_core
{

    private $_waybillCore;
    private $_paymentCore;
    private $_tenderClaimCore;
    private $_routeWageCore;

    public function __construct(){
        DBConnection::getInstance();

        $this->_waybillCore = new WaybillCore();
        $this->_paymentCore = new PaymentCore();
        $this->_tenderClaimCore = new TenderClaimCore();
        $this->_routeWageCore = new RouteWageCore();
    }

    public function getWaybillId($tn, $loadingDate){
        // Get dates
        $loadingDateFrom = date("Y-m-d", strtotime("-3 day", strtotime($loadingDate)));
        $loadingDateTo = date("Y-m-d", strtotime("+3 day", strtotime($loadingDate)));
        // Get waybill bean by tn and loading_date +- 2
        $filter = [
            ["key" => "tn", "val" => $tn],
            ["key" => "tender_id", "val" => "13"],
            ["key" => "loading_date", "op" => "date greater than", "val" => $loadingDateFrom],
            ["key" => "loading_date", "op" => "date less than", "val" => $loadingDateTo],
        ];
        $waybillBean = $this->_waybillCore->searchWaybills($filter, 100, 0, $_SESSION["user_id"]);
        if (isset($waybillBean->data)){
            return $waybillBean->data;
        }return null;
    }


    public function fillTenderClaims($limit){
        $query = " SELECT * FROM import_tender_claim where wn IS NOT NULL AND tender_claim_id is null limit $limit ";
        $importRecords = DBConnection::runDatabaseQuery($query);
        foreach ($importRecords as $record){
            //die(var_dump($record));
            $tenderClaimId = $this->getOrCreateTenderClaimForWaybill($record->tender_company_id, $record->ref_num);
            $this->updateTenderClaimId($record->id, $tenderClaimId);
           // die(var_dump([$tenderClaimId,$record->id, $record->waybill_id ]));
        }
    }

    private function getOrCreateTenderClaimForWaybill($tenderCompanyId, $ref){
        //params: tender_company_id, ref_id != ref_number, claim_type="waybill_claim"

        $filters = [
          ["key" => "tender_id", "val" => "13"],
          ["key" => "claim_details->>\"$.ref\"", "val" => $ref],
          ["key" => "tender_company_id", "val" => $tenderCompanyId],
          ["key" => "status", "val" => "NEW"],
        ];
        // Find tender claim for waybill
        $tenderClaims = $this->_tenderClaimCore->searchTenderClaims($filters, 1, 0, $_SESSION["user_id"]);
        if ($tenderClaims->found_rows == 1){
            return $tenderClaims->data[0]->id;
        }elseif ($tenderClaims->found_rows > 1){
            return null;
        }
        // If there is not create new
        else{
            $tenderClaimBean = new stdClass();
            $tenderClaimBean->ref = $ref;
            $tenderClaimBean->waybills = null;
            $tenderClaimBean->tender_company_id = $tenderCompanyId;
            $tenderClaimBean->claim_type = "waybill_claim";
            $this->_tenderClaimCore->createTenderClaim($tenderClaimBean, $_SESSION['user_id']);

            return $this->getOrCreateTenderClaimForWaybill($tenderCompanyId, $ref);
        }
    }

    public function pushWaybillToClaim($limit){
        $query = " 
             SELECT i.* FROM import_tender_claim i
            where i.wn IS NOT NULL
             AND i.tender_claim_id is not null 
             and not exists (
             select waybill_id from waybill.tender_claim_item where waybill_id = i.waybill_id and status = \"ACTIVE\"
             )
            limit $limit ";
        $importRecords = DBConnection::runDatabaseQuery($query);
        foreach ($importRecords as $record) {
            //die(print_r($record));

            try {
                $this->_tenderClaimCore->appendWaybillToTenderClaim($record->tender_claim_id, $this->getWaybillInfo($record), $_SESSION["u_id"], $_SESSION["user_id"]);
                $this->addNote($record->id, $record->note . ", ADDED" . $record->tender_claim_id );
            }
            catch (Exception $throwable){
                $this->addNote($record->id, $record->note . ", " . $throwable->getMessage() );
            }
            catch (Error $throwable){
                $this->addNote($record->id, $record->note . ", " . $throwable->getMessage() );
            }

        }
    }


    public function getWaybillInfo($importRecord){
        $waybill_info = new stdClass();
        $waybill_info->waybill_id = $importRecord->waybill_id ;
        $waybill_info->claim_loading_date = $importRecord->loading_date ;
        $waybill_info->claim_discharge_date = $importRecord->discharge_date ;
        $waybill_info->claim_loading_weight = $importRecord->loading_weight ;
        $waybill_info->claim_discharge_weight = $importRecord->discharge_weight ;
        $waybill_info->ref_num = $importRecord->policy_number ;

        // search for route wage
        $waybillBean = $this->_waybillCore->getWaybillBasic($importRecord->waybill_id,$_SESSION['user_id'] );
        $routeWage = $waybillBean->document->freight->route_wage;

        if(!$routeWage) {
            $routeWageFilter = [['key'=>'destination_id','val' =>$waybillBean->destination_id],
                ['key'=>'tender_id','val' =>$waybillBean->tender_id],
                ['key'=>'cargo_id','val' =>$waybillBean->document->cargo[0]->cargo_id],
                ['key'=>'start_date','val' =>  $importRecord->loading_date , 'op'=>'less than'],
                ['key'=>'end_date','val' =>  $importRecord->loading_date, 'op'=>'greater than'],
                ['key'=>'status','val' => 'ACTIVE']];

            $routeWageInfo = $this->_routeWageCore->searchRouteWage($routeWageFilter,1,0,0);
            if($routeWageInfo->found_rows == 0){
                throw new Exception("لا يمكن اضافة الأرسالية رقم $waybillBean->wn ، لا يوجد تسعيرة معرفة لموقع التفريغ ");
            }
            $routeWage = $routeWageInfo->data[0];
        }

        // calculate waybill claim amount
        $freight = $this->_paymentCore->calculateFreight($importRecord->waybill_id, $importRecord->discharge_weight, $importRecord->loading_weight, $routeWage);
        $waybill_info->claim_amount = $freight->amount->net_amount;
        $waybill_info->freight = $freight;
        $waybill_info->freight->route_wage = $routeWage;

        return $waybill_info;
    }

    public function validateWaybillData($waybill, $cargoId, $destId, $truckingCompanyID){
        $doc = json_decode($waybill->document);

        // Dest ID
        if ($waybill->destination_id != $destId) return "الوجهة غير مطابقة";
        // Cargo ID
        if ($doc->cargo[0]->cargo_id != $cargoId) return "الحمل غير مطابق";
        // trucking Company ID
        if ($waybill->trucking_company_id != $truckingCompanyID) return "الشركة غير مطابقة";

        return "PASS";
    }

    public function addNote($id, $note){
        DBConnection::runBindDatabaseQuery("
            UPDATE import_tender_claim
            SET note = ?
            WHERE id=?
        ", [ $note, $id ]);
    }

    public function updateWaybillId($id, $waybillID){
        DBConnection::runBindDatabaseQuery("
            UPDATE import_tender_claim
            SET waybill_id = ?
            WHERE id= ?
        ", [ $waybillID, $id ]);
    }

    public function updateTenderClaimId($id, $tenderClaimId){
        DBConnection::runBindDatabaseQuery("
            UPDATE import_tender_claim
            SET tender_claim_id = ?
            WHERE id= ?
        ", [ $tenderClaimId, $id ]);
    }

    public function unblockWaybills($limit, $offset){
        // Get all waybills in 1 week interval with user id 10338
        $tenderClaims = DBConnection::runBindDatabaseQuery(
            "select id from waybill.tender_claim t where update_by=10338 and exists (select id from tender_claim_item where tender_claim_id= t.id and status=\"ACTIVE\" and update_by = 10338) limit $limit offset $offset;", []
        );
        //die(var_dump($tenderClaims));

        foreach ($tenderClaims as $tenderClaim){
            $this->_tenderClaimCore->revokeTenderClaim( $tenderClaim->id, $_SESSION["user_id"]);
            //die(var_dump($tenderClaim->id));
        }
    }

}