<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../core/API.php");
require_once(dirname(__FILE__) . "/../company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../cargo_type/cargo_type_core.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../location/location_core.php");

header('Content-Type: application/json; charset=utf-8');


class GatewayCore
{

    private $TT_JSON = null;
    private $location_JSON = null;
    private $status_JSON = null;
    private $menuItems_JSON = null;
    private $validation_JSON = null;
    private $questionnaire_JSON = null;
    private $roles_JSON = null;
    private $cargoTypes_JSON = null;
    private $tenderDestination_JSON = null;
    private $MINAGATE_CONFIG_JSON = null;
    private $objectFollow_JSON = null;
    private $ISO = null;
    private $captions_JSON = null;
    private $contract_types_JSON = null;
    private $default_tender_JSON = null;
    private $external_waybills_JSON = null;
    private $dictionary_JSON = null;
    private $navigation_mobile_items_JSON = null;
    private $axial_loads_JSON = null;
    private $axial_limits_JSON = null;
    private $wallet_vendor_JSON = null;
    private $wallet_bank_JSON = null;

    private $clearingAgentCore;
    private $truckingCompanyCore;

    public function __construct()
    {
        DBConnection::getInstance();

        $this->clearingAgentCore = new ClearingAgentCore();
        $this->truckingCompanyCore = new TruckingCompanyCore();
        $this->_cargoTypeCore = new CargoTypeCore();
        $this->_locationCore = new LocationCore();
    }

    private function get_default_tender_setting()
    {
        if ($this->default_tender_JSON) {
            return $this->default_tender_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/default_tender_setting_01.json');

            $this->default_tender_JSON = $json;
            return $this->default_tender_JSON;
        }
    }

    private function get_MINAGATE_CONFIG_Instance() {
        if($this->MINAGATE_CONFIG_JSON){
            return $this->MINAGATE_CONFIG_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/minagate_config.json');

            $this->MINAGATE_CONFIG_JSON = $json;
            return $this->MINAGATE_CONFIG_JSON;
        }
    }

    private function get_TT_Instance()
    {
        if ($this->TT_JSON) {
            return $this->TT_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/TT.json');

            $this->TT_JSON = $json;
            return $this->TT_JSON;
        }
    }

    private function get_location_Instance()
    {
        if ($this->location_JSON) {
            return $this->location_JSON;
        } else {
            $searchFilter = [['key' => 'status', 'val' => 'ACTIVE']];
            $locations_qry = $this->_locationCore->searchLocation($searchFilter, 1000, 0, 0);
            $children = [];
            foreach ($locations_qry->data as $loc) {
                $child = [];
                $child['id'] = $loc->id;
                $child['name'] = $loc->name;
                $child['parent_id'] = $loc->parent_id;
                $children[] = $child;
            }
            $jordanNode = [];
            $jordanNode['label'] = 'الأردن';
            $jordanNode['value'] = '910000';
            $jordanNode['parent_id'] = null;
            $jordanNode['children'] = $children;
            $result['locations'][] = $jordanNode;
            $this->location_JSON = $result;

            return $this->location_JSON;
        }
    }

    private function get_status_Instance($object)
    {
        if ($this->status_JSON) {
            return $this->status_JSON[$object];
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/STATUS.json');
            $statusJson = json_decode($json, true);

            $this->status_JSON = $statusJson;

            if (isset($object)) {
                $status = $statusJson[$object];
                return $status;
            } else {
                return $this->status_JSON;
            }
        }
    }

    public function get_roles_Instance($role)
    {

        $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/ROLES.json');

        $rolesJsonArr = json_decode($json, true);
        $this->roles_JSON = $rolesJsonArr;
        $rolesArr = explode(",", $role);
        $resultArr = [];

        foreach ($rolesArr as $tempRole) {
            foreach ($rolesJsonArr as $rolesJsonArr_temp) {

                if ($rolesJsonArr_temp['VALUE'] == $tempRole) {
                    foreach ($rolesJsonArr_temp['children'] as $child_role) {
                        array_push($resultArr, $child_role);
                    }
                }
            }
        }
        return $resultArr;
    }

    private function get_cargoTypes_Instance($object)
    {
        if ($this->cargoTypes_JSON) {
            return $this->cargoTypes_JSON;
        } else {

            // get the major CT (with parent id = "ALL:)
            $ct_searchFilter = [['key' => 'parent_id', 'val' => '920000']];
            $cargo_type_qry = $this->_cargoTypeCore->searchCargoType($ct_searchFilter, 1000, 0, 0);
            $result = $cargo_type_qry->data;

            // loop on each major CT and get its children
            $cargoTypesNodes = [];
            foreach ($result as $major_ct) {

                // temp solution in order to list the grains children under cargo option
                if ($major_ct->id == "920200") {
                    $ct_searchFilter = [['key' => 'parent_id', 'val' => [920210, $major_ct->id], 'op' => 'in']];
                } else {
                    $ct_searchFilter = [['key' => 'parent_id', 'val' => $major_ct->id]];
                }

                // run database query
                $cargo_type_qry = $this->_cargoTypeCore->searchCargoType($ct_searchFilter, 1000, 0, 0);
                $childrenResult = $cargo_type_qry->data;

                $major_ct_node = new stdClass();
                $major_ct_node->label = $major_ct->name;
                $major_ct_node->value = $major_ct->id;
                $major_ct_node->parent_id = $major_ct->parent_id;
                $children = [];
                foreach ($childrenResult as $child) {
                    $child_node = new stdClass();
                    $child_node->value = $child->id;
                    $child_node->label = $child->name;
                    $children[] = $child_node;
                }
                $major_ct_node->children = $children;

                // add the CT node to result
                $cargoTypesNodes[] = $major_ct_node;
            }
            $this->cargoTypes_JSON = $cargoTypesJson;

            // return result
            $returnResult = [];
            $returnResult['cargoTypes'] = $cargoTypesNodes;
            return $returnResult;
        }
    }

    private function get_ca_list()
    {

        $searchFilter = [['key' => 'status', 'val' => "ACTIVE"]];
        $caResult = $this->clearingAgentCore->searchClearingAgent($searchFilter, 1000, 0, 0); // search by system
        $rows = array();
        foreach ($caResult->data as $ca) {
            $temp = new stdClass();
            $temp->id = $ca->id;
            $temp->name = $ca->name;
            array_push($rows, $temp);
        }
        return $rows;
    }

    public function get_external_waybill_services()
    {
        if ($this->external_waybills_JSON) {
            return $this->external_waybills_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/external_waybills_services.json');

            $this->external_waybills_JSON = $json;
            return $this->external_waybills_JSON;
        }
    }

    public function get_navigation_mobile_items()
    {
        if ($this->navigation_mobile_items_JSON) {
            return $this->navigation_mobile_items_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/navigation_mobile_items.json');
            $json = json_decode($json);

            $order = new stdClass();
            $order->id = 5;
            $order->title = "طلبية اليوم";
            $order->route = "https://storage.googleapis.com/waybill_system_config/help/orders.html?r=" . rand();
            $order->icon = "truck-loading";
            $json[] = $order;

            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER') {
                    $order = new stdClass();
                    $order->id = 8;
                    $order->title = "ارسال رسالة";
                    $order->route = "send_message";
                    $order->icon = "paper-plane";
                    $json[] = $order;
                }
            }

            if ($_SESSION['company_id']) {
                $order = new stdClass();
                $order->id = 6;
                $order->title = "NAV_EMPLOYEE";
                $order->route = "Employee";
                $order->icon = "user";
                $json[] = $order;
            }

            $order = new stdClass();
            $order->id = 9;
            $order->title = "ارشيف الطلبيات";
            $order->route = "https://api.minagate.com/report?method=getOrdersArchive&tender_id=11";
            $order->icon = "database";
            $json[] = $order;

            $order = new stdClass();
            $order->id = 10;
            $order->title = "اوامر الصرف";
            $order->route = "voucher";
            $order->icon = "money-check";
            $json[] = $order;

            $order = new stdClass();
            $order->id = 11;
            $order->title = "المعاملات";
            $order->route = "ticket";
            $order->icon = "comment";
            $json[] = $order;


            $this->navigation_mobile_items_JSON = $json;
            return $this->navigation_mobile_items_JSON;
        }
    }

    private function get_tc_list()
    {

        $searchFilter = [['key' => 'status', 'val' => "ACTIVE"]];
        $tcResult = $this->truckingCompanyCore->searchTruckingCompany($searchFilter, 1000, 0, 0); // search by system

        $rows = array();
        foreach ($tcResult->data as $tc) {
            $temp = new stdClass();
            $temp->id = $tc->id;
            $temp->name = $tc->name;
            array_push($rows, $temp);
        }
        return $rows;
    }


    private function get_DVLD_ROLES()
    {
        return ['DATA_ENTRY', 'DATA_AUDITOR'];
    }


    private function get_MENUITEMS_Instance($object)
    {

        session_start();

        if ($object && $object == 'mobile') {
            $menu_items_url = 'https://storage.googleapis.com/waybill_system_config/dev/MOBILE_MENU_ITEMS2.json';
        } else {
            $menu_items_url = 'https://storage.googleapis.com/waybill_system_config/dev/MENU_ITEMS.json?rand=' . rand();
        }


        $json = $this->callCURL($menu_items_url);


        $MENU_ITEMS = [];
        $menuItem = json_decode($json, true);
 

        if ($_SESSION['USER_ROLES'] == "") {
            $_SESSION['USER_ROLES'] = "ANONYMOUS";
        }
        // $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $companyRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $userRolesArray = array_merge($userRolesArray, $companyRolesArray);

        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $user_wf = DBConnection::getCompanyEmployeeWF($_SESSION['company_employee_id']);
        } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
            $user_wf = DBConnection::getUserWF($_SESSION['u_id']);
        } else if (strtoupper($_SESSION['type']) == "SYSTEM") {
            $user_wf = DBConnection::getUserWF($_SESSION['u_id']);
        } else {
            //throw new Exception("INVALID SESSION TYPE");
        }

        // clear any empty role
        foreach ($userRolesArray as &$role) {
            if ($role == "") {
                unset($userRolesArray[$role]);
            }
        }



        $flatList = [];
        // loop on user roles
        foreach ($userRolesArray as &$role) {

            // if the menu item has a set of items for user curent role
            if ($menuItem[$role]) {
                // loop on this menu item set


                foreach ($menuItem[$role] as &$item) {
                    if (!$this->isInMenuItem($MENU_ITEMS, $item)) {
                        if ($item['object']) {
                            foreach ($user_wf as $wf_node) {
                                if (strtoupper($wf_node->object_code) == strtoupper($item['object']) && $wf_node->action_code = 'VIEW') {
                                    array_push($MENU_ITEMS, $item);
                                    break;
                                }
                            }
                        } else {
                            // if the menu item has no object then show it
                            array_push($MENU_ITEMS, $item);
                        }
                    }
                }
            }
        }

        // sort the array asc by id
        usort($MENU_ITEMS, array('GatewayCore', 'comparator'));

        $this->menuItems_JSON = $MENU_ITEMS;
        return $MENU_ITEMS;
    }
    public static function comparator($object1, $object2)
    {
        return $object1['id'] > $object2['id'];
    }

    private function get_user_wf()
    {
        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $user_wf = DBConnection::getCompanyEmployeeWF($_SESSION['company_employee_id']);
        } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
            $user_wf = DBConnection::getUserWF($_SESSION['u_id']);
        } else if (strtoupper($_SESSION['type']) == "SYSTEM") {
            $user_wf = DBConnection::getUserWF($_SESSION['u_id']);
        }

        return $user_wf;
    }

    private function get_user_roles()
    {
        if ($_SESSION['USER_ROLES']) {
            return $_SESSION['USER_ROLES'];
        } else {
            return "";
        }
    }

    private function get_user_profile()
    {

        $result = [];

        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $result['type'] =  $_SESSION['type'];
            $result['company_id'] =  $_SESSION['company_id'];
        } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
            $result['type'] =  $_SESSION['type'];
            $result['user_id'] =  $_SESSION['u_id'];
        }

        return $result;
    }


    private function isInMenuItem($MENU_ITEM, $item)
    {
        foreach ($MENU_ITEM as $menuItem) {
            if ($menuItem['children']) {
                foreach ($menuItem['children'] as $child) {
                    if ($child['id'] == $item['id']) {
                        return true;
                    }
                }
            } else {
                if ($menuItem['id'] == $item['id']) {
                    return true;
                }
            }
        }
        return false;
    }

    private function get_VALIDATION_Instance($objectName)
    {
        if ($this->menuItems_JSON) {
            return $this->menuItems_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/VALIDATION_RULES.json');

            $VALIDATION = [];
            $validationJSON = json_decode($json, true);

            $this->validation_JSON = $validationJSON;
            return $validationJSON[$objectName];
        }
    }

    private function get_questionnaireResources_Instance()
    {
        if ($this->questionnaire_JSON) {
            return $this->questionnaire_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/questionnaire_resources.json');
            $questionnaireJSON = json_decode($json, true);

            $this->questionnaire_JSON = $questionnaireJSON;
            return $this->questionnaire_JSON;
        }
    }

    private function get_tenderDestinationResources_Instance()
    {
        if ($this->tenderDestination_JSON) {
            return $this->tenderDestination_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/tender_destination_resource.json');

            $this->tenderDestination_JSON = json_decode($json, true);

            return $this->tenderDestination_JSON;
        }
    }

    private function callCURL($url)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $json = curl_exec($ch);
        curl_close($ch);

        return $json;
    }

    private function get_captions_Instance()
    {
        if ($this->captions_JSON) {
            return $this->captions_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/CAPTIONS.json');
            $this->captions_JSON = json_decode($json, true);
            return $this->captions_JSON;
        }
    }

    private function get_contract_types_Instance()
    {
        if ($this->contract_types_JSON) {
            return $this->contract_types_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/CONTRACT_TYPES.json');
            $this->contract_types_JSON = json_decode($json, true);
            return $this->contract_types_JSON;
        }
    }

    private function get_objectFollowAction_Instance()
    {
        if ($this->objectFollow_JSON) {
            return $this->objectFollow_JSON;
        } else {

            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/object_follow_rules.json');
            $this->objectFollow_JSON = json_decode($json, true);
            return $this->objectFollow_JSON;
        }
    }
    private function getISOLists()
    {
        if ($this->ISO) {
            return $this->ISO;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/ISO.json');
            $this->ISO = json_decode($json, true);
            return $this->ISO;
        }
    }


    private function get_axial_loads()
    {
        if ($this->axial_loads_JSON) {
            return $this->axial_loads_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/dev/AXIAL_LOADS.json');
            $this->axial_loads_JSON = json_decode($json, true);
            return $this->axial_loads_JSON;
        }
    }

    private function get_axial_limits()
    {
        if ($this->axial_limits_JSON) {
            return $this->axial_limits_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/AXIAL_LIMITS.json');
            $this->axial_limits_JSON = json_decode($json, true);
            return $this->axial_limits_JSON;
        }
    }

    private function get_wallet_vendor()
    {
        if ($this->wallet_vendor_JSON) {
            return $this->wallet_vendor_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/wallet_vendor.json');
            $this->wallet_vendor_JSON = json_decode($json, true);
            return $this->wallet_vendor_JSON;
        }
    }

    private function get_wallet_bank()
    {
        if ($this->wallet_bank_JSON) {
            return $this->wallet_bank_JSON;
        } else {
            $json = $this->callCURL('https://storage.googleapis.com/waybill_system_config/wallet_bank.json');
            $this->wallet_bank_JSON = json_decode($json, true);
            return $this->wallet_bank_JSON;
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get resource by calling json config file ------------- //
    // ------------------------------------------------------------------------ //
    public function getResource($resourceType, $object)
    {
        switch ($resourceType) {
            case 'CONTRACT_TYPES': {
                    return $this->get_contract_types_Instance();
                }
            case 'TT': {
                    return $this->get_TT_Instance();
                }
            case 'MENU_ITEMS': {
                    return $this->get_MENUITEMS_Instance($object);
                }
            case 'STATUS': {
                    return $this->get_status_Instance($object);
                }
            case 'VALIDATION': {
                    return $this->get_VALIDATION_Instance($object);
                }
            case 'QUESTIONNAIRE': {
                    return $this->get_questionnaireResources_Instance();
                }
            case 'ROLES': {
                    return $this->get_roles_Instance($object);
                }
            case 'CARGO_TYPES': {
                    return $this->get_cargoTypes_Instance($object);
                }
            case 'TENDER_DESTINATION': {
                    return $this->get_tenderDestinationResources_Instance();
                }
            case 'CA': {
                    return $this->get_ca_list();
                }
            case 'TC': {
                    return $this->get_tc_list();
                }
            case 'VERSION': {
                    return API::$VERSION_NUMBER;
                }
            case 'DVLD_ROLES': {
                    return $this->get_DVLD_ROLES();
                }
            case 'MINAGATE_CONFIG':{
                return $this->get_MINAGATE_CONFIG_Instance();
                }
            case 'DEFAULT_TENDER_SETTING': {
                    return $this->get_default_tender_setting();
                }
            case 'LOCATION': {
                    return $this->get_location_Instance();
                }
            case 'CAPTIONS': {
                    return $this->get_captions_Instance();
                }
            case 'FOLLOW_ACTION_CODES': {
                    return $this->get_objectFollowAction_Instance();
                }
            case 'ISO': {
                    return $this->getISOLists();
                }
            case 'EXTERNAL_WAYBILL_SERVICES': {
                    return $this->get_external_waybill_services();
                }
            case 'NAVIGATION_MOBILE_ITEM': {
                    return $this->get_navigation_mobile_items();
                }
            case 'WF': {
                    return $this->get_user_wf();
                }
            case 'USER_ROLES': {
                    return $this->get_user_roles();
                }
            case 'USER_PROFILE': {
                    return $this->get_user_profile();
                }
            case 'AXIAL_LOADS': {
                    return $this->get_axial_loads();
                }
            case 'AXIAL_LIMITS': {
                    return $this->get_axial_limits();
                }
            case 'WALLET_VENDOR': {
                    return $this->get_wallet_vendor();
                }
            case 'WALLET_BANK': {
                    return $this->get_wallet_bank();
                }
            case 'MOBILE_MENU': {
                return [
                    ['id'=>1,'title'=>'الرئيسية','route'=>'mobile_index','icon'=>'fa fa-lg fa-fw fa-home','object'=>null],
                    ['id'=>2,'title'=>'التقارير','route'=>'mobile_minagate_report','icon'=>'fas fa-file-invoice','object'=>null],
                    ['id'=>3,'title'=>'البيانات الجمركية','route'=>'mobile_declaration','icon'=>'fas fa-tasks','object'=>null]
                ];
            }

            default:
                break;
        }
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- Get Dictionary for certain language ----------------------- //
    // -------------------------------------------------------------------------------- //
    public function getDictionary($lang){

        $dic = $this->callCURL('https://storage.googleapis.com/waybill_system_config/ar.json?rand=1');
        return json_decode($dic);

    }

}
