<?php

require_once "../API.php";
require_once "gateWay_core.php";

class Gateway extends API
{

    private $_request = array();
    private $_gatewayCore;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // validate session
        session_start();

        $this->_gatewayCore = new GatewayCore();
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest()
    {
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int) method_exists($this, $func) > 0) {
            $this->$func();
        } else {
            parent::response('Error code 404, method not found', 404);
        }
        // If the method not exist with in this class, response would be "Page not found".
    }

    public function getMinagateResources()
    {
        $object = '';
        $resource = $this->_request->resource;
        if (isset($this->_request->object)) {
            $object = $this->_request->object;
        }
        $resource = explode(",", $resource);

        $response = array();
        foreach ($resource as $value) {

            $tempObject=$object;
            $data = new stdClass();
            $data->name = $value;
            if($value!="ROLES" && $value != "MENU_ITEMS")
            {
                $tempObject=null;
            }

            $data->resource = $this->_gatewayCore->getResource($value, $tempObject);
            array_push($response, $data);
        }

        parent::response($response);
    }

    public function getResource(){

        $resourceType = str_replace("'", "", $this->_request->resource);
        $object = str_replace("'", "", $this->_request->object);

        $resource = $this->_gatewayCore->getResource($resourceType,$object);
        parent::response($resource);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- Get Dictionary for certain language ----------------------- //
    // -------------------------------------------------------------------------------- //
    public function getDictionary(){

        $lang = $this->_request->language;
        $dictionary = $this->_gatewayCore->getDictionary($lang);
        parent::response($dictionary);
    }

}

$Gateway = new Gateway();