<?php
require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/gate_core.php";
require_once dirname(__FILE__) . "/../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../queue/queue_core.php";

class Gate_interface extends API {
    private $_request = array();
    private $_queueCore;
    private $_waybillCore;
    private $_gateCore;

    private $tender_id = 11;    // 11: النفط الخام
    private $q_id = 2;          // 2: شويعر

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_queueCore = new QueueCore();
        $this->_gateCore = new GateCore();
        $this->_waybillCore = new WaybillCore();
        $this->_tenderCore = new TenderCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();

    }


    private function prepareFilter(){
        $waybillFilter = [];
         
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
 
            foreach ($filter as $key => $value) {
                if($key == 'document'){
                    $tempArr = ['key'=>$key,'val' => $value, 'op'=>'like'];
                }
                else{
                    $tempArr = ['key'=>$key,'val' => $value];
                }
                array_push($waybillFilter,$tempArr);
            }
        }

        return $waybillFilter;
    }

    // ------------------------------------------------------------------- //
    // ------------- list all trucks in a certain yard ------------------- //
    // ------------------------------------------------------------------- //
    public function listYardTrucks(){
        // get all trucks  inside yard
        $truckFilter = [['key'=>"q_id",'val' => $this->q_id],
                        ['key'=>"tender_id",'val' => $this->tender_id],
                        ['key'=>"status", 'val'=>['ACTIVE','APPROVED'],'op' => 'in']
        ];
        $truckQuery = $this->_queueCore->searchQueue($truckFilter,10000,0,$_SESSION['user_id']);

        foreach ($truckQuery->data as &$queue) {
            $queue->status = 'YARD.'.$queue->status;
        }

        parent::response($truckQuery);
    }

    // ----------------------------------------------------- //
    // ------------- search waybill info ------------------- //
    // ----------------------------------------------------- //
    public function searchWaybills(){

        // get waybill info
        $waybillFilter = $this->prepareFilter();
        $waybillFilter[] = ['key'=>'tender_id','val' => $this->tender_id];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter,
                                                    $this->_request->limit,
                                                    $this->_request->offset,
                                                    $_SESSION['user_id']
        );
        
        $Result = [];
        if($waybillResult->found_rows > 0){
            $waybillBean = $waybillResult->data[0];         

            // get truck info inside yard
            $truckFilter = [['key'=>"q_id",'val' => $this->q_id],
                            ['key'=>"tender_id",'val' => $this->tender_id],
                            ['key'=>"truck_id",'val' => $waybillBean->truck_id],
                            ['key'=>"status", 'val'=>['ACTIVE','ONROAD','APPROVED'],'op' => 'in']
                            ];
            $truckQuery = $this->_queueCore->searchQueue($truckFilter,1,0,$_SESSION['user_id']);

            if($truckQuery->found_rows > 0){
                $queueInfo = $truckQuery->data[0];

                $queueInfo->status = 'YARD.'.$queueInfo->status;
            }else{
                $queueInfo = null;
            }
        }

        if($waybillBean){
            // Temp fix untill we deploy new mopbile app
            $doc = json_decode($waybillBean->document);         
            $waybillBean->trailer_id =$doc->carrier[0]->trailer->tn;
        }

        $Result['waybill_info'] = $waybillBean;
        $Result['queue_info'] = $queueInfo;
        parent::response($Result);
    }


    // ----------------------------------------------------------------------- //
    // ------------- process any gate-in or gate-out event ------------------- //
    // ----------------------------------------------------------------------- //
    public function gateEvent(){

        // init params 
        $waybill_id = $this->_request->waybill_id;

        // get the waybillBean
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id , $_SESSION['user_id']);

        // get the tender of the waybill
        $tenderBean = $this->_tenderCore->getTenderBasic($waybillBean->tender_id , 0);

        // get the queues and see if any queue is yard
        $queues = $tenderBean->manifest->queues;
        $has_yard = false;
        $q_id = 0;
        foreach ($queues as $queue) {
            if($queue->type == "yard"){
                $has_yard = true;
                $q_id = $queue->id;
                $allowed_waybill_status = $queue->waybill_filter[0]->status;
                $yard_name = $queue->name;
            }
        }
        if(!$has_yard){
            throw new Exception("لا توجد ساحة معرفة على المشروع لمستند الشحن");
        }
        
        // get the truck in queue
        $truckFilter = [['key'=>"q_id",'val' => $q_id],
                        ['key'=>"tender_id",'val' => $waybillBean->tender_id],
                        ['key'=>"truck_id",'val' => $waybillBean->truck_id],
                        ['key'=>"rank",'op' => 'is not null']];
        $truckQuery = $this->_queueCore->searchQueue($truckFilter,1,0,$_SESSION['user_id']);

        // if the truck is not in the queue, then the user wants to make gate_in
        // make sure the waybill is in the valid status to enter the queue
        if($truckQuery->found_rows == 0){
            if(in_array($waybillBean->status,$allowed_waybill_status)){
                $this->_gateCore->gateInYard($waybill_id , $waybillBean->tender_id, $q_id , $yard_name, $_SESSION['user_id']);
            }else{
                throw new Exception("لا تستطيع المتابعة ، حالة مستند الشحن لا تسمح بدخول الساحة");
            }
        }
   
        // see if the tn is already in the queue , then the user wants to make gate_out
        else {
            $queueBean = $truckQuery->data[0];
            if($queueBean->status == 'APPROVED'){
                $this->_gateCore->gateOutYard( $queueBean->id , $waybill_id , $yard_name , $_SESSION['user_id']);
            }
            else{
                throw new Exception("الشاحنة لم يسمح لها بالخروج من الساحة بعد");
            }
        }

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);

    }


    // -------------------------------------------------------------------------- //
    // ------------ Release number of trucks to leave the yard ------------------ //
    // -------------------------------------------------------------------------- //
    public function releaseTrucks(){

        // init params 
        $tender_id = $this->tender_id;
        $q_id = $this->q_id;
        $count = $this->_request->count;

        if(!$count){
            throw new Exception("الرجاء تحديد عدد السيارات");
        }

        $numberOfTrucks = $this->_gateCore->releaseTrucks( $tender_id , $q_id , $count , $_SESSION['user_id']);

        if($numberOfTrucks > 0){
            $Result=[];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تم فك شاحنات بعدد ' . $count;
            parent::response($Result);
        }else{
            throw new Exception("لا يوجد شاحنات متاحة للخروج من الساحة");            
        }
    }
}


new Gate_interface();