<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once dirname(__FILE__) . "/../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../queue/queue_core.php";
require_once dirname(__FILE__) . "/../driver/driver_core.php";
require_once dirname(__FILE__) . "/../social/social_core.php";
require_once (dirname(__FILE__). "/../notification/notification_core.php");
require_once (dirname(__FILE__). "/../outgoing_integration/Jo_Petrol.php");


class GateCore {

    public function __construct(){
        DBConnection::getInstance();
    }

    // --------------------------------------------------------------------------------- //
    // ---------------------- Gate In yard Procedure ----------------------------------- //
    // --------------------------------------------------------------------------------- //
    public function gateInYard($waybill_id , $tender_id, $queue_id, $yard_name , $user_id){
        $queueCore = new queueCore();
        $waybillCore = new WaybillCore();

        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);

        // insert truck into the yard ( yard means queue)
        $addQueueId = $queueCore->addQueue($waybillBean->truck_id,$waybillBean->driver_id,$waybillBean->trailer_id,
                                                            $queue_id,$tender_id,$user_id);

        // write note into waybill
        $waybillCore->logActivity($waybill_id, "دخول ساحة", "الموقع : ".$yard_name, "YARD_IN",$user_id);

    }

    // ---------------------------------------------------------------------------------- //
    // ---------------------- Gate out yard Procedure ----------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function gateOutYard($queue_id , $waybill_id , $yard_name , $user_id){
        $queueCore = new queueCore();
        $waybillCore = new WaybillCore();

        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);

        // insert truck into the yard ( yard means queue)
        $addQueueId = $queueCore->changeStatus($queue_id,'CLOSED',$user_id);

        // write note into waybill
        $waybillCore->logActivity($waybill_id, "خروج ساحة", "الموقع : ".$yard_name, "YARD_OUT",$user_id);

    }


    // -------------------------------------------------------------------------- //
    // ------------ Release number of trucks to leave the yard ------------------ //
    // -------------------------------------------------------------------------- //
    public function releaseTrucks($tender_id , $q_id , $count , $user_id){

        $queueCore = new queueCore();
        $waybillCore = new WaybillCore();

        // search for queue for the requested number
        $queueFilter = [['key'=>'tender_id','val' => $tender_id],
                         ['key'=>'q_id','val' => $q_id],
                         ['key'=>'status','val' => 'ACTIVE']
                        ];

        // search for waybills
        $order_by = " order by rank ";
        $queueResult = $queueCore->searchQueue($queueFilter, $count, 0, $user_id, $order_by);

        foreach ($queueResult->data as $queue) {

            // change status of queue to APPROVED ("مسموح الخروج")
            $addQueueId = $queueCore->changeStatus($queue->id,'APPROVED',$user_id);

            // remove the truck from queue
            $addQueueId = $queueCore->changeStatus($queue->id,'CLOSED',$user_id);

            // set the waybills status on Jo_Petrol system to 4
            $waybillFilter = [['key'=>'truck_id','val' => $queue->truck_id],
                              ['key'=>'status','val' => 'ONROAD'],
                              ['key'=>'tender_id','val' => '11']
                            ];                
            // search for the waybill
            $waybillCore = new WaybillCore();       
            $waybillResult = $waybillCore->searchWaybills($waybillFilter, 1, 0, 0);
            $waybill_id = $waybillResult->data[0]->id;

            if($waybill_id){

                $waybillCore->logActivity($waybill_id, "خروج ساحة", "الموقع : ساحة شويعر", "YARD_OUT",$user_id);

            $jo_petrol = new Jo_Petrol();
                $jo_petrol->changeWaybillStatus($waybill_id , 4);
            }

            // send SMS to driver
            $messageRecipient = $queue->driver_phone;
            $messageRecipient = convertToInternational($messageRecipient);
            $messageBody = "$queue->tn - تستطيع الخروج من الساحة باتجاه السلامة العامة";
            $result = sendSMS($messageRecipient,$messageBody);

            // send notification on the mobile app
            try{
                $socialCore = new SocialCore();
                $driverCore = new DriverCore();
                $notificationCore = new NotificationCore();

                if($queue->driver_id){
                    $driver_user_id = $driverCore->getDriverBasic($queue->driver_id,0)->user_id;                 
                    $title = "خروج من ساحة شويعر";
                    $wallMessageBody = "حان دور السيارة رقم $queue->tn للخروج من ساحة شويعر ، الرجاء التوجه نحو السلامة العامة";
                    $socialCore->createWallEntry($driver_user_id,$title,$wallMessageBody);

                    // send notification
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = rand(1, 1000);
                    $payload->title = $title;
                    $payload->message = $messageBody;
                    $notificationCore->sendDataMessage($driver_user_id,$payload);
                }

            }catch (Exception $e){}

            // send custom mp3 ringtone
        }

        return $queueResult->found_rows;

    }

}