<?php
error_reporting(E_ERROR | E_ALL);

// import required classes
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/social/social_core.php");
require_once dirname(__FILE__) . "/../../core/tender/tender_core.php";
require_once dirname(__FILE__) . "/../../core/truck/truck_core.php";
require_once dirname(__FILE__) . "/../../core/user/user_core.php";

require_once(dirname(__FILE__) . "/fps_voucher_core.php");

class FPS_Voucher_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_fps;
    private $_paymentAgentCore;
    private $_fpsVoucherCore;
    private $_socialCore;
    private $_paymentCore;
    private $_voucherCore;
    private $_tenderCore;
    private $_truckOwnerCore;
    private $_truckCore;
    private $_userCore;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();
        DBConnection::getInstance();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION",1);
        }

        // init the object
        $this->_fps = new FPS();
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_fpsVoucherCore = new Fps_voucher_core();
        $this->_socialCore = new SocialCore();
        $this->_paymentCore = new PaymentCore();
        $this->_voucherCore = new VoucherCore();
        $this->_tenderCore = new TenderCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_truckCore = new TruckCore();
        $this->_userCore = new UserCore();

        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest()
    {
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int)method_exists($this, $func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found', 404);   // If the method not exist with in this class, response would be "Page not found".
    }



    // -------------------------------------------------------------- //
    // --------------------- get voucher info------------------------- //
    // -------------------------------------------------------------- //
    public function getVoucher()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $result = $this->_fps->getVoucher($data, $_SESSION['user_id']);

        $result['trx'] = $result['jv_template']['trx_template'];

        $trx_template = [];
        $trx_template['amount'] = $result['amount'];

        if ($result['source_account_id'] == 500005) {
            $result['system_code'] = "payment_voucher";
        } else {
            $result['system_code'] = "fps_voucher"; // TODO
        }
        $result['trx_template'] = $trx_template;

        if ($result['integration_details']) {
            if (!$result['integration_details']['activity']) {
                $result['integration_details']['activity'] = [];
            }
        }

        // get the logo of the pa who creates the voucher
        try {

            $voucher_pa_id = $result['details']['pa_id'];
            if ($voucher_pa_id) {
                $paBean = $this->_paymentAgentCore->getPaymentAgentBasic($voucher_pa_id, $_SESSION['user_id']);
                $photos = $paBean->photo;
                foreach ($photos as $photo) {
                    if ($photo->type == "logo") {
                        $result['logo'] = $photo->url;
                    }
                }
            }
        } catch (\Throwable $th) {
        }


        parent::response($result);
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for vouchers using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchVouchers()
    {
        $data = new stdClass();
        $userFilter = $this->_request->filter;
        if (gettype($userFilter) == "string") {
            $userFilter = json_decode($userFilter);
        }

        if ($_SESSION['type'] == "CORPORATE" && $_SESSION['pa_id']) {
            $paymentAgentBean = $this->_paymentAgentCore->getPaymentAgentBasic($_SESSION['pa_id'], 0);

            $accountFilter = new stdClass();
            $accountFilter->filter = ["company_id" => $paymentAgentBean->company_id, "status" => "ACTIVE"];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);
            $userFilter->source_account_id =  $account_qry['data'][0]['id'];
        }

        $data->filter = $userFilter;

        $voucherResult = $this->_fps->searchVouchers($data, $_SESSION['user_id']);

        // get the account of the company
        $accountFilter = new stdClass();
        $accountFilter->filter = [
            "target_company_id" => $_SESSION['company_id'],
            "status" => "ACTIVE"
        ];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $pa_account = $this->_fps->searchAccount($accountFilter, 0);
        foreach ($pa_account['data'] as $acc) {
            $company_accounts[] = $acc['id'] . "-" . $acc['sub_id'];
        }

        // inject filter and extract source name and recipient name
        foreach ($voucherResult['data'] as &$v) {

            $voucherIsAllowed = false;
            if ($_SESSION['company_id'] == 266770 || $_SESSION['employee_id']) {
                $voucherIsAllowed = true;
                $company_accounts = [];
            }

            // the user can see the voucher in 2 cases: 1) the source is his account,
            if ($company_accounts && in_array($v['source_account_id'] . "-" . $v['source_sub_id'], $company_accounts)) {
                $voucherIsAllowed = true;
            }

            // 2) his account is part of jv_template
            $jv_template = json_decode($v['jv_template']);

            if ($jv_template->trx_template) {
                $trxs = $jv_template->trx_template;
            } else {
                $trxs = $jv_template;
            }

            if ($trxs && $voucherIsAllowed == false) {
                foreach ($trxs as $trx) {
                    if ($trx->account_id && $company_accounts && in_array($trx->account_id, $company_accounts)) {
                        $voucherIsAllowed = true;
                        break;
                    }
                    if ($trx->account && $company_accounts && in_array($trx->account, $company_accounts)) {
                        $voucherIsAllowed = true;
                        break;
                    }
                }
            }

            if (!$voucherIsAllowed) {
                $v = null;
                continue;
            }

            $details = json_decode($v['details']);
            $integration_details = json_decode($v['integration_details']);
            $v['recipient_phone'] = $integration_details->recipient_phone;
            $v['recipient_name'] = $details->recipient_name;
            $v['source_account_name'] = $details->source_account_name;
        }

        // clean data by removing any null
        $dataResult = [];
        foreach ($voucherResult['data'] as $d) {
            if ($d) {
                $dataResult[] = $d;
            }
        }

        $voucherResult['data'] = $dataResult;
        $voucherResult['found_rows'] = sizeOf($dataResult);
        $voucherResult['company_id'] = $_SESSION["company_id"];
        parent::response($voucherResult);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- validte e-payment with CBJ and complete trx ------------------ //
    // ------------------------------------------------------------------------------------ //
    public function completeTrx()
    {

        try {


            $voucher_id = $this->_request->voucher_id;
            $ref_id = $this->_request->ref_id;
            $trial = $this->_request->trial;
            if (!$trial) {
                $trial = 1;
            }

            $fps = new FPS();
            $data = new stdClass();
            $data->voucher_id = $voucher_id;
            $data->ref_id = $ref_id;
            $data->trial = $trial;
            $fps->validateWithJCB($data, $_SESSION['user_id']);

            // reuturn result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "CARGO.SUCCESSFUL_CREATE";
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function changeStatus()
    {
        $fps = new FPS();

        // get params
        $voucher_id = $this->_request->id;
        $new_status = $this->_request->new_status;

        if ($new_status == "PENDING") {

            // process voucher to start the payment process
            $processData = new stdClass();
            $processData->voucher_id = $voucher_id;

            $res = $fps->processVoucherTrx($processData, $_SESSION['user_id']);

            // reuturn result
            $Result['ERRORCODE'] = "0";
            $Result['res'] = $res;
            $Result['MESSAGE'] = "CHANGE STATUS SUCCESS";
        }

        if ($new_status == "REVOKED" || $new_status == "INACTIVE") {
            $processData = new stdClass();
            $processData->voucher_id = $voucher_id;
            $processData->new_status = $new_status;
            $res = $fps->changeVoucherStatus($processData, $_SESSION['user_id']);
            $Result['ERRORCODE'] = "0";
            $Result['res'] = $res;
            $Result['MESSAGE'] = "CHANGE STATUS SUCCESS";
        }

        parent::response($Result, 200);
    }


    public function gitVoucherAuditReport()
    {
        $fps = new FPS();
        $processData = new stdClass();
        $res = $fps->gitVoucherAuditReport($processData, $_SESSION['user_id']);

        parent::response($res, 200);
    }




    private function prepareFilter()
    {
        $voucherFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == "date_from") {
                    $tempArr = ['key' => "create_date", 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == "date_to") {
                    $tempArr = ['key' => "create_date", 'val' => $value, 'op' => 'date less than'];
                } else if ($key == "notes") {
                    $tempArr = ['key' => "trx_notes", 'val' => $value, 'op' => 'like'];
                } else if ($key == "payment_date_from") {
                    $tempArr = ['key' => "update_date", 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == "payment_date_to") {
                    $tempArr = ['key' => "update_date", 'val' => $value, 'op' => 'date less than'];
                } else if ($key == "check_number") {
                    $tempArr = ['key' => 'integration_details', 'val' => '"' . $value . '"', 'op' => 'json unquote', 'node' => '$.payment.ref_id'];
                } else if ($key == "waybill_id") {
                    $tempArr = ['key' => 'trx_template', 'val' => '"' . $value . '"', 'op' => 'json unquote', 'node' => '$.ref_id'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => '='];
                }
                array_push($voucherFilter, $tempArr);
            }
        }

        // filter voucher for pa
        if ($_SESSION['type'] == "CORPORATE" && $_SESSION['pa_id']) {
            $paymentAgentBean = $this->_paymentAgentCore->getPaymentAgentBasic($_SESSION['pa_id'], 0);

            $accountFilter = new stdClass();
            $accountFilter->filter = ["company_id" => $paymentAgentBean->company_id, "status" => "ACTIVE"];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $this->_fps->searchAccount($accountFilter, 0);

            $tempArr = ['key' => 'from_account', 'val' => $account_qry->data[0]->id, 'op' => 'like'];
            array_push($voucherFilter, $tempArr);
        }


        dump($voucherFilter);
        die;
        return $voucherFilter;
    }


    // ----------------------------------------------------------------------------------------- //
    // --------------------- Create task to user answers for downpayment poll ------------------ //
    // ----------------------------------------------------------------------------------------- //
    public function createProcessDownpaymentPollAnswerTask()
    {

        $poll_id = $this->_request->poll_id;
        $recipient_user_id = $this->_request->user_id;
        $u_id = $_SESSION['u_id'];

        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->createProcessDownpaymentPollAnswerTask($poll_id, $recipient_user_id, $u_id, 0);

        // inform the user that his answers has been recorded successfuly
        $wall_message_title = null;
        $wall_message_body = null;
        $notification_title = "شكرا لك، تم استلام اجابتك";
        $notification_message = "سيتم اعلامك بالنتيجة فور معالجتها من النظام";
        $this->_socialCore->informUser($wall_message_title, $wall_message_body, $notification_title, $notification_message, $recipient_user_id);
    }

    // ------------------------------------------------------------------------------------------------- //
    // --------------------- Create Downpayment Voucher by understand user poll answer------------------ //
    // ------------------------------------------------------------------------------------------------- //
    public function processDownpaymentPollAnswer()
    {

        $poll_id = $this->_request->poll_id;
        $recipient_user_id = $this->_request->recipient_user_id;
        $u_id = $this->_request->u_id;

        $this->_fpsVoucherCore->processDownpaymentPollAnswer($poll_id, $recipient_user_id, $this->_request, $u_id);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- get list of beneficiaries ----------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getBeneficiaries()
    {
        try {
            // sql queury
            $sqlQuery = "select * from beneficiary_address_book where status = ?";
            $param = ['ACTIVE'];
            $beneficiaries = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            // return list
            parent::response($beneficiaries);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    //////////////////////////// fps check interface starts here ////////////////////////////////////////////////////////
    // ------------------------------------------------------------------------------------------------- //
    // --------------- search for company details using  search filter from fps system ----------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function searchCompanyBankDetails()
    {
        $data = new stdClass();
        if ($this->_request->filter) {
            $data->filter = $this->_request->filter;
        }
        $data->limit = $this->_request->limit;
        $data->offset = $this->_request->offset;
        $searchCompanyBankDetailsResult =  $this->_fps->searchCompanyBankDetails($data, $_SESSION['user_id']);
        parent::response($searchCompanyBankDetailsResult);
    }

    // ------------------------------------------------------------------------ //
    // --------------------- create new list of checks on fps system ---------- //
    // ------------------------------------------------------------------------ //
    public function createNewListOfCheck()
    {
        $data = new stdClass();
        $data->first_check_number = $this->_request->first_check_number;
        $data->last_check_number = $this->_request->last_check_number;
        $data->company_bank_account_id = $this->_request->company_bank_account_id;
        $createNewListOfCheckRes =  $this->_fps->createNewListOfCheck($data, $_SESSION['user_id']);
        parent::response($createNewListOfCheckRes);
    }
    // ------------------------------------------------------------------------ //
    // --------------------- crete new check on fps system ------------------ //
    // ------------------------------------------------------------------------ //
    public function createNewCheck()
    {
        $data = new stdClass();
        $data->check_number = $this->_request->check_number;
        $data->company_bank_account_id = $this->_request->company_bank_account_id;
        $createNewCheckRes =  $this->_fps->createNewCheck($data, $_SESSION['user_id']);
        parent::response($createNewCheckRes);
    }
    // ------------------------------------------------------------------------ //
    // --------------------- get singe check from fps system ------------------ //
    // ------------------------------------------------------------------------ //
    public function getCheck()
    {
        $data = new stdClass();
        $data->check_id = $this->_request->check_id;
        $createNewCheckRes =  $this->_fps->getCheck($data, $_SESSION['user_id']);
        parent::response($createNewCheckRes);
    }
    // ------------------------------------------------------------------------------------------------- //
    // --------------- search for checks list using  search filter from fps system  -------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function searchChecks()
    {
        $data = new stdClass();
        if ($this->_request->filter) {
            $data->filter = $this->_request->filter;
        }
        $data->limit = $this->_request->limit;
        $data->offset = $this->_request->offset;
        $changeCheckStatusResult =  $this->_fps->searchChecks($data, $_SESSION['user_id']);
        parent::response($changeCheckStatusResult);
    }
    // ------------------------------------------------------------------------ //
    // --------------------- change check status form fps system ------------------ //
    // ------------------------------------------------------------------------ //
    public function changeCheckStatus()
    {
        $data = new stdClass();
        $data->check_id = $this->_request->check_id;
        $data->new_status = $this->_request->new_status;
        $changeCheckStatusRes =  $this->_fps->changeCheckStatus($data, $_SESSION['user_id']);
        parent::response($changeCheckStatusRes);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------ Start the process of group of vouchers to be paid as checks ----------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function addVouchersToCheck()
    {

        // get input params
        $voucher_ids = $this->_request->filter->voucher_ids;
        $check_id = $this->_request->check_id;
        $check_number = $this->_request->check_number;

        // aquire the check
        $data = new stdClass();
        $data->check_id = $check_id;
        $this->_fps->aquireCheck($data, $_SESSION['user_id']);

        // call fps to continute
        $data = new stdClass();
        $data->voucher_ids = $voucher_ids;
        $data->check_id = $check_id;
        $data->check_number = $check_number;
        $this->_fps->addVouchersToCheck($data, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    public function createVoucherForClaimItems()
    {
        // get user params
        $source_account_id = $this->_request->source_account_id;
        $target_account_id = $this->_request->target_account_id;
        $voucher_amount = $this->_request->voucher_amount;
        $payment_method = $this->_request->payment_method;
        $check_number = $this->_request->check_number;
        $bank_id = $this->_request->bank_id;
        $claim_item_ids = $this->_request->items;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR' || $role == 'PA_FPS_AUDITOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        try {
            // validate
            if ($voucher_amount == 0) {
                throw new Exception("لا تستطيع المتابعة قيمة الدفعة غير صحيحة");
            }
            $ledger_account_id = 590000;
            $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id, $_SESSION["user_id"]);
            if (!$sourceAccountBean) {
                throw new Exception("حساب الدفع غير صحيح");
            }
            $targetAccountBean = $this->_fps->getAccountBasic($target_account_id, $_SESSION["user_id"]);
            if (!$targetAccountBean) {
                throw new Exception("جهة الدفع غير صحيحة");
            }

            if (strtoupper($payment_method) == "CHECK") {
                $data = new stdClass();
                $data->filter = new stdClass();
                $data->filter->check_number = $check_number;
                $data->filter->company_bank_account_id = $bank_id;
                $data->filter->status = 'ACTIVE';
                $data->filter = json_encode($data->filter);
                $data->limit = 1;
                $data->offset = 0;
                $checkResult =  $this->_fps->searchChecks($data, $_SESSION['user_id']);
                if ($checkResult['found_rows'] == 0) {
                    throw new Exception("رقم الشيك غير صحيح");
                }
                $check_id = $checkResult['data'][0]['id'];
            }

            // call FPS to continue the process
            $settelmentData = new stdClass();
            $settelmentData->ledger_account_id = $ledger_account_id;
            $settelmentData->voucher_type = "PA_SETTELMENT";
            $settelmentData->source_account_id =  $sourceAccountBean['id'] . "-" . $sourceAccountBean['sub_id'];
            $settelmentData->source_account_name =  $sourceAccountBean['name'];
            $settelmentData->target_account_id = $targetAccountBean['id']  . "-" . $targetAccountBean['sub_id'];
            $settelmentData->target_account_name = $targetAccountBean['name'];
            $settelmentData->payment_method = strtoupper($payment_method);
            $settelmentData->voucher_amount = $voucher_amount;
            $settelmentData->check_id = $check_id;
            $settelmentData->claim_item_ids = $claim_item_ids;


            $voucherResult = $this->_fps->claimSettelment($settelmentData, $_SESSION['user_id']);

            if ($voucherResult['voucher_id']) {
                // return success
                $Result = [];
                $Result['ERRORCODE'] = "0";
                $Result['voucher_id'] = $voucherResult['voucher_id'];
                $Result['MESSAGE'] = "تمت العملية بنجاح";
                parent::response($Result);
            } else {
                throw new Exception(" لم يتمكن النظام من تسديد المبلغ ");
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function autoCompleteDefaultContactDetails()
    {
        $tn = $this->_request->tn;
        $tender_id = 23;

        // search for tender truck record
        $tenderTruckFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0,  $_SESSION['user_id']);

        $financial_details = $tenderTruckResult->data[0]->financial_details;
        if (!$financial_details) {
            throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
        }
        $financial_details = json_decode($financial_details);
      
        // search for tender truck account
        $tender_bean = $this->_tenderCore->getTenderBasic($tender_id, $_SESSION['user_id']);
        $account_ledger_id = $tender_bean->manifest->account_ledger_id;
        $accountFilter = new stdClass();
        $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $financial_details->truck_owner->id];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry =  $this->_fps->searchAccount($accountFilter, 0);
        if ($account_qry["found_rows"] === 0) {
            throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
        }

        // contact info
        $default_contact_truck_owner_id = $tenderTruckResult->data[0]->default_contact_user_id;
        if (!$default_contact_truck_owner_id) {
            throw new Exception("جهة اتصال الشاحنة غير معرفة");
        }
        $truckOwnerBean = $this->_truckOwnerCore->getTruckOwnerBasic($default_contact_truck_owner_id, 0);
        $default_recipient_bean = $this->_userCore->getUserBasic($truckOwnerBean->user_id, 0);
        $tenderTruckResult->data[0]->name = $default_recipient_bean->name . "  /  هاتف : " . $default_recipient_bean->phone;        
        parent::response($tenderTruckResult->data[0]);
    }


    // --------------------------------------------------------------------------------------------- //
    // -------------------- Create MG Claim for truck in case it take advancePayment --------------- //
    // --------------------------------------------------------------------------------------------- //
    public function createMGClaim()
    {
        // get user inout
        $tn = $this->_request->tn;
        $voucher_type = $this->_request->voucher_type;
        $voucher_amount = $this->_request->voucher_amount;
        $recipient_name = $this->_request->recipient_name;
        $tender_id = 23;

        // validate truck account and limit
        $tenderTruckFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0,  $_SESSION['user_id']);
        $financial_details = $tenderTruckResult->data[0]->financial_details;
        if (!$financial_details) {
            throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
        }
        $financial_details = json_decode($financial_details);
        $default_contact_truck_owner_id = $tenderTruckResult->data[0]->default_contact_user_id;
        $truckOwnerBean = $this->_truckOwnerCore->getTruckOwnerBasic($default_contact_truck_owner_id, $_SESSION['user_id']);
        $default_recipient_bean = $this->_userCore->getUserBasic($truckOwnerBean->user_id, $_SESSION['user_id']);

        // search for tender truck account
        $tender_bean = $this->_tenderCore->getTenderBasic($tender_id, $_SESSION['user_id']);
        $account_ledger_id = $tender_bean->manifest->account_ledger_id;
        $accountFilter = new stdClass();
        $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $financial_details->truck_owner->id];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry =  $this->_fps->searchAccount($accountFilter, 0);

        $truckAccount = $account_qry['data'][0];
        if ($truckAccount['balance'] + $voucher_amount > $truckAccount['maximum_balance']) {
            throw new Exception("ذمة الشاحنة تجاوزت الحد المسموح");
        }

        // validate if the truck owner id has to be same as  $financial_details->truck_owner->id
        $truckFilter = [['key' => 'tn', 'val' => $tn , 'key'=> 'status' , 'val' => ['INACTIVE'] , "op" => 'not in']];
        $truck_result = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);
        $truckBean = $truck_result->data[0];
        if ($financial_details->truck_owner->id != $truckBean->truck_owner_id) {

            // update truck record
            $truckBean->truck_owner_id = $financial_details->truck_owner->id;
            $this->_truckCore->updateTruckInfo($truckBean, $truckBean->id, 0);

            // revalidate
            $truckFilter2 = [['key' => 'tn', 'val' => $tn , 'key'=> 'status' , 'val' => ['INACTIVE'] , "op" => 'not in']];
            $truck_result2 = $this->_truckCore->searchTrucks($truckFilter2, 1, 0, 0);
            $truckBean2 = $truck_result2->data[0];
            if ($financial_details->truck_owner->id != $truckBean2->truck_owner_id) {
                throw new Exception("لا تستطيع المتابعة ، خطأ في عقد مالك الشاحنة");
            }
        }

        // create NEW claim to the truck
        $data = new stdClass();
        $data->tn = $tn;
        $data->truck_owner_id = $financial_details->truck_owner->id;
        $voucher_type_caption = $voucher_type == "MG_FUEL" ? "محروقات" : "نقدي";
        $data->notes = "مطالبة للشاحنة رقم " . $tn;
        $data->amount = $voucher_amount;
        $data->jv_template = [];
        $data->recipient_name = $recipient_name;
        $data->voucher_type = $voucher_type;
        $data->voucher_type_caption = $voucher_type_caption;
        $data->truck_owner_id = $financial_details->truck_owner->id;
        $data->truck_owner_user_id = $truckOwnerBean->user_id;
        $data->tender_id = $tender_id;
        $data->allow_days = $financial_details->allow_days;

        $claimResult = $this->_fps->createTruckClaim($data, $_SESSION['user_id']);    
        $claim_id = $claimResult['claim_id'];

        // send SMS and link on app ro Recipient
        $this->informMGClaimRecipient($claim_id);

        $Result = [];
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        $Result['claim_id'] = $claim_id;
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------ //
    // -------------- Create Post on claim receipient and send him SMS -------------- //
    // ------------------------------------------------------------------------------ //
    public function informMGClaimRecipient($claim_id)
    {

        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->claim_ids_in = [$claim_id];
        
        $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

        $claim_item_id = $claim_items['data'][0]['id'];

        $secret = md5($claim_item_id);
        $encoder = 'https://chart.googleapis.com/chart?chs=200x200&chld=M%7C0&cht=qr&chl=';
        $encodedVoucher = $encoder . $secret;

        $claim_item_bean = $this->_fps->getClaimItem($claim_item_id, $_SESSION['user_id']);
        $voucher_amount = $claim_item_bean['requested_amount'];
        $voucher_type_caption = $claim_item_bean['details']['type_code'] == "MG_FUEL" ? "محروقات" : "نقدي";


        // validate truck account and limit
        $tenderTruckFilter = [
            ['key' => 'tender_id', 'val' => $claim_item_bean['details']['tender_id']],
            ['key' => 'tn', 'val' => $claim_item_bean['details']['tn']],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0,  $_SESSION['user_id']);
        $financial_details = $tenderTruckResult->data[0]->financial_details;
        if (!$financial_details) {
            throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
        }
        $financial_details = json_decode($financial_details);
        $default_contact_truck_owner_id = $tenderTruckResult->data[0]->default_contact_user_id;
        $truckOwnerBean = $this->_truckOwnerCore->getTruckOwnerBasic($default_contact_truck_owner_id, $_SESSION['user_id']);
        $default_recipient_bean = $this->_userCore->getUserBasic($truckOwnerBean->user_id, $_SESSION['user_id']);

        // Create Post on user Wall
        $sender_id = 266770;
        $sender_name =  "شركة مدارج للخدمات اللوجستية ";
        $writeOnWall = true;
        $body_img = $encodedVoucher;
        $title = "معاملة صرف ";
        $msg = 'تستطيع صرف ' . $voucher_amount . " محروقات وذلك عن طريق ابراز الرمز المرفق في محطات الوطنية المعتمدة  ";
        $body = $this->_socialCore->createPostBody($title, $msg, $body_img, $sender_id, $sender_name);

        // for live
        $default_recipient_user_id = $default_recipient_bean->id;;
        $default_recipient_phone_number = $default_recipient_bean->phone;
        // $taskQueuesCore = new TaskQueuesCore();
        // $taskQueuesCore->createPostOnWallTask($default_recipient_user_id , $body , $title , true);

        // for testing
        // $default_recipient_user_id = 2;
        // $default_recipient_phone_number = "0791233491";
        // $this->_socialCore->createPost($sender_id, $default_recipient_user_id, $body);

        // Generate view voucher QR link
        $smsHash = substr($secret, 0, 20);
        $url =  "g.minagate.com/?c=";
        $sms_url = $url . $smsHash;

        // fetch voucher details
        $voucher_amount = $voucher_amount . " دينار ";
        $smsMsg = "بناءً على رغبتك تم صرف سلفة " .  $voucher_type_caption . " بقيمة " . $voucher_amount . "\n" . " للتفاصيل اضغط على الرابط" . "\n" . $sms_url;

        // send SMS
        $default_recipient_phone_number = convertToInternational($default_recipient_phone_number);
        $sms_msg_result = sendSMS($default_recipient_phone_number, $smsMsg);
        $sms_msg_result = explode("=", $sms_msg_result);

        $details = $claim_item_bean['details'];
        if ($sms_msg_result[4]) {
            $sms_msg_id = trim($sms_msg_result[4]);
            $details['sms_details'] = [];
            $details['sms_details']['status'] = "تم الإرسال";
            $details['sms_details']['msg_id'] = $sms_msg_id;
            $details['sms_details']['text'] = str_replace("\n", " ", $smsMsg);
            $details['sms_details']['recipient'] = $default_recipient_phone_number;
            $details['sms_details']['time_stamp'] = DBConnection::getSystemDate();
        } else {
            $error_msg = trim($sms_msg_result[3]);
            $details['sms_details'] = [];
            $details['sms_details']['recipient'] = $default_recipient_phone_number;
            if (strpos($error_msg, 'Invalid Mobile Number') !== false) {
                $details['sms_details']['status'] = "رقم الهاتف غير صحيح";
            } else {
                $details['sms_details']['status'] = "خطأ في ارسال رسالة الرمز";
            }
        }

        // update claimItem to store sms info
        $smsUpdateData = new stdClass();
        $smsUpdateData->claim_item_id = $claim_item_id;
        $smsUpdateData->details = $details;

        $this->_fps->updateClaimItemDetails($smsUpdateData, $_SESSION['user_id']);
    }

    // ----------------------------------------------------------------- //
    // -------------- resend QR code link and SMS to user -------------- //
    // ----------------------------------------------------------------- //
    public function resendClaimItemSmsLink()
    {

        $claim_id = $this->_request->claim_id;
        $response = $this->informMGClaimRecipient($claim_id);

        $Result = [];
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result);
    }




    public function generateVoucherQrCode()
    {
        //$g = new \Google\Authenticator\GoogleAuthenticator();

        $secret = md5($this->_request->voucher_id);
        $encoder = 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl=';
        $encodedVoucher = $encoder . $secret;

        $Result['voucher_key'] = $encodedVoucher;
        parent::response($Result);
    }

    //////////////////////////// fps check interface ends here ////////////////////////////////////////////////////////
    public function generateVoucherTemplate()
    {
        $template_id = $this->_request->id;

        $data = new stdClass();
        $data->id = $template_id;

        $res = $this->_fps->getVoucherTrx($data, $_SESSION['user_id']);
 
        parent::response($res);
    }
}
new FPS_Voucher_interface();
