<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . '/../../includes/util.php');
require_once(dirname(__FILE__) . '/../../core/user/user_core.php');
require_once(dirname(__FILE__) . '/../../core/payment/payment_core.php');
require_once(dirname(__FILE__) . '/../../core/DBR/dbr_core.php');
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../../core/fps_claim/fps_claim_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . '/../../core/outgoing_integration/poll.php');
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");


class Fps_voucher_core
{


    public function __construct()
    {
        DBConnection::getInstance();
    }


    // ------------------------------------------------------------------ //
    // --------------------- Create Downpayment Voucher------------------ //
    // ------------------------------------------------------------------ //
    public function processDownpaymentPollAnswer($poll_id, $recipient_user_id, $request, $u_id)
    {

        // generate a new session for customer care robot in case the integration token in session is correct
        if ($u_id == 14064) { // 14064= Poll System
            // create session for CUSTOMER_CARE_BOT
            $user_id = 3;
        } else {
            throw new Exception("INAVLID attempt to process poll answer");
        }

        try {

            // init
            $fpsClaimCore = new Fps_claim_core();
            $waybillCore = new WaybillCore();
            $dbrCore = new DBR_Core();
            $tenderCore = new TenderCore();
            $truckOwnerCore = new TruckOwnerCore();
            $queueCore = new QueueCore();

            // Analyze user answers to determine the correct scenarion
            $scenario_info = $this->analyzePollAnswer($poll_id, $recipient_user_id);

            // in case the poll is build on waybill_id
            // get the waybillBean of the poll
            if ($scenario_info->waybill_id) {
                $waybill_id = $scenario_info->waybill_id;
                $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
                if (!$waybillBean) {
                    throw new Exception("invalid waybill_id in poll attributes");
                }

                $truck_id = $waybillBean->truck_id;
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $tender_id = $waybillBean->tender_id;
            }

            // in case the poll is build on queue_id
            else if ($scenario_info->queue_id) {
                $queue_id = $scenario_info->queue_id;
                $queueFilter = [['key' => 'id', 'val' => $queue_id]];
                $queueResult = $queueCore->searchQueue($queueFilter, 1, 0, 0);
                if ($queueResult->found_rows == 0) {
                    throw new Exception("invalid queue_id in poll attributes");
                }

                $truck_id =  $queueResult->data[0]->truck_id;
                $tn =  $queueResult->data[0]->tn;
                $tender_id =  $queueResult->data[0]->tender_id;
            }

            // get the financial manager of the truck
            $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in'],
                ['key' => 'tender_id', 'val' => $tender_id]
            ];
            $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter, 1, 0, $user_id);
            $tenderTruckBean = $tenderTruck_qry->data[0];

            $financial_details = json_decode($tenderTruckBean->financial_details);
            $payment_channel = $financial_details->payment_channel;

            if (!$payment_channel) {
                throw new Exception("Invalid payment method in tender truck");
            }

            $financial_manager_owner_id = $tenderTruck_qry->data[0]->financial_manager_owner_id;
            if (!$financial_manager_owner_id) {
                throw new Exception("Invalid financial manager for the truck in tender truck record");
            }
            $financialManagerBean = $truckOwnerCore->getTruckOwnerBasic($financial_manager_owner_id, $user_id);
            if (!$financialManagerBean->user_id) {
                throw new Exception("Invalid financial manager for the truck, manager has to be user and not company");
            }

            // // in case the user wants the service ... make some validation then create a Claim
            if ($scenario_info->scenario_number == 1 || $scenario_info->scenario_number == 2) {

                if (!$payment_channel) {
                    throw new Exception("Invalid payment method in tender truck");
                }

                // the user cant accept the downpayment after discharge
                if ($waybillBean && $waybillBean->discharge_date) {

                    // send notification to user that answer is done and the system is processing your request
                    $socialCore = new SocialCore();
                    $user_id = $financialManagerBean->user_id;
                    $wall_message_title = "تعذر تحويل مبلغ الدفعة المقدمة";
                    $wall_message_body = "نعتذر عن عدم تمكن النظام من تحويل المبلغ إلى محفظتك، حيث انتهى الوقت المتاح لإستلامها " . "\n";
                    $wall_message_body .= " الشاحنة رقم " . $tn . "أتمت عملية التفريغ" . "\n";
                    $wall_message_body .= "تستطيع مراجعة مكتب مدارج في الزرقاء لاستلام مستحقات الرحلة كاملة";
                    $notification_title = $wall_message_title;
                    $notification_message = $wall_message_body;
                    // $socialCore->informUser($wall_message_title, $wall_message_body, $notification_title, $notification_message, $user_id);

                    throw new Exception("cant proceed with downpayment after discharge the waybill");
                }

                // create claim (total amount , new , empty items)
                $activation_date = DBConnection::getSystemDate();
                $due_date = null;

                $notes = "مطالبة دفعة مقدمة للشاحنة $tn";
                $claimResult = $fpsClaimCore->createWaybillDownpaymentClaim($waybill_id, $queue_id, $notes, $activation_date, $due_date, $user_id);
                $claim_id = $claimResult['claim_id'];
                if (!$claim_id) {
                    throw new Exception("the system could not create claim for waybill: $waybill_id , queue: $queue_id");
                }
            }

            //  The user accept the money and does not want driver wage service
            if ($scenario_info->scenario_number == 1) {

                // create one voucher for the financial manager
                $dbr = $dbrCore->calculateTruckDownPayment($tn, $tender_id);
                $voucher_amount = $dbr['down_payment']['value'];
                $recipient_user_id  = $financialManagerBean->user_id;
                $notes = "أمر صرف كدفعة مقدمة للشاحنة $tn";
                $this->createDownpaymentVoucher($waybill_id, $queue_id, $voucher_amount, $claim_id, $recipient_user_id, "DOWNPAYMENT", $payment_channel, $notes, $user_id);

                $wall_message_title = null;
                $wall_message_body = null;
                $notification_title = "شكرا لك، تم استقبال اجابتك بنجاح";
                $notification_message = "جار العمل على تحويل المبلغ لمحفظتك";
            }

            // The user accept the money and want driver wage service
            else if ($scenario_info->scenario_number == 2) {

                // create first voucher for the financial manager
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $tender_id = $waybillBean->tender_id;

                $dbr = $dbrCore->calculateTruckDownPayment($tn, $tender_id);
                $voucher_amount = $dbr['down_payment']['value'] - $scenario_info->driver_wage;
                $recipient_user_id  = $financialManagerBean->user_id;
                $notes1 = "أمر صرف كدفعة مقدمة عن رحلة الشاحنة $waybillBean->wn";
                $this->createDownpaymentVoucher($waybill_id, $queue_id, $voucher_amount, $claim_id, $recipient_user_id, "DOWNPAYMENT", $payment_channel, $notes1, $user_id);

                // create the second voucher for the driver 
                $driver_user_id = $scenario_info->driver_user_id;
                $notes2 = "أمر صرف بدل اجرة للسائق عن رحلة الشاحنة رقم $tn";
                $driver_voucher_amount = $scenario_info->driver_wage;
                $this->createDownpaymentVoucher($waybill_id, $queue_id, $driver_voucher_amount, $claim_id, $driver_user_id, "DRIVER_WAGE", $payment_channel, $notes2, $user_id);

                $wall_message_title = null;
                $wall_message_body = null;
                $notification_title = "شكرا لك، تم استقبال اجابتك بنجاح";
                $notification_message = "جار العمل على تحويل المبلغ لمحفظتك وتحويل أجرة السائق على محفظته";
            }

            // the user rejected the service
            else if ($scenario_info->scenario_number == 3) {
                $wall_message_title = null;
                $wall_message_body = null;
                $notification_title = "نأسف لعدم قبولك للخدمة";
                $notification_message = "تستطيع مراجعة مكتب مدارج بعد عملية التفريغ لصرف الوصل, نتمنى العمل معك في المرات القادمة";
            } else {
                throw new Exception("the system could not parse user answers for the poll");
            }


            // send notification to user that answer is done and the system is processing your request
            $socialCore = new SocialCore();
            //$user_id = $financialManagerBean->user_id;
            //$socialCore->informUser($wall_message_title, $wall_message_body, $notification_title, $notification_message, $user_id);
        } catch (Exception $ex) {

            // something went wrong, inform the financial manager of the truck that the poll answer is failed
            // TODO: discuss if this step is good or not

            // inform supervisor, then put this request on failed downpayment queue to be reviewd manualy
            $this->generateAnswerPollFailReport($poll_id, $recipient_user_id, $ex->getMessage(), $request);
        }
    }

    // generate full report for IT suport to review the reason of answer failure
    private function generateAnswerPollFailReport($poll_id, $recipient_user_id, $error_msg, $request)
    {

        $socialCore = new SocialCore();

        // send this as wall post to supervisor
        $notification_message = "error in poll answer";
        $wall_message_title = "error in poll answer";
        $wall_message_body = "poll_id=$poll_id, recipient_user_id=$recipient_user_id, error_message=$error_msg";
        $operation_manager_id = 2;
        $socialCore->informSupervisor($wall_message_title, $wall_message_body, $notification_message, $operation_manager_id);

        // push this error on queue
        $taskQueuesCore = new TaskQueuesCore();
        // $taskQueuesCore->createDownpaymentPollFailAnswerTask($poll_id, $wall_message_body, 0, $request);
    }


    // ---------------------------------------------------------------------------------------- //
    // ----------------- Analyze user answers to determine the correct scenarion -------------- //
    // ---------------------------------------------------------------------------------------- //
    public function analyzePollAnswer($poll_id, $recipient_user_id)
    {
        $pollIntegration = new Poll();
        $driverCore = new DriverCore();

        $result = new stdClass();

        // get the user answer
        $pollBean = $pollIntegration->getPoll($poll_id);

        $recipients = $pollBean['recipients'];
        $recBean = null;
        foreach ($recipients as $rec) {
            if ($rec['remote_user_id'] == $recipient_user_id) {
                $recBean = $rec;
            }
        }

        $answers = json_decode($recBean['answers']);
        $bind_params = json_decode($recBean['bind_params'], true);
        $result->waybill_id = $pollBean['details']['attributes']['waybill_id'];
        $result->queue_id = $pollBean['details']['attributes']['queue_id'];


        $question_0_answer = ""; // question_0: do you want the money or not
        $question_1_answer = ""; // question_1: confirm that user does not want the service
        $question_2_answer = ""; // question_2: confirm wallet phone
        $question_3_answer = ""; // question_3: do you to give driver wage
        $question_4_answer = ""; // question_4: driver id of the wage
        $question_8_answer = ""; // question_8: I am sure o give driver wage to new driver
        $question_6_answer = ""; // question_6: driver phone
        $question_5_answer = ""; // question_5: driver wage amount

        foreach ($answers as $ans) {
            if ($ans->question_id == 0) $question_0_answer = $ans->value;
            if ($ans->question_id == 1) $question_1_answer = $ans->value;
            if ($ans->question_id == 2) $question_2_answer = $ans->value;
            if ($ans->question_id == 3) $question_3_answer = $ans->value;
            if ($ans->question_id == 4) $question_4_answer = $ans->value;
            if ($ans->question_id == 5) $question_5_answer = $ans->value;
            if ($ans->question_id == 6) $question_6_answer = $ans->value;
            if ($ans->question_id == 8) $question_8_answer = $ans->value;
        }


        // ------------------------------- analayze ansewrs -----------------------------------

        // The user accept the money and dconfirm wallet phone
        if ($question_0_answer == "1" && $question_2_answer == "1") {
            $result->scenario_number = 1;
            $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
            $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];
        }

        // The user accept the money but the phone wallet is wrong
        if ($question_0_answer == "1" && $question_2_answer == "0") {
            $result->scenario_number = 3;
            $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
            $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];
        }

        // The user rejected the money then changed his mind
        if ($question_0_answer == "0" && $question_1_answer == "1" && $question_2_answer == "1") {
            $result->scenario_number = 1;
            $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
            $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];
        }

        // The user rejected the money then changed his mind then the wallet phone is wrong
        if ($question_0_answer == "0" && $question_1_answer == "1" && $question_2_answer == "0") {
            $result->scenario_number = 3;
            $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
            $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];
        }

        // The user accept the money and want driver wage service
        if ($question_0_answer == "1" &&  $question_3_answer == "1") {

            $result->scenario_number = 2;

            // TODO: if the driver has already worked on the truck
            if ($question_4_answer && $question_4_answer != "") {
                $result->driver_id = $question_4_answer;
                $result->driver_wage = convertArabicNumbers($question_5_answer);

                // search for driver user id
                $driverFilter = [['key' => 'id', 'val' => $result->driver_id]];
                $driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
                $result->driver_user_id = $driver_qry->data[0]->user_id;
            }

            // if the driver is total new on this truck
            else if ($question_8_answer == "1") {
                $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
                $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];

                // search for driver
                $driver_phone = convertArabicNumbers($question_6_answer);
                $driver_phone = convertToInternational($driver_phone);
                $driverFilter = [
                    ['key' => 'phone', 'val' => $driver_phone],
                    ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                ];

                $driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
                if ($driver_qry->found_rows > 0) {
                    $result->driver_user_id = $driver_qry->data[0]->user_id;
                    $result->driver_id = $driver_qry->data[0]->id;
                    $result->driver_wage = $question_5_answer;
                } else {
                    $result->driver_user_id = null;
                    $result->driver_id = null;
                    $result->driver_wage = 0;
                }
            }
        }

        // The user reject the service
        if ($question_0_answer == "0" &&  $question_1_answer == "0") {
            $result->scenario_number = 3;
            $result->amount = $bind_params['_$_PAYMENT_AMOUNT_$_'];
            $result->phone  = $bind_params['_$_WALLET_PHONE_NUMBER_$_'];
        }

        return $result;
    }





    // ---------------------------------------------------------------------------------------------- //
    // --------- Create New MG PAY voucher : these voucher needs to be prossed from 3rd party ------- //
    // ---------------------------------------------------------------------------------------------- //
    public function creat_MG_PAY_voucher(
        $account_id,
        $tender_id,
        $pa_id,
        $claim_id,
        $recipient_name,
        $voucher_amount,
        $voucher_type,
        $recipient_company_id,
        $target_company_id,
        $done_by
    ) {
        $fps = new FPS();
        $paymentAgentCore = new PaymentAgentCore();
        $ledger_account_id = 590000;

        // validate things
        if ($voucher_type == "MG_CASH") {
            $payment_method_code = "MG_CASH";
            $notes = "سلفة نقدية";
        } else if ($voucher_type == "MG_FUEL") {
            $payment_method_code = "MG_FUEL";
            $notes = "سلفة محروقات";
        } else {
            throw new Exception("Not supported MG Pay allowed method - " . $voucher_type);
        }

        // generate vouhcer basic info
        $voucherBasicInfo = $this->generateMGPayVoucherBasicInfo($account_id, $tender_id, $done_by);
        //$notes .= " للشاحنة رقم " . $voucherBasicInfo->tn;

        // generate vouhcer trx info
        $voucherTrxInfo = $this->generateMGPayVoucherTrxTemplate($tender_id, $pa_id, $voucher_type, $voucher_amount, $notes,$target_company_id, $done_by);

        // generate Voucher Auth Info
        $auth = $this->generateMGPayVoucherAuthorityInfo($voucherTrxInfo['trx_template'], null, $recipient_company_id, $done_by);

        // generate vouhcer integration info
        $integerationDetails = new stdClass();
        $integerationDetails->wallet_id = $auth['wallet_id'];
        $integerationDetails->claim_id = $claim_id;
        $integerationDetails->tn = $voucherBasicInfo->tn;
        $integerationDetails->notes = $notes;
        $integerationDetails->amount = $voucher_amount;
        $integerationInfo = $this->generateVoucherIntegrationInfo($voucher_type, $integerationDetails, $done_by);

        // combinbe all into voucher data
        $voucher_data = new stdClass();
        $voucher_data->authority = $auth['authority'];
        $voucher_data->voucher_destination = [$auth['destination']];
        $voucher_data->jv_template = $voucherTrxInfo;
        $voucher_data->amount = $voucher_amount;
        $voucher_data->payment_method_code = $payment_method_code;
        $voucher_data->recipient_name = $recipient_name;
        $voucher_data->tn = $voucherBasicInfo->tn;
        $voucher_data->pa_id = $pa_id;
        $voucher_data->recipient_user_id = null;
        $voucher_data->recipient_nn = null;
        $voucher_data->claim_id = $claim_id;
        $voucher_data->integration_details = $integerationInfo;

        // create voucher
        $voucher_id = $fps->createVoucher($voucher_data, $done_by);

        return $voucher_id;
    }


    public function generateMGPayVoucherBasicInfo($account_id, $tender_id, $done_by)
    {
        $tenderCore = new TenderCore();
        $fps = new FPS();
        $truckCore = new TruckCore();

        // get needed info from account
        $accountBean =  $fps->getAccountBasic($account_id, 0);

        if ($accountBean && $accountBean != "null") {
            $tn = $accountBean['sub_id'];
        } else {
            $tn = $account_id;
        }

        // get needed info from tender
        $tenderBean = $tenderCore->getTenderBasic($tender_id, 0);
        $tender_id = $tenderBean->id;
        $tender_name = $tenderBean->manifest->name;

        // get truck_id if exist
        $tnSearchFilter = [
            ['key' => 'tn', 'val' => $tn]
        ];
        $truckBean = $truckCore->searchTrucks($tnSearchFilter, 1, 0, 0)->data[0];

        // return result
        $result = new stdClass();
        $result->tn = $tn;
        $result->tender_id = $tender_id;
        $result->tender_name = $tender_name;
        $result->truck_id = $truckBean->id;

        return $result;
    }

    public function generateMGPayVoucherTrxTemplate($tender_id, $pa_id, $voucher_type, $voucher_amount, $notes, $target_company_id , $done_by)
    {

        $voucherCore = new VoucherCore();
        $paymentAgentCore = new PaymentAgentCore();
        $fps = new FPS();
        $accountCore = new AccountCore();

        // get tender_pa
        $tenderPaFilter = [
            ['key' => 'pa_id', 'val' => $pa_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderPa = $paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];

        // loop om trx details to search for the correct one
        $voucher_template = null;
        $jv_template = json_decode($tenderPa->pa_jv_template);
        foreach ($jv_template as $template) {
            if ($template->code == $voucher_type) {
                $voucher_template = $template;
            }
        }

        // fill dynamic params
        $item = [];
        $item['note'] = $notes;

        $sourceAccountBean = null;
        $tagreeshFreight = new stdClass();
        $tagreeshFreight->net_amount = $voucher_amount;

        $paymentObj = new stdClass();
        $paymentObj->value = $voucher_amount;

        $accountFilter = new stdClass();
        $accountFilter->filter = [
            "target_company_id" => $target_company_id,
            "status" => "ACTIVE"
        ];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry = $fps->searchAccount($accountFilter, $done_by); 
        $source_account_id = $account_qry['data'][0]['id'] . "-" . $account_qry['data'][0]['sub_id'];

        $paymentObj->source_account_id = $source_account_id;
        $trx_template = $voucherCore->generateVoucherTrx($voucher_template->template, $sourceAccountBean, $paymentObj, $tagreeshFreight, $item);

        // format data
        $jv_template = [];
        $jv_template['code'] = $voucher_type;

        $jv_note = new stdClass();
        $jv_note->notes = $notes;
        $jv_note->text = "jv_note";
        $jv_template['jv_note'] = $jv_note;
        $jv_template['trx_template'] = $trx_template;
        $voucher_note = new stdClass();
        $voucher_note->text = $jv_note;
        $jv_template['voucher_note'] = $voucher_note;

        return $jv_template;
    }

    public function generateMGPayVoucherAuthorityInfo($trx_template, $rec_user_id, $rec_company_id, $done_by)
    {
        $fps = new FPS();

        // authority object
        foreach ($trx_template as $trx) {

            if ($trx['source_account']) {
                $voucherData = new stdClass();
                $authority = new stdClass();

                if ($trx['account_id']) {
                    $authority->source_account_id = explode("-", $trx['account_id'])[0];
                    $authority->source_sub_id = explode("-", $trx['account_id'])[1];
                    $voucherData->authority = $authority;
                } else if ($trx['value']) {
                    $authority->source_account_id = explode("-", $trx['value'])[0];
                    $authority->source_sub_id = explode("-", $trx['value'])[1];
                    $voucherData->authority = $authority;
                }

                // get the wallet id in case the source account is zain cash account
                // $sourceAccountBean = $fps->getAccountBasic($authority->source_account_id . "-" . $authority->source_sub_id, $done_by);
                // $company_bank_account_id = $sourceAccountBean['company_bank_account_id'];
                // if ($company_bank_account_id) {
                //     $companyBankAccount = $fps->getCompanyBankAccount($company_bank_account_id, $done_by);
                //     $wallet_id = $companyBankAccount['integration_details']['wallet_id'];
                // }else{
                    $wallet_id = null;
                // }
            }
        }

        // destination object
        $destination = new stdClass();
        $destination->user_id =  $rec_user_id;
        $destination->company_id =  $rec_company_id;   // in case the recipients is a company
        $destination->is_beneficiary = 1;
        $voucherData->voucher_destination[] = $destination;

        $result = ["destination" => $destination, "authority" => $authority, "wallet_id" => $wallet_id];
        return $result;
    }

    public function generateVoucherIntegrationInfo($scenarionType, $integerationDetails, $done_by)
    {

        $integration_details = new stdClass();
        $integration_details->callback = new stdClass();

        switch (strtoupper($scenarionType)) {
            case 'WAYBILL_COMPLETE':
                $integration_details->callback->endpoint = "waybill";
                $integration_details->callback->method = "addWaybillCompleteData";

                $integration_details->callback->params = [
                    "waybill_id" => $integerationDetails->waybill_id,
                    "origin_id" => $integerationDetails->origin_id,
                    "destination_id" => $integerationDetails->destination_id,
                    "loading_weight" => $integerationDetails->loading_weight,
                    "loading_date" => $integerationDetails->loading_date,
                    "discharge_weight" => $integerationDetails->discharge_weight,
                    "discharge_date" => $integerationDetails->discharge_date,
                    "amount" => $integerationDetails->amount,
                ];

                break;

            case 'MG_FUEL':
            case 'MG_CASH':
                $integration_details->callback->endpoint = "fps_claim";
                $integration_details->callback->method = "activateTruckClaim";

                $integration_details->callback->params = [
                    "claim_id" =>  $integerationDetails->claim_id,
                    "tn" => $integerationDetails->tn,
                    "notes" => $integerationDetails->notes,
                    "amount" => $integerationDetails->amount
                ];

                break;
            case 'CASH_DOWNPAYMENT':
                $integration_details->callback->endpoint = "social";
                $integration_details->callback->method = "generateDownpaymentPost";

                $integration_details->callback->params = [
                    "recipient_user_id" => $integerationDetails->recipient_user_id,
                    "waybill_id" => $integerationDetails->waybill_id,
                    "queue_id" => $integerationDetails->queue_id,
                    "tender_id" => $integerationDetails->tender_id,
                    "tender_name" => $integerationDetails->tender_name,
                    "phone" => $integerationDetails->recipient_phone,
                    "tn" => $integerationDetails->tn
                ];

                break;
            case 'DRIVER_WAGE':
                $integration_details->callback->endpoint = "social";
                $integration_details->callback->method = "generateDriverWagePost";

                $integration_details->callback->params = [
                    "recipient_user_id" => $integerationDetails->recipient_user_id,
                    "waybill_id" => $integerationDetails->waybill_id,
                    "queue_id" => $integerationDetails->queue_id,
                    "tender_id" => $integerationDetails->tender_id,
                    "tender_name" => $integerationDetails->tender_name,
                    "phone" => $integerationDetails->recipient_phone,
                    "tn" => $integerationDetails->tn
                ];

                break;

            default:
                break;
        }

        return $integration_details;
    }


    // ------------------------------------------------------------------ //
    // --------------------- Create Downpayment Voucher------------------ //
    // ------------------------------------------------------------------ //
    private function createDownpaymentVoucher(
        $waybill_id,
        $queue_id,
        $voucher_amount,
        $claim_id,
        $recipient_user_id,
        $voucher_type,
        $payment_method,
        $notes,
        $user_id
    ) {

        $fps = new FPS();
        $paymentCore = new PaymentCore();
        $waybillCore = new WaybillCore();
        $userCore = new UserCore();
        $voucherCore = new VoucherCore();
        $queueCore = new QueueCore();

        // validate inputs        
        if ($voucher_amount == 0) {
            throw new Exception("لا تستطيع المتابعة قيمة أمر الصرف غير صحيحة");
        }

        // get needed info from waybill
        if ($waybill_id) {
            $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);
            if (!$waybillBean) {
                throw new Exception("waybill id is invalid");
            }

            $tender_id = $waybillBean->tender_id;
            $tn = $waybillBean->document->carrier[0]->truck->tn;
            $tender_name = $waybillBean->document->tender->name;
            $truck_id = $waybillBean->truck_id;
        }

        // get needed info from queue
        else if ($queue_id) {
            $queueFilter = [['key' => 'id', 'val' => $queue_id]];
            $queueResult = $queueCore->searchQueue($queueFilter, 1, 0, 0);
            if ($queueResult->found_rows == 0) {
                throw new Exception("queue id is invalid");
            }

            $tn =  $queueResult->data[0]->tn;
            $tender_id =  $queueResult->data[0]->tender_id;
            $tender_name = $queueResult->data[0]->tender_name;
            $truck_id = $queueResult->data[0]->truck_id;
        }

        $userBean = $userCore->getUserBasic($recipient_user_id, $user_id);
        if (!$userBean) {
            throw new Exception("recipient_user_id is invalid");
        }

        // get voucher trx template
        if ($voucher_type == "DOWNPAYMENT") {
            $trx_template = $paymentCore->generateVoucherTrx($tender_id, 'DOWNPAYMENT');
        } else if ($voucher_type == "DRIVER_WAGE") {
            $trx_template = $paymentCore->generateVoucherTrx($tender_id, 'DRIVER_WAGE');
        }

        if (!$trx_template) {
            throw new Exception("Tender has no trx_template");
        }

        // generate voucher trx
        $item = [];
        $item['driver_name'] = $userBean->name;
        $ledger_account_id = 590000;
        $sourceAccountBean = $fps->getAccountBasic($ledger_account_id, $user_id);
        $paymentObj = new stdClass();
        $paymentObj->value = $voucher_amount;
        $paymentObj->target_account_id = $ledger_account_id . "-" . $tn;
        $trx_template = $voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $paymentObj, null, $item);

        // authority object
        foreach ($trx_template as $trx) {
            if ($trx['source_account']) {
                $voucherData = new stdClass();
                $authority = new stdClass();
                $authority->source_account_id = $ledger_account_id;
                $authority->source_sub_id = explode("-", $trx['account_id'])[1];
                $voucherData->authority = $authority;

                $sourceAccountBean = $fps->getAccountBasic($authority->source_account_id . "-" . $authority->source_sub_id, $user_id);
                $company_bank_account_id = $sourceAccountBean['company_bank_account_id'];
                $companyBankAccount = $fps->getCompanyBankAccount($company_bank_account_id, $user_id);
                $wallet_id = $companyBankAccount['integration_details']['wallet_id'];
            }
        }

        // destination object
        $destination = new stdClass();
        $destination->user_id =  $userBean->id;
        $destination->company_id =  null;   // in case the recipients is a company
        $destination->is_beneficiary = 1;
        $voucherData->voucher_destination[] = $destination;

        // jv_template array
        $jv_template = [];
        $jv_template['code'] = $voucher_type;
        $jv_note = new stdClass();
        $jv_note->notes = $notes;
        $jv_note->text = "jv_note";
        $jv_template['jv_note'] = $jv_note;
        $jv_template['trx_template'] = $trx_template;

        $voucher_note = new stdClass();
        $voucher_note->text = $jv_note;
        $jv_template['voucher_note'] = $voucher_note;

        $voucherData->jv_template = $jv_template;
        $voucherData->amount = $voucher_amount;
        $voucherData->payment_method_code = strtoupper($payment_method);
        $voucherData->recipient_name = $userBean->name;

        $voucherData->integration_details = new stdClass();
        $voucherData->integration_details->wallet_id = $wallet_id;
        $voucherData->integration_details->recipient_phone = $userBean->phone;

        $voucherData->integration_details->waybill = new stdClass();
        $voucherData->integration_details->waybill->id = $waybill_id;

        $voucherData->integration_details->queue = new stdClass();
        $voucherData->integration_details->queue->id = $queue_id;

        $voucherData->integration_details->truck = new stdClass();
        $voucherData->integration_details->truck->id = $truck_id;

        $voucherData->integration_details->claim = new stdClass();
        $voucherData->integration_details->claim->id = $claim_id;
        $voucherData->integration_details->claim->tn = $tn;
        $voucherData->integration_details->claim->waybill_id = $waybill_id;
        $voucherData->integration_details->claim->queue_id = $waybill_id;
        $voucherData->integration_details->claim->tender_id = $tender_id;
        $voucherData->integration_details->claim->tender_name = $tender_name;

        $voucherData->integration_details->callback = new stdClass();
        $voucherData->integration_details->callback->endpoint = "social";
        if ($voucher_type == "DOWNPAYMENT") {
            $voucherData->integration_details->callback->method = "generateDownpaymentPost";
        } else if ($voucher_type == "DRIVER_WAGE") {
            $voucherData->integration_details->callback->method = "generateDriverWagePost";
        }

        $voucherData->integration_details->callback->params = [
            "recipient_user_id" => $userBean->id,
            "waybill_id" => $waybill_id,
            "queue_id" => $waybill_id,
            "tender_id" => $tender_id,
            "tender_name" => $tender_name,
            "phone" => $userBean->phone,
            "tn" => $tn
        ];

        $voucherData->recipient_phone = $userBean->phone;
        $voucherData->recipient_user_id = $userBean->id;
        $voucherData->recipient_nn = $userBean->nn;

        // create voucher
        $voucher_id = $fps->createVoucher($voucherData, $user_id);

        // process voucher to start the payment process
        $processData = new stdClass();
        $processData->voucher_id = $voucher_id;
        $fps->processVoucherTrx($processData, $user_id);
    }


    // ----------------------------------------------------------------------- //
    // --------------------- Create Waybill_complete Voucher------------------ //
    // ----------------------------------------------------------------------- //
    public function createWaybillCompletetVoucher($waybill_id, $user_id)
    {

        $fps = new FPS();
        $paymentCore = new PaymentCore();
        $waybillCore = new WaybillCore();
        $tenderCore = new TenderCore();
        $truckOwnerCore = new TruckOwnerCore();
        $userCore = new UserCore();

        // get waybillBean
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);

        // get voucher trx template
        $trx_template = $paymentCore->generateVoucherTrx($waybillBean->tender_id, 'WAYBILL_COMPLETE');
        $ledger_account_id = 590000;
        $trx_template = $waybillCore->generateWaybillSettelmentTrx($waybill_id, $trx_template, $user_id);
        $voucher_amount = 0;


        // authority object
        foreach ($trx_template as $trx) {
            if ($trx['source_account']) {
                $voucherData = new stdClass();
                $authority = new stdClass();
                $authority->source_account_id = $ledger_account_id;
                $authority->source_sub_id = explode("-", $trx['account_id'])[1];
                $voucherData->authority = $authority;

                $sourceAccountBean = $fps->getAccountBasic($authority->source_account_id . "-" . $authority->source_sub_id, $user_id);
                $company_bank_account_id = $sourceAccountBean['company_bank_account_id'];
                $companyBankAccount = $fps->getCompanyBankAccount($company_bank_account_id, $user_id);
                $wallet_id = $companyBankAccount['integration_details']['wallet_id'];

                // calculate voucher amount (net_amount - claim_amount) or the source trx
                $voucher_amount = $trx['amount'];
            }
        }

        // if there is a trx but the voucher amount is 0, dont create it, just make the trx
        if ($voucher_amount == 0 && sizeof($trx_template) > 0) {
            $data = new stdClass();
            $data->ledger_account_id = $ledger_account_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks = "تسوية مالية للشاحنة عن المستند رقم: " . $waybillBean->wn;
            $data->trx = $trx_template;
            $fps->createTrx($data, $user_id);
            $result = [];
            $result['voucher_id'] = null;
            $result['voucher_amount'] = 0;
            $result['recipient_name'] = null;
            return $result;
            die;
        }

        $voucherData = new stdClass();
        $authority = new stdClass();
        $authority->source_account_id = $ledger_account_id;
        $authority->source_sub_id = 14002;
        $voucherData->authority = $authority;

        // get payment channel
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderFilter = [
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $waybillBean->tender_id]
        ];
        $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter, 1, 0, $user_id);
        $tenderTruckBean = $tenderTruck_qry->data[0];
        $financial_details = json_decode($tenderTruckBean->financial_details);
        $payment_channel = $financial_details->payment_channel;
        $financial_manager_owner_id = $tenderTruckBean->financial_manager_owner_id;

        $financialManagerBean = $truckOwnerCore->getTruckOwnerBasic($financial_manager_owner_id, $user_id);
        $userBean =  $userCore->getUserBasic($financialManagerBean->user_id, $user_id);

        // destination object
        $destination = new stdClass();
        $destination->user_id =  $userBean->id;
        $destination->company_id =  null;   // in case the recipients is a company
        $destination->is_beneficiary = 1;
        $voucherData->voucher_destination[] = $destination;

        // jv_template array
        $jv_template = [];
        $jv_template['code'] = "WAYBILL_COMPLETE";
        $jv_note = new stdClass();
        $jv_note->notes = " مستحقات رحلة المستند رقم " . $waybillBean->wn;
        $jv_note->text = "jv_note";
        $jv_template['jv_note'] = $jv_note;
        $jv_template['trx_template'] = $trx_template;

        $voucher_note = new stdClass();
        $voucher_note->text = $jv_note;
        $jv_template['voucher_note'] = $voucher_note;

        $voucherData->jv_template = $jv_template;
        $voucherData->amount = $voucher_amount;
        $voucherData->payment_method_code = strtoupper($payment_channel);
        $voucherData->recipient_name = $userBean->name;

        $voucherData->integration_details = new stdClass();
        if (strtoupper($payment_channel) == "ZAIN_CASH") {
            $voucherData->integration_details->wallet_id = $wallet_id;
            $voucherData->integration_details->recipient_phone = $userBean->phone;
        }

        $voucherData->integration_details->waybill = new stdClass();
        $voucherData->integration_details->waybill->id = $waybillBean->id;
        $voucherData->integration_details->callback = new stdClass();

        $voucherData->recipient_phone = $userBean->phone;
        $voucherData->recipient_user_id = $userBean->id;
        $voucherData->recipient_nn = $userBean->nn;
        $voucherData->tender_id = $waybillBean->tender_id;

        // create voucher
        $voucher_id = $fps->createVoucher($voucherData, 0);

        // process voucher to start the payment process
        //$processData = new stdClass();
        //$processData->voucher_id= $voucher_id;
        //$fps->processVoucherTrx($processData, $user_id);

        $result = [];
        $result['voucher_id'] = $voucher_id;
        $result['voucher_amount'] = $voucher_amount;
        $result['recipient_name'] = $userBean->name;
        return $result;
    }



    // -------------------------------------------------------------------------- //
    // ---------------- Generate Fps Voucher trx from template ------------------ //
    // -------------------------------------------------------------------------- //
    public function generateFpsVoucherTrx($template_id, $data, $recipient_company_id, $notes , $trx_only = null)
    {

        // get the raw template
        $sqlQuery = " select  CAST(`trx` AS CHAR CHARSET UTF8) AS trx from voucher_trx_template where id = ?";
        $template = DBConnection::runBindDatabaseQuery($sqlQuery, [$template_id]);
        $jv_trx = $template[0]->trx;

        // fill missing info in raw temaplte
        foreach ($data as $key => $value) {
            $jv_trx = str_replace($key,  $value, $jv_trx);
        }
        $jv_trx = json_decode($jv_trx, true);
        if($trx_only){
            return $jv_trx;
        }

        // generate Voucher Auth Info
        $authority = new stdClass();
        $authority->source_account_id = explode("-", $jv_trx[0]['account'])[0];
        $authority->source_sub_id = explode("-", $jv_trx[0]['account'])[1];
        $destination = new stdClass();
        $destination->user_id =  null;
        $destination->company_id =  $recipient_company_id;   // in case the recipients is a company
        $destination->is_beneficiary = 1;
        $auth = ["destination" => $destination, "authority" => $authority];

        // jv_template array
        $jv_template = [];
        $jv_template['code'] = "LAND_TRIP_COMPLETE";
        $jv_note = new stdClass();
        $jv_note->notes = $notes;
        $jv_note->text = "jv_note";
        $jv_template['jv_note'] = $notes;
        $jv_template['trx_template'] = $jv_trx;
        $voucher_note = new stdClass();
        $voucher_note->text = $jv_note;
        $jv_template['voucher_note'] = $voucher_note;

        // combinbe all into voucher data
        $voucher_data = new stdClass();
        $voucher_data->authority = $auth['authority'];
        $voucher_data->voucher_destination = [$auth['destination']];
        $voucher_data->jv_template = $jv_template;
        $voucher_data->amount = $data->voucher_amount;
        $voucher_data->payment_method_code = strtoupper($data->payment_method_code);
        $voucher_data->recipient_name = "";
        $voucher_data->tn = $data->tn;
        $voucher_data->land_trip_id = $data->land_trip_id;
        $voucher_data->pa_id = $data->pa_id;
        $voucher_data->recipient_user_id = null;
        $voucher_data->recipient_nn = null;
        $voucher_data->integration_details = $data->integerationInfo;

        // create voucher
        $fps = new FPS();
        $voucher_id = $fps->createVoucher($voucher_data, 0);

        return $voucher_id;
    }

 
}
