<?php

// import required classes

require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../pa_route_wage/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/../payment/payment_core.php");
require_once(dirname(__FILE__) . "/../voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../company/company_core.php");
require_once(dirname(__FILE__) . "/../payment/payment_core.php");
require_once(dirname(__FILE__) . "/../voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../location/location_core.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/fps_claim_core.php");
require_once(dirname(__FILE__) . "/../pa_route_wage/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");

class FpsClaims_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_fps;
    private $_fps_claim_core;
    private $_waybillCore;
    private $_tenderCore;
    private $_truckOwnerCore;
    private $_companyCore;
    private $_paymentCore;
    private $_voucherCore;
    private $_tenderClaimCore;
    private $_routeWageCore;
    private $_cargoCore;
    private $_locationCore;
    private $_paRouteWageCore;
    private $_truckingCompanyCore;
    private $_fpsVoucherCore;
    private $_customerCare;
    private $_con;
    private $_ca;
    public function __construct()
    {
        $this->_fps = new FPS();
        $this->_fps_claim_core = new Fps_claim_core();
        $this->_waybillCore = new WaybillCore();
        $this->_tenderCore = new TenderCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_companyCore = new CompanyCore();
        $this->_paymentCore = new PaymentCore();
        $this->_voucherCore = new VoucherCore();
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_tenderClaimCore = new TenderClaimCore();
        $this->_routeWageCore = new RouteWageCore();
        $this->_cargoCore = new CargoCore();
        $this->_locationCore = new LocationCore();
        $this->_paRouteWageCore = new PaRouteWageCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_truckCore = new TruckCore();
        $this->_customerCare = new CustomerCare();
        $this->_fpsVoucherCore = new Fps_voucher_core();
        $this->_con = new Container();
        $this->_ca = new ClearingAgentCore();
        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // -------------------------------------------------------------------- //
    // --------------------- get single claim info ------------------------ //
    // -------------------------------------------------------------------- //
    public function getClaim()
    {
        $id = $this->_request->id;
        $claimsReuslt =  $this->_fps->getClaim($id, $_SESSION["user_id"]);

        // fix date format
        $claimsReuslt['create_date'] =  date_format(date_create($claimsReuslt['create_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['create_date']), "H:i");
        $claimsReuslt['due_date'] =  date_format(date_create($claimsReuslt['due_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['due_date']), "H:i");
        $claimsReuslt['activation_date'] =  date_format(date_create($claimsReuslt['activation_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['activation_date']), "H:i");

        // get remaining amount
        $remainingAmount =  $this->_fps->getClaimRemainingAmount($id, $_SESSION["user_id"]);
        $claimsReuslt['remaining_amount'] = number_format($remainingAmount, 3);

        $claimAmount =  $this->_fps->getClaimAmount($id, $_SESSION["user_id"]);
        $claimsReuslt['claim_amount'] = number_format($claimAmount, 3);

        // get print_template
        $accountFilter = new stdClass();
        $accountFilter->filter = ["target_company_id" => $_SESSION["company_id"], "type" => "AR"];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry =  $this->_fps->searchAccount($accountFilter, 0);

        $details = json_decode($account_qry['data'][0]['details']);
        $claimsReuslt['print_template'] = $details->print_template;

        if (!$claimsReuslt['print_template']) {
            $claimsReuslt['print_template']  = "AR_claim";
        }

        // get claim item
        if ($claimsReuslt['payee_reference']['reference_code'] == "TRUCK_OWNER") {
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = [$claimsReuslt['id']];
            $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            $item_details = json_decode($claim_items['data'][0]['details']);
            $share_link = $item_details->sms_details->text;
            $share_link = explode("g.minagate.com", $share_link);
            $share_link = "g.minagate.com" . $share_link[1];
            $claimsReuslt['share_link'] = $share_link;

            $secret = md5($claim_items['data'][0]['id']);
            $encoder = 'https://chart.googleapis.com/chart?chs=200x200&chld=M%7C0&cht=qr&chl=';
            $QR_code_url = $encoder . $secret;
            $claimsReuslt['QR_code_url'] = $QR_code_url;
        }

        parent::response($claimsReuslt);
    }



    // --------------------------------------------------------------------------- //
    // --------------------- get multi claims info by filter------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchClaims()
    {
        try {

            // get claims
            $request = $this->_request;
            $request->order_by = " order by id desc";
            $claimsReuslt =  $this->_fps->searchClaims($request, $_SESSION["user_id"]);

            // get claim_items
            $claimIds = [];
            foreach ($claimsReuslt['data'] as $claim) {
                $claimIds[] = $claim['id'];
                if (sizeof($claimIds) >= 980) {
                    break;
                }
            }

            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = $claimIds;
            $data->limit = 980;
            $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            // fill amount and
            foreach ($claimsReuslt['data'] as &$claim) {
                $claim_item_list = [];
                foreach ($claim_items['data'] as $item) {
                    if ($item['claim_id'] == $claim['id']) {
                        $claim['claim_amount'] += $item['requested_amount'];
                        $claim['item_count']++;
                        $claim_item_list[] = $item;
                    }
                }

                $claim_details = json_decode($claim['claim_details']);
                $claim['items'] = $claim_item_list;
                $claim['cargo_name'] = $claim_details->cargo_name;
                $claim['route_wage_mode'] = $claim_details->route_wage_mode;

                if ($claim_details->payments) {
                    $amount = 0;
                    foreach ($claim_details->payments as $pay) {
                        $amount += doubleval($pay->value);
                    }
                    $claim['remaining_amount'] = doubleval($claim['claim_amount']) - $amount;
                } else {
                    $claim['remaining_amount'] = $claim['claim_amount'];
                }
            }

            parent::response($claimsReuslt);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // --------------------- get multi claims info by filter------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchMGClaims()
    {
        try {

            // get claims
            $request = $this->_request;
            $request->order_by = " order by id desc";
            $claimsReuslt =  $this->_fps->searchMGClaims($request, 0);

            // get claim_items
            $claimIds = [];
            foreach ($claimsReuslt['data'] as $claim) {
                $claimIds[] = $claim['id'];
            }
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = $claimIds;
            $claim_items = $this->_fps->searchClaimItems($data, 0);

            // fill amount and
            foreach ($claimsReuslt['data'] as &$claim) {
                foreach ($claim_items['data'] as $item) {
                    if ($item['claim_id'] == $claim['id']) {
                        $item_requested = json_decode($item['requested']);
                        $claim['claim_amount'] += $item_requested->freight->net_amount;
                        $claim['item_count']++;
                    }
                }

                $claim_details = json_decode($claim['claim_details']);
                $claim['cargo_name'] = $claim_details->cargo_name;
                $claim['route_wage_mode'] = $claim_details->route_wage_mode;

                if ($claim_details->payments) {
                    $amount = 0;
                    foreach ($claim_details->payments as $pay) {
                        $amount += doubleval($pay->value);
                    }
                    $claim['remaining_amount'] = doubleval($claim['claim_amount']) - $amount;
                } else {
                    $claim['remaining_amount'] = $claim['claim_amount'];
                }
            }

            parent::response($claimsReuslt);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // --------------------- get single claim item info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getClaimItem()
    {
        try {
            $result =  $this->_fps->getClaimItem($this->_request->id, $_SESSION["user_id"]);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- get multi claim items info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchClaimItems()
    {
        try {
            $result =  $this->_fps->searchClaimItems($this->_request, $_SESSION["user_id"]);

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- change claim status  --------------------- //
    // --------------------------------------------------------------------------- //
    public function changeClaimStatus()
    {
        try {
            // user input
            $claim_id = $this->_request->claim_id;

            // get claim bean
            $claimBean =  $this->_fps->getClaim($claim_id, $_SESSION["user_id"]);

            // PA submit claim for review
            if ($claimBean['status'] == 'NEW' && $this->_request->new_status == "PENDING") {

                // make sure the claim is from the same session pa (unless Minagate pa)
                if ($_SESSION['pa_id'] != 2 && $_SESSION['pa_id'] != $claimBean['claim_details']['pa_id']) {
                    throw new Exception("لا تستطيع المتابعة ، المطالبة ليست لمكتب الصرف");
                }
                $data = new stdClass();
                $data->claim_id = $claim_id;
                $data->new_status = $this->_request->new_status;
                $this->_fps->changeClaimStatus($data, $_SESSION["user_id"]);
            }

            // Minagate approved the claim
            else if ($claimBean['status'] == 'PENDING' && $this->_request->new_status == "APPROVED") {
                $data = new stdClass();
                $data->claim_id = $claim_id;
                $data->new_status = $this->_request->new_status;
                $this->_fps->changeClaimStatus($data, $_SESSION["user_id"]);
            } else if ($claimBean['status'] == 'NEW' && $this->_request->new_status == "INACTIVE") {
                $data = new stdClass();
                $data->claim_id = $claim_id;
                $data->new_status = $this->_request->new_status;
                $this->_fps->changeClaimStatus($data, $_SESSION["user_id"]);
            }

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------- //
    // --------------------- change pa claim item status from new to inactive  ------------------------ //
    // --------------------------------------------------------------------------- //
    public function changeClaimItemStatus()
    {
        try {

            // user inputs
            $item_id =  $this->_request->item_id;
            $new_status =  $this->_request->new_status;

            // get voucher of this claim item then get the JV
            $data = new stdClass();
            $data->claim_item_id = $this->_request->item_id;
            $data->new_status = $this->_request->new_status;

            $result = $this->_fps->changeClaimItemStatus($data, $_SESSION["user_id"]);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';

            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------- //
    // --------------------- search Company Claims ----------------------- //
    // ------------------------------------------------------------------- //
    public function searchCompanyClaims()
    {

        // search for company claims
        $request = $this->_request;
        $request->filter = new stdClass();
        $request->filter->payee_reference_code = "COMPANY";
        $claimsReuslt =  $this->_fps->searchClaims($request, $_SESSION["user_id"]);

        foreach ($claimsReuslt['data'] as &$claim) {

            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_id = $claim['id'];
            $claim_items = $this->_fps->searchClaimItems($data, 0);
            $totalAmount = 0;
            foreach ($claim_items["data"] as  $item) {
                $itemDetail = json_decode($item["details"]);
                $item_amount = $itemDetail->amount;
                $totalAmount += $item_amount;
            }
            $claim['total_amount'] = number_format($totalAmount, 3);
            $claim['remaining_amount'] =  $this->_fps->getClaimRemainingAmount($claim['id'], 0);

            $payee_reference = json_decode($claim['payee_reference']);
            $company_id = $payee_reference->reference_value;
            $companyBean = $this->_companyCore->getCompanyBasic($company_id, 0);
            $claim['company_name'] =  $companyBean->name;
            $claim['number_of_claims'] = $claim_items['found_rows'];
        }

        parent::response($claimsReuslt);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- searchClaimsByTruckNumber----------------------- //
    // ---------------------------------------------------------------------- //
    public function searchClaimTruckProfiles()
    {
        try {
            $request = $this->_request;
            if (!$this->_request->filter) {
                $request->filter = new stdClass();
                $request->filter->payee_reference_code = "TN";
            }

            $finalList = [];

            // search for all claims
            $claimsReuslt =  $this->_fps->searchClaims($request, $_SESSION["user_id"]);
            $claims = $claimsReuslt["data"];
            $tn_list = [];
            foreach ($claims as $value) {
                $ref = json_decode($value["payee_reference"]);
                if ($ref->reference_code == "TN") {
                    $tn = $ref->reference_value;
                    if (!in_array($tn, $tn_list)) {
                        $tn_list[] = $tn;
                    }
                }
            }

            // get all trucks financial manager name for all claims
            $tenderFilter = [
                ['key' => 'tn', 'val' => $tn_list, 'op' => 'in'],
                ['key' => 'tender_id', 'val' => 11] // TODO
            ];
            $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1000, 0, $_SESSION["user_id"]);


            // group claims by tn
            $finManagerList = [];
            foreach ($tn_list as $key => $truck_number) {
                $obj  =  new stdClass();
                $obj->total_amount = 0;
                $obj->number_of_claims = 0;
                $obj->tn = $truck_number;
                $obj->financial_manager_name = "";
                $obj->status = "";
                $obj->referance_code = "TN";
                $claim_total_payments = 0;

                foreach ($claims as $key => $value) {
                    $details = json_decode($value["claim_details"]);
                    $tn = $details->tn;
                    $amount = $value['claim_amount'];

                    if ($truck_number == $tn) {
                        $obj->total_amount = $obj->total_amount + $amount;
                        if ($details->payments) {
                            foreach ($details->payments as $p) {
                                $claim_total_payments += $p->value;
                            }
                        }

                        $obj->number_of_claims =  $obj->number_of_claims + 1;
                        $obj->status = $value['status'];
                        $obj->remaining_amount = $obj->total_amount - $claim_total_payments;

                        // collect fin manager ids
                        foreach ($tenderTruck_qry->data as $tt) {
                            if ($tt->tn == $truck_number) {
                                $obj->financial_manager_name = $tt->financial_manager_owner_id;
                                $finManagerList[] = $tt->financial_manager_owner_id;
                                break;
                            }
                        }
                    }
                }
                $finalList[] = $obj;
            }

            // convert fin manager list to names
            $truckOwnerFilter = [['key' => "id", 'val' => $finManagerList, 'op' => 'in']];
            $truckOwnerQuery = $this->_truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1000, 0, 0);
            foreach ($finalList as &$final) {
                foreach ($truckOwnerQuery->data as $finManager) {
                    if ($finManager->id == $final->financial_manager_name) {
                        $final->financial_manager_name = $finManager->name;
                    }
                }
            }

            $Result = [];
            $Result['data'] = $finalList;
            $Result['found_rows'] = sizeof($finalList);
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------ //
    // --------------- search for all active and pending claims and the corrsponsding claim items to each claim---------------- //
    // ------------------------------------------------------------------------------------------------------------------------ //
    public function searchClaimItemsByTruckNumber()
    {
        try {

            // get claim details from fps
            $request = $this->_request;
            $claimsReuslt =  $this->_fps->searchClaims($request, 0);
            $claims = $claimsReuslt["data"];

            // fill other info
            $claims_items_list = [];
            foreach ($claims as &$value) {

                $claim_id = $value["id"];
                // get each claim remaining amount and inject it in the claim bean
                $remainingAmount =  $this->_fps->getClaimRemainingAmount($claim_id, 0);
                $value["remaining_amount"] = $remainingAmount;

                // get claim items
                $data = new stdClass();
                $data->filter = new stdClass();
                $data->filter->claim_id = $claim_id;
                $tender_Claim_items = $this->_fps->searchClaimItems($data, 0);
                $value["amount"] = 0;
                foreach ($tender_Claim_items["data"] as  $item) {
                    $item_details = json_decode($item["details"]);
                    if ($value['reference_code'] == "TN") {
                        $item_amount = $item_details->details->amount;
                    } else if ($value['reference_code'] == "COMPANY") {
                        $item_amount = $item_details->amount;
                    }

                    $value["amount"] = $value["amount"] + $item_amount;
                }
                $value["amount"] = number_format($value["amount"], 3);
                $value["remaining_amount"] = number_format($value["remaining_amount"], 3);

                $obj = new stdClass();
                $obj->claim = $value;
                $obj->claim_items = $tender_Claim_items["data"];
                $claims_items_list[] = $obj;
            }

            $Result = [];
            $Result['data'] = $claims_items_list;
            $Result['found_rows'] = sizeof($claims_items_list);
            $Result['MESSAGE'] = 'تمت العملية بنجاح ';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------ //
    // --------------- search for all active and pending claims and the corrsponsding claim items to each claim---------------- //
    // ------------------------------------------------------------------------------------------------------------------------ //
    public function searchReconstructionClaimsOfTucks()
    {
        try {
            $request = new stdClass();
            $request->filter = new stdClass();
            $request->filter->payee_reference_code = "TN";
            $claimsReuslt = $this->_fps->searchClaims($request, $_SESSION["user_id"]);
            $claims = $claimsReuslt["data"];
            $lastSevenDays = date('Y-m-d H:m:s', strtotime(' - 7 days'));
            $formSevenToFort = date('Y-m-d H:m:s', strtotime($lastSevenDays . ' - 7 days'));
            $oneMonth = date('Y-m-d H:m:s', strtotime($formSevenToFort . ' - 16 days'));
            $threeMonths = date('Y-m-d H:m:s', strtotime($oneMonth . ' - 60 days'));
            $amount_7 = 0;
            $count_7 = 0;
            $amount_14 = 0;
            $count_14 = 0;
            $amount_30 = 0;
            $count_30 = 0;
            $amount_90 = 0;
            $count_90 = 0;
            $amount_more = 0;
            $count_more = 0;
            foreach ($claims as $claim) {
                $amount = json_decode($claim["claim_details"])->amount;
                $claim_date = $claim["activation_date"];
                if ($claim_date <= $threeMonths) {
                    $amount_more = $amount_more + $amount;
                    $count_more++;
                } else if ($claim_date > $threeMonths && $claim_date <= $oneMonth) {
                    $amount_90 = $amount_90 + $amount;
                    $count_90++;
                } else if ($claim_date > $oneMonth && $claim_date <= $formSevenToFort) {
                    $amount_30 = $amount_30 + $amount;
                    $count_30++;
                } else if ($claim_date > $formSevenToFort && $claim_date <= $lastSevenDays) {
                    $amount_14 = $amount_14 + $amount;
                    $count_14++;
                } else {
                    $amount_7 = $amount_7 + $amount;
                    $count_7++;
                }
            }
            $final_data = new stdClass();
            $final_data->sevenDays = new stdClass();
            $final_data->fourteenDays = new stdClass();
            $final_data->month = new stdClass();
            $final_data->threeMonths = new stdClass();
            $final_data->moreThanTreeMonths = new stdClass();
            $final_data->sevenDays->amount = $amount_7;
            $final_data->sevenDays->count = $count_7;
            $final_data->fourteenDays->amount = $amount_14;
            $final_data->fourteenDays->count = $count_14;
            $final_data->month->amount = $amount_30;
            $final_data->month->count = $count_30;
            $final_data->threeMonths->amount = $amount_90;
            $final_data->threeMonths->count = $count_90;
            $final_data->moreThanTreeMonths->amount = $amount_more;
            $final_data->moreThanTreeMonths->count = $count_more;

            $Result = [];
            $Result['data'] = $final_data;
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
            parent::response($Result);
            // parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------- //
    // --------------- Add Manual payment to certain TN claim ------------- //
    // ----------------------------------------------------------------- //
    public function closeTnClaim()
    {

        // get user params
        $tn = $this->_request->tn;
        $amount = $this->_request->amount;
        $cashbox_id = $this->_request->cashbox_id;
        $recipient_name = $this->_request->recipient_name;
        $notes = $this->_request->notes;
        $tender_id = 11; // TODO
        $voucher_type = "RECEIPT";
        $payment_method = $this->_request->payment_method;


        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }


        try {

            // validate
            if ($amount == 0) {
                throw new Exception("لا تستطيع المتابعة قيمة الدفعة غير صحيحة");
            }

            // create reciet payment voucher
            $trx_template = $this->_paymentCore->generateVoucherTrx($tender_id, $voucher_type);
            $ledger_account_id = 590000;
            $sourceAccountBean = $this->_fps->getAccountBasic($cashbox_id, $_SESSION["user_id"]);

            $item = [];
            $item['recipient_name'] = $recipient_name;
            $paymentObj = new stdClass();
            $paymentObj->value = $amount;
            $paymentObj->source_account_id = $ledger_account_id . "-" . $tn;
            $trx_template = $this->_voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $paymentObj, null, $item);

            // authority object
            foreach ($trx_template as $trx) {
                if ($trx['source_account']) {
                    $voucherData = new stdClass();
                    $authority = new stdClass();
                    $authority->source_account_id = $ledger_account_id;
                    $authority->source_sub_id = explode("-", $trx['account_id'])[1];
                    $voucherData->authority = $authority;
                }
            }

            // destination object
            $destination = new stdClass();
            $destination->user_id =  null;
            $destination->company_id =  266770;
            $destination->is_beneficiary = 1;
            $voucherData->voucher_destination[] = $destination;

            $jv_template = [];
            $jv_template['code'] = $voucher_type;
            $jv_note = new stdClass();
            $jv_note->notes = $notes;
            $jv_note->text = "jv_note";
            $jv_template['jv_note'] = $jv_note;
            $jv_template['trx_template'] = $trx_template;

            $voucher_note = new stdClass();
            $voucher_note->text = $jv_note;
            $jv_template['voucher_note'] = $voucher_note;

            $voucherData->jv_template = $jv_template;
            $voucherData->amount = $amount;
            $voucherData->payment_method_code = strtoupper($payment_method);
            $voucherData->recipient_name = $recipient_name;

            $voucherData->integration_details = new stdClass();
            $voucher_id = $this->_fps->createVoucher($voucherData, 0);

            $processData = new stdClass();
            $processData->voucher_id = $voucher_id;
            $this->_fps->processVoucherTrx($processData, 0);

            // call fps to add payment claim
            $this->_fps_claim_core->addPaymentToTnClaim($amount, $tn, $notes, 0);

            // return success
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['voucher_id'] = $voucher_id;
            $Result['MESSAGE'] = "تمت العملية بنجاح";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function generateFpsCompanyClaimPdf()
    {
        try {
            $claim_id = $this->_request->claim_id;
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_id = $claim_id;

            // get claim items
            $tender_Claim_items = $this->_fps->searchClaimItems($data, 0);

            // collect waybill ids
            $list_of_waybills = [];
            foreach ($tender_Claim_items["data"] as  $item) {
                $list_of_waybills[] =   json_decode($item["details"])->waybill_id;
            }

            // search for waybill info
            $waybillFilter = [['key' => 'id', 'val' => $list_of_waybills, "op" => "in"]];
            $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, 0);



            $list_of_waybills = [];
            foreach ($waybills->data as $waybill) {
                $document = json_decode($waybill->document);
                $data = new stdClass();
                $data->wn = $waybill->wn;
                $data->create_date = $waybill->create_date;
                $data->discharge_date = date_format(date_create(explode(" ", $waybill->discharge_date)[0]), "m/d");
                $data->loading_date = date_format(date_create(explode(" ", $waybill->loading_date)[0]), "m/d");
                $data->tn = $waybill->tn;
                $data->notes = $document->notes;
                $data->tender_name  = $document->tender->name;
                $data->tender_id  = $document->tender->id;
                $data->loading_weight = $document->freight->amount->loading_weight;
                $data->discharge_weight = $document->freight->amount->discharge_weight;
                $data->tolerance_in_kg = $document->freight->amount->tolerance_in_kg;
                $data->loss_in_kg = $document->freight->amount->loss_in_kg;
                $data->total_deductions = $document->freight->amount->total_deductions;
                $data->base_amount = $document->freight->amount->base_amount;
                $data->destination = $document->freight->amount->destination;
                $data->wage_per_ton = $document->freight->amount->wage_per_ton;
                $data->loss_fine = $document->freight->amount->loss_fine;
                $data->late_fine = $document->freight->amount->late_fine;

                $data->net_amount = "0";
                foreach ($tender_Claim_items['data'] as $item) {
                    $item_details = json_decode($item["details"]);
                    $item_waybill_id = $item_details->waybill_id;
                    if ($waybill->id == $item_waybill_id) {
                        $data->net_amount = $item_details->amount;
                        break;
                    }
                }

                $data->total_fines = $document->freight->amount->total_fines;
                $data->policy_number =  $document->integeration_details->jo_petrol->nfldnm;
                $list_of_waybills[] = $data;
            }
            parent::response($list_of_waybills);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------- //
    // ----------------- Transfer certain claim from 1 truck to another --------------- //
    // -------------------------------------------------------------------------------- //
    public function transferClaim()
    {

        // get user params
        $claim_id = $this->_request->claim_id;
        $new_tn = $this->_request->new_tn;

        // get the claimBean info
        $claimBean =  $this->_fps->getClaim($claim_id, $_SESSION["user_id"]);

        // validate if the user can see the claim
        if (!$claimBean) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }
        // validate the 2 trucks are for the same financial manager
        $tn_list = [$claimBean['claim_details']['tn'], $new_tn];
        $tenderFilter = [
            ['key' => 'tn', 'val' => $tn_list, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => 11] // TODO
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1000, 0, $_SESSION["user_id"]);
        $financial_manager_id = null;
        foreach ($tenderTruck_qry->data as $tender_truck) {
            if ($financial_manager_id && $financial_manager_id != $tender_truck->financial_manager_owner_id) {
                throw new Exception("لا تستطيع المتابعة ، المدير المالي للشاحنتبن مختلف");
            }
            $financial_manager_id = $tender_truck->financial_manager_owner_id;
        }

        $claim_amount = $this->_fps->getClaimRemainingAmount($claim_id, 0);
        if (!$claim_amount || $claim_amount <= 0) {
            throw new Exception("لا يمكن نقل ذمة الشاحنة حيث أن المبلغ المتبقي للمطالبة اقل أو يساوي 0");
        }

        // generate trx
        $trx = [];
        $ledger_account_id = 590000;
        $temp = new stdClass();
        $temp->amount =  $claim_amount;
        $temp->account = $ledger_account_id . "-" . $claimBean['claim_details']['tn'];
        $temp->op = 'C';
        $temp->notes =  "نقل ذمة الي الشاحنة رقم $new_tn";
        $trx[] = $temp;
        $temp2 = new stdClass();
        $temp2->amount =  $claim_amount;
        $temp2->account = $ledger_account_id . "-" . $new_tn;
        $temp2->op = 'D';
        $temp2->notes =  "نقل ذمة من الشاحنة رقم " . $claimBean['claim_details']['tn'];
        $trx[] = $temp2;

        // create the new trx
        $data = new stdClass();
        $data->ledger_account_id = $ledger_account_id;
        $data->jv_date = DBConnection::getSystemDate();
        $data->remarks = "نقل ذمة الشاحنة " . $claimBean['claim_details']['tn'] . " إلى ذمة الشاحنة " . $new_tn;
        $data->trx = $trx;
        $this->_fps->createTrx($data, $_SESSION["user_id"]);

        // update the claim with the new tn
        $notes = "نقل ذمة من الشاحنة " . $claimBean['claim_details']['tn'];
        $updateData = new stdClass();
        $updateData->claim_id = $claim_id;
        $updateData->new_tn = $new_tn;
        $updateData->notes = $notes;
        $r = $this->_fps->updateClaimTn($updateData, $_SESSION["user_id"]);

        $Result = [];
        $Result['MESSAGE'] = 'تمت العملية بنجاح ';
        parent::response($Result);
    }



    // ---------------------------------------------------------------------------------------------------------------------------- //
    // --------------- in case the new claim item is not based on waybill, the item will be added as stand alone onject ----------- //
    // --------------- and all its dependencies will be (pa_project, pa_route_wage) ----------------------------------------------- //
    // --------------- pa_id=2&pa_project_id=53&tender_payable_id=2&claim_loading_weight=35000&claim_loading_date=2021-09-01&claim_discharge_weight=35000&claim_discharge_date=2021-09-01&policy_num=554&cargo_name=Neitrate&claim_origin_id=91090038&claim_destination_id=91110010&tn=602154&policy_num=554&recipient_name=mohhammad&selected_account_box=590000-14006
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function appendOrApproveItemToAPClaim()
    {
        // prepare params
        $pa_id = $this->_request->pa_id;
        $pa_project_id = $this->_request->pa_project_id;
        $tender_payable_id = $this->_request->tender_payable_id;

        // loading & discharge part
        $claim_loading_weight = $this->_request->claim_loading_weight;
        $claim_loading_date = $this->_request->claim_loading_date;
        $claim_discharge_weight = $this->_request->claim_discharge_weight;
        $claim_discharge_date = $this->_request->claim_discharge_date;
        $claim_discharge_arrive_date = $this->_request->claim_discharge_arrive_date;

        // cargo info
        $policy_num = $this->_request->policy_num;
        $cargo_id = $this->_request->cargo_id;
        $cargo_name = $this->_request->cargo_name;
        $claim_origin_id = $this->_request->claim_origin_id;
        $claim_destination_id = $this->_request->claim_destination_id;

        // carriers info
        $tn = $this->_request->tn;

        // tagreesh info
        $late_fine =  $this->_request->late_fine;
        $compensation = $this->_request->compensation;
        $absence_fine = $this->_request->absence_fine;
        $loss_fine = $this->_request->loss_fine;
        $other_fine_amount = $this->_request->other_fine_amount ? $this->_request->other_fine_amount : null;

        // recipient info
        $recipient_name = $this->_request->recipient_name;
        $selected_account_box = $this->_request->selected_account_box;
        $recipient_user_id =  $this->_request->recipient_name;
        $recipient_nn =  $this->_request->recipient_name;

        // get pa_project
        $paProjectBean = $this->_paRouteWageCore->getBasicPaProject($pa_project_id, $_SESSION['user_id']);
        $pa_project_name = $paProjectBean->name;

        // get pa route wage
        $routeWage = $this->_paRouteWageCore->searchPaRouteWageForFreight(
            $pa_project_id,
            $_SESSION['pa_id'],
            $claim_origin_id,
            $claim_destination_id,
            $claim_loading_date,
            $_SESSION['user_id']
        );

        // ----------- generate claim item freight ------------
        $virtualWaybillBean = new stdClass();
        $virtualWaybillBean->document = new stdClass();
        $virtualWaybillBean->document->freight = null;
        $virtualWaybillBean->document->tender = new stdClass();
        $virtualWaybillBean->document->tender->id = null;
        $virtualWaybillBean->document->negotiable_instructios = new stdClass();
        $virtualWaybillBean->document->negotiable_instructios->route = new stdClass();
        $virtualWaybillBean->document->negotiable_instructios->route->destination = new stdClass();
        $virtualWaybillBean->document->negotiable_instructios->route->destination->id = $claim_destination_id;
        $virtualWaybillBean->document->cargo[0] = new stdClass();
        $virtualWaybillBean->document->cargo[0]->weights = new stdClass();
        $virtualWaybillBean->document->cargo[0]->weights->loading = new stdClass();
        $virtualWaybillBean->document->cargo[0]->weights->discharge = new stdClass();
        $virtualWaybillBean->document->cargo[0]->weights->arrival = new stdClass();
        $freight = $this->generateClaimItemFreightNode(
            $virtualWaybillBean,
            $routeWage,
            $claim_loading_weight,
            $claim_loading_date,
            $claim_discharge_weight,
            $claim_discharge_date,
            $claim_discharge_arrive_date,
            $late_fine,
            $compensation,
            $absence_fine,
            $loss_fine,
            $pa_id
        );
        // calculate late_fine if exists
        if ($late_fine) {
            $freight->late_fine = $late_fine;
            $freight->total_fine += $late_fine;
            $freight->net_amount = $freight->net_amount - $late_fine;
        }
        // calculate other fines if exists
        if ($other_fine_amount) {
            $freight->other_fine_amount = $other_fine_amount;
            $freight->total_fine += $other_fine_amount;
            $freight->net_amount = $freight->net_amount - $other_fine_amount;
        }
        // calculate advance payment
        $claim_advance_payment_value = $this->_paymentCore->calculateClaimAdvancePayment($this->_request->ref_num, $_SESSION['pa_id'], $_SESSION['user_id']);
        $freight->total_advance_payment = $freight->total_advance_payment + $claim_advance_payment_value;
        $freight->net_amount = $freight->net_amount - $claim_advance_payment_value;
        // ----------------------------------------------------


        $paBean = $this->_paymentAgentCore->getPaymentAgentBasic($_SESSION['pa_id'], 0);
        $tenderPayableBean = $this->_truckingCompanyCore->getTruckingCompanyBasic($paProjectBean->details->tc->id, 0);

        $details = new stdClass();
        $details->waybill_id = null;
        $details->pa_name = $paBean->name;
        $details->pa_id = $paBean->id;
        $details->tn = $tn;
        $details->pa_project_id =  $pa_project_id;
        $details->pa_project_name =  $pa_project_name;
        $details->sender_company_id = $this->_request->item_id ? 266770 : $paBean->company_id;
        $details->receiver_company_id = $this->_request->item_id ? $tenderPayableBean->company_id : 266770;
        $details->recipient_name =  $recipient_name;
        $details->recipient_user_id =  $recipient_user_id;
        $details->recipient_nn =  $recipient_nn;

        $details->route_wage_mode = $routeWage->type == "payable" ? "أهالي" : "شركات";
        $details->route_wage_mode_code = $routeWage->type;
        $details->project_owner_name = $paProjectBean->details->tc->name;
        $details->origin_id = $claim_origin_id;
        $details->destination_id = $claim_destination_id;

        // fill the filter params
        $details->cargo_id =  $cargo_id;
        $details->cargo_name =  $cargo_name;
        $details->ct_id =  $cargo_name;

        $amount = new stdClass();
        $amount->source = $claim_origin_id;
        $amount->target = $claim_origin_id;

        $origin_name = $this->_locationCore->getLocationBasic($claim_origin_id, 0)->name;
        $distination_name = $this->_locationCore->getLocationBasic($claim_destination_id, 0)->name;



        $tagreesh_obj = new stdClass();
        $tagreesh_obj->loading = new stdClass();
        $tagreesh_obj->loading->origin_id = $claim_origin_id;
        $tagreesh_obj->loading->origin_name = $origin_name;
        $tagreesh_obj->loading->weight = $claim_loading_weight;
        $tagreesh_obj->loading->time_stamp = $claim_loading_date;
        $tagreesh_obj->discharge = new stdClass();
        $tagreesh_obj->discharge->distination_id = $claim_destination_id;
        $tagreesh_obj->discharge->distination_name = $distination_name;
        $tagreesh_obj->discharge->weight = $claim_discharge_weight;
        $tagreesh_obj->discharge->time_stamp = $claim_discharge_date;
        $tagreesh_obj->discharge->arrival_date = $claim_discharge_arrive_date;
        $tagreesh_obj->cargo = new stdClass();
        $tagreesh_obj->cargo->tender_id = null;
        $tagreesh_obj->cargo->tender_name = null;
        $tagreesh_obj->cargo->pa_project_id = $pa_project_id;
        $tagreesh_obj->cargo->pa_project_name = $pa_project_name;
        $tagreesh_obj->cargo->policy_num = $policy_num;
        $tagreesh_obj->cargo->cargo_id = "-";
        $tagreesh_obj->cargo->cargo_name = $paProjectBean->details->ct[0]->label;
        $tagreesh_obj->freight = new stdClass();
        $tagreesh_obj->freight->base_amount =  $freight->amount->base_amount;
        $tagreesh_obj->freight->net_amount =  $freight->amount->net_amount;
        $tagreesh_obj->freight->route_wage_id =  $freight->amount->route_wage_id;
        $tagreesh_obj->freight->wage_per_ton =  $freight->amount->wage_per_ton;
        $tagreesh_obj->freight->affected_loss =  $freight->amount->affected_loss;
        $tagreesh_obj->freight->minimum_weight =  $freight->amount->minimum_weight;
        $tagreesh_obj->freight->tolerance_in_kg =  $freight->amount->tolerance_in_kg;
        $tagreesh_obj->freight->late_fine =  $freight->amount->late_fine;
        $tagreesh_obj->freight->late_fine_hours =  $freight->amount->late_fine_hours;
        $tagreesh_obj->freight->late_fine_percentage =  $freight->amount->late_fine_percentage;
        $tagreesh_obj->freight->trx_fees =  $freight->amount->trx_fees;
        $tagreesh_obj->freight->loss_fine_per_kg =  $freight->amount->loss_fine_per_kg;
        $tagreesh_obj->freight->total_deductions =  $freight->amount->total_deductions;
        $tagreesh_obj->freight->total_fines =  $freight->amount->total_fines;
        $tagreesh_obj->freight->compensation =  $freight->amount->compensation;
        $tagreesh_obj->freight->compensation_hours =  $freight->amount->compensation_hours;
        $tagreesh_obj->freight->compensation_price_per_hour =  $freight->amount->compensation_price_per_hour;
        $tagreesh_obj->freight->general_fees =  $freight->amount->general_fees;
        $tagreesh_obj->freight->axial_load_fine =  $freight->amount->axial_load_fine;

        // search for trx template from tender_pa
        $trx_templates = $paProjectBean->trx_template;
        foreach ($trx_templates as $template) {
            if ($template->code == 'WAYBILL_COMPLETE') {
                $trx_template = $template->template;
            }
        }
        if (!$trx_template) {
            throw new Exception("Error , no WAYBILL_COMPLETE trx template was found for this project");
        }

        // generate the voucher trx (freight amounts + commission + notes to be logged)
        $sourceAccountBean = $this->_fps->getAccountBasic($selected_account_box, $_SESSION['user_id']);
        $item = [];
        $item['tn'] = $details->tn;
        $item['ct_id'] = $details->ct_id;
        $item['origin_id'] = $claim_origin_id;
        $item['cargo_name'] = $paProjectBean->details->ct[0]->label;
        $item['claim_type'] = "AR_claim";
        $item['origin_name'] = $origin_name;
        $item['loading_date'] = $claim_loading_date;
        $item['policy_number'] = $policy_num;
        $item['destination_id'] = $claim_destination_id;
        $item['discharge_date'] = $claim_discharge_date;
        $item['loading_weight'] = $claim_loading_weight;
        $item['destination_name'] = $distination_name;
        $item['discharge_weight'] = $claim_discharge_weight;
        $item['recipient_name'] = $recipient_name;
        $item['pa_project_id'] = $pa_project_id;
        $item['pa_project_name'] = $pa_project_name;

        $jv_template = $this->_voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $paProjectBean->details->payment, $freight->amount, $item);

        // store account in details
        foreach ($jv_template as $trx) {
            if ($trx["source_account"]) {
                $details->account =  $trx["account"];
            }
        }
        $tagreesh_obj->jv_template =  $jv_template;
        $cargo_name = $paProjectBean->details->ct[0]->label;

        // temp solution for pa_project = 53;
        $target_claim_id_filter = [];
        $target_claim_id_filter[] = ['key' => "sender_company_id", 'val' => $_SESSION['company_id']];
        $target_claim_id_filter[] = ['key' => "status", 'val' => "NEW"];
        $target_claim_id_filter[] = ['key' => 'claim_details', 'val' => "$pa_project_id", 'op' => 'json unquote', 'node' => '$.pa_project_id'];
        $target_claim_id_filter[] = ['key' => 'claim_details', 'val' => "$claim_destination_id", 'op' => 'json unquote', 'node' => '$.destination_id'];



        // fill the extra info
        $itemData = new stdClass();
        $itemData->voucher_type_code = "WAYBILL_COMPLETE";
        $itemData->pa_id = $pa_id;
        $itemData->jv_note_string = " مستحقات رحلة الشاحنة $tn ، وزن التحميل: $claim_loading_weight - التفريغ: $claim_discharge_weight ، الحمولة: $cargo_name  ، المسار: $origin_name - $distination_name ";
        $itemData->remarks = " مستحقات رحلة الشاحنة $tn ، وزن التحميل: $claim_loading_weight - التفريغ: $claim_discharge_weight ، الحمولة: $cargo_name  ، المسار: $origin_name - $distination_name ";
        $itemData->jv_template = $jv_template;
        $itemData->tender_payable_company_id = $tenderPayableBean->company_id;
        $itemData->pa_project_id = $pa_project_id;
        $itemData->freight = $freight;
        $itemData->target_claim_id_filter = $target_claim_id_filter;
        $itemData->details = $details;
        $itemData->tagreesh_obj = $tagreesh_obj;
        $itemData->sender_company_id = $this->_request->item_id ? 266770 : $paBean->company_id;






        if ($this->_request->item_id) {
            $claim_req = new stdClass();
            $claim_req->filter = new stdClass();
            $claim_req->filter->status = "NEW";
            $claim_req->filter->sender_company_id =  $details->sender_company_id;
            $claim_req->filter->receiver_company_id = $details->receiver_company_id;
            $claim_req->filter->pa_project_id = $pa_project_id;
            $claim_req->filter->claim_destination_id = $claim_destination_id;
            $claimByFilter = $this->_fps->searchClaims($claim_req, $_SESSION['user_id']);

            if ($claimByFilter["found_rows"] > 0) {
                $itemData->target_claim_id = $claimByFilter['data'][0]['id'];
            } else {
                $itemData->target_claim_id = null;
            }
            $itemData->claim_item_id = $this->_request->item_id;


            $response = $this->_fps->approveClaimItem($itemData, $_SESSION["user_id"]);
        } else {
            $response = $this->_fps->payClaimItem($itemData, $_SESSION["user_id"]);
        }

        $Result = [];
        $Result['MESSAGE'] = 'تمت العملية بنجاح ';
        $Result['voucher_id'] = $response['voucher_id'];
        $Result['item_id'] = $response['item_id'];
        $Result['claim_id'] = $response['claim_id'];
        parent::response($Result);
    }


    public function createVoucherForItemClaim(
        $sourceAccountBean,
        $item,
        $freight,
        $jv_template,
        $recipient_name
    ) {

        // create voucher
        $voucherData = new stdClass();

        // authority object
        $authority = new stdClass();
        $authority->source_account_id = $sourceAccountBean['id'];
        $authority->source_sub_id = $sourceAccountBean['sub_id'];
        $voucherData->authority = $authority;

        // destination object
        $destination = new stdClass();
        $destination->user_id =  $this->_request->recipient_user_id;
        $destination->company_id =  null;   // TODO: in case the recipients is a company
        $destination->is_beneficiary = 1;
        $voucherData->voucher_destination[] = $destination;

        // jv_template array
        $jv_template = [];
        $jv_template['code'] = "WAYBILL_COMPLETE";
        $jv_note = new stdClass();

        $tn = $item['tn'];
        $loading_weight = $freight->loading_weight;
        $discharge_weight = $freight->discharge_weight;
        $cargo_name = $item['cargo_name'];
        $origin_name = $item['origin_name'];
        $destination_name = $item['destination_name'];
        $jv_note_string = " مستحقات رحلة الشاحنة $tn ، وزن التحميل: $loading_weight - التفريغ: $discharge_weight ، الحمولة: $cargo_name ، المسار: $origin_name - $destination_name ";
        $jv_note->text = "jv_note";
        $jv_template['jv_note'] = $jv_note_string;
        $jv_template['trx_template'] = $jv_template;

        $voucher_note = new stdClass();
        $voucher_note->text = $jv_note_string;
        $jv_template['voucher_note'] = $voucher_note;

        $voucherData->jv_template = $jv_template;
        $voucherData->payment_method_code = strtoupper($sourceAccountBean['payment_channel'][0]);
        $voucherData->recipient_name = $this->_request->recipient_name;
        $voucherData->recipient_name = $recipient_name;
        $voucherData->pa_id = $_SESSION['pa_id'];

        // add claim integration details
        $voucherData->integration_details = new stdClass();
        $voucherData->integration_details->claim_item = $item;

        // create voucher
        $voucher_id = $this->_fps->createVoucher($voucherData, $_SESSION['user_id']);
        if (!is_numeric($voucher_id)) {
            throw new Exception("خطأ في اضافة أمر الصرف");
        }

        // process voucher to insert the jv trx in case the payment method of the source account is cash
        if ($voucherData->payment_method_code == "CASH") {
            $processVoucherData = new stdClass();
            $processVoucherData->voucher_id = $voucher_id;
            $this->_fps->processVoucherTrx($processVoucherData, $_SESSION['user_id']);
        }
    }
   
    
    // ----------------------------------------------------------------------------- //
    // --------------- append new waybill to a certain fps claim ------------------- //
    // ----------------------------------------------------------------------------- //
    public function appendOrAuditWaybillToAPClaim()
    {
        try {

            if ($this->_request->item_id) {
                $item_id = $this->_request->item_id;
            }
            if ($this->_request->claim_id) {
                $claim_id = $this->_request->claim_id;
            }

            // prepare params
            $pa_id = $this->_request->pa_id;
            $waybill_id = $this->_request->waybill_id;
            $claim_loading_weight = $this->_request->claim_loading_weight;
            $claim_discharge_weight = $this->_request->claim_discharge_weight;
            $claim_loading_date = $this->_request->claim_loading_date;
            $claim_discharge_date = $this->_request->claim_discharge_date;
            $claim_discharge_arrive_date = $this->_request->claim_discharge_arrive_date;
            $policy_num = $this->_request->policy_num;
            $cargo_id = $this->_request->cargo_id;
            $late_fine =  $this->_request->late_fine;
            $compensation = $this->_request->compensation;
            $absence_fine = $this->_request->absence_fine;
            $loss_fine = $this->_request->loss_fine;
            $claim_origin_id = $this->_request->origin_id;
            $claim_destination_id = $this->_request->destination_id;
            $tender_payable_id = $this->_request->tender_payable_id;
            $selected_account = $this->_request->selected_account;

            if ($_SESSION['pa_id'] && $_SESSION['company_id'] != 266770) {
                $pa_id = $_SESSION['pa_id'];
            }
            if (!$cargo_id) {
                throw new Exception("الحمل غير صحيح");
            }
            if (!$pa_id || $pa_id == "" && $_SESSION['company_id'] == 266770) {
                $pa_id = 2;
            }
            if (!$tender_payable_id) {
                throw new Exception("جهة المطالبة غير صحيحة");
            }
            if (!$policy_num) {
                throw new Exception("رقم البوليصة مطلوب");
            }
            if (!$claim_discharge_date) {
                throw new Exception("تاريخ التفريغ غير صحيح");
            }
            if (!$claim_destination_id) {
                throw new Exception("الوجهة غير صحيحة");
            }
            if (!$claim_loading_date) {
                throw new Exception("تاريخ التحميل غير صحيح");
            }
            if (!$claim_discharge_weight) {
                throw new Exception("وزن التفريغ غير صحيح");
            }
            if (!$claim_discharge_arrive_date) {
                throw new Exception("تاريخ الوصول غير صحيح");
            }
            if (!$claim_loading_weight) {
                throw new Exception("وزن التحميل غير صحيح");
            }


            // search for waybill
            if ($waybill_id) {
                $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
                // Compare if loading date is before create date
                $formated_claim_date    =  date_create($claim_loading_date);
                $formated_waybill_date  = date_create($waybillBean->create_date);
                $dateDiff = date_diff($formated_waybill_date, $formated_claim_date);
                if ($dateDiff->d > 0 && $dateDiff->invert > 0) {
                    throw new Exception('لا يمكنك المتابعة, تاريخ التحميل المدخل في المطالبة يجب ان يكون بعد تاريخ انشاء المستند');
                }
            } else {
                throw new Exception("Error Processing Request, no waybill", 1);
            }


            // get cargo bean
            $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
            $cargoBean = $this->_cargoCore->getCargoBasic($cargo_id, 0);

            // get pa Bean
            $paBean = $this->_paymentAgentCore->getPaymentAgentBasic($pa_id, 0);

            // get tender payable bean
            $tenderPayableBean = $this->_tenderClaimCore->getTenderPayable($tender_payable_id, $_SESSION['user_id']);
            $tender_id = $waybillBean->document->tender->id;

            // determine claim_type
            if ($item_id) {
                $claim_type = "AR_CLAIM";
            } else {
                $claim_type = "AP_CLAIM";
            }

            // search for route wage
            $routeWage =  $this->_routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $claim_origin_id,
                $claim_destination_id,
                $cargo_id,
                $claim_loading_date,
                "payable",
                false,
                $waybillBean,
                $_SESSION['pa_id']
            );

            // calculate the freight
            if ($routeWage) {
                $freight = $this->generateClaimItemFreightNode(
                    $waybillBean,
                    $routeWage,
                    $claim_loading_weight,
                    $claim_loading_date,
                    $claim_discharge_weight,
                    $claim_discharge_date,
                    $claim_discharge_arrive_date,
                    $late_fine,
                    $compensation,
                    $absence_fine,
                    $loss_fine,
                    $pa_id
                );
            }


            // fill the extra info

            $origin_name = $this->_locationCore->getLocationBasic($claim_origin_id, 0)->name;
            $distination_name = $this->_locationCore->getLocationBasic($claim_destination_id, 0)->name;

            $details = new stdClass();
            $details->waybill_id = $waybillBean->id;
            $details->pa_name = $paBean->name;
            $details->pa_id = $paBean->id;
            $details->wn = $waybillBean->wn;
            $details->tn = $waybillBean->document->carrier[0]->truck->tn;
            $details->tender_id =  $tender_id;
            $details->pa_project_id = $tender_id;
            $details->nafith_wn =  ""; // TODO
            $details->sender_company_id =  $paBean->company_id;
            $details->receiver_company_id =  $tenderPayableBean->company_id;
            $details->cargo_id =  $waybillBean->document->cargo[0]->cargo->id;
            $details->cargo_name =  $waybillBean->document->cargo[0]->cargo->name;
            $details->ct_id =  $waybillBean->document->cargo[0]->cargo->ct_id;
            // check if the item is payable item or recevable claim
            $route_wage_id = $waybillBean->document->freight->amount->route_wage_id;
            if ($route_wage_id) {
                // from the waybill get the route_wage type
                $routeWageMode = $this->_waybillCore->getWaybillRouteWageMode($waybillBean->trucking_company_id, $waybillBean->tender_id, 0);
                $details->route_wage_mode_code = $routeWageMode->code;
                $details->route_wage_mode = $routeWageMode->caption;
            } else {
                $details->route_wage_mode_code = "-";
                $details->route_wage_mode = "-";
            }

            $tagreesh_obj = new stdClass();
            $tagreesh_obj->loading = new stdClass();
            $tagreesh_obj->loading->origin_id = $claim_origin_id;
            $tagreesh_obj->loading->origin_name = $origin_name;
            $tagreesh_obj->loading->weight = $claim_loading_weight;
            $tagreesh_obj->loading->time_stamp = $claim_loading_date;
            $tagreesh_obj->discharge = new stdClass();
            $tagreesh_obj->discharge->distination_id = $claim_destination_id;
            $tagreesh_obj->discharge->distination_name = $distination_name;
            $tagreesh_obj->discharge->weight = $claim_discharge_weight;
            $tagreesh_obj->discharge->time_stamp = $claim_discharge_date;
            $tagreesh_obj->discharge->arrival_date = $claim_discharge_arrive_date;
            $tagreesh_obj->cargo = new stdClass();
            $tagreesh_obj->cargo->tender_id = $waybillBean->document->tender->id;
            $tagreesh_obj->cargo->tender_name = $waybillBean->document->tender->name;
            $tagreesh_obj->cargo->policy_num = $policy_num;
            $tagreesh_obj->cargo->cargo_id = $cargoBean->id;
            $tagreesh_obj->cargo->cargo_name = $cargoBean->name;
            $tagreesh_obj->freight = new stdClass();
            $tagreesh_obj->freight->base_amount =  $freight->amount->base_amount;
            $tagreesh_obj->freight->total_advance_payment = $waybillBean->document->freight->amount->total_advance_payment;

 
            // in case o ALwataniah
            if ($pa_id == 57 || $pa_id == 58){
                
                // append new item
                if (!$item_id) {
                    $tagreesh_obj->freight->net_amount =  $freight->amount->base_amount - $freight->amount->total_deductions - 
                                                          $tagreesh_obj->freight->total_advance_payment - $loss_fine - $late_fine + 10;
                }

                // approve item
                if ($item_id) {
                    $tagreesh_obj->freight->net_amount =  $freight->amount->base_amount - $freight->amount->total_deductions - 
                                                          $tagreesh_obj->freight->total_advance_payment - $loss_fine - $late_fine + 5;
                }
            }
            else {
                $tagreesh_obj->freight->net_amount =  $freight->amount->net_amount;
            }
          
            $tagreesh_obj->freight->route_wage_id =  $freight->amount->route_wage_id;
            $tagreesh_obj->freight->wage_per_ton =  $freight->amount->wage_per_ton;
            $tagreesh_obj->freight->affected_loss =  $freight->amount->affected_loss;
            $tagreesh_obj->freight->minimum_weight =  $freight->amount->minimum_weight;
            $tagreesh_obj->freight->tolerance_in_kg =  $freight->amount->tolerance_in_kg;
            $tagreesh_obj->freight->late_fine =  $freight->amount->late_fine;
            $tagreesh_obj->freight->late_fine_hours =  $freight->amount->late_fine_hours;
            $tagreesh_obj->freight->late_fine_percentage =  $freight->amount->late_fine_percentage;
            $tagreesh_obj->freight->trx_fees =  $freight->amount->trx_fees;
            $tagreesh_obj->freight->loss_in_kg =  $freight->amount->loss_in_kg;
            $tagreesh_obj->freight->loss_fine_per_kg =  $freight->amount->loss_fine_per_kg;
            $tagreesh_obj->freight->total_deductions =  $freight->amount->total_deductions;
            $tagreesh_obj->freight->total_fines =  $freight->amount->total_fines;
            $tagreesh_obj->freight->compensation =  $freight->amount->compensation;
            $tagreesh_obj->freight->compensation_hours =  $freight->amount->compensation_hours;
            $tagreesh_obj->freight->compensation_price_per_hour =  $freight->amount->compensation_price_per_hour;
            $tagreesh_obj->freight->general_fees =  $freight->amount->general_fees;
            $tagreesh_obj->freight->axial_load_fine =  $freight->amount->axial_load_fine;

            // search for template from tender_pa
            $tenderPaFilter = [
                ['key' => 'pa_id', 'val' => $pa_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_id', 'val' => $tender_id]
            ];


            // get tender pa
            $tenderPa = $this->_paymentAgentCore->searchTenderPaymentAgents($tenderPaFilter, 1, 0, 0)->data[0];
            // get jv template
            $jv_template = json_decode($tenderPa->jv_template);

            $temp = $jv_template->template;
            foreach ($temp as &$trx) {
                if ($trx->source_account) {
                    foreach ($trx->value as  $account) {
                        $details->account =  $account;
                    }
                }
            }

            if (gettype($selected_account) == "array") {
                $selected_account = $selected_account[0];
            }

            if ($selected_account != "") {
                // validate all source accounts based on the selected account
                $temp = $jv_template->template;
                foreach ($temp as &$trx) {
                    if ($trx->source_account) {
                        $account_val = [];
                        foreach ($trx->value as  $account) {
                            if ($account == $selected_account) {
                                $account_val[] = $account;
                            }
                        }
                        $trx->value = $account_val;
                    }
                }
                $jv_template->template = $temp;
            }


            $itemInfo = new stdClass();
            $itemInfo->details = $details;
            $itemInfo->freight = $freight;
            // re-organize jv template if not
            $jv_template = $this->_waybillCore->autoCompleteJvTemplate($jv_template, $itemInfo, null, 0);
  

            // validate if the item is already exists
            if (!$item_id) {
                $data = new stdClass();
                $data->filter = new stdClass();
                $data->filter->wn = $waybillBean->wn;
                $firstClaimItems = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);
                if ($firstClaimItems['found_rows'] > 0) {
                    throw new Exception("المستند مضاف مسبقا على المطالبة");
                }
            }

            // determine if the item has to be insert into new claim or existing one
            $receiver_company_id = $tenderPayableBean->company_id;
            $sender_company_id = $paBean->company_id;

            // get target claim id if exists, if the method is approve
            if ($item_id) {
                $itemBean = $this->_fps->getClaimItem($item_id, $_SESSION["user_id"]);

                // get target company id
                $trx_template = $itemBean['requested']['jv_template'];

                foreach ($trx_template as $trx) {

                    if ($trx['target_account']) {
                        $accountBean = $this->_fps->getAccountBasic($trx['account'], $_SESSION['user_id']);
                        $project_owner_company_id = $accountBean['details']['target_company_id'];
                    }
                }

                $receiver_company_id = $project_owner_company_id;
                $sender_company_id = 266770;
                // $details->route_wage_mode_code = $route_wage_mode->code;
                $target_claim_id = $this->_fps_claim_core->chooseTargetClaim(
                    $tender_id,
                    $claim_type,
                    $sender_company_id,
                    $receiver_company_id,
                    $details,
                    $_SESSION['user_id']
                );
            }

            // get target claim id if exists, if the method is append
            else {
                $target_claim_id = $this->_fps_claim_core->chooseTargetClaim(
                    $tender_id,
                    $claim_type,
                    $sender_company_id,
                    $receiver_company_id,
                    $details,
                    $_SESSION['user_id']
                );
            }

            // prepare item data to be send to fps sys
            $ItemData = new stdClass();
            $ItemData->pa_id = $pa_id;
            $ItemData->tender_payable_company_id = $tenderPayableBean->company_id;
            $ItemData->tender_id = $tender_id;
            $ItemData->freight = $freight;
            $ItemData->details = $details;
            $tagreesh_obj->jv_template = $jv_template;
            $ItemData->tagreesh_obj = $tagreesh_obj;
            $ItemData->sender_company_id = $item_id ? 266770 : $paBean->company_id;
            $ItemData->target_claim_id = $target_claim_id;
            if ($selected_account != "") {
                $ItemData->selected_account = $selected_account;
            }
            if ($item_id) {
                $ItemData->claim_item_id = $item_id;
                $ItemData->remarks = "تدقيق الوصل للمستند رقم " . $waybillBean->wn;
            }
            $ItemData->voucher_type_code = "WAYBILL_COMPLETE";
            $ItemData->jv_template = $jv_template;
            $tender_id = $this->_request->tender_id;

            $target_claim_id_filter = [];
            $target_claim_id_filter[] = ['key' => "sender_company_id", 'val' => $_SESSION['company_id']];
            $target_claim_id_filter[] = ['key' => "status", 'val' => "NEW"];
            $target_claim_id_filter[] = ['key' => 'claim_details', 'val' => "$tender_id", 'op' => 'json unquote', 'node' => '$.pa_project_id'];
            $target_claim_id_filter[] = ['key' => 'claim_details', 'val' => "$claim_destination_id", 'op' => 'json unquote', 'node' => '$.destination_id'];
            $ItemData->target_claim_id_filter = $target_claim_id_filter;

            if ($item_id) {
                $response = $this->_fps->approveClaimItem($ItemData, $_SESSION["user_id"]);
                // save waybill tagreesh and update its weights
                if ($response == "SUCCESS") {

                    // save the approved freight info in waybill
                    if ($waybill_id) {

                        // if the claim is for GO Station, then add trx in thier ledger
                        if ($pa_id == 57) {
                            $this->createGoApprovalTrx(
                                $tagreesh_obj->freight->net_amount + $tagreesh_obj->freight->total_advance_payment,
                                $waybillBean->wn,
                                $waybillBean->document->carrier[0]->truck->tn
                            );
                        }

                        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
                        $approvedInfo = $tagreesh_obj;

                        // update cargo
                        if ($waybillBean->document->cargo[0]->cargo_id != $approvedInfo->cargo->cargo_id) {
                            $this->_waybillCore->changeCargo($waybill_id, $approvedInfo->cargo->cargo_id, 0);
                        }

                        // update loading info
                        if ($waybillBean->document->cargo[0]->weights->loading->net_weight != $approvedInfo->loading->weight) {
                            $cargoBean = $waybillBean->document->cargo[0];
                            $cargoBean->weights->loading->net_weight = $approvedInfo->loading->weight;
                            $cargoBean->weights->loading->time_stamp = $approvedInfo->loading->time_stamp;
                            $waybillBean->document->cargo[0] = $cargoBean;
                            $this->_waybillCore->updateWeight($waybillBean, 0);
                        }

                        // update discharge info
                        if ($waybillBean->document->cargo[0]->weights->discharge->net_weight != $approvedInfo->discharge->weight) {
                            $cargoBean = $waybillBean->document->cargo[0];
                            $cargoBean->weights->discharge->net_weight = $approvedInfo->discharge->weight;
                            $cargoBean->weights->discharge->time_stamp = $approvedInfo->discharge->time_stamp;
                            $waybillBean->document->cargo[0] = $cargoBean;
                            $this->_waybillCore->updateWeight($waybillBean, 0);
                        }


                        // update origin info
                        if ($waybillBean->origin_id != $approvedInfo->loading->origin_id) {
                            $old_location = "-";
                            $old_location = $this->_locationCore->getLocationBasic($waybillBean->origin_id, 0)->name;
                            $new_location = $this->_locationCore->getLocationBasic($approvedInfo->loading->origin_id, 0)->name;
                            $routeBean = $waybillBean->document->negotiable_instructios->route;

                            $originNode = new stdClass();
                            $originNode->id = $approvedInfo->loading->origin_id;
                            $originNode->name = $new_location;
                            $routeBean->origin = $originNode;
                            $route_remark = new stdClass();
                            $route_remark->type = 'CHANGE_ROUTE';
                            $route_remark->notes = 'تم تغير موقع التحميل عند قبول المطالبة من ' . $old_location . ' الى ' . $new_location;
                            $route_remark->timestamp = date("Y-m-d") . " " . date("h:i:s");
                            $route_remark->user_id = 0;
                            if ($routeBean->remarks) {
                                array_push($routeBean->remarks, $route_remark);
                            } else {
                                $remarks = [];
                                array_push($remarks, $route_remark);
                                $routeBean->remarks = $remarks;
                            }

                            //update the route node in document
                            $waybillBean->document->negotiable_instructios->route = $routeBean;
                            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
                        }


                        // update distination info
                        if ($waybillBean->destination_id != $approvedInfo->discharge->distination_id) {
                            $old_location = "-";
                            $old_location = $this->_locationCore->getLocationBasic($waybillBean->destination_id, 0)->name;
                            $new_location = $this->_locationCore->getLocationBasic($approvedInfo->discharge->distination_id, 0)->name;
                            $routeBean = $waybillBean->document->negotiable_instructios->route;

                            $destinationNode = new stdClass();
                            $destinationNode->id = $approvedInfo->discharge->distination_id;
                            $destinationNode->name = $new_location;
                            $routeBean->destination = $destinationNode;
                            $route_remark = new stdClass();
                            $route_remark->type = 'CHANGE_ROUTE';
                            $route_remark->notes = 'تم تغير موقع التفريغ عند قبول المطالبة من ' . $old_location . ' الى ' . $new_location;
                            $route_remark->timestamp = date("Y-m-d") . " " . date("h:i:s");
                            $route_remark->user_id = 0;
                            if ($routeBean->remarks) {
                                array_push($routeBean->remarks, $route_remark);
                            } else {
                                $remarks = [];
                                array_push($remarks, $route_remark);
                                $routeBean->remarks = $remarks;
                            }

                            //update the route node in document
                            $waybillBean->document->negotiable_instructios->route = $routeBean;
                            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
                        }

                        // save waybill tagreesh
                        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
                        $this->_waybillCore->saveTagreeshData($waybillBean, $_SESSION['user_id'], $_SESSION['pa_id']);
                    }
                }
            } else {
                $response = $this->_fps->payClaimItem($ItemData, $_SESSION["user_id"]);
            }

            // return result
            $Result['ERRORCODE'] = "0";
            if (isset($response['claim_id'])) {
                $Result['CLAIM_ID'] = $response['claim_id'];
            }
            if (isset($response['item_id'])) {
                $Result['ITEM_ID'] = $response['item_id'];
            }
            if (isset($response['voucher_id'])) {
                $Result['VOUCHER_ID'] = $response['voucher_id'];
            }
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    private function generateClaimItemFreightNode(
        $waybillBean,
        $routeWage,
        $claim_loading_weight,
        $claim_loading_date,
        $claim_discharge_weight,
        $claim_discharge_date,
        $claim_discharge_arrive_date,
        $late_fine,
        $compensation,
        $absence_fine,
        $loss_fine,
        $pa_id
    ) {

        // inject cargo weights and dates in waybill bean
        $waybillBean->document->cargo[0]->weights->loading->net_weight = $claim_loading_weight;
        $waybillBean->document->cargo[0]->weights->loading->time_stamp = $claim_loading_date;
        $waybillBean->document->cargo[0]->weights->discharge->net_weight = $claim_discharge_weight;
        $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $claim_discharge_date;
        $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
        $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $claim_discharge_arrive_date;

        $freight = $this->_paymentCore->calculateFreight($waybillBean, $claim_discharge_weight, $claim_loading_weight, $routeWage, null, $pa_id);

        //update fines
        if ($late_fine) {
            $freight->amount->late_fine = $late_fine;
        }
        if ($compensation) {
            $freight->amount->compensation = $compensation;
        }
        if ($absence_fine) {
            $freight->amount->absence_fine = $absence_fine;
        }
        if ($loss_fine) {
            $freight->amount->loss_fine = $loss_fine;
        }

        $freight->amount->total_fines = $freight->amount->loss_fine + $freight->amount->absence_fine  +  $freight->amount->late_fine;

        return $freight;
    }

    // ------------------------------------------------------------------------------------ //
    // ---------------------  searchPayableClaims (claims sent to me )--------------------- //
    // ------------------------------------------------------------------------------------ //
    public function searchPayableClaims()
    {
        // claims received by me
        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->receiver_company_id = $_SESSION['company_id'];
        $result1 = $this->_fps->searchPayableClaims($data, 0);

        // claims sent by me
        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->sender_company_id = $_SESSION['company_id'];
        $result2 = $this->_fps->searchPayableClaims($data, 0);

        // merge 2 results
        $result_data = array_merge($result1['data'], $result2['data']);
        $result = new stdClass();
        $result->data = $result_data;
        $result->found_rows = sizeof($result_data);

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------- //
    // ---------------------  search receivable Claims (claims send by me)--------------------- //
    // ------------------------------------------------------------------------------------- //
    public function searchReceivableClaims()
    {
        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->sender_company_id = $_SESSION['company_id'];
        $result = $this->_fps->searchReceivableClaims($data, 0);
        parent::response($result);
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in AR Claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function autoCompleteARWaybillInfo()
    {

        // parse param
        $wn = $this->_request->wn;
        $tn = $this->_request->tn;

        try {
            if (!$wn && !$tn) {
                throw new Exception("رقم المستند او الشاحنة مطلوب");
            }

            // prepare search filter
            if ($tn) {
                $data = new stdClass();
                $data->filter = new stdClass();
                $data->filter->item_tn = $tn;
                $data->filter->status = "NEW";
            } else if ($wn) {
                $data = new stdClass();
                $data->filter = new stdClass();
                $data->filter->wn = $wn;
                $data->filter->status = "NEW";
            }

            // search in claim item
            $claimItemResult = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            $arr = [];
            foreach ($claimItemResult['data'] as $item) {

                $details = json_decode($item['details']);
                $requested = json_decode($item['requested']);

                // clean the data
                $result = new stdClass();
                $result->nafith_wn = $details->nafith_wn;
                $result->wn = $details->wn;
                $result->id = $details->waybill_id;
                $result->tn = $details->tn;
                $result->cargo_name = $requested->cargo->cargo_name;
                $result->cargo_id = $requested->cargo->cargo_id;
                $result->loading_weight = $requested->loading->weight;
                $result->loading_date = $requested->loading->time_stamp;
                $result->origin_id = $requested->loading->origin_id;
                $result->origin_name = $requested->loading->origin_name;

                $result->discharge_weight = $requested->discharge->weight;
                $result->discharge_date = $requested->discharge->time_stamp;
                $result->destination_name = $requested->discharge->distination_name;
                $result->destination_id = $requested->discharge->distination_id;
                $result->arrival_time = $requested->discharge->arrival_date;

                $result->policy_num = $requested->cargo->policy_num;

                $result->claim_id = $item['claim_id'];
                $result->claim_item_id = $item['id'];

                $result->pa_id = $details->pa_id;
                $result->pa_name = $details->pa_name;
                $arr[] = $result;
            }

            if (sizeof($arr) == 0) {
                throw new Exception("لا توجد معلومات متاحة");
            }
            parent::response($arr);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // -------------------------------------------------------------------------------------------------------------------------- //
    // --------- Make settelment with company by creating a voucher and closing thiers claim wich covers the payed amount ------- //
    // -------------------------------------------------------------------------------------------------------------------------- //
    public function makeCompanyClaimSettlement()
    {

        // get user params
        $assets_account_id = $this->_request->assets_account_id;
        $source_account_id = $this->_request->source_account_id;
        $amount = $this->_request->amount;
        $recipient_name = $this->_request->recipient_name;
        $notes = $this->_request->notes;

        $payment_method = "CASH";
        $voucher_type = "COMPANY_SETTELMENT";

        // validate auth
        $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR' || $role == 'PA_FPS_AUDITOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }



        try {

            // validate
            if ($amount == 0) {
                throw new Exception("لا تستطيع المتابعة قيمة الدفعة غير صحيحة");
            }
            $ledger_account_id = 590000;
            $assetsAccountBean = $this->_fps->getAccountBasic($assets_account_id, $_SESSION["user_id"]);
            if (!$assetsAccountBean) {
                throw new Exception("الحساب غير صحيح");
            }
            $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id, $_SESSION["user_id"]);
            if (!$sourceAccountBean) {
                throw new Exception("جهة الدفع غير صحيح");
            }


            // create bluebrint payment voucher
            $data = new stdClass();
            $data->voucher_type = $voucher_type;
            $trx_template_result = $this->_fps->getVoucherTypeTemplate($data, $_SESSION["user_id"]);
            $trx_template = json_decode($trx_template_result[0]['trx_templates'])->template;

            // fill bluebrint
            $item = [];
            $item['company_name'] = $sourceAccountBean['name'];
            $paymentObj = new stdClass();
            $paymentObj->value = $amount;
            $paymentObj->source_account_id = $sourceAccountBean['id'] . "-" . $sourceAccountBean['sub_id'];
            $paymentObj->target_account_id = $assetsAccountBean['id'] . "-" . $assetsAccountBean['sub_id'];

            $trx_template = $this->_voucherCore->generateVoucherTrx($trx_template, $assetsAccountBean, $paymentObj, null, $item);
            // authority object
            foreach ($trx_template as $trx) {
                if ($trx['source_account']) {
                    $voucherData = new stdClass();
                    $authority = new stdClass();
                    $authority->source_account_id = $ledger_account_id;
                    $authority->source_sub_id = explode("-", $trx['account_id'])[1];
                    $voucherData->authority = $authority;
                }
            }

            // destination object
            $destination = new stdClass();
            $destination->user_id =  null;
            $destination->company_id =  266770;
            $destination->is_beneficiary = 1;
            $voucherData->voucher_destination[] = $destination;

            $jv_template = [];
            $jv_template['code'] = $voucher_type;
            $jv_note = new stdClass();
            $jv_note->notes = $notes;
            $jv_note->text = $notes;
            $jv_template['jv_note'] = $jv_note;
            $jv_template['trx_template'] = $trx_template;

            $voucher_note = new stdClass();
            $voucher_note->text = $jv_note;
            $jv_template['voucher_note'] = $voucher_note;

            $voucherData->jv_template = $jv_template;
            $voucherData->amount = doubleval($amount);
            $voucherData->payment_method_code = strtoupper($payment_method);
            $voucherData->recipient_name = $recipient_name;

            $integration_details = new stdClass();
            $integration_details->callback = new stdClass();
            $integration_details->callback->endpoint = "fps_claim";
            $integration_details->callback->method = "addPaymentToReferance";
            $integration_details->callback->params = [
                "voucher_amount" => $amount,
                "target_company_id" => $sourceAccountBean['details']['target_company_id'],
                "notes" => $notes,
                "voucher_category" => "receipt"
            ];
            $voucherData->integration_details = $integration_details;
            $voucher_id = $this->_fps->createVoucher($voucherData, 0);

            // process the voucher
            $processData = new stdClass();
            $processData->voucher_id = $voucher_id;
            $this->_fps->processVoucherTrx($processData, 0);

            // call fps to add payment claim
            $company_id = $sourceAccountBean['details']['target_company_id'];
            $this->_fps_claim_core->addPaymentToCompanyClaim($amount, $company_id, $notes,  $_SESSION["user_id"]);

            // return success
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['voucher_id'] = $voucher_id;
            $Result['MESSAGE'] = "تمت العملية بنجاح";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------- //
    // ------
    // -------------------------------------------------- //
    public function FpsGetApprovedItemsForPa()
    {
        $data = new stdClass();
        $data->pa_id = $this->_request->pa_id;
        $result =  $this->_fps->FpsGetApprovedItemsForPa($data, $_SESSION["user_id"]);

        parent::response($result);
    }


    // --------------------------------------------------------------------------- //
    // --------------------- get multi claims info by filter------------------------ //
    // --------------------------------------------------------------------------- //
    public function customSearchClaims()
    {
        try {
            $request = $this->_request;

            $data = new stdClass();
            $data->filter = new stdClass();

            if ($this->_request->filter) {

                // prepare search filter in case the search crieteria is for claim items
                $item_filter = json_decode($this->_request->filter);
                $searchItems = false;
                if ($item_filter->tn) {
                    $data->filter->Truck_number_for_item = $item_filter->tn;
                    $searchItems = true;
                }
                if ($item_filter->wn) {
                    $data->filter->wn = $item_filter->wn;
                    $searchItems = true;
                }
                if ($item_filter->policy_num) {
                    $data->filter->policy_num = $item_filter->policy_num;
                    $searchItems = true;
                }

                // search for items
                $claim_id_list = [];
                if ($searchItems) {
                    $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

                    // exclude duplicate claim ids
                    foreach ($claim_items["data"] as $value) {
                        $claim_id_list[] = $value["claim_id"];
                    }
                    $claim_id_list = array_unique($claim_id_list);
                    $newClaim_id_list = [];
                    foreach ($claim_id_list as $key => $value) {
                        $newClaim_id_list[] = $value;
                    }
                    $claim_id_list = $newClaim_id_list;
                }
            }

            // search for claims
            $claim_req = new stdClass();
            $claim_req->filter = new stdClass();
            $claim_req->filter->status_in = ["NEW", "PENDING", "ACTIVE", "APPROVED"];
            if (sizeof($claim_id_list) > 0) {
                $claim_req->filter->claim_id_list = $claim_id_list;
            }
            if ($this->_request->filter) {
                $claim_filter = json_decode($this->_request->filter);
                if ($claim_filter->claim_id) {
                    $claim_req->filter->claim_id_list = [$claim_filter->claim_id];
                }
            }


            if ($claim_filter->route_wage_mode_code_item == "payable") {
                // search for claims sent to me
                $claim_req->filter->receiver_company_id = $_SESSION['company_id'];
            } else if ($claim_filter->route_wage_mode_code_item == "receivable") {
                // search for claims sent by me
                $claim_req->filter->sender_company_id = $_SESSION['company_id'];
            }
            $claimByFilter = $this->_fps->searchClaims($claim_req, $_SESSION['user_id']);


            parent::response($claimByFilter);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // --------------------------------------------------------------------------- //
    // --------------------- Go Station approval ------------------------ //
    // --------------------------------------------------------------------------- //
    public function createGoApprovalTrx($amount, $wn, $tn)
    {
        // generate trx
        $trx = [];
        $ledger_account_id = 500003;
        $temp = new stdClass();
        $temp->amount =  $amount;
        $temp->account = "500003-43003";
        $temp->op = 'C';
        $temp->notes =  "موافقة على المستند $wn للشاحنة رقم $tn";
        $trx[] = $temp;

        $temp2 = new stdClass();
        $temp2->amount =  $amount;
        $temp2->account = "500003-43004";
        $temp2->op = 'D';
        $temp2->notes =  "موافقة على المستند $wn للشاحنة رقم $tn";
        $trx[] = $temp2;

        // create the new trx
        $data = new stdClass();
        $data->ledger_account_id = $ledger_account_id;
        $data->jv_date = DBConnection::getSystemDate();
        $data->remarks = "موافقة على المستند $wn للشاحنة رقم $tn";
        $data->trx = $trx;

        $this->_fps->createTrx($data, 0);
    }



    // -------------------------------------------------------------------------------------------------- //
    // --------------------- get multi claims info by filter for the last 7 days ------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function getMGPayClaimDashboard_2()
    {
        try {

            // get claims
            $data = new stdClass();
            $data->filter = new stdClass();

            $data->filter->payee_reference_code = "TRUCK_OWNER";
            $data->filter->status_in = ["NEW", "ACTIVE"];
            $data->limit = 5000;
            $claimsReuslt =  $this->_fps->searchClaims($data, $_SESSION["user_id"]);
            
            
            // get claim_items
            $claimIds = [];
            foreach ($claimsReuslt['data'] as $claim) {
                $claimIds[] = $claim['id'];
            }
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = $claimIds;
            $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            // fill amount and
            foreach ($claimsReuslt['data'] as &$claim) {
                foreach ($claim_items['data'] as $item) {
                    if ($item['claim_id'] == $claim['id']) {
                        $claim['claim_amount'] += $item["requested_amount"];
                        $claim['item_count']++;
                    }
                }
            };

            $new_amount = 0;
            $held_amount = 0;

            foreach ($claimsReuslt['data'] as $val) {
                if ($val['status'] === "NEW") {
                    $new_amount += $val["claim_amount"];
                }
                if ($val['status'] === "ACTIVE" ) {
                    $claim_details = json_decode($val['claim_details']);
                    if($claim_details->is_delayed){
                        $held_amount += $val["claim_amount"];
                    }
                }
            }
            $result = [];
            $result["new_sum_amount"] = $new_amount;
            $result["held_sum_amount"] = $held_amount;


            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    
    // -------------------------------------------------------------------------------------------------- //
    // --------------------- get multi claims info by filter for the last 7 days ------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function getMGPayClaimDashboard_1()
    {
        try {

            // get all claims (active and complete)
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->date_from = date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 7 days'));
            $data->filter->date_to = DBConnection::getSystemDate();
            $data->filter->payee_reference_code = "TRUCK_OWNER";
            $data->filter->status_in = ["ACTIVE", "COMPLETE"];
            $claimsReuslt =  $this->_fps->searchClaims($data, $_SESSION["user_id"]);

            // get claim_items
            $claimIds = [];
            foreach ($claimsReuslt['data'] as $claim) {
                $claimIds[] = $claim['id'];
            }
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = $claimIds;
            $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            // fill amount for each claim
            foreach ($claimsReuslt['data'] as &$claim) {
                foreach ($claim_items['data'] as $item) {
                    if ($item['claim_id'] == $claim['id']) {
                        $claim['claim_amount'] += $item["requested_amount"];
                        $claim['item_count']++;
                    }
                }
            };

            // start formating data
            $final_result =   [
                ['اليوم', 'المصروف من المحطات', 'المسدد'],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 7 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 6 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 5 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 4 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 3 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 2 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . ' - 1 days')))[0]],
                [explode(' ', date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate())))[0]]
            ];

            // fill empty result (template)
            $temp = [];
            foreach ($final_result as $value) {
                $obj = new stdClass();
                $obj->key = $value[0];
                $obj->amount = 0;
                $obj->paid = 0;
                $temp[] = $obj;
            }
            array_shift($temp);

            foreach ($claimsReuslt['data'] as  $fps_claim) {
                $activation_date = explode(' ', $fps_claim['activation_date'])[0];
                $payments = json_decode($fps_claim['claim_details'])->payments;
                foreach ($temp as &$value) {
                    if ($value->key === $activation_date) {
                        $value->amount += $fps_claim["claim_amount"];
                    }

                    if (sizeof($payments) > 0) {
                        foreach ($payments as  $p) {
                            if (explode(' ', $p->time_stamp)[0] === $value->key) {
                                $value->paid += $p->value;
                            }
                        }
                    }
                }
            }


            foreach ($temp as  $t) {
                foreach ($final_result as  &$ar) {
                    if ($t->key === explode(" ", $ar[0])[0]) {
                        $ar[] = intval($t->amount);
                        $ar[] = intval($t->paid);
                    }
                }
            }

            parent::response($final_result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------- //
    // ------------------- Get NEW and Active Truck Owner claims ----------------- //
    // ------------------------------------------------------------------- //
    public function getActiveTruckOwnerClaims()
    {
        $truck_owner_id = $_SESSION['truck_owner_id']; #436674
        $result = [];

        // search for tickets (REUQEST_ADV_PAYMENT)
        $filter = array();
        $filter['type_code'] = 'REUQEST_ADV_PAYMENT';
        $filter['status'] = ['NEW'];
        $tickets = $this->_customerCare->searchTickets($filter, null, null, " desc ");
        foreach ($tickets['data'] as $ticket) {
            $ticket_data = json_decode($ticket['request']['data']);
            if ($ticket_data->body->truck_owner_id == $truck_owner_id) {

                $tempClaim = new stdClass();
                $tempClaim->id = $ticket['id'];
                $tempClaim->type = "TICKET";
                $tempClaim->status = $ticket['status'];
                $tempClaim->color = "gray";

                $item1 = new stdClass();
                $item1->label = "المبلغ";
                $item1->value =  $ticket_data->body->amount . " دينار";
                $tempClaim->item_1 = $item1;

                $item2 = new stdClass();
                $item2->label = "قيد المراجعة";
                $item2->value = "";
                $tempClaim->item_2 = $item2;

                $item3 = new stdClass();
                $item3->label = "";
                $item3->value = "ديزل للشاحنة " . $ticket_data->body->tn;
                $tempClaim->item_3 = $item3;

                $item4 = new stdClass();
                $item4->label = "تاريخ الطلب";
                $item4->value = date_format(date_create($ticket['created_at']), "Y-m-d");
                $tempClaim->item_4 = $item4;
                $result[] = $tempClaim;
            }
        }

        // search for NEW and ACTIVE claims
        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->payee_reference_code = "TRUCK_OWNER";
        $data->filter->payee_reference_value = $truck_owner_id;
        $data->filter->status_in = ["NEW", "ACTIVE"];
        $claimsReuslt =  $this->_fps->searchClaims($data, 0);

        // loop on each claim and start sorting
        foreach ($claimsReuslt['data'] as $claim) {

            $details = json_decode($claim['claim_details']);

            // basic info
            $tempClaim = new stdClass();
            $tempClaim->id = $claim['id'];
            $tempClaim->type = "CLAIM";
            $tempClaim->status = $claim['status'];

            $item1 = new stdClass();
            $item1->label = "المبلغ";
            $item1->value =  $this->_fps->getClaimRemainingAmount($claim['id'], 0) . " دينار";
            $tempClaim->item_1 = $item1;

            switch ($claim['status']) {
                    // --------------------------------- NEW CLAIMS ------------------------------------ //
                case 'NEW':
                    $tempClaim->color = "blue";

                    $item2 = new stdClass();
                    $item2->label = "جديد";
                    $item2->value = "";
                    $tempClaim->item_2 = $item2;

                    $item3 = new stdClass();
                    $item3->label = "نوع السلفة";
                    $item3->value = "ديزل";
                    $tempClaim->item_3 = $item3;

                    $item4 = new stdClass();
                    $item4->label = "تاريخ الطلب";
                    $item4->value = date_format(date_create($claim['create_date']), "Y-m-d");
                    $tempClaim->item_4 = $item4;

                    break;

                case 'ACTIVE':
                    // -------------------------- المتعثر --------------------------- //
                    if ($details->is_delayed) {
                        $tempClaim->color = "red";

                        $item2 = new stdClass();
                        $item2->label = "متعثر";
                        $item2->value = "";
                        $tempClaim->item_2 = $item2;

                        $item3 = new stdClass();
                        $item3->label = "نوع السلفة";
                        $item3->value = "ديزل";
                        $tempClaim->item_3 = $item3;

                        $item4 = new stdClass();
                        $item4->label = "متعثر منذ";
                        $item4->value = date_format(date_create($claim['due_date']), "Y-m-d");
                        $tempClaim->item4 = $item4;
                    }
                    // -------------------------- ACTIVE --------------------------- //
                    else {
                        $tempClaim->color = "green";

                        $item2 = new stdClass();
                        $item2->label = "فعال";
                        $item2->value = "";
                        $tempClaim->item_2 = $item2;

                        $item3 = new stdClass();
                        $item3->label = "نوع السلفة";
                        $item3->value = "ديزل";
                        $tempClaim->item_3 = $item3;

                        $item4 = new stdClass();
                        $item4->label = "تاريخ التفعيل";
                        $item4->value =  date_format(date_create($claim['activation_date']), "Y-m-d");
                        $tempClaim->item_4 = $item4;
                    }
                    break;
            }

            $result[] = $tempClaim;
        }


        parent::response($result);
    }


    // ------------------------------------------------------------------- //
    // ------------------- Get Complete Truck Owner claims ----------------- //
    // ------------------------------------------------------------------- //
    public function getCompleteTruckOwnerClaims()
    {

        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->payee_reference_code = "TRUCK_OWNER";
        $data->filter->payee_reference_value = $_SESSION['truck_owner_id'];
        $data->filter->status_in = ["COMPLETE"];

        $claimsReuslt =  $this->_fps->searchClaims($data, 0);

        $result = [];
        foreach ($claimsReuslt['data'] as $claim) {
            $tempClaim = new stdClass();
            $tempClaim->id = $claim['id'];
            $tempClaim->type = "CLAIM";

            $item1 = new stdClass();
            $item1->label = "المبلغ";
            $item1->value =   $this->_fps->getClaimRemainingAmount($claim['id'], 0);;
            $tempClaim->item_1 = $item1;

            $item2 = new stdClass();
            $item2->label = "الاستحقاق";
            $item2->value = date_format(date_create($claim['due_date']), "Y-m-d");
            $tempClaim->item_2 = $item2;

            $item3 = new stdClass();
            $item3->label = "";
            $item3->value = "";
            $tempClaim->item_3 = $item3;

            $item4 = new stdClass();
            $item4->label = "التفعيل";
            $item4->value = date_format(date_create($claim['activation_date']), "Y-m-d");

            $tempClaim->item_4 = $item4;

            $result[] = $tempClaim;
        }

        parent::response($result);
    }


    public function getClaimForMobile()
    {

        $claim_id = $this->_request->claim_id;
        $claimsReuslt =  $this->_fps->getClaim($claim_id, $_SESSION["user_id"]);

        // fix date format
        $claimsReuslt['create_date'] =  date_format(date_create($claimsReuslt['create_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['create_date']), "H:i");
        $claimsReuslt['due_date'] =  date_format(date_create($claimsReuslt['due_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['due_date']), "H:i");
        $claimsReuslt['activation_date'] =  date_format(date_create($claimsReuslt['activation_date']), "Y-m-d") . " " . date_format(date_create($claimsReuslt['activation_date']), "H:i");

        // get remaining amount
        $remainingAmount =  $this->_fps->getClaimRemainingAmount($claim_id, $_SESSION["user_id"]);
        $claimsReuslt['remaining_amount'] = $remainingAmount;
        $claimAmount =  $this->_fps->getClaimAmount($claim_id, $_SESSION["user_id"]);
        $claimsReuslt['claim_amount'] = $claimAmount;

        // get claim item
        if ($claimsReuslt['payee_reference']['reference_code'] == "TRUCK_OWNER") {
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->claim_ids_in = [$claimsReuslt['id']];
            $claim_items = $this->_fps->searchClaimItems($data, $_SESSION["user_id"]);

            $item_details = json_decode($claim_items['data'][0]['details']);
            $share_link = $item_details->sms_details->text;
            $share_link = explode("g.minagate.com", $share_link);
            $share_link = "g.minagate.com" . $share_link[1];
            $claimsReuslt['share_link'] = $share_link;

            $secret = md5($claim_items['data'][0]['id']);
            $encoder = 'https://chart.googleapis.com/chart?chs=200x200&chld=M%7C0&cht=qr&chl=';
            $QR_code_url = $encoder . $secret;
            $claimsReuslt['QR_code_url'] = $QR_code_url;
        }

        $raw_template = '
        <html>
                <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
            <head>
            <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

                <style>
                    .MinagateFont {
                        font-family: DroidArabicKufiRegular;
                        font-weight: lighter;
                        font-style: normal;
                        color: #807d7d;
                        font-size: 11px;
                        margin-top: 22px;
                    }
                    .labelStyle {
                        text-align: right;
                        padding-right: 25px;
                    }
                    .valueStyle {
                        text-align: right;
                        color: rgb(74, 163, 222);
                    }
                    .divStyle {
                        padding: 4px;
                        border-bottom: solid 0.5px #ccc;
                    }
                </style>
            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
            </head>
            <body>
                <div class="MinagateFont">
                    <form>
                        <div class="QR" id="QR" style="display: flex;justify-content: center;">
                            <img src=' . $QR_code_url . '/>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $claimsReuslt['claim_details']['tn'] . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : رقم الشاحنة</label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle"> ' . $claimsReuslt['claim_amount'] . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : المبلغ</label>
                        </div>
                        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                                ' . $claimsReuslt['create_date'] . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : تاريخ الانشاء </label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle">
                                ' . $claimsReuslt['activation_date'] . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : تاريخ التفعيل </label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 ">
                            <label class="col-sm-7  col-md-7 col-xs-7 col-form-label valueStyle" style=" direction: rtl;">
                                ' . $claimsReuslt['due_date'] . '</label>
                            <label class="col-sm-5   col-md-5 col-xs-5  col-form-label labelStyle"> : تاريخ الاستحقاق </label>
                        </div>
                        <div class="form-group divStyle col-sm-12  col-xs-12   col-md-12 " style=" direction: rtl;">
                            تستطيع صرف سلفة الديزل في أي من محطات الوطنية للمحروقات المعتمدة لدينا في المواقع التالية
                        </div>
                        <div class="row" >
                        <div id="available_stations" class="col-xs-12 text-center" style="display: flex; justify-content: space-evenly; flex-wrap: wrap"><div style="width:110px"><a href="https://goo.gl/maps/DuT1nST2qwnJjrFK8"><img src="https://storage.googleapis.com/g.minagate.com/station_1.jpeg" width="100" height="100" style="border-radius: 64.5px; margin-top: 20px; border: 2px solid rgb(151, 198, 103);"><label style="font-size:10px">الجيزة - زيزيا</label></a></div><div style="width:110px"><a href="https://g.page/qatranah-gas-oil?share"><img src="https://storage.googleapis.com/g.minagate.com/station_2.jpeg" width="100" height="100" style="border-radius: 64.5px; margin-top: 20px; border: 2px solid rgb(151, 198, 103);"><label style="font-size:10px">القطرانة 2 - توتال</label></a></div><div style="width:110px"><a href="https://goo.gl/maps/NRCddJZhADNBSf1Y7"><img src="https://storage.googleapis.com/g.minagate.com/station_3.jpeg" width="100" height="100" style="border-radius: 64.5px; margin-top: 20px; border: 2px solid rgb(151, 198, 103);"><label style="font-size:10px">الرجيب - الجويدة شارع سحاب</label></a></div><div style="width:110px"><a href="https://goo.gl/maps/YdoLaydCCeA8GmQm6"><img src="https://storage.googleapis.com/g.minagate.com/station_4.jpeg" width="100" height="100" style="border-radius: 64.5px; margin-top: 20px; border: 2px solid rgb(151, 198, 103);"><label style="font-size:10px">الهاشمية - لواء الحسينية (قريبا)</label></a></div><div style="width:110px"><a href="https://goo.gl/maps/MXhKUdjU4Sv9bDLs6"><img src="https://storage.googleapis.com/g.minagate.com/station_5.jpeg" width="100" height="100" style="border-radius: 64.5px; margin-top: 20px; border: 2px solid rgb(151, 198, 103);"><label style="font-size:10px">الحسا - توتال (قريبا)</label></a></div></div>
                    </div>
                       </form>
                </div>
            </body>

        </html>
        ';

        $raw_template = str_replace("\n", "", $raw_template);
        $result = new stdClass();
        $result->template =  $raw_template;
        $result->share_link =  $share_link;
        parent::response($result);
    }



    // ---------------------------------------------------------------------------- //
    // --------------- Add Manual Payment to certain claim ----------------------- //
    // ---------------------------------------------------------------------------- //
    public function addManualPayment()
    {
        // get user input
        $payment_amount = $this->_request->payment_amount;
        $claim_id = $this->_request->claim_id;
        $remarks = $this->_request->remarks;
        $account_id = $this->_request->account_id;

        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR' ) {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية كافية");
        }
        
        // get claimBean
        $claimBean =  $this->_fps->getClaim($claim_id, $_SESSION["user_id"]);        
        if(!$claimBean) {
            throw new Exception("المطالبة غير صحيحة");
        }
        $truck_owner_id =  $claimBean['payee_reference']['reference_value'];        
      
        $MGPAY_tender_id = $this->_tenderCore->getMgPayTender()->id;
        $tender_bean = $this->_tenderCore->getTenderBasic($MGPAY_tender_id, 0);
        $account_ledger_id = $tender_bean->manifest->account_ledger_id;
        $accountFilter = new stdClass();
        $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $truck_owner_id];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $owner_account_qry =  $this->_fps->searchAccount($accountFilter, 0);
        $generateFpsVoucherTrxData = new stdClass();
        $generateFpsVoucherTrxData->net_amount = $payment_amount;
        $generateFpsVoucherTrxData->truck_owner_account =  $owner_account_qry['data'][0]['id'] . "-" .  $owner_account_qry['data'][0]['sub_id'];
        $generateFpsVoucherTrxData->debit_note = "سداد قيمة السلفة - " . $remarks;

        $recipient_company_id = 266770;
        $template_id = 4;   //4= سداد السلفة
        $jv_trx_2 = $this->_fpsVoucherCore->generateFpsVoucherTrx(
            $template_id,
            $generateFpsVoucherTrxData,
            $recipient_company_id,
            "سداد قيمة السلفة بشكل يدوي " . $remarks,
            true
        );
        
        $jv_trx_2[1]['account'] = $account_id;
        $jv_trx_2[1]['notes'] = "استلام المبلغ نقدا كسداد للسلفة رقم $claim_id";
 
        $data = new stdClass();
        $data->ledger_account_id = $account_ledger_id;
        $data->jv_date = DBConnection::getSystemDate();
        $data->remarks = "سداد قيمة السلفة بشكل يدوي " . $remarks;
        $data->trx = $jv_trx_2;
        $this->_fps->createTrx($data, 0);

        // add payment
        $this->_fps_claim_core->addPaymentToTruckOwnerClaim($payment_amount, $truck_owner_id, "سداد قيمة السلفة - " . $remarks, 0);

        // return success
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result);
    }


            
}

new FpsClaims_interface();
