<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . '/../../includes/util.php');
require_once(dirname(__FILE__) . '/../../core/user/user_core.php');
require_once(dirname(__FILE__) . '/../../core/DBR/dbr_core.php');

class Fps_claim_core
{


    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------- //
    // -------------- create new claim for truck ------------------------------------- //
    // -------------- This method is called when answer downpayment poll ------------- //
    // ------------------------------------------------------------------------------- //
    public function createWaybillDownpaymentClaim($waybill_id, $queue_id, $notes, $activation_date, $due_date, $done_by)
    {

        $_dbrCore = new DBR_Core();
        $_fps = new FPS();
        $_truckCore = new TruckCore();
        $waybillCore = new waybillCore();
        $queueCore = new QueueCore();

        // get waybill bean in case waybill_id is defined
        if ($waybill_id) {
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id,$done_by);
        $tn = $waybillBean->document->carrier[0]->truck->tn;
        $tender_id = $waybillBean->tender_id;
        }
        if ($queue_id) {
            $queueFilter = [['key' => 'id', 'val' => $queue_id]];
            $queueResult = $queueCore->searchQueue($queueFilter, 1, 0, 0);
            $tn =  $queueResult->data[0]->tn;
            $tender_id =  $queueResult->data[0]->tender_id;
        }


        $truck_id =  $queueResult->data[0]->truck_id;
        $tn =  $queueResult->data[0]->tn;
        $tender_id =  $queueResult->data[0]->tender_id;

        // make sure the truck is owned by the user
        $truckFilter = [['key'=>'tn','val' => $tn]];
        $truck_result = $_truckCore->searchTrucks($truckFilter,1,0,$done_by);

        if($truck_result->found_rows == 0){
            throw new Exception("لا يوجد لديك صلاحية للمتابعة أو ان الشاحنة غير صحيحة");
        }

        // calculate Truck DBR amount
        $dbr = $_dbrCore->calculateWaybillDBR($tn , $tender_id);

        // make sure the down_payment value is > 0
        if($dbr['dbr_value'] <= 0){
            throw new Exception("لا تستطيع المتابعة ، قيمة الدفع المقدم غير صحيحة (صفر)");
        }

        $data = new stdClass();

        // if activation_date is not set then the claim must be activated now
        if(!$activation_date){
            $activation_date = DBConnection::getSystemDate();
        }
        $data->activation_date = $activation_date;
        $data->due_date = $due_date;

        // reference object
        $data->reference = new stdClass();
        $data->reference->reference_code = "TN";
        $data->reference->reference_value = $tn;

        // claim details
        $claim_details = new stdClass();
        $claim_details->waybill_id = $waybill_id;
        $claim_details->queue_id = $queue_id;

        $claim_details->claim_sub_type = "DOWNPAYMENT";
        $claim_details->claim_type = "AP_CLAIM";
        $claim_details->tender_id = $tender_id;
        $claim_details->tn = $tn;
        $claim_details->notes = $notes;
        $claim_details->ledger_account_sub_id =  $tn; // truck

        // payments
        $claim_details->payments = [];
        $data->claim_details = $claim_details;
        $data->ledger_account_id = "590000"; // Minagate

        // call fps system to create claim
        $claim_id = $_fps->createClaim($data, $done_by);

        // create task to monitor the claim


        $result = [];
        $result['claim_id'] = $claim_id;
        $result['claim_amount'] = $dbr['down_payment']['value'];
        return $result;
    }


    // --------------------------------------------------------------------------------------- //
    // -------------- create new item in claim for truck ------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function appendDownpaymentClaimItem($claim_id, $amount, $waybill_id, $notes, $done_by)
    {

        // init
        $waybillCore = new waybillCore();
        $_fps = new FPS();

        // get waybill bean
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id,$done_by);

        $itemBean = new stdClass();
        $itemBean->claim_id = $claim_id;
        $itemBean->status = "NEW";
        $itemBean->create_date = date("Y-m-d h:m:s");
        $itemBean->details = new stdClass();
        $itemBean->details->tn = $waybillBean->document->carrier[0]->truck->tn;
        $itemBean->details->amount = $amount;
        $itemBean->details->wn = $waybillBean->wn;
        $itemBean->details->waybill_id = $waybillBean->id;
        $itemBean->details->tender_id = $waybillBean->tender_id;
        $itemBean->details->tender_name = $waybillBean->document->tender->name;

        // call fps system to append item to claim
        $claim_id = $_fps->appendItemToClaim($itemBean, $done_by);
    }


    // --------------------------------------------------------------------------- //
    // --------------------- change pa claim status  --------------------- //
    // --------------------------------------------------------------------------- //
    public function changeClaimStatus($claim_id, $new_status, $done_by)
    {
        try {
            // init 
            $_fps = new FPS();

            $data = new stdClass();
            $data->claim_id = $claim_id;
            $data->new_status = $new_status;
            $_fps->changeClaimStatus($data, $done_by);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain company claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToCompanyClaim($amount, $company_id, $notes, $done_by)
    {

        try {
            // init
            $_fps = new FPS();

            $data = new stdClass();
            $data->amount = $amount;
            $data->company_id = $company_id;
            $data->notes = $notes;
            $result = $_fps->addPaymentToClaim($data, $done_by);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain TN claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToTnClaim($amount, $tn, $notes, $done_by)
    {

        try {
            // init 
            $_fps = new FPS();

            $data = new stdClass();
            $data->amount = $amount;
            $data->tn = $tn;
            $data->notes = $notes;
            $result = $_fps->addPaymentToTnClaim($data, $done_by);
            return $result;

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain truck owner claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToTruckOwnerClaim($amount, $truck_owner_id, $notes, $done_by)
    {

        try {
            // init
            $_fps = new FPS();

            $data = new stdClass();
            $data->amount = $amount;
            $data->truck_owner_id = $truck_owner_id;
            $data->notes = $notes;

            $result = $_fps->addPaymentToTruckOwnerClaim($data, $done_by);
            return $result;

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ---------------------Add new payment into certain TN claim --------------- //
    // ----------------------------------------------------------------------- //
    public function addPaymentToReferance($amount, $tn, $notes, $done_by)
    {

        try {
            // init
            $_fps = new FPS();

            $data = new stdClass();
            $data->amount = $amount;
            $data->tn = $tn;
            $data->notes = $notes;
            $_fps->addPaymentToReferance($data, $done_by);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    public function getTruckACtiveClaimAmount($tn)
    {
        // get active claims on the truck
        $fps = new FPS();
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->tn = $tn;
        $filterObj->filter->status = "ACTIVE";
        $claimsReuslt =  $fps->searchClaims($filterObj, 0);

        $totalClaimRemaingAmount = 0;
        // in case the truck has claim, deduct from net amount
        if ($claimsReuslt['found_rows']) {
            // get the remaining of each claim
            foreach ($claimsReuslt['data'] as $claim) {
                $remainingAmount =  $fps->getClaimRemainingAmount($claim['id'], 0);
                $totalClaimRemaingAmount += $remainingAmount;
            }
        }
        $downpayment = $totalClaimRemaingAmount;
    }


    // -------------------------------------------------------------------------------------------- //
    // -------------- create new AR claim for the truck owner company (NAFITH) -------------------- //
    // -------------- This method is called when waybill is set to complete  ---------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function createARClaimWithProjectOwner($waybill_id, $user_id)
    {

        $waybillCore = new waybillCore();
        $tenderCore = new TenderCore();
        $fps = new FPS();

        // get waybill bean for tender id and cargo name
        $waybillBean = $waybillCore->getWaybillBasic($waybill_id, $user_id);
        $cargo_name = $waybillBean->document->cargo[0]->name;
        $tender_id = $waybillBean->tender_id;
        $tenderBean = $tenderCore->getTenderBasic($tender_id, $user_id);
        $company_id = $tenderBean->company_id;

        $request = new stdClass();
        $request->filter = new stdClass();
        $request->filter->status = "ACTIVE";
        $request->filter->company_id = $company_id;
        $claimsReuslt = $fps->searchClaims($request, $user_id);

        // if there is no claim in the database
        if ($claimsReuslt["found_rows"] == 0) {
            $claim_bean =  new stdClass();
            $claim_bean->ledger_account_id = "590000"; // todo need to be fetched from tenderTruck bean
            $claim_bean->activation_date = DBConnection::getSystemDate();
            $claim_bean->reference = new stdClass();
            $claim_bean->reference->reference_code = "COMPANY";
            $claim_bean->reference->reference_value = $company_id;
            $claim_bean->claim_details = new stdClass();
            $claim_bean->claim_details->claim_type = "AR_CLAIM";

            // get current month
            $dt = new DateTime($claim_bean->activation_date);
            $currentMonth = $dt->format('Y-m');
            $claim_bean->claim_details->month = $currentMonth;
            $claim_bean->claim_details->cargo = $cargo_name;
            $claim_bean->claim_details->tender_id = $tender_id;

            // create NEW Claim
            $claim_id = $this->createWaybillARClaim($claim_bean, 0);

            // activate it
            $this->changeClaimStatus($claim_id, "ACTIVE", 0);
        } else {
            $claim_id = $claimsReuslt["data"][0]["id"];
        }

        $itemBean = new stdClass();
        $itemBean->claim_id = $claim_id;
        $itemBean->status = "NEW";
        $itemBean->create_date = date("Y-m-d h:m:s");
        $itemBean->details = new stdClass();
        $itemBean->details->tn = $waybillBean->document->carrier[0]->truck->tn;
        $itemBean->details->amount = $waybillBean->document->freight->amount->net_amount + 5;  // TODO: 5 has to be dynamic
        $itemBean->details->wn = $waybillBean->wn;
        $itemBean->details->waybill_id = $waybillBean->id;
        $itemBean->details->voucher_id = $voucher_id;
        $itemBean->details->tender_id = $waybillBean->tender_id;
        $itemBean->details->tender_name = $waybillBean->document->tender->name;

        $item_id = $this->appendItemToARClaim($itemBean,  $user_id);
    }

    private function createWaybillARClaim($claim_bean, $done_by)
    {
        $_fps = new FPS();
        $claim_id = $_fps->createClaim($claim_bean, $done_by);
        return $claim_id;
    }

    // --------------------------------------------------------------------------------------- //
    // -------------- create new item in claim for truck ------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    private function appendItemToARClaim($itemBean, $done_by)
    {
        $_fps = new FPS();
        // call fps system to append item to claim
        $item_id = $_fps->appendItemToClaim($itemBean, $done_by);
        return $item_id[0]["@id"];
    }


    // ---------------------------------------------------------------------------------------------------------------------------- //
    // -------------- choose whether the app has to add the item to new claim or append it to an existing claim ------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function chooseTargetClaim(
        $tender_id,
        $claim_type,
        $sender_company_id,
        $receiver_company_id,
        $details,
        $user_id
    ) {

        $fps = new FPS();

        switch ($tender_id) {

            // for Vessels Porject
            case 3 || 13:
                $filterObj = new stdClass();
                $filter = new stdClass();
                $filter->claim_type = $claim_type;
                $filter->status = "NEW";
                $filter->sender_company_id = $sender_company_id;
                $filter->receiver_company_id = $receiver_company_id;
                $filter->cargo_id = $details->cargo_id;
                $filter->route_wage_mode_code = $details->route_wage_mode_code;
                $filterObj->filter = $filter;
                $claim_result = $fps->searchClaims($filterObj, $user_id);


                dump($claim_result);die;
                
                if($claim_result['found_rows'] == 0){
                    return null;
                }else{
                    return $claim_result['data'][0]['id'];
                }
            default:
                throw new Exception("Unsupported Tender in target");
                break;
        }
    }
}
