<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/company_employee/company_employee_core.php");


class FPS_Account_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_fps;
    private $_accountCore;
    private $_companyEmployeeCore;
    private $_userCore;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // init the object
        $this->_fps = new FPS();
        $this->_accountCore = new AccountCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();
        $this->_userCore = new UserCore();

        DBConnection::getInstance();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------------------- //
    // ------------------  prepare any json filter for search --------------------- //
    // ---------------------------------------------------------------------------- //
    private function prepareFilter($filter)
    {
        $accountFilter = [];

        if ($filter) {
            $filter = json_decode($filter, true);

            foreach ($filter as $key => $value) {
                if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == "idWith") {
                    $tempArr = ['key' => "id", 'val' => $value, 'op' => 'startsWith'];
                } else if ($key == "payment_channel") {
                    $tempArr = ['key' => 'payment_channel', 'val' => "'$value'", 'op' => 'json unquote', 'node' => '$[0]'];
                } else if ($key == "user_id" || $key == "company_id") {
                    if ($value == 'is null' || $value == 'is not null') {
                        $tempArr = ['key' => 'name', 'op' => 'is not null'];
                        array_push($accountFilter, $tempArr);
                        $tempArr = ['key' => $key, 'op' => $value];
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value];
                    }
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($accountFilter, $tempArr);
            }
        }

        // if session id for corporate , inject the account_ids filter
        $account_ids = $this->_accountCore->getAccountAuthority($_SESSION);
        if ($account_ids) {
            $tempArr = ['key' => 'sub_id', 'val' => $account_ids, 'op' => 'in'];
            array_push($accountFilter, $tempArr);
        }

        return $accountFilter;
    }

    // -------------------------------------------------------------------- //
    // --------------------- get account bean + trx ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function getAccount()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $data->date_from = $this->_request->date_from;
        $data->date_to = $this->_request->date_to;

        $result = $this->_fps->getAccount($data, $_SESSION['user_id']);

        parent::response($result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function searchAccount()
    {
        $data = new stdClass();
        $data->account_id = $this->_request->account_id;
        if ($this->_request->filter)
            $data->filter = $this->_request->filter;


        $result = $this->_fps->searchAccount($data, $_SESSION['user_id']);
        parent::response($result);
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------- Search for accounts for TC, PA, CA accounts --------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchCompanyAccounts()
    {

        $data = new stdClass();
        $result = $this->_fps->searchCompanyAccounts($data, $_SESSION['user_id']);

        parent::response($result);
    }


    public function searchCashBoxAccount()
    {

        $filter = $this->prepareFilter(null);

        $data = new stdClass();
        $data->filter = [];
        $data->filter['type'] = "CASH";
        $data->filter['status'] = "ACTIVE";
        $data->filter = json_encode($data->filter);

        $result = $this->_fps->searchCashBoxAccount($data, $_SESSION['user_id']);
        parent::response($result);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function searchAdvancePaymentAccounts()
    {
    }

    // --------------------------------------------------------------------------------------- //
    // --------------------- create Sub Account ---------------------------------------------- //
    // --------------------- params tc_id, pa_id, ca_id , $type , account_name --------------- //
    // --------------------------------------------------------------------------------------- //
    public function createSubAccount()
    {
    }

    // ----------------------------------------------------------------- //
    // --------------------- update account info ----------------------- //
    // ----------------------------------------------------------------- //
    public function updateAccount()
    {
    }

    // --------------------------------------------------------------------------------- //
    // --------------Clear the request and form it to be a valid account bean ---------- //
    // --------------------------------------------------------------------------------- //
    private function cleanAccountBean($request)
    {
    }

    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------- get a list of financial account for any user or company  grouped by type--------------------- //
    // ----------------- params: account_id -------------------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function getFinancialAccounts()
    {


        $data = new stdClass();
        $data->account_id = $this->_request->account_id;

        $result = $this->_fps->getFinancialAccounts($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: company_id, user_id--------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_scoreCards()
    {
        $data = new stdClass();
        $data->account_id = $this->_request->account_id;

        $result = $this->_fps->getFinancialSummary_scoreCards($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: company_id, user_id--------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getMobileFinancialSummaryScoreCards()
    {
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_cashFlow()
    {
        $data = new stdClass();
        $data->account_id = $this->_request->account_id;

        $result = $this->_fps->getFinancialSummary_cashFlow($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account payables --------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AP()
    {
        $data = new stdClass();
        $data->account_id = $this->_request->account_id;

        $result = $this->_fps->getFinancialSummary_AP($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account receivable ------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AR()
    {
        $data = new stdClass();
        $data->account_id = $this->_request->account_id;

        $result = $this->_fps->getFinancialSummary_AR($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummaryForAccount()
    {

        $data = new stdClass();
        $data->account_id = $this->_request->account_id;
        $data->sub_id = $this->_request->sub_id;
        $data->from_date = $this->_request->from_date;
        $data->to_date = $this->_request->to_date;

        $result = $this->_fps->getFinancialSummaryForAccount($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // --------------------------------------------------------------------------//
    // ------------------- Search trx stattment  --------------------------------//
    // --------------------------------------------------------------------------//
    public function searchTrxStatment()
    {
        $data = new stdClass();
        $data->trx_id = $this->_request->trx_id;

        $result = $this->_fps->searchTrxStatment($data, $_SESSION['user_id']);

        // in case the session is corporate , change done_by to return employee name
        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $user_ids = [];
            foreach ($result['trx'] as $trx) {
                $user_ids[] = $trx->done_by;
            }

            $searchFilter = [
                ['key' => 'company_id', 'val' => $_SESSION['company_id']],
                ['key' => 'status', 'val' => 'ACTIVE']

            ];
            $employeeInfo = $this->_companyEmployeeCore->searchCompanyEmployee($searchFilter, 100, 0, 0); #17558

            foreach ($result['trx'] as &$trx) {
                foreach ($employeeInfo->data as $employee) {
                    if ($trx['update_by'] == $employee->user_id) {
                        $trx['update_by'] = $employee->name;
                    }
                }
            }
        }


        parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // ----------------- withdraw amount of money from a cap account ) ---------------------------------------------------- //
    // ----------------- also this withdraw will decrease certain assets account (like Wallet, Cash ----------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function withdrawAssetsBalance()
    {
    }

    // --------------------------------------------------------------------------------------------------------- //
    // ----------------- deposite amount of money in a certain assets account (like Wallet, Cash) -------------- //
    // ----------------- also this deposite will increase the CAP account of the company ----------------------- //
    // ----------------- params: account_id, amount                          ----------------------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function depositeAssetsBalance()
    {
        $data = new stdClass();

        $data->amount = $this->_request->amount;
        $data->capital_account_id = $this->_request->capital_account_id;
        $data->asset_account_id = $this->_request->asset_account_id;
        $data->remarks = $this->_request->remarks;

        $result = $this->_fps->depositeAssetsBalance($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- move amount of money from an assets account (like Wallet, Cash) -------------- //
    // ----------------- to another assets account (like Wallet, Cash) -------------------------------- //
    // ----------------- params: from_account_id, to_account_id , amount       ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function moveBalanceBetweenAccounts()
    {

        $data = new stdClass();

        // prepare params
        $data->from_account_id = $this->_request->from_account_id;
        $data->to_account_id = $this->_request->to_account_id;
        $data->amount = $this->_request->amount;
        $remarks = $this->_request->remarks;
        $data->remarks = str_replace("↵", '\n', $remarks); // remove new lines

        $result = $this->_fps->moveBalanceBetweenAccounts($data, $_SESSION['user_id']);
        parent::response($result);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function undoJV()
    {
        $data = new stdClass();
        $data->jv_id = $this->_request->jv_id;
        $data->note = $this->_request->note;

        $result = $this->_fps->undoJV($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- createCashBoxLog ------------- //
    // ------------------------------------------------------------------------------- //
    public function createCashBoxLog()
    {
        $data = new stdClass();
        $accounts = $this->_fps->searchAccount($data, $_SESSION['user_id']);

        $ledger_account_id = $accounts["data"][0]["id"];
        $transferBalance = $accounts["data"][0]["balance"];

        $cashBoxLogBean = new stdClass();
        $cashBoxLogBean->account_id = $ledger_account_id;
        $cashBoxLogBean->sub_id = $accounts["data"][0]["sub_id"];
        $cashBoxLogBean->notes = "";
        $cashBoxLogBean->action_code = "CLOSE";
        $this->_fps->createCashBoxLog($cashBoxLogBean, $_SESSION['user_id']);


        // TODO: write JV (store in DB)
        if ($_SESSION['pa_id'] == 57 && $transferBalance > 0) {   //57: الوطنية
            $trx_template = [];
            $trx_template[] = array(
                "account" => "500003-40000", //TODO
                "amount" => $transferBalance,
                "op" => "C",
                "notes" => "ترحيل صندوق",
                "trx_note" => ["text" => "ترحيل صندوق"],
                "source_account" => true
            );
            $trx_template[] = array(
                "account" => $ledger_account_id . "-" . $accounts["data"][0]["sub_id"],
                "amount" => $transferBalance,
                "op" => "D",
                "notes" => "ترحيل صندوق",
                "trx_note" => ["text" => "ترحيل صندوق"]
            );
            $data = new stdClass();
            $data->ledger_account_id = $ledger_account_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks = "ترحيل صندوق";
            $data->trx = $trx_template;

            $this->_fps->createTrx($data, $_SESSION['user_id']);
        }

        parent::response("تمت العملية بنجاح");
    }
    // ---------------------------------------------------- //
    // ---------------- createCashBoxLog ------------------ //
    // ---------------------------------------------------- //
    public function getCashBoxLogDetails()
    {
        $cashBoxLogBean = new stdClass();
        $cashBoxLogBean->filter = $this->_request->filter;
        $cashBoxLogBean->limit = 1;
        $cashBoxLogBean->offset = 0;
        $result = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);


        parent::response($result);
    }
    public function cash_box_report()
    {
        $names = [];
        $ids = [];
        $cashBoxLogBean = new stdClass();
        $cashBoxLogBean->account_id = $this->_request->account_id;
        $cashBoxLogBean->date_from = $this->_request->date_from;
        $cashBoxLogBean->date_to = $this->_request->date_to;
        $result = $this->_fps->cash_box_report($cashBoxLogBean, $_SESSION['user_id']);
        foreach ($result['data'] as &$value) {
            $id = $value['update_by'];
            if (!in_array($id, $ids)) {
                $ids[] = $id;
                $names[$id] = $this->_userCore->getUserBasic($id, 0)->name;
            }
            $value['employee_name'] = $names[$id];
        }
        parent::response($result);
    }

    // ---------------------------------------------------- //
    // ---------------- createCashBoxLog ------------------ //
    // ---------------------------------------------------- //
    public function getShiftCashBoxLogDetails()
    {
        $account = explode("-", $this->_request->account_id);
        $receivedBalance = 0;

        $cashBoxLogBean = new stdClass();
        $cashBoxLogBean->filter = ["account_id" => $account[0], "sub_id" => $account[1]];
        $cashBoxLogBean->limit = 1;
        $cashBoxLogBean->offset = 0;
        $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id'])[0];

        $result = [];
        $result['employee_name'] = $this->_userCore->getUserBasic($_SESSION['u_id'], 0)->name;
        $result['open_balance'] = $cashBoxResult['open_balance'];
        $result['open_balance'] = $cashBoxResult['open_balance'];
        $result['open_date'] = $cashBoxResult['open_date'];
        $result['close_balance'] = $cashBoxResult['close_balance'];

        $result['shift_num'] = $cashBoxResult['id'];
        $result['status_caption'] = $cashBoxResult['status'] == "NEW" ? "مفتوح" : "مغلق";
        $result['status'] = $cashBoxResult['status'];
        $result['remarks'] = $cashBoxResult['remarks'];
        $result['account_id'] = $cashBoxResult['account_id'] . "-" . $cashBoxResult['sub_id'];

        $data = new stdClass();
        $data->filter = ["id" => $this->_request->account_id];

        $accountFilter = new stdClass();
        $accountFilter->filter = ["id" => $account[0], "sub_id" => $account[1]];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $account_qry =  $this->_fps->searchAccount($accountFilter, 0);
        $accountDetails = json_decode($account_qry["data"][0]["details"]);

        if ($cashBoxResult['status'] == "COMPLETE") {

            $result['close_date'] = $cashBoxResult['close_date'];

            $fpsData = new stdClass();
            $fpsData->jv_id = $cashBoxResult['jv_id'];
            $jv_trx = $this->_fps->getJvTrx($fpsData, $_SESSION['user_id']);
            $trx_amount = $jv_trx[0]['amount'];

            $receivedBalance =  $trx_amount + $accountDetails->minimum_residual;
            $result['transfered_balance'] = $receivedBalance - $accountDetails->minimum_residual;
        } else {

            $result['close_date'] = '';

            $accountStatmentData = new stdClass();
            $accountStatmentData->account_id = $account[0];
            $accountStatmentData->account_sub_id = $account[1];
            $accountStatmentData->from_date = $cashBoxResult['open_date'];
            $accountStatmentData->to_date = DBConnection::getSystemDate();
            $accountTrxResult = $this->_fps->getAccountStatement($accountStatmentData, 10000, $_SESSION['user_id']);

            $receivedBalance = 0; // TODO;
            foreach ($accountTrxResult['data'] as $trx) {
                if ($trx['op'] == "D") {
                    $receivedBalance += $trx['amount'];
                }
                if ($trx['op'] == "C") {
                    $receivedBalance -= $trx['amount'];
                }
            }
            $result['transfered_balance'] = 0;
        }


        $result['received_balance'] = $receivedBalance;
        $result['remaining_balance'] = $result['received_balance'] - $result['transfered_balance'];

        parent::response($result);
    }



    // ----------------------------------- Close Cash Box -----------------------------------//
    public function closeShiftCashBoxLog()
    {

        try {

            // validate account
            $account = explode("-", $this->_request->account_id);

            // search account
            $accountFilter = new stdClass();
            $accountFilter->filter = ["id" => $account[0], "sub_id" => $account[1]];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);
            if ($account_qry['found_rows'] == 0) {
                throw new Exception("رقم الحساب غير صحيح");
            }

            // get account details
            $accountDetails = json_decode($account_qry["data"][0]["details"]);
            $ledger_account_id = $account_qry["data"][0]["id"];
            $accountBalance = $account_qry["data"][0]["balance"];

            $targetAccount = $accountDetails->transfer_account_id;
            $minimum_residual = $accountDetails->minimum_residual;

            //validate cashbox log if the box is already closed
            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->filter = ["account_id" => $account[0], "sub_id" => $account[1]];
            $cashBoxLogBean->limit = 1;
            $cashBoxLogBean->offset = 0;
            $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);

            if ($cashBoxResult == "[]" || sizeof($cashBoxResult) == 0  || $cashBoxResult[0]['status'] == "COMPLETE") {
                throw new Exception("الصندوق مغلق مسبقا");
            }

            // calculate transfer balance
            if ($accountBalance > $minimum_residual) {
                $transferBalance = $accountBalance - $minimum_residual;
            } else {
                $transferBalance = 0;
            }

            $transferBalance = 1;

            // transfer amount to target cashbox
            $remarks = " ترحيل صندوق: " . $this->_request->account_id . "-" . $this->_request->remarks . " وردية رقم: " . $cashBoxResult[0]['id'];
            if ($transferBalance > 0) {
                $trx_template = [];
                $trx_template[] = array(
                    "account" => $ledger_account_id . "-" . $targetAccount,
                    "amount" => $transferBalance,
                    "op" => "D",
                    "notes" => $remarks,
                    "trx_note" => ["text" => $remarks],
                    "source_account" => true
                );
                $trx_template[] = array(
                    "account" => $ledger_account_id . "-" . $account_qry["data"][0]["sub_id"],
                    "amount" => $transferBalance,
                    "op" => "C",
                    "notes" => $remarks,
                    "trx_note" => ["text" => $remarks]
                );

                $data = new stdClass();
                $data->ledger_account_id = $ledger_account_id;
                $data->jv_date = DBConnection::getSystemDate();
                $data->remarks = "ترحيل صندوق";
                $data->trx = $trx_template;

                $jv_id = $this->_fps->createTrx($data, $_SESSION['user_id']);
            }

            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->account_id = $ledger_account_id;
            $cashBoxLogBean->sub_id = $account_qry["data"][0]["sub_id"];
            $cashBoxLogBean->notes = $remarks;
            $cashBoxLogBean->action_code = "CLOSE";
            $cashBoxLogBean->jv_id = $jv_id;

            $result = $this->_fps->closeCashBoxLog($cashBoxLogBean, $_SESSION['user_id']);

            parent::response("تمت العملية بنجاح");
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function openShiftCashBoxLog()
    {

        try {

            $acount_id = explode("-", $this->_request->account_id);
            $accountFilter = new stdClass();
            $accountFilter->filter = ["id" => $acount_id[0], "sub_id" => $acount_id[1]];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $accounts = $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);

            $ledger_account_id = $accounts["data"][0]["id"];
            if ($accounts['found_rows'] != 1) {
                throw new Exception("Error while open account");
            }
   

            // open cash box
            $cashBoxLogBean = new stdClass();
            $cashBoxLogBean->account_id = $ledger_account_id;
            $cashBoxLogBean->sub_id = $accounts["data"][0]["sub_id"];
            $cashBoxLogBean->notes = "";
            $cashBoxLogBean->action_code = "OPEN";
            $result = $this->_fps->openCashBoxLog($cashBoxLogBean, $_SESSION['user_id']);


            parent::response("تمت العملية بنجاح");
        } catch (Exception $e) {
            if (gettype($e->getMessage() == "string")) {
                $messageObj = json_decode($e->getMessage());
                throw new Exception($messageObj->MESSAGE);
            }
        }
    }
    public function getAccountStatment()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $data->sub_id = $this->_request->sub_id;
        $data->from_date =  $this->_request->date_from;
        $data->to_date = $this->_request->date_to;
        $accountTrxResult = $this->_fps->getAccountStatement($data, 10000, $_SESSION['user_id']);
        parent::response($accountTrxResult);
    }
    public function getAccountStatment2()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $data->sub_id = $this->_request->sub_id;
        $data->from_date =  $this->_request->date_from;
        $data->to_date = $this->_request->date_to;
        $accountTrxResult = $this->_fps->getAccountStatement($data, 10000, $_SESSION['user_id']);
        parent::response($accountTrxResult);
    }


    public function getAccountStatementChart()
    {
        $date_from = new DateTime(DBConnection::getSystemDate());
        $date_from = $date_from->format('Y-m-d');
        $interval  = $this->_request->days;
        $date_from_week = date('Y-m-d ', strtotime($date_from . ' -'.$interval.' days'));

        $result = [];

        $data = new stdClass();
        $data->filter = ['type' => 'CASH'];

        if ($this->_request->account_id) {
            $account = explode("-", $this->_request->account_id);
            $id     = $account[0];
            $sub_id = $account[1];
        }else{
            throw new Exception("لا يوجد معلومات",600);
        }

        $data2 = new stdClass();
        $data2->account_id =  $id   ;
        $data2->account_sub_id = $sub_id;
        $data2->from_date = $date_from_week;
        $data2->to_date = $date_from;
        $getAccount = $this->_fps->getAccountStatement($data2, 10000, $_SESSION['user_id']);
        $sum = $getAccount['data'][0]['past_balance'];

        foreach ($getAccount['data'] as $key => $value) {
            if ($value['op'] == 'C') {
                $sum -= $value['amount'];
            } elseif ($value['op'] == 'D') {
                $sum += $value['amount'];
            }
            $date = date('M-d H:00', strtotime($value['trx_date']));

            $result[$date] = $sum;
        }

        $result2 = [];
        foreach ($result as $key => $value) {
            $result2[] = [$key, $value];
        }
        parent::response($result2);
    }
}

new FPS_Account_interface();
