<?php

require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/employee_core.php");
require_once (dirname(__FILE__)."/../notes/add_notes_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../gateway/gateWay_core.php");


class employee_interface  extends API{

    // the request of each call
    private $_request = array();
    private $_employeeCore;
    private $_userCore;
    private $_gatewayCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();

        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the EmployeeCore object
        $this->_employeeCore = new EmployeeCore();
        $this->_userCore = new UserCore();
        $this->_gatewayCore = new GatewayCore();

        // process the incoming request
        $this->processRequest();

    }


    // call the correnponding method based on what the request call
    private function processRequest(){
        $func = $this->_request->method;
        unset($this->_request->method);
        if((int)method_exists($this,$func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found',404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // -------------------------------------------------------------- //
    // --------------------- get employee info------------------------- //
    // -------------------------------------------------------------- //
    public function getEmployee(){

        $employeeBean = json_decode($this->_employeeCore->getEmployee($this->_request->id, $_SESSION['user_id']));
        $employee_id = $employeeBean->id;
        $searchFilter = [['key'=>'employee_id','val' =>$employee_id]];
        $userBean = $this->_userCore->searchUser($searchFilter,1,0,$_SESSION['user_id']);

        $result = new stdClass();
        $result->employeeBean = $employeeBean;
        $result->userBean = $userBean->data[0];

        //return Success reponse
        parent::response($result);
    }



    // ------------------------------------------------------------------------ //
    // -------------------search for employees using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchEmployees(){

        // call the core search
        $searchFilter = $this->prepareFilter();

        // dont show employee where id < 119000
        $searchFilter[] = ['key'=>'id', 'val'=>119000, 'op' => 'less than'];

        $employees_qry = $this->_employeeCore->searchEmployees(  $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        foreach ($employees_qry->data as $emp) {
            $employee_id =$emp->id;
            $searchFilter = [['key'=>'employee_id','val' =>$employee_id]];
            $userBean = $this->_userCore->searchUser($searchFilter,1,0,$_SESSION['user_id']);
            $emp->photos = $userBean->data[0]->photos;
            $emp->user_id= $userBean->data[0]->id;

        }

        parent::response($employees_qry);
    }

    // ------------------------------------------------------------------------ //
    // -----------deactivate user role for employee using any  filter ---------- //
    // ------------------------------------------------------------------------ //
    public function deactivateUserRole()
    {
        if(is_null($this->_request->company_id)){
            $userLoggedInBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
            $company_id=$userLoggedInBean->company_id;
        }else{
            $company_id=$this->_request->company_id;
        }
        $this->_employeeCore->deactivateUserRole(
            $this->_request->user_id,
            $this->_request->role_code,
            $company_id,
            $this->_request->new_status
        );
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }
    // ------------------------------------------------------------------------ //
    // -----------Activate user role for employee using  filter ---------- //
    // ------------------------------------------------------------------------ //
    public function ActivateUserRole()
    {

        if(is_null($this->_request->company_id)){
            $userLoggedInBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
            $company_id=$userLoggedInBean->company_id;
        }else{
            $company_id=$this->_request->company_id;
        }
        $allowedRoles = $this->_userCore->getUserRolesHierarchy($_SESSION['user_id']);
        $this->_employeeCore->ActivateUserRole(
            $this->_request->user_id,
            $this->_request->role_code,
            $company_id,
            $this->_request->employee_id,
            $this->_request->new_status
        );
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // --------------------------------------------------------------- //
    // -----------deactivate TENDER for a certain user ------------ //
    // --------------------------------------------------------------- //
    public function deactivateTenderForEmployee(){

        // call the core to activate this tender
        $user_id = $this->_request->user_id;
        $tender_id = $this->_request->tender_id;
        $company_id = $_SESSION['company_id'];
        $employee_id = $this->_request->employee_id;

        $this->_employeeCore->deactivateTenderForEmployee($user_id, $tender_id, $company_id, $employee_id,$_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // ----------------------------------------------------------------------------------------------------------------- //
    // ----------- add new TENDER for a cerain emplyee, by either create new record or re-activate old one ---------- //
    // ----------------------------------------------------------------------------------------------------------------- //
    public function activateTenderForEmployee(){



        // call the core to activate this tender
        $user_id = $this->_request->user_id;
        $tender_id = $this->_request->tender_id;
        $company_id = $_SESSION['company_id'];
        $employee_id = $this->_request->employee_id; // in case the user is minagate employee
        $this->_employeeCore->activateTenderForEmployee($user_id, $tender_id, $company_id, $employee_id,$_SESSION['user_id']);

        // return the response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------ //
    // -----------Add user roles for employee  ------------------------- //
    // ------------------------------------------------------------------------ //
    public function addUserRole()
    {
        $allowedRoles = $this->_userCore->getUserRolesHierarchy($_SESSION['user_id']);
        $userRoles = array_filter(json_decode($this->_request->rolecodes),function($role){ return $role!='ANONYMOUS'; });
        if(array_diff($userRoles, $allowedRoles)) {
            throw new Exception(' لا يوجد لديك صلاحية ﻹتمام هذه العملية ');
        }
        if(is_null($this->_request->company_id)){
            $userLoggedInBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
            $company_id=$userLoggedInBean->company_id;
        }else{
            $company_id=$this->_request->company_id;
        }
        foreach ($userRoles as $roleCode ) {
            $this->_employeeCore->ActivateUserRole(
                $this->_request->user_id,
                $roleCode,
                $company_id,
                $this->_request->employee_id,
                $this->_request->new_status
            );
        }
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    private function prepareFilter()
    {
        $employeeFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($value){
                    if($key=='name') {
                        $tempArr = [key => $key, 'val' => $value, 'op' => 'like'];
                        array_push($employeeFilter,$tempArr);

                    }else{
                        $tempArr = ['key'=>$key,'val' => $value, 'op' => '='];
                        array_push($employeeFilter,$tempArr);
                    }
                }
            }
        }
        return $employeeFilter;
    }
    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate Employee Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeStatus(){

        $this->_employeeCore->changeStatus($this->_request->employee_id,
            $this->_request->new_status,
            $_SESSION['user_id']);

        // write remarks if exist
        if($this->_request->remarks != null){
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('employee', $this->_request->employee_id, $this->_request->remarks , $_SESSION['user_id'] );
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "EMPLOYEE.SUCCESSFUL_OPERATION";
        parent::response($Result);

    }

    // -------------------------------------------------------------------------- //
    // ----------- get a list of phone_operator employees ----------------------- //
    // -------------------------------------------------------------------------- //
    public function getCallCenterEmployee(){

        $db_query = " SELECT
                        us.user_id, us.name
                     FROM
                        user_role_view us,
                        user u,
                        employee e
                     WHERE
                        us.role_code IN ('PHONE_OPERATOR' , 'MINAGATE_OPERATION')
                            AND us.status = 'ACTIVE'
                            AND us.user_id = u.id
                            AND u.status = 'ACTIVE'
                            and u.employee_id = e.id
                            and e.status = 'ACTIVE'";

        $result =  DBConnection::runDatabaseQuery($db_query);
        parent::response($result);

    }


    // -------------------------------------------------------------- //
    // --------------------- update Employee email------------------------- //
    // -------------------------------------------------------------- //
    public function UpdateEmployeeEmail()
    {
        try {
            // get user params
            $employee_id = $this->_request->id;
            $employee_email = $this->_request->user_email;
            // search for user id 
            $searchFilter = [['key' => 'employee_id', 'val' => $employee_id]];
            $users = $this->_userCore->searchUser($searchFilter, 1, 0, $_SESSION['user_id']);
            if ($users->found_rows == 0) {
                throw new Exception("الموظف غير صحيح ");
            }
            // update employee email 
            $userPhone = json_decode($users->data[0]->phone_array);
            $userPhone[0]->email = $employee_email;
            $users->data[0]->phone_array = $userPhone;
            $userBean = $users->data[0];
            // save in data base 
            $this->_userCore->updateUserInfo($userBean, $userBean->id, $_SESSION['user_id']);
            $result = new stdClass();
            $result->message = "تمت العملية بنجاح";
            parent::response($result);
        } catch (Exception $ex) {
            throw new Exception($ex->getMessage());
        }
    }
    
}

$employee_interface= new employee_interface();
