<?php
/**
 * Created by PhpStorm.
 * User: LENOVO
 * Date: 7/25/2018
 * Time: 8:03 AM
 */

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../notification/notification_core.php");
require_once (dirname(__FILE__)."/../company/company_core.php");


class EmployeeCore
{

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_notificationCore = new NotificationCore();
        $this->_companyCore = new CompanyCore();

    }

    // ------------------------------------------------------------------------ //
    // -------------------get  User bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getEmployee($id, $user_id)
    { // IMPORTANT: user_id is the user who search not the user we are looking for.

        $employeeInfo = DBConnection::getObjectBean("employee", $id, $user_id);
        if ($employeeInfo == null) {
            throw new Exception("EMPLOYEE.NOT_EXIST", 0);
        }
        return $employeeInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------get  User bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getEmployeeBasic($id, $user_id){ 

        $employeeInfo = DBConnection::getBasicObjectBean("employee", $id, $user_id);
        if ($employeeInfo == null) {
            throw new Exception("EMPLOYEE.NOT_EXIST", 0);
        }
        return $employeeInfo;
    }


    // -------------------------------------------------------------------------- //
    // -------------------search for employees using any search filter ---------- //
    // -------------------------------------------------------------------------- //
    public function searchEmployees($searchFilter, $limit, $offset, $user_id)
    {

        $searchUserResult = DBConnection::searchDB("employee", $searchFilter, $limit, $offset, $user_id);
        return $searchUserResult;
    }

    // --------------------------------------------------------------------------- //
    // ---------------------activate/ Deactivate an employee---------------------- //
    // --------------------------------------------------------------------------- //
    public function changeStatus($employee_id, $new_status, $user_id)
    {
        $updateStruct = new stdClass();
        $updateStruct->id = $employee_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("employee", $updateStruct, $user_id);
    }
    // --------------------------------------------------------------------------- //
    // ---------------------Deactivate user role for  employee-------------------- //
    // --------------------------------------------------------------------------- //
    public function deactivateUserRole($user_id, $role_code,$company_id, $new_status)
    {
        // search for userRole row in user role table
        $roleActive = $this->searchUserRole($user_id, $company_id,'ACTIVE', $role_code);
        $updateStruct = new stdClass();
        $updateStruct->id = $roleActive->data[0]->id;
        $updateStruct->role_code = $role_code;
        $updateStruct->status = $new_status;
        //update  user role from ACTIVE to INACTIVE in user role table
        DBConnection::updateDB("user_role", $updateStruct, $_SESSION['user_id']);
        //update  user roles from in user  table
        $rolesActive = $this->searchUserRole($user_id,$company_id, 'ACTIVE');
        $rolesArray = ["ANONYMOUS"];
        foreach ($rolesActive->data as $role) {
            array_push($rolesArray, $role->role_code);
        }
        $updateUserStruct = new stdClass();
        $updateUserStruct->id = $user_id;
        $updateUserStruct->role_code = join(",", array_unique($rolesArray));
        DBConnection::updateDB("user", $updateUserStruct, $_SESSION['user_id']);
    }
    // --------------------------------------------------------------------------- //
    // ---------------------Deactivate user role for  employee-------------------- //
    // --------------------------------------------------------------------------- //
    public function ActivateUserRole($user_id, $role_code, $company_id, $employee_id, $new_status)
    {
        // search for userRole row in user role table
        $roleActive = $this->searchUserRole($user_id, $company_id,'INACTIVE', $role_code);
            $updateStruct = new stdClass();

        if (count($roleActive->data) != 0) {

            $updateStruct->id = $roleActive->data[0]->id;
            $updateStruct->role_code = $role_code;
            $updateStruct->status = $new_status;
            // change the status
            DBConnection::updateDB("user_role", $updateStruct, $_SESSION['user_id']);
        } else {
            //assign new user role to user in user role table
            $userRoleBean = new stdClass();
            $userRoleBean->user_id = $user_id;
            $userRoleBean->role_code = $role_code;
            $userRoleBean->status = $new_status;
            $userRoleBean->company_id = $company_id;
            $userRoleBean->employee_id = $employee_id;
            $newUserRoleQry = DBConnection::insertDB("user_role", $userRoleBean, $_SESSION['user_id']);

            //update  user role from new to active in user role table
            $updateStruct = new stdClass();
            $updateStruct->id = $newUserRoleQry[0]['@id'];
            $updateStruct->status = $new_status;
            $updateStruct->role_code = $role_code;
            DBConnection::updateDB("user_role", $updateStruct, 0);

            // --------- SEND NOTIFICATION TO ACTIVATED USER----------------
            $companyBean = $this->_companyCore->getCompanyBasic($company_id, $_SESSION['user_id']);
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = 2222;
            $payload->message =  " تم إضافنك على شركة " .$companyBean->name;
            $this->_notificationCore->sendDataMessage($user_id,$payload);
        }

        //update  user roles from in user  table
        $rolesActive = $this->searchUserRole($user_id,$company_id, 'ACTIVE');
        $rolesArray = ["ANONYMOUS"];
        foreach ($rolesActive->data as $role) {
            array_push($rolesArray, $role->role_code);
        }
        $updateUserStruct = new stdClass();
        $updateUserStruct->id = $user_id;
        $updateUserStruct->role_code = join(",", array_unique($rolesArray));
        DBConnection::updateDB("user", $updateUserStruct, $_SESSION['user_id']);

    }

    // -------------------------------------------------------------------------------- //
    // ------------------ activate tender for a certain employee-------------------- //
    // -------------------------------------------------------------------------------- //
    public function activateTenderForEmployee($user_id, $tender_id, $company_id, $employee_id, $done_by)
    {

        try {
            // get the employee
            $employee = json_decode($this->getEmployee($employee_id, $done_by));

            // if all tenders
            if ($tender_id == "*") {

                $tendersArray = ["*"];

            } else {
                // add new tender to employee tender list
                $tendersArray = $employee->tender_ids;
                if ($tendersArray && gettype($tendersArray) == 'array') {
                    $tendersArray[] = $tender_id;
                } else {
                    $tendersArray = [$tender_id];
                }
            }



            $employee->tender_ids = $tendersArray;

            // update
            DBConnection::updateDB("employee", $employee, $done_by);

            // inform the user about this change
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand(1, 1000);
            $payload->message =  "تمت إضافة مشروع جديد الى قائمتك";
            $this->_notificationCore->sendDataMessage($user_id, $payload);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------- //
    // ------------------ deactivate tender for a certain employee-------------------- //
    // -------------------------------------------------------------------------------- //
    public function deactivateTenderForEmployee($user_id, $tender_id, $company_id, $employee_id, $done_by)
    {

        try {
            $employee = json_decode($this->getEmployee($employee_id, $done_by));

            // if all tenders
            if ($tender_id == "*") {
                $newTendersArray = [];
            } else {
                // get the employee
                $tendersArray = $employee->tender_ids;
                $newTendersArray = [];

                // remove the selected tender from employee list
                foreach ($tendersArray as $tender) {
                    if ($tender != $tender_id) {
                        $newTendersArray[] = $tender;
                    }
                }
            }


            $employee->tender_ids = $newTendersArray;

            // update
            DBConnection::updateDB("employee", $employee, $done_by);

            // inform the user about this change
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand(1, 1000);
            $payload->message =  "تمت حذف مشروع من قائمتك";
            $this->_notificationCore->sendDataMessage($user_id, $payload);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    private function searchUserRole($user_id,$company_id, $status, $role_code = null)
    {

        if ($role_code) {
            $searchFilter = [['key' => 'user_id', 'val' => $user_id],
                ['key' => 'role_code', 'val' => $role_code],
                ["key"=>'company_id',"val"=>$company_id],
                ['key' => 'status', 'val' => $status]];
        } else {
            $searchFilter = [['key' => 'user_id', 'val' => $user_id],
                ["key"=>'company_id',"val"=>$company_id],
                ['key' => 'status', 'val' => $status]];
        }
        $searchUserResult = DBConnection::searchDB("user_role", $searchFilter, 100, 0, $_SESSION['user_id']);
        return $searchUserResult;
    }


}