<?php

// import required classes
require_once (dirname(__FILE__)."/driver_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../notes/add_notes_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");

class Driver_interface extends API{

    // the request of each call
    private $_request = array();
    private $_driverCore;
    private $_userCore;
    

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();
        
        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the DriverCore object
        $this->_driverCore = new DriverCore();
        $this->_userCore = new UserCore();
        
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }
 
    // -------------------------------------------------------------- //
    // --------------------- get Driver info------------------------- //
    // -------------------------------------------------------------- //
    public function getDriver(){
      
  
        $driverBean = $this->_driverCore->getDriver($this->_request->id,$_SESSION['user_id']);
        $user_id = (json_decode($driverBean)->user_id);
        
        $userBean = $this->_userCore->getUser($user_id,$_SESSION['user_id']);
        $activities = json_decode($driverBean)->activity;

        $result = new stdClass();
        $result->driverBean = $driverBean;
        $result->userBean = $userBean;
  
        //return Success reponse
        parent::response($result);
    }

    // ------------------------------------------------------- //
    // -------------------auto complete driver info ---------- //
    // ------------------------------------------------------- //
    public function driverAutoComplete() {

        $driverBean = $this->_driverCore->driverAutoComplete($this->_request,$_SESSION['user_id']);
        if(!$driverBean)
            $driverBean = new stdClass();

        parent::response($driverBean);
    }

    // ------------------------------------------------------- //
    // -------------------auto complete driver info ---------- //
    // ------------------------------------------------------- //
    public function driverAutoCompleteForMobile() {

        if($this->_request->user_answer){
            $this->_request->phone_nn = $this->_request->user_answer;
        }

        $driverBean = $this->_driverCore->driverAutoComplete($this->_request,0);
        if(!$driverBean){
            $driverBean = new stdClass();
            $driverBean->name = "تحديد السائق عند الوصول";
        }


        parent::response($driverBean->name);
    }

     // ------------------------------------------------------------------- //
    // -------------------auto complete driver info for terminal ---------- //
    // -------------------------------------------------------------------- //
    public function driverAutoCompleteForTerminal() {

        if($this->_request->user_answer){
            $this->_request->phone_nn = $this->_request->user_answer;
        }

        $driverBean = $this->_driverCore->driverAutoComplete($this->_request,0);
        if(!$driverBean)
            $driverBean = new stdClass();

        $result = new stdClass();
        $result->id = $driverBean->driver_id;
        $result->name = $driverBean->name;
        $result->nn = $driverBean->nn;
        $result->phone = $driverBean->phone;

        parent::response($result);
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for drivers using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchDrivers(){
        
        // give default values  to offset and limit in case not provided
        if(property_exists($this->_request, 'offset') ? $offset = $this->_request->offset : $offset = 0); 
        if(property_exists($this->_request, 'limit') ? $limit = $this->_request->limit : $limit = 15); 
        
        $filter = $this->prepareFilter();

        // call the core search
        $driver_qry = $this->_driverCore->searchDriver($filter,
                                                       $this->_request->limit,
                                                       $this->_request->offset,
                                                       $_SESSION['user_id']
                                                      );

        // loop on the search result and convert any code into caption
        // add any warning
        foreach ($driver_qry->data  as &$driverInfo) {
            $driverInfo->status_caption = "DRIVER.STATUS.$driverInfo->status";
            // gert driver warning
            $warnings = $this->_driverCore->getDriverWarnings($driverInfo->id,$_SESSION['user_id']);
            if($warnings){
                $driverInfo->warnings = $warnings;
            }else{
                $driverInfo->warnings = null;
            }
        }

        parent::response($driver_qry);
    }

    private function prepareFilter(){
        $DriverFilter = [];


        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                if($key == 'id'){
                    $tempArr = ['key'=>$key,'val' => $value, 'op' => '='];
                    array_push($DriverFilter,$tempArr);
                }
                else if($key == 'name'){
                    $tempArr = ['key'=>$key,'val' => $value, 'op' => 'like'];
                    array_push($DriverFilter,$tempArr);
                }
                else if($value){
                    if(is_numeric($value)){
                        $tempArr = ['key'=>$key,'val' => $value, 'op' => 'like'];
                    }else{
                        $tempArr = ['key'=>$key,'val' => $value, 'op' => '='];
                    }

                    array_push($DriverFilter,$tempArr);
                }
            }
        }

        return $DriverFilter;
    }


    // ------------------------------------------------------------------------ //
    // ---------------------create new driver profile ------------------------- //
    // ------------------------------------------------------------------------ //
    public function createDriver(){

        //clean user input
        // loop on userBean and remove any empty string
        foreach ($this->_request as $key => $value) {
            if($value == ""){
                unset($this->_request->{$key});
            }
        }

        // create driver bean
        $this->_driverCore->createDriver($this->_request,
                                        $this->_request->user_id,
                                         $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "DRIVER.SUCCESS_CREATE";
        parent::response($Result);
    }

    // ---------------------------------------------------------------------------------------- //
    // -------------------- create new Anoymous driver profile -------------------------------- //
    // -------------------- param: phone_number, id_url, personal_url, license_url ------------ //
    // ---------------------------------------------------------------------------------------- //
    public function createAnonymousDriver(){

        // convert mobile to international standards
        $phone_number = convertToInternational($this->_request->phone_number);
        $id_url = $this->_request->id_url;
        $personal_url = $this->_request->personal_url;
        $license_url = $this->_request->license_url;

        // create the anonymouse driver
        $this->_driverCore->createAnonymousDriver( $phone_number,$id_url,$personal_url,$license_url, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "DRIVER.SUCCESS_CREATE";

        parent::response($Result);
    }

    // ------------------------------------------------------------------ //
    // --------------------- update driver info ------------------------- //
    // ------------------------------------------------------------------ //
    public function updateDriverInfo(){

        $driverBean = $this->cleanUserBean($this->_request);

        $this->_driverCore->updateDriverInfo($driverBean,
                                             $this->_request->driver_id,
                                             $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "DRIVER.SUCCESSFUL_UPDATE";
        parent::response($Result);

    }

    // ------------------------------------------------------------------------------ //
    // --------------Clear the request and form it to be a valid user bean ---------- //
    // ------------------------------------------------------------------------------ //
    private function cleanUserBean ($request) {

        $driverBean = $request;

        // prepare the photos info array
        $photos_array = [];
        $photos_info = new stdClass();
        $photos_info->type = 'license_photo';
        $photos_info->url = $request->license_photo;
        $photos_array[0]=$photos_info;

        $driverBean->photos = json_decode(json_encode($photos_array)) ;

        // remove unneccery items from bean
        unset($driverBean->license_photo);
        return $driverBean;
    }



    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate Driver Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeStatus(){

        $this->_driverCore->changeStatus($this->_request->driver_id,
                                         $this->_request->new_status,
                                         $_SESSION['user_id']);

        // write remarks if exist
        if($this->_request->remarks != null){
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('driver', $this->_request->driver_id, $this->_request->remarks , $_SESSION['user_id'] );
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "DRIVER.SUCCESSFUL_OPERATION";
        parent::response($Result);

    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------------- get the warnings of driver bean ----------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getDriverWarnings(){
        $Result = $this->_driverCore->getDriverWarnings($this->_request->driver_id,$_SESSION['user_id']);

        parent::response($Result);

    }
 
}


$driver_interface = new Driver_interface();
