<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../tender_driver/tender_driver_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../gateway/gateWay_core.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");

class DriverCore {
     
    private $_userCore;
    
    public function __construct(){
        DBConnection::getInstance();

        $this->_userCore = new UserCore();
        $this->_gatewayCore = new GatewayCore(); 
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Driver bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getDriver($id,$user_id){
        
        $driverInfo = DBConnection::getObjectBean("driver",$id,$user_id);
        return $driverInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Driver bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getDriverBasic($id,$user_id){

        $driverInfo = DBConnection::getBasicObjectBean("driver",$id,$user_id);
        return $driverInfo;
    }



    // ------------------------------------------------------------------------ //
    // -------------------search for drivers using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchDriver($searchFilter, $limit, $offset,$user_id){
        
        $searchDriverResult = DBConnection::searchDB("driver",$searchFilter,$limit,$offset,$user_id);
        return $searchDriverResult;
    }

    // ------------------------------------------------------------------------ //
    // ---------------------create new driver---------------------------------- //
    // ------------------------------------------------------------------------ //
    public function createDriver($driverBean,$user_id, $created_by){
        
        try{

            DBConnection::startTransaction();

            // get the user bean to make sure the id is valid
            $userBean = $this->_userCore->getUserBasic($user_id,$created_by);

            // to make sure no driver is stored in DB without a user
            if (!$userBean){
                throw new Exception("DRIVER.INVALID_USER");
            }
 
            // validatr user input
            //$this->validateForCreate($driverBean);
             
            // insert the driver bean in the databases
            $driverBean->user_id = $userBean->id;
            $photos_array = []; 
            $photos_info = new stdClass();
            $photos_info->type = 'license_photo';
            $photos_info->url = $driverBean->license_photo;
            $photos_array[0]=$photos_info;
            $driverBean->photos = json_decode(json_encode($photos_array)) ;
            $createDriverResult = DBConnection::insertDB("driver",$driverBean,$created_by); 

            // get the newly created driver
            $newDriverQry = $createDriverResult[0];
            $driver_ID =  $newDriverQry['@id'];

            //assign the new created driver to the user roles
            $userRoleBean = new stdClass();
            $userRoleBean->user_id = $driverBean->user_id;
            $userRoleBean->driver_id = $driver_ID;
            $userRoleBean->role_code = 'DRIVER';
            $newUserRoleQry = DBConnection::insertDB("user_role",$userRoleBean,$created_by);      

            DBConnection::commitTransaction();

            return $createDriverResult;
        }
        catch(Exception $e){
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }


    // ----------------------------------------------------------------------- //
    // ------------ Validate User input for create new driver ---------------- //
    // ----------------------------------------------------------------------- //
    function validateForCreate($driverBean) {
        $validationRules =  $this->_gatewayCore->getResource("VALIDATION","driver");
        
        // basic validation
        foreach($driverBean as $key=>$userInput){
            if($validationRules[$key]){
                $rule = $validationRules[$key];
                $validationResult = validateInput($userInput,$rule,'NEW');

                if($validationResult->error_message){
                    throw new Exception($validationResult->error_message);
                }
            }
        }

        //any extra custom validations goes here
    }



    // ------------------------------------------------------- //
    // -------------------auto complete driver info ---------- //
    // ------------------------------------------------------- //
    public function driverAutoComplete($request,$user_id){


        $driver_id = null;
        if($request->phone_nn){
            $searchFilter = [['key'=>'nn','val' =>$request->phone_nn],['key'=>'status','val' =>['INACTIVE'], 'op'=>'not in']];
            $userInfo = $this->_userCore->searchUser($searchFilter,1,0,0)->data;              
            if($userInfo){
                $driver_id = $userInfo[0]->driver_id;
            }
        }


        //get the id of driver if user typed mobile
        if($driver_id == null){
            $request->phone_nn = convertToInternational($request->phone_nn);
            $searchFilter = [['key'=>'phone','val' =>$request->phone_nn ],['key'=>'status','val' =>['INACTIVE'], 'op'=>'not in']];
            $userInfo = $this->_userCore->searchUser($searchFilter,1,0,0)->data;
            if($userInfo){
                $driver_id = $userInfo[0]->driver_id;
            }else{
                $driver_id = null;
            }
        }

        // get the driver bean
        if($driver_id){

            // if the auto_complete is for tender 11
            if($request->tender_id && $request->tender_id == 11){
                $tenderDriverCore = new TenderDriverCore();

                // validate if the driver is black listed
                $filter = [ ['key'=>'driver_id','val'=> $driver_id],
                            ['key'=>'status','val'=> 'PENDING'],
                            ['key'=>'tender_id','val'=> 11]];
                $tenderDriverSearchResult= $tenderDriverCore->searchTenderDriver($filter,1, 0, 1);

                if($tenderDriverSearchResult->found_rows>0){
                    throw new Exception("لا تستطيع المتابعة، عقد تشغيل السائق على المشروع موقوف");
                }
            }
            // get the driver bean
            $driverBean =  $this->getDriverBasic($driver_id, 0);
            if($driverBean->status == 'ACTIVE'){
                $result = new stdClass();
                $result->driver_id = $driver_id;
                $result->name = $userInfo[0]->name;
                $result->nn = $userInfo[0]->nn;
                $result->phone = $userInfo[0]->phone;
                $result->driver_user_id = $userInfo[0]->id;                
                return $result;
            }else{
                return null;
            }
        }
        else{
            return null; 
        }
    }


    // --------------------------------------------------------------------------------- //
    // ---------------------create new Anoymous driver profile ------------------------- //
    // --------------------------------------------------------------------------------- //
    public function createAnonymousDriver($phone_number,$id_url,$personal_url,$license_url,$created_by){
    
        // search for the user record localy using (phone)
        $searchFilter = [['key'=>'phone','val' =>$phone_number]];
        $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System User 


        // in case the user does not exist create it
        if ($searchUserResult->found_rows == 0) {

            $userBean = new stdClass();

            // prepare the phone info array
            $phone_array = [];
            $phone_info = new stdClass();
            $phone_info->sim = 0;
            $phone_info->phone = convertToInternational($phone_number);
            $phone_info->imei = 0;
            $phone_info->brand = null;
            $phone_info->verification_method = 'NONE';
            $phone_array[0]=$phone_info;
            $userBean->phone_array = json_decode(json_encode($phone_array)) ;

            // prepare the photos info array
            $photos_array = [];
            if($id_url ){
                $photos_info = new stdClass();
                $photos_info->type = 'id_photo';
                $photos_info->url = $id_url;
                array_push($photos_array,$photos_info);
            }
            if($personal_url){
                $photos_info = new stdClass();
                $photos_info->type = 'personal_photo';
                $photos_info->url = $personal_url;
                array_push($photos_array,$photos_info);
            }
            $userBean->photos = $photos_array;

            $user_id =$this->_userCore->registerNewUser($userBean,0);
        }else{
            // update user info
            $userBean = new stdClass();

            $photos_array = [];
            if($id_url){
                $photos_info = new stdClass();
                $photos_info->type = 'id_photo';
                $photos_info->url = $id_url;
                array_push($photos_array,$photos_info);
            }
            if($personal_url){
                $photos_info = new stdClass();
                $photos_info->type = 'personal_photo';
                $photos_info->url = $personal_url;
                array_push($photos_array,$photos_info);
            }
            $userBean->photos = $photos_array;

            $this->_userCore->updateUserInfo($userBean,$searchUserResult->data[0]->id, $created_by);

            $user_id = $searchUserResult->data[0]->id;

        }

        // in case the driver does not exist, create new driver
        if(!$searchUserResult->data[0]->driver_id) {

            $driverBean = new stdClass();

            // insert the driver bean in the databases
            $driverBean->user_id = $user_id;
            $photos_array = [];
            $photos_info = new stdClass();
            $photos_info->type = 'license_photo';
            $photos_info->url = $license_url;
            $photos_array[0]=$photos_info;
            $driverBean->photos = json_decode(json_encode($photos_array)) ;

            $createDriverResult = $this->createDriver($driverBean,$user_id,$created_by);

        }else{
            // update driver info
            $newDriverBean = new stdClass();
          
            $newDriverBean->id = $searchUserResult->data[0]->driver_id;
            $photos_array = [];
            $photos_info = new stdClass();
            $photos_info->type = 'license_photo';
            $photos_info->url = $license_url;
            $photos_array[0]=$photos_info;
            $newDriverBean->photos = json_decode(json_encode($photos_array)) ;
        
            $this->updateDriverInfo($newDriverBean, $searchUserResult->data[0]->driver_id, $created_by);
        }
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------------- get the warnings of driver bean ----------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getDriverWarnings($driver_id, $user_id){

        $driverBean = $this->getDriver($driver_id,$user_id);
        $driverBean = json_decode($driverBean);

        $warnings = [];

        if(!$driverBean->license_number){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "رقم الرخصة غير موجود";
            array_push($warnings,$warning);
        }
        if(!$driverBean->license_expiry_date){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "تاريخ انتهاء الرخصة غير موجود";
            array_push($warnings,$warning);
        }

        $has_license_photo = false;
        if($driverBean->photos){
            foreach ($driverBean->photos as $photo) {
                if($photo->type == 'license_photo' && $photo->url != null ) {
                    $has_license_photo = true;
                }
            }
        }

        if(!$has_license_photo){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "صورة الرخصة غير موجودة";
            array_push($warnings,$warning);
        }

        if(!empty($warnings)){
            return $warnings;
        }else{
            return null;
        }

    }

    ////////////////////////////////////////////////////////////////////////////////
    //..........................driver document...................................//
    //............................................................................//
    public function getDriverDocument($driver_id){
        $documentData = new stdClass();
        $documentData->personal_photo = null;
        $documentData->id_photo = null;
        $documentData->license_photo = null;
        // fill driver documents

        if($driver_id){
        $driverBean = $this->getDriverBasic($driver_id, 0);
        for($j = 0 ; $j < count($driverBean->photos); $j++){
            if($driverBean->photos[$j]->type == 'license_photo'){
                $documentData->license_photo = $driverBean->photos[$j]->url;
            }
        }
        // fill user documents
        $driverUserId = $driverBean->user_id;
        $userBean = $this->_userCore->getUserBasic($driverUserId,0);
        $userBeanPhotos = $userBean->photos;
        if($userBeanPhotos && sizeof($userBeanPhotos) > 0){
         for($i = 0; $i < count($userBeanPhotos); $i++){
            if($userBeanPhotos[$i]->type == 'id_photo'){
                $documentData->id_photo = $userBeanPhotos[$i]->url;
            }else if($userBeanPhotos[$i]->type == 'personal_photo'){
                $documentData->personal_photo = $userBeanPhotos[$i]->url;
            }
        }
      }
   }
        return $documentData;
        }


    // ---------------------------------------------------------------------- //
    // --------------------- Update driver info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function updateDriverInfo($driverBean,$driver_id, $updated_by){
        
        // fill update struct and set the target user id
        $driverBean->id = $driver_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("driver",$driver_id,$updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if(compareObject($driverBean,$DB_Bean) == false) {
            
            // map all the new values into the DB_bean
            $driverBean = mapBeanToDBBean($driverBean,$DB_Bean);

            //re-validate the user input 
            $this->validateForEdit($driverBean);

            // fill update struct and set the target user id
            DBConnection::updateDB("driver",$driverBean,$updated_by);
        }
    }

    // --------------------------------------------------------------------- //
    // ------------ Validate User input for update drivere ----------------- //
    // --------------------------------------------------------------------- //
    function validateForEdit($driverBean) {
        $validationRules =  $this->_gatewayCore->getResource("VALIDATION","driver");
        $status = $driverBean->status;
 
        foreach($driverBean as $key=>$userInput){

            if($validationRules[$key]){
                $rule = $validationRules[$key];
                $validationResult = validateInput($userInput,$rule,$status);
 
                if($validationResult->error_message){
                    throw new Exception($validationResult->error_message);
                }
            }
        }
    }




    // ------------------------------------------------------------------------ //
    // ---------------------activate/ Deactivate a driver---------------------- //
    // ------------------------------------------------------------------------ //
    public function changeStatus($driver_id,$new_status,$user_id){
        
        // get the assigned role to this driver
        $searchFilter = [['key'=>'driver_id','val' => $driver_id ,'op' => '=']];
        $userRoleStruct = DBConnection::searchDB("user_role",$searchFilter,1,0,$user_id);

        // activate the driver and its role
        $userObj = new UserCore();
        $userObj->changeRoleStatus($userRoleStruct->data[0]->id,'DRIVER',$new_status,$user_id);
         
    } 
}
?>