<?php
require_once (dirname(__FILE__)."/../API.php");
require_once dirname(__FILE__) . "/../tender_company/tender_company_core.php";
require_once (dirname(__FILE__). "/../user/user_core.php");
require_once (dirname(__FILE__). "/../waybill/waybill_core.php");
require_once (dirname(__FILE__). "/../queue/queue_core.php");

class Tc_manager_dashboard extends API{

    private $_request = array();
    private $_tenderCompanyCore;
    private $_userCore;
    private $_waybillCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_userCore = new UserCore();
        $this->_waybillCore = new WaybillCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    private function prepareFilter(){
        $tenderFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key'=>$key,'val' => $value ];
                array_push($tenderFilter,$tempArr);
            }
        }
        return $tenderFilter;
    }

    // ################################################## CARGO DASHBOARD ##################################################################################### //

    // ----------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a the raw data of dashboard for cargo grouped by "cargo type"  --------------------------------- //
    // ----------------------------------------------------------------------------------------------------------------------------------- //
    public function get_tc_cargo_dashboard_by_cargo_type(){

        // search tender_company in order to get the tender ids which the company has access to
        $queueSearchFilter = [];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter,100,0,$_SESSION['user_id']) ;
        $tender_ids = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            array_push($tender_ids, $tenderCompany->tender_id);
        }
        $param = [implode($tender_ids,",")];

        // define the intervals in days (ex: now->180 , 180->250)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // -------------------------------------------------- cargo type -------------------------------------------------------- //
        // cargo sql grouped by "cargo type" interval 1
        $sql_1 = "SELECT
                    COUNT(c.id) cnt, ct.name
                FROM
                    cargo_view c,
                    ct,
                    activity a
                WHERE
                    c.tender_id in (?) AND c.ct_id = ct.id
                        AND a.action_code = 'CREATE'
                        AND a.cargo_id = c.id
                        AND a.activity_date < DATE(NOW())
                        AND a.activity_date > DATE(NOW()) - INTERVAL $interval1 DAY
                GROUP BY ct.name";
        $cargo_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "cargo type" interval 2
        $sql_2 = "SELECT
                    COUNT(c.id) cnt, ct.name
                FROM
                    cargo_view c,
                    ct,
                    activity a
                WHERE
                    c.tender_id in (?) AND c.ct_id = ct.id
                        AND a.action_code = 'CREATE'
                        AND a.cargo_id = c.id
                        AND a.activity_date < DATE(NOW()) - INTERVAL $interval1 DAY
                        AND a.activity_date > DATE(NOW()) - INTERVAL $interval2 DAY
                GROUP BY ct.name";

        // call the database
        $cargo_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_cargo_names = [];
        foreach (array_values(array_merge($cargo_result_1,$cargo_result_2)) as $cargoObj) {
            array_push($distinct_cargo_names,$cargoObj->name);
        }
        $distinct_cargo_names = array_unique($distinct_cargo_names);

        // parse the return data
        $result = new stdClass();
        $by_cargo = [];

        // by cargo
        foreach ($distinct_cargo_names as $label) {
            $val1 = $this->findInArray($label,$cargo_result_1);
            $val2 = $this->findInArray($label,$cargo_result_2);
            array_push( $by_cargo , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        $result->data = $by_cargo;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($cargo_result_2);
        $header->new_value = $this->calculateTotalArray($cargo_result_1);
        $result->header = $header;

        parent::response($result);

    }

    // --------------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a the raw data of dashboard for cargo grouped by "clearing agent"  --------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------------------------- //
    public function get_tc_cargo_dashboard_by_ca(){

        // search tender_company in order to get the tender ids which the company has access to
        $queueSearchFilter = [];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter,100,0,$_SESSION['user_id']) ;
        $tender_ids = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            array_push($tender_ids, $tenderCompany->tender_id);
        }
        $param = [implode($tender_ids,",")];

        // define the intervals in days (ex: now->180 , 180->250)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "clearing agent" interval 1
        $sql_1 = "SELECT
            COUNT(c.id) cnt, c.ca_name name
        FROM
            cargo_view c,
            activity a
        WHERE
                c.tender_id in (?)
                AND a.action_code = 'CREATE'
                AND a.cargo_id = c.id
                AND a.activity_date < DATE(NOW())
                AND a.activity_date > DATE(NOW()) - INTERVAL $interval1 DAY
        GROUP BY c.ca_name";
        $ca_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "cargo type" interval 2
        $sql_2 = "SELECT
                COUNT(c.id) cnt, c.ca_name name
            FROM
                cargo_view c,
                activity a
            WHERE
                c.tender_id in (?)
                AND a.action_code = 'CREATE'
                AND a.cargo_id = c.id
                AND a.activity_date < DATE(NOW()) - INTERVAL $interval1 DAY
                AND a.activity_date > DATE(NOW()) - INTERVAL $interval2 DAY
            GROUP BY c.ca_name";

        // call the database
        $ca_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_ca_names = [];
        foreach (array_values(array_merge($ca_result_1,$ca_result_2)) as $caObj) {
            array_push($distinct_ca_names,$caObj->name);
        }
        $distinct_ca_names = array_unique($distinct_ca_names);


        // parse the return data
        $result = new stdClass();
        $by_ca = [];

        // by ca
        foreach ($distinct_ca_names as $label) {
            $val1 = $this->findInArray($label,$ca_result_1);
            $val2 = $this->findInArray($label,$ca_result_2);
            array_push( $by_ca , [$label, $val1, $val2] ) ;   // current point, previous point
        }
        $result->data = $by_ca;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($ca_result_1);
        $header->new_value = $this->calculateTotalArray($ca_result_2);
        $result->header = $header;

        parent::response($result);

    }

    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for cargo grouped by "cargo owner"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_cargo_dashboard_by_owner(){

        // search tender_company in order to get the tender ids which the company has access to
        $queueSearchFilter = [];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter,100,0,$_SESSION['user_id']) ;
        $tender_ids = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            array_push($tender_ids, $tenderCompany->tender_id);
        }
        $param = [implode($tender_ids,",")];

        // define the intervals in days (ex: now->180 , 180->250)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "clearing agent" interval 1
        $sql_1 = "SELECT
            COUNT(c.id) cnt, c.cargo_owner name
        FROM
            cargo_view c,
            activity a
        WHERE
                c.tender_id in (?)
                AND a.action_code = 'CREATE'
                AND a.cargo_id = c.id
                AND a.activity_date < DATE(NOW())
                AND a.activity_date > DATE(NOW()) - INTERVAL $interval1 DAY
        GROUP BY c.cargo_owner";
        $owner_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "cargo owner" interval 2
        $sql_2 = "SELECT
                COUNT(c.id) cnt, c.cargo_owner name
            FROM
                cargo_view c,
                activity a
            WHERE
                c.tender_id in (?)
                AND a.action_code = 'CREATE'
                AND a.cargo_id = c.id
                AND a.activity_date < DATE(NOW()) - INTERVAL $interval1 DAY
                AND a.activity_date > DATE(NOW()) - INTERVAL $interval2 DAY
            GROUP BY c.cargo_owner";

        // call the database
        $owner_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_owner_names = [];
        foreach (array_values(array_merge($owner_result_1,$owner_result_2)) as $ownerObj) {
            array_push($distinct_owner_names,$ownerObj->name);
        }
        $distinct_owner_names = array_unique($distinct_owner_names);

        // parse the return data
        $result = new stdClass();
        $by_owner = [];

        // by ca
        foreach ($distinct_owner_names as $label) {
            $val1 = $this->findInArray($label,$owner_result_1);
            $val2 = $this->findInArray($label,$owner_result_2);
            array_push( $by_owner , [$label, $val1, $val2] ) ;   // current point, previous point
        }
        $result->data = $by_owner;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($owner_result_1);
        $header->new_value = $this->calculateTotalArray($owner_result_2);
        $result->header = $header;

        parent::response($result);

    }


    // ########################################################### number of trucks for each destination ################################################## //

    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "destination"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trucks_dashboard_by_destination(){

        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "destination" interval 1
        $sql_1 = "SELECT
                    COUNT(truck_id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.negotiable_instructios.route.destination.name')) destination
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL $interval1 DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,
                                '$.negotiable_instructios.route.destination.name'))";

        $param = [$_SESSION['trucking_company_id']];
        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "destination" interval 2
        $sql_2 = "SELECT
                    COUNT(truck_id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.negotiable_instructios.route.destination.name')) destination
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL $interval1 DAY
                        AND create_date > DATE(NOW()) - INTERVAL $interval2 DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,
                    '$.negotiable_instructios.route.destination.name'))";

        // call the database
        $param = [$_SESSION['trucking_company_id']];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_destination_names = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $ownerObj) {
            array_push($distinct_destination_names,$ownerObj->destination);
        }
        $distinct_destination_names = array_unique($distinct_destination_names);

        // parse the return data
        $result = new stdClass();
        $by_destination = [];

        // by cargo
        foreach ($distinct_destination_names as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'destination');
            $val2 = $this->findInArray($label,$trips_result_2,'destination');
            array_push( $by_destination , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_destination as &$dest) {
            $dest[1] = (int)$dest[1];
            $dest[2] = (int)$dest[2];
        }

        $result->data = $by_destination;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }

    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "cargo"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trucks_dashboard_by_cargo(){


        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "cargo_name" interval 1
        $sql_1 = "SELECT
                    COUNT(truck_id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name')) cargo_name
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                        GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name'))";

        $param = [$_SESSION['trucking_company_id'],$interval1];
        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "cargo_name" interval 2
        $sql_2 = "SELECT
                    COUNT(truck_id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name')) cargo_name
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name'))";

        // call the database
        $param = [$_SESSION['trucking_company_id'],$interval1,$interval2];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_cargo_names = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $ownerObj) {
            array_push($distinct_cargo_names,$ownerObj->cargo_name);
        }
        $distinct_cargo_names = array_unique($distinct_cargo_names);

        // parse the return data
        $result = new stdClass();
        $by_cargo = [];

        // by cargo
        foreach ($distinct_cargo_names as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'cargo_name');
            $val2 = $this->findInArray($label,$trips_result_2,'cargo_name');
            array_push( $by_cargo , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_cargo as &$cargo) {
            $cargo[1] = (int)$cargo[1];
            $cargo[2] = (int)$cargo[2];
        }

        $result->data = $by_cargo;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "day"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trucks_dashboard_by_day(){


        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "day" interval 1
        $sql_1 = "SELECT
                    COUNT(truck_id) cnt,
                    DATE(create_date ) create_date
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                        GROUP BY DATE(create_date)";

        $param = [$_SESSION['trucking_company_id'],$interval1];
        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);


        // cargo sql grouped by "cargo_name" interval 2
        $sql_2 = "SELECT
                    COUNT(truck_id) cnt,
                    DATE(create_date ) create_date
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY DATE(create_date)";

        // call the database
        $param = [$_SESSION['trucking_company_id'],$interval1,$interval2];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_dates = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $tripObj) {
            array_push($distinct_dates,$tripObj->create_date);
        }
        $distinct_dates = array_unique($distinct_dates);

        // parse the return data
        $result = new stdClass();
        $by_date = [];

        // by create_date
        foreach ($distinct_dates as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'create_date');
            $val2 = $this->findInArray($label,$trips_result_2,'create_date');
            array_push( $by_date , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        $result->data = $by_date;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ################################################## TRIPS DASHBOARD ##################################################################################### //

    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "destination"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trips_dashboard_by_destination(){

        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "destination" interval 1
        $sql_1 = "SELECT
                    COUNT(id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.negotiable_instructios.route.destination.name')) destination
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL $interval1 DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,
                                '$.negotiable_instructios.route.destination.name'))";
        $param = [$_SESSION['trucking_company_id']];

        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "destination" interval 2
        $sql_2 = "SELECT
                    COUNT(id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.negotiable_instructios.route.destination.name')) destination
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL $interval1 DAY
                        AND create_date > DATE(NOW()) - INTERVAL $interval2 DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,
                    '$.negotiable_instructios.route.destination.name'))";

        // call the database
        $param = [$_SESSION['trucking_company_id']];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_destination_names = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $ownerObj) {
            array_push($distinct_destination_names,$ownerObj->destination);
        }
        $distinct_destination_names = array_unique($distinct_destination_names);

        // parse the return data
        $result = new stdClass();
        $by_destination = [];

        // by cargo
        foreach ($distinct_destination_names as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'destination');
            $val2 = $this->findInArray($label,$trips_result_2,'destination');
            array_push( $by_destination , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_destination as &$dest) {
            $dest[1] = (int)$dest[1];
            $dest[2] = (int)$dest[2];
        }         

        $result->data = $by_destination;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }

    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "cargo"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trips_dashboard_by_cargo(){


        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "cargo_name" interval 1
        $sql_1 = "SELECT
                    COUNT(id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name')) cargo_name
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                        GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name'))";

        $param = [$_SESSION['trucking_company_id'],$interval1];
        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);

        // cargo sql grouped by "cargo_name" interval 2
        $sql_2 = "SELECT
                    COUNT(id) cnt,
                    JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name')) cargo_name
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY JSON_UNQUOTE(JSON_EXTRACT(document,'$.cargo[0].cargo.name'))";

        // call the database
        $param = [$_SESSION['trucking_company_id'],$interval1,$interval2];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_cargo_names = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $ownerObj) {
            array_push($distinct_cargo_names,$ownerObj->cargo_name);
        }
        $distinct_cargo_names = array_unique($distinct_cargo_names);

        // parse the return data
        $result = new stdClass();
        $by_cargo = [];

        // by cargo
        foreach ($distinct_cargo_names as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'cargo_name');
            $val2 = $this->findInArray($label,$trips_result_2,'cargo_name');
            array_push( $by_cargo , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_cargo as &$cargo) {
            $cargo[1] = (int)$cargo[1];
            $cargo[2] = (int)$cargo[2];
        }

        $result->data = $by_cargo;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of dashboard for trips grouped by "day"  --------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_trips_dashboard_by_day(){


        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "day" interval 1
        $sql_1 = "SELECT
                    COUNT(id) cnt,
                    DATE(create_date ) create_date
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW())
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                        GROUP BY DATE(create_date)";

        $param = [$_SESSION['trucking_company_id'],$interval1];
        $trips_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param);


        // cargo sql grouped by "cargo_name" interval 2
        $sql_2 = "SELECT
                    COUNT(id) cnt,
                    DATE(create_date ) create_date
                FROM
                    waybill
                WHERE
                    trucking_company_id = ?
                        AND status NOT IN ('REVOKED' , 'INVALID')
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY DATE(create_date)";

        // call the database
        $param = [$_SESSION['trucking_company_id'],$interval1,$interval2];
        $trips_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param);

        // get the distinct values from both intervals
        $distinct_dates = [];
        foreach (array_values(array_merge($trips_result_1,$trips_result_2)) as $tripObj) {
            array_push($distinct_dates,$tripObj->create_date);
        }
        $distinct_dates = array_unique($distinct_dates);

        // parse the return data
        $result = new stdClass();
        $by_date = [];

        // by create_date
        foreach ($distinct_dates as $label) {
            $val1 = $this->findInArray($label,$trips_result_1,'create_date');
            $val2 = $this->findInArray($label,$trips_result_2,'create_date');
            array_push( $by_date , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_date as &$date) {
            $date[1] = (int)$date[1];
            $date[2] = (int)$date[2];
        }

        $result->data = $by_date;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trips_result_2);
        $header->new_value = $this->calculateTotalArray($trips_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ################################################## TRUCKS DASHBOARD ##################################################################################### //

    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of truck registration dashboard for trucking company ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_truck_dashboard_by_tt(){

        // get the truck owner id
        $userBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
        $truck_owner_id = $userBean->truck_owner_id;

        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "minor tt" interval 1
        $sql_1 = "SELECT
                    COUNT(id) cnt,
                    minor_tt
                FROM
                    truck_contract_view
                WHERE
                    truck_owner_id = ?
                    AND create_date > DATE(NOW()) - INTERVAL ? DAY
                    group by minor_tt";

        $param1 = [$truck_owner_id,$interval1];
        $trucks_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param1);

        // cargo sql grouped by "minor tt" interval 2
        $sql_2 = "SELECT
                   COUNT(id) cnt,
                    minor_tt
                FROM
                    truck_contract_view
                WHERE
                    truck_owner_id = ?
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY minor_tt";

        // call the database
        $param2 = [$truck_owner_id,$interval1,$interval2];
        $trucks_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param2);

        // get the distinct values from both intervals
        $distinct_minor_tt_names = [];
        foreach (array_values(array_merge($trucks_result_1,$trucks_result_2)) as $ownerObj) {
            array_push($distinct_minor_tt_names,$ownerObj->minor_tt);
        }
        $distinct_minor_tt_names = array_unique($distinct_minor_tt_names);

        // parse the return data
        $result = new stdClass();
        $by_minor_tt = [];

        // by minor_tt
        foreach ($distinct_minor_tt_names as $label) {
            $val1 = $this->findInArray($label,$trucks_result_1,'minor_tt');
            $val2 = $this->findInArray($label,$trucks_result_2,'minor_tt');
            array_push( $by_minor_tt , [get_tt_caption($label), $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($distinct_minor_tt_names as &$temp) {
            $temp[1] = (int)$temp[1];
            $temp[2] = (int)$temp[2];
        }

        $result->data = $by_minor_tt;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trucks_result_2);
        $header->new_value = $this->calculateTotalArray($trucks_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of truck registration dashboard for trucking company ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_truck_dashboard_by_contract_type(){

        // get the truck owner id
        $userBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
        $truck_owner_id = $userBean->truck_owner_id;

        // define the intervals in days (ex: now->30 , 30->60)
        $interval1 = $this->_request->interval1;
        $interval2 = $this->_request->interval2;

        // cargo sql grouped by "minor tt" interval 1
        $sql_1 = "SELECT
                    COUNT(id) cnt,
                    contract_type
                FROM
                    truck_contract_view
                WHERE
                    truck_owner_id = ?
                    AND create_date > DATE(NOW()) - INTERVAL ? DAY
                    group by contract_type";

        $param1 = [$truck_owner_id,$interval1];
        $trucks_result_1 = DBConnection::runBindDatabaseQuery($sql_1,$param1);

        // cargo sql grouped by "minor tt" interval 2
        $sql_2 = "SELECT
                   COUNT(id) cnt,
                   contract_type
                FROM
                    truck_contract_view
                WHERE
                    truck_owner_id = ?
                        AND create_date < DATE(NOW()) - INTERVAL ? DAY
                        AND create_date > DATE(NOW()) - INTERVAL ? DAY
                GROUP BY contract_type";

        // call the database
        $param2 = [$truck_owner_id,$interval1,$interval2];
        $trucks_result_2 = DBConnection::runBindDatabaseQuery($sql_2,$param2);


        // get the distinct values from both intervals
        $distinct_contract_type_names = [];
        foreach (array_values(array_merge($trucks_result_1,$trucks_result_2)) as $ownerObj) {
            array_push($distinct_contract_type_names,$ownerObj->contract_type);
        }
        $distinct_contract_type_names = array_unique($distinct_contract_type_names);


        // parse the return data
        $result = new stdClass();
        $by_minor_tt = [];

        // by cargo
        foreach ($distinct_contract_type_names as $label) {
            $val1 = $this->findInArray($label,$trucks_result_1,'contract_type');
            $val2 = $this->findInArray($label,$trucks_result_2,'contract_type');

            switch ($label) {
                case 'OWN': $label = "ملك";break;
                case 'AUTH': $label = "وكالة";break;
                case 'JOIN': $label = "ائتلاف";break;
                default: break;
            }
            array_push( $by_minor_tt , [$label, $val1, $val2] ) ;   // current point, previous point
        }

        foreach ($by_minor_tt as &$temp) {
            $temp[1] = (int)$temp[1];
            $temp[2] = (int)$temp[2];
        }

        $result->data = $by_minor_tt;
        $header = new stdClass();
        $header->old_value = $this->calculateTotalArray($trucks_result_2);
        $header->new_value = $this->calculateTotalArray($trucks_result_1);
        $result->header = $header;

        parent::response($result);

    }


    // ################################################## MONTHLEY TRIPS DASHBOARD ############################################################################### //

    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a the raw data of truck trips dashboard for trucking company ------------------------------------------------ //
    // ------------------------------ 0: current month, -1: laste month, -2: the month before it ------------------------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------------------------------------ //
    public function get_tc_monthly_trips(){

        // prepare search filter
        $filter = $this->prepareFilter();
         $first_date = $filter[0]['val'];
         $last_date =  $filter[1]['val'];

        //search for waybills
        $waybillFilter = [['key'=>'create_date','val' => $first_date , 'op' => 'date greater than'],
                          ['key'=>'create_date','val' => $last_date, 'op' => 'date less than']
                         ];

        $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter,10000,0,$_SESSION['user_id']) ;

        $result= new stdClass();
        $result->trucks = new stdClass();
        $result->trucks->month = $first_date;
        $result->trucks->trips = [];

        // add virtual trip from 1 - end of month just to force google chart to show full month view
        $trip = new stdClass();
        $trip->tn = 'رقم الشاحنة';
        $trip->cargo = '';
        $trip->driver_name = '';
        $trip->total_trips = "";
        $trip->start_date = explode("-",date('Y-m-d',strtotime($first_date)));
        $trip->end_date = explode("-",date('Y-m-d',strtotime($last_date)));
        array_push($result->trucks->trips,$trip);

        foreach ( $waybill_result->data as $waybill) {
            $doc = json_decode($waybill->document);

            $trip = new stdClass();
            $trip->tn = $waybill->tn;
            $trip->cargo = $doc->cargo[0]->name;
            $trip->driver_name = $doc->carrier[0]->driver->name;
            $trip->total_trips = "";
            $trip->start_date = explode("-",date('Y-m-d',strtotime($waybill->create_date)));
            $trip->end_date = explode("-",date('Y-m-d',strtotime($waybill->create_date . '+ 1 days')));

            array_push($result->trucks->trips,$trip);
        }

        parent::response($result);

    }


    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ loop on array and search its value foe a certain value ---------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    private function findInArray($value, $arr, $key='name'){
        foreach ($arr as $temp) {
            if($temp->$key == $value){
                return $temp->cnt;
            }
        }
        return 0;
    }
    private function calculateTotalArray($arr){
        $sum = 0;
        foreach ($arr as $temp) {
            $sum += $temp->cnt;
        }
        return $sum;
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------ get a summary of tc fleet and users --------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function tc_summary(){

        $result = new stdClass();
        $truckContractCore = new TruckContractCore();
        $tenderCore = new TenderCore();
        $userCore = new UserCore();
        $queueCore = new QueueCore();

        $user_bean = $userCore->getUserBasic($_SESSION['u_id'],$_SESSION['user_id']);

        // search for truck contract (not trailers) for the company
        $truck_owner_id = $user_bean->truck_owner_id;
        if(!$truck_owner_id){
            $truck_owner_id = $_SESSION['truck_owner_id'];
        }
        $companyFleetFilter = [['key'=>'truck_owner_id','val' => $truck_owner_id],
                               ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                               ['key'=>'cat','val' => ['TRUCK-SINGLE','TRUCK'], 'op'=>'in' ]
                              ];
        $contract_qry = $truckContractCore->searchTruckContracts($companyFleetFilter,10000, 0, $_SESSION['user_id'] );

        $result->trucks = $contract_qry->found_rows;
        $truck_ids = [];
        foreach ($contract_qry->data as $contract) {
            array_push($truck_ids, $contract->truck_id);
        }

        // get number of tender trucks
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderTruckFilter = [['key'=>'truck_id','val' => $truck_ids, 'op'=> 'in'],
                              ['key'=>'status','val' => $activeTenderTruckStatus, 'op' => 'in']];
        $tenderTruck_result = $tenderCore->searchTenderTruck($tenderTruckFilter,10000, 0,$_SESSION['user_id']) ;

        $result->tender_trucks = $tenderTruck_result->found_rows;

        // get number of employees
        $userFilter = [['key'=>'company_id','val' => $_SESSION['company_id']],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op' => 'in']];
        $users_qry = $userCore->searchUser(  $userFilter,1000,0,$_SESSION['user_id']);
        $result->employees = $users_qry->found_rows;

        // get number of queue
        $activeQueueStatus = DBConnection::getActiveStatus('queue');
        $queueFilter = [['key'=>'truck_id','val' => $truck_ids, 'op'=> 'in'],
                       ['key'=>'status','val' => $activeQueueStatus , 'op' => 'in']];
        $queue_qry = $queueCore->searchQueue(  $queueFilter,10000,0,$_SESSION['user_id']);
        $result->queue = $queue_qry->found_rows;


        parent::response($result);
    }




}

$tc_manager_dashboard = new Tc_manager_dashboard();

