<?php

// import required classes
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/registrar_dashboard.php");
require_once (dirname(__FILE__)."/waybill_dashboard.php");
require_once (dirname(__FILE__)."/cargo_dashboard.php");
require_once (dirname(__FILE__)."/queue_dashboard.php");


class Dashboard_interface extends API{
    
    // the request of each call
    private $_request = array();
    private $_waybillDashboard;
    private $_cargoDashboard;
    private $_registrarDashboard;
    private $_queueDashboard;


    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();
        
        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the DriverCore object
        $this->_waybillDashboard = new WaybillDashboard();
        $this->_cargoDashboard = new CargoDashboard();
        $this->_registrarDashboard = new RegistrarDashboard();
        $this->_queueDashboard = new QueueDashboard();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter
    private function prepareFilter(){
        $queueFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key'=>$key,'val' => $value ];
                array_push($queueFilter,$tempArr);
            }
        }
        return $queueFilter;
    }


    // ---------------------------------------------------------------------------------------- //
    // --------------------- get dashboard info for a certain portlet ------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getDashboardInfo(){

        $dashboardInfo = 'NO_AVAILABLE_DATA';

        switch($this->_request->dashboard){
            case "registrar" : {
                $dashboardInfo = $this->_registrarDashboard->getRegistrarStatistics( $_SESSION['user_id'] );
                break;
            }
            case "waybill_by_status" : {
                $dashboardInfo = $this->_waybillDashboard->getWaybillByStatusStatistics( $_SESSION['user_id'] );
                break;
            }
            case "waybill_by_destination" : {
                $dashboardInfo = $this->_waybillDashboard->getWaybillByDestinationStatistics( $_SESSION['user_id'] );
                break;
            }
            case "cargo_rate_timeline" : {
                $dashboardInfo = $this->_cargoDashboard->getCargoRateStatistics($this->_request->start , $this->_request->end ,  $_SESSION['user_id'] );
            }

        }
        parent::response($dashboardInfo);
    }


    // ---------------------------------------------------------------------------------------- //
    // --------------------- get dashboard info for a queue by status ------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getQueueDashboardByStatus(){

        $queueFilter = $this->prepareFilter();
        $dashboardInfo = $this->_queueDashboard->getQueueDashboardByStatus($queueFilter, $_SESSION['user_id'] );

        $data = [];
        foreach ($dashboardInfo->data as $info) {

            $temp = new stdClass();
            $temp->code = $info->status;
            $temp->val = $info->cnt;
            $temp->name = "QUEUE.STATUS." . $info->status;

            array_push($data , $temp);
        }
        $result = [ "caption" => "اعداد الشاحنات على الدور حسب الحالة" ,
                    "val" => $data];

        parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------- //
    // --------------------- get dashboard info for a queue by ByActivationDate ------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getQueueDashboardByActivationDate(){

        $queueFilter = $this->prepareFilter();
        $dashboardInfo = $this->_queueDashboard->getQueueDashboardByActivationDate($queueFilter, $_SESSION['user_id'] );

        $data = [];
        foreach ($dashboardInfo->data as $info) {

            $temp = new stdClass();
            $temp->val = $info->cnt;
            $temp->code = $info->activation_date ? $info->activation_date:null;

            if($info->activation_date){
                $date = new DateTime($info->activation_date);
                $temp->name = $date->format('Y-m-d');
            }else{
                $temp->name = "غير محدد";
            }
            array_push($data , $temp);
        }

        $result = [ "caption" => "اعداد الشاحنات على الدور حسب تاريخ التفعيل",
                    "val" => $data];

        parent::response($result);
    }
}

$dashboard_interface = new Dashboard_interface();