<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");

class CargoDashboard {
 
    public function __construct(){
        DBConnection::getInstance();
    }

    // ---------------------------------------------------------------------------- //
    // ------------------get the rate of creating cargo on the system ------------- //
    // ---------------------------------------------------------------------------- //
    public function getCargoRateStatistics($start, $end , $user_id){
        
        //TODO
        $start =  trim(explode('00:00:00',$start)[0]); 
        $end =  trim(explode('00:00:00',$end)[0]);
 
        // caculate the requested interval
        $datetime1 = DateTime::createFromFormat('D M j Y', $start);
        $datetime2 = DateTime::createFromFormat('D M j Y', $end);
        $interval = date_diff($datetime1, $datetime2);
        

        $cargoInfo = [];
 
        // get the data for 1 year
        if($interval->y == 1){
            for ($x = 1; $x <= 12; $x++) {
                $tempVal = new stdClass();
                $tempVal->date = date("Y/m/d", strtotime( -1 * $x .' months' ) );
                $tempVal->val = rand(0,400);   
                
                array_push($cargoInfo,$tempVal);
            }
        }

        // get the data for 6 month
        else if($interval->m == 6){
            for ($x = 1; $x <= 6; $x++) {
                $tempVal = new stdClass();
                $tempVal->date = date("Y/m/d", strtotime( -1 * $x .' months' ) );
                $tempVal->val = rand(0,400);   
                
                array_push($cargoInfo,$tempVal);
            }
        }

        // get the data for 1 month
        else if($interval->m == 1){
            for ($x = 1; $x <= 30; $x++) {
                $tempVal = new stdClass();
                $tempVal->date = date("Y/m/d", strtotime( -1 * $x .' days' ) );
                $tempVal->val = rand(0,400);   
                
                array_push($cargoInfo,$tempVal);
            }
        }

        // get the data for 1 week
        else if($interval->d >= 6 && $interval->d <= 8 ){
            for ($x = 1; $x <= 7; $x++) {
                $tempVal = new stdClass();
                $tempVal->date = date("Y/m/d", strtotime( -1 * $x .' days' ) );
                $tempVal->val = rand(0,400);   
                
                array_push($cargoInfo,$tempVal);
            }
        }

        //get data for 1 day
        if($interval->d == 0 && $interval->m ==0 && $interval->y == 0){

            $startTime = "00:00";
            $endTime = "23:59";
            
            $tStart = strtotime($startTime);
            $tEnd = strtotime($endTime);
            $tNow = $tStart;
            
            while($tNow <= $tEnd){
                $tempVal = new stdClass();
                $tempVal->date = date("Y/m/d") . " " . date("H:i",$tNow);
                $tempVal->val = rand(0,400);   
                
                array_push($cargoInfo,$tempVal);
 
              $tNow = strtotime('+60 minutes',$tNow);
            }
        }
                          
        return $cargoInfo;
    }
 
}
?>