<?php

require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../includes/debug.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");
require_once(dirname(__FILE__) . "/../social/social_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo_type/cargo_type_core.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/object_watcher/object_watcher_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php");
require_once dirname(__FILE__) . "/../../core/outgoing_integration/container.php";


class CustomerCare_Interface extends API
{
    // the request of each call
    private $_request = array();
    private $_customerCare;
    private $_userCore;
    private $_truckCore;
    private $_socialCore;
    private $_tenderCore;
    private $_truckContractCore;
    private $_cargoTypeCore;
    private $_cargoCore;
    private $_waybillCore;
    private $_notificationCore;
    private $_queueCore;
    private $_objectWatcherCore;
    private $_waybillOrderCore;
    private $_driverCore;
    private $_pollIntegration;
    private $_routeWageCore;
    private $_clearingAgent;
    private $_con;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // init objects
        $this->_customerCare = new CustomerCare();
        $this->_userCore = new UserCore();
        $this->_socialCore = new SocialCore();
        $this->_tenderCore = new TenderCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_cargoTypeCore = new CargoTypeCore();
        $this->_waybillCore = new WaybillCore();
        $this->_cargoCore = new CargoCore();
        $this->_notificationCore = new NotificationCore();
        $this->_queueCore = new QueueCore();
        $this->_objectWatcherCore = new ObjectWatcherCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_truckCore = new TruckCore();
        $this->_driverCore = new DriverCore();
        $this->_pollIntegration = new Poll();
        $this->_routeWageCore = new RouteWageCore();
        $this->_clearingAgent = new ClearingAgentCore();
        $this->_con = new Container();

        // validate the session
        session_start();

        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION");
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    public function getTicket()
    {
        $id = $this->_request->id;
        try {
            // call to customer care system to get ticket
            $ticket = $this->_customerCare->getTicket($id);
            // get ticket data
            $ticketData = is_string($ticket['request']['data'])
                ? json_decode($ticket['request']['data'])
                : $ticket['request']['data'];
            $ticketBody = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;
            $type_code = $ticketBody->type_code;

            // parse data to more human readable form
            switch (strtoupper($type_code)) {
                case 'CREATE_GRAINS_WAYBILL':
                case 'CREATE_VESSELS_WAYBILL':
                case 'CREATE_EXTERNAL_WAYBILL':
                case 'REVOKE_AND_PRINT_WAYBILL':
                case 'INSIDE_ZONE_WAYBILL':
                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;

                    $cargoBean = $this->_cargoCore->getCargoBasic($ticket_details->cargo_id, 0);
                    $cargoName = $cargoBean->name;
                    $ticket_details->cargo_id = $cargoName;

                    if ($ticket_details->operation_type == "import") {
                        $operation_type_caption = "استيراد";
                    } else if ($ticket_details->operation_type == "export") {
                        $operation_type_caption = "تصدير";
                    } else if ($ticket_details->operation_type == "import_export") {
                        $operation_type_caption = "استيراد/تصدير";
                    }

                    // format data
                    $body = "رقم الشاحنة: "  . $ticket_details->tn . "\n";
                    $body .= "رقم المقطورة: "  . $ticket_details->trn . "\n";
                    $body .= "الرقم الوطني: "  . $ticket_details->nn . "\n";
                    $body .= "مركز الدخول: "  . $ticket_details->entry_point_name . "\n";
                    $body .= "مركز الخروج: "  . $ticket_details->exit_point_name . "\n";
                    $body .= "العملية: "  . $operation_type_caption . "\n";
                    $body .= "الحمولة: "  . $cargoName . "\n";
                    $body .= "ملاحظات: "  . $ticket_details->remarks . "\n";
                    $ticketData->body = $body;

                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;
                case "ACTIVE_QUEUE_TRUCK":
                case "DELAY_QUEUE_TRUCK":
                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;
                    $trucks = [];
                    foreach ($ticket_details->trucks as $truck) {
                        array_push($trucks, $truck->tn);
                    }
                    $body = "المشروع: "  . $ticket_details->tender_name . "\n";
                    $body .= "الدور: "  . $ticket_details->q_name . "\n";
                    $body .= "الشاحنة: "  . join(', ', $trucks);
                    $ticketData->body = $body;
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;

                case 'FUEL_TENDER_ORDER':
                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;
                    $destinationName = getLocationName($ticket_details->destination_id);
                    $body = "الوجهة: "  . $destinationName . "\n";
                    $body .= "عدد الشاحنات: "  . $ticket_details->num_of_trucks . "\n";
                    $body .= "تاريخ الطلبية: "  . $ticket_details->order_date . "\n";
                    $body .= "ملاحظات: "  . $ticket_details->notes . "\n";
                    $ticketData->body = $body;
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);

                    // $ticket['request']['data'] = $ticketData;
                    break;
                case 'SUBMIT_PERMIT_FOR_WAYBILL':
                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;

                    // get needed data
                    if (!$ticket_details->first_trip_entry_location) {
                        $ticket_details->first_trip_entry_location = getLocationName($ticket_details->entry_point_id);
                    }
                    if (!$ticket_details->first_trip_destination) {
                        $ticket_details->first_trip_destination = getLocationName($ticket_details->discharge_location_id);
                    }
                    if (!$ticket_details->first_trip_type) {
                        $ticket_details->first_trip_type = Captions::getCaption("EXTERNAL_WAYBILL.SERVICE." . $ticket_details->waybill_service_id);
                    }
                    $ticket_details->payment_method = $ticket_details->payment_method == "cash" ? "نقدا" : "ذمم";

                    if (!$ticket_details->first_trip_type) {
                        $ticket_details->first_trip_type = $ticket_details->waybill_service_id;
                    }


                    // format data
                    $body = "رقم الشاحنة: "  . $ticket_details->tn . "\n";
                    $body .= "رقم المقطورة: "  . $ticket_details->trn . "\n";
                    $body .= "الرقم الوطني: "  . $ticket_details->nn . "\n";
                    $body .= "مركز الدخول: "  . $ticket_details->first_trip_entry_location . "\n";
                    $body .= "موقع التفريغ: "  . $ticket_details->first_trip_destination . "\n";
                    $body .= "العملية: "  . $ticket_details->first_trip_type . "\n";
                    $body .= "الدفع: "  . $ticket_details->payment_method . "\n";
                    $ticketData->body = $body;
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;

                case 'WAYBILL_LOADING_DELAY':

                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;
                    $waybill_id = $ticket_details->waybill_id;
                    $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);

                    $create_date = date_format(date_create($waybillBean->create_date), "Y-m-d");
                    $create_time = date_format(date_create($waybillBean->create_date), "H:i");

                    // format data
                    $tn = $waybillBean->document->carrier[0]->truck->tn;

                    $body = "رقم المستند: "  . $waybillBean->wn . "\n";
                    $body .= "رقم الشاحنة: "  . $waybillBean->document->carrier[0]->truck->tn . "\n";
                    $body .= "رقم المقطورة: "  . $waybillBean->document->carrier[0]->trailer->tn . "\n";
                    $body .= "تاريخ الإنشاء: "  . $create_date . " " . $create_time . "\n";
                    $body .= "تاريخ التفعيل: "  . "-" . "\n";


                    $ticketData->body = $body;
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;

                case 'PERSONAL_DOCS':
                case 'OTHER':

                default:
                    # code...
                    $ticket_details = is_string($ticketData->body) ? json_decode($ticketData->body) : $ticketData->body;
                    $body = "ملاحظات: "  . $ticket_details->remarks . "\n";
                    $ticketData->body = $body;
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;
            }


            // append WF
            $ticket['wf'] = [];
            if ($ticket['status'] == "NEW") {
                $ticket['wf'] = [
                    ["action_code" => "reply"],
                    ["action_code" => "CHANGE_STATUS", "new_status" => "CANCELED", "caption" => "الغاء المعاملة"]
                ];
            }
            if ($ticket['status'] == "IN_PROGRESS" || $ticket['status'] == "WAITING" || $ticket['status'] == "SNOOZED" || $ticket['status'] == "WAITING_REPLY") {
                $ticket['wf'] = [["action_code" => "reply"]];
            }


            parent::response($ticket);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------- //
    // ----------------to get ticket bean----------------------// 
    // ------------------------------------------------------------- //
    public function getTicketWeb()
    {

        $id = $this->_request->id;
        try {
            // call to customer care system to get ticket
            $ticket = $this->_customerCare->getTicket($id);

            // get ticket data
            if (gettype($ticket['request']['data']) == "string") {
                $ticketData = json_decode($ticket['request']['data']);
            } else {
                $ticketData = $ticket['request']['data'];
            }

            // convert ticket data from array to stdClass
            if (gettype($ticketData) == 'array') {
                $ticketData = json_decode(json_encode($ticketData, JSON_UNESCAPED_UNICODE));
            }
            if (!$ticketData->type_code) {
                if (gettype($ticket->body) == "string") {
                    $ticketData->type_code = json_decode($ticket->body)->type_code;
                } else {
                    $ticketData->type_code = $ticket->body->type_code;
                }
            }


            // parse data to more human readable form
            switch (strtoupper($ticketData->type_code)) {
                case 'CREATE_GRAINS_WAYBILL':
                case 'CREATE_VESSELS_WAYBILL':
                case 'CREATE_EXTERNAL_WAYBILL':
                case 'REVOKE_AND_PRINT_WAYBILL':
                case 'INSIDE_ZONE_WAYBILL':
                    $ticket_details = json_decode($ticketData->body);

                    // convert to caption
                    $cargoBean = $this->_cargoCore->getCargoBasic($ticket_details->cargo_id, 0);
                    $cargoName = $cargoBean->name;
                    $ticket_details->cargo_id = $cargoName;

                    if ($ticket_details->operation_type == "import") {
                        $operation_type_caption = "استيراد";
                    } else if ($ticket_details->operation_type == "export") {
                        $operation_type_caption = "تصدير";
                    } else if ($ticket_details->operation_type == "import_export") {
                        $operation_type_caption = "استيراد/تصدير";
                    }
                    $ticket_details->operation_type = $operation_type_caption;

                    $ticketData->body = $ticket_details;
                    $ticket['request']['data'] = $ticketData;

                    break;

                case 'DELAY_QUEUE_TRUCK':
                case 'ACTIVE_QUEUE_TRUCK':
                    $ticket_details = json_decode($ticketData->body);
                    $ticketData->body = $ticket_details;
                    $ticket['request']['data'] = $ticketData;
                    break;

                case 'OTHER':
                    $ticket_details = json_decode($ticketData->body);
                    $body = "ملاحظات: "  . $ticket_details->remarks . "\n";
                    $ticketData->body = $body;
                    $ticket['request']['data'] = $ticketData;
                    break;

                case 'FUEL_TENDER_ORDER':
                    $ticket_details = json_decode($ticketData->body);
                    $body = "ملاحظات: "  . $ticket_details->remarks . "\n";
                    $ticketData->body = $body;
                    $ticket['request']['data'] = $ticketData;
                    break;

                case 'SUBMIT_PERMIT_FOR_WAYBILL':
                    $ticket_details = json_decode($ticketData->body);

                    $waybill_id = $ticket_details->waybill_id;
                    $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
                    $destination_name = $waybillBean->document->negotiable_instructios->route->destination->name;
                    $ticket_details->destination_name = $destination_name;
                    $ticketData->body = $ticket_details;
                    $ticket['request']['data'] = $ticketData;
                    break;

                case 'ADD_ROUTE_WAGE':
                    $ticket_details = json_decode($ticketData->body);
                    $ticketData->body = $ticket_details;
                    $ticket['request']['data'] = $ticketData;
                    break;

                case 'CALL':
                    if (!$ticketData->call_details->origin_route_id) {
                        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($ticketData->call_details->id, 0);
                        $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($waybillOrderBean->tender_order_id, 0);
                        $tenderMan = $this->_tenderCore->getTenderManifest($tenderOrderBean->tender_id, 0);
                        // get tender order to get destination
                        $questionnaire = $tenderMan['questionnaire'];
                        if ($questionnaire) {
                            foreach ($questionnaire as $q) {
                                if ($q['question_type'] == "ROUTE:ORIGIN") {
                                    $origin_question_id = $q['id'];
                                }
                            }
                        }

                        foreach ($tenderOrderBean->questionnaire as $order_q) {
                            if ($order_q->id ==  $origin_question_id) {
                                $origin_route_id = $order_q->val;
                            }
                        }

                        $ticket_details = $ticketData->call_details;
                        $ticket_details->origin_route_id = $origin_route_id;
                        $ticketData->call_details = $ticket_details;
                        $ticket['request']['data'] = json_encode($ticketData);
                    }
                    break;

                case 'BULK_WAYBILL_LOADING_DELAY':
                    foreach ($ticketData->body as &$wbl) {
                        // see if any waybill has completed the loading
                        $waybillBean = $this->_waybillCore->getWaybillBasic($wbl->id, 0);
                        if ($waybillBean->document->cargo[0]->weights->loading->net_weight) {
                            $wbl->loading_weight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
                        }
                    }
                    $ticket['request']['data'] = json_encode($ticketData, JSON_UNESCAPED_UNICODE);
                    break;

                default:
                    # code...
                    break;
            }

            // gettype() == "string|object"
            if (is_string($ticket['request']['data'])) {
                $ticket['request']['data'] = json_decode($ticket['request']['data'], true);
            }

            if (isset($ticket['request']['data']['body']) && is_string($ticket['request']['data']['body'])) {
                $ticket['request']['data']['body'] = json_decode($ticket['request']['data']['body']);
            }

            // append WF
            $ticket['wf'] = [];
            if ($ticket['status'] == "NEW") {
                $ticket['wf'] = [
                    ["action_code" => "reply"],
                    ["action_code" => "CHANGE_STATUS", "new_status" => "CANCELED", "caption" => "الغاء المعاملة"]
                ];
            }
            if ($ticket['status'] == "IN_PROGRESS" || $ticket['status'] == "WAITING" || $ticket['status'] == "SNOOZED" || $ticket['status'] == "WAITING_REPLY") {
                $ticket['wf'] = [["action_code" => "REPLY"]];
            }


            parent::response($ticket);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------- //
    // ----------------to git list of tickets ---------------------- //
    // ------------------------------------------------------------- // 
    public function searchTickets()
    {
        try {

            $page = $this->_request->page;
            $limit = $this->_request->limit;
            $tn  = $this->_request->tn;
            $sort = $this->_request->sort;
            // call to customer care system to create ticket
            $filter = array();

            // get the company id or user_id
            if (strtoupper($_SESSION['type']) == "CORPORATE") {
                $filter['remote_company_id'] = $_SESSION['company_id'];
                $filter['remote_user_id'] = null;
            } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
                $filter['remote_company_id'] = null;
                $filter['remote_user_id'] = $_SESSION['u_id'];
            }

            // temp solution: (if the user is ca_operation for Jo_petrol, search for Fuel_tender_ticket )
            if ($_SESSION['COMPANY_EMPLOYEE_ROLES'] == 'CA_OPERATION' && $_SESSION['company_id'] == 1912) {
                $filter = array();
                $filter['type'] = 'CLIENT';
                $filter['type_code'] = 'FUEL_TENDER_ORDER';
            }


            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER') {
                    $filter = array();
                }
            }

            if (!$filter['status']) {
                $filter['status'] = ['NEW', 'ASSIGNED', 'IN_PROGRESS', 'COMPLETED', 'WAITING_REPLY'];
            }


            // append user custome filter
            if (gettype($this->_request->filter) == "string") {
                $userFilter = json_decode($this->_request->filter);
            }
            if ($userFilter) {
                foreach ($userFilter as $filter_key => $filter_object) {
                    $filter[$filter_key] = $filter_object;
                }
            }

            if (!$sort) {
                if ($_SESSION['employee_id']) {
                    $sort = "asc";
                } else {
                    $sort = "desc";
                }
            }

            // to search in truck number////////////////////////temporarily
            if ($tn && $filter['type'] != 'CALL') {
                $activeWaybillStatus = DBConnection::getActiveStatus('waybill');

                $waybills = $this->_waybillCore->searchWaybills([
                    ['key' => 'tn', 'val' => $tn],
                    ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
                ], 1000, 0, $_SESSION['user_id']);
                if ($waybills->found_rows == 0) {
                    parent::response([]);
                    die;
                }
                $waybill_ids = [];
                foreach ($waybills->data as $waybill) {
                    $waybill_ids[] = $waybill->id;
                }
                $filter['data->body->waybill_id'] = $waybill_ids;
            } else if ($tn) {
                $filter['data->tn'] = $tn;
            }

            if ($filter['tender_id']) {
                $filter['data->body->tender_id'] = $filter['tender_id'];
                unset($filter['tender_id']);
            }

            $tickets = $this->_customerCare->searchTickets($filter, $page, $limit, $sort);
            $result = [];
            // formating data
            foreach ($tickets['data'] as $ticket) {
                $temp = new stdClass();
                $temp->id = $ticket['id'];
                $temp->status = $ticket['status'];
                $temp->created_at = $ticket['created_at'];
                if (gettype($ticket['request']['data']) == "string") {
                    $temp->data = json_decode($ticket['request']['data']);
                }
                $result[] = $temp;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------- //
    // ---------------- get Tickets Summary -------------------------//
    // ------------------------------------------------------------- //
    public function getTicketsSummary()
    {
        $summary = $this->_customerCare->getTicketsSummary(json_decode($this->_request->filter));
        parent::response($summary);
    }


    // ------------------------------------------------------------- //
    // ----------------to create a ticket----------------------------// 
    // ------------------------------------------------------------- //
    public function createTicket()
    {
        try {

            // get user params
            $body = new stdClass();
            $attachments = $this->_request->attachments;
            $type_code = $this->_request->type_code;
            $body->type_code = $type_code;
            $body->truck_id = $this->_request->truck_id;
            $body->tn = $this->_request->tn;
            $body->trn = $this->_request->trn;
            $body->nn = $this->_request->nn;
            $body->entry_point_id = $this->_request->entry_point_id;
            $body->entry_point_name = $this->_request->entry_point_name;
            $body->exit_point_id = $this->_request->exit_point_id;
            $body->exit_point_name = $this->_request->exit_point_name;
            $body->operation_type = $this->_request->operation_type;
            $body->discharge_location_id = $this->_request->discharge_location_id;
            $body->discharge_location_name = $this->_request->discharge_location_name;
            $body->cargo_id = $this->_request->cargo_id;
            $body->remarks =  $this->_request->remarks ? $this->_request->remarks : $this->_request->body;
            $body->tender_id = $this->_request->tender_id;
            if ($this->_request->tender_name) {
                $body->tender_name = $this->_request->tender_name;
            } else {
                $tender_id = $this->_request->tender_id;
                $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
                $tender_name = $tenderBean->manifest->name;
                $body->tender_name = $tender_name;
            }

            $body->q_id = $this->_request->q_id;
            $body->q_name = $this->_request->q_name;
            $body->trucks = $this->_request->trucks;
            $body->order_date = $this->_request->order_date;
            $body->num_of_trucks = $this->_request->num_of_trucks;
            $body->destination_id = $this->_request->destination_id;
            $body->notes = $this->_request->notes;
            switch ($type_code) {
                case 'create_grains_waybill':
                    $title = "تقديم مستند تموين";
                    break;
                case 'create_vessels_waybill':
                    $title = "تقديم مستند بواخر";
                    break;
                case 'create_external_waybill':
                    $title = "تقديم تصريح خارجي";
                    break;
                case 'revoke_and_print_waybill':
                    $title = "الغاء وطباعة";
                    break;
                case 'inside_zone_waybill':
                    $title = "طلب تسهيلات";
                    break;
                case 'delay_queue_truck':
                    $title = "منع شاحنات";
                    break;
                case 'active_queue_truck':
                    $title = "فك منع شاحنات";
                    break;
                case 'fuel_tender_order':
                    $title = "طلبية فيول";
                    break;
                case 'other':
                    $title = $this->_request->title;
                    break;
                case 'revoke_queue':
                    $title = 'حذف دور';
                    break;
                case 'change_queue_driver':
                    $title = 'تغير معلومات سائق على الدور';
                    break;
                case 'container_waybill_order':
                   $this->createTenderOrderTicket();
                   return;
                    break;
                default:
                    $title = "";
                    break;
            }

            // get the bean of the user who want to create ticket
            $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);

            // fill ticket data
            $data = new stdClass();
            $data->title =  $title;
            $data->body = json_encode($body, JSON_UNESCAPED_UNICODE);
            $data->priority = 3;
            $data->type_code = strtoupper($type_code);

            // get the company id
            if (strtoupper($_SESSION['type']) == "CORPORATE") {
                $data->company_id = $_SESSION['company_id'];
                $data->user_id = $_SESSION['u_id'];
                $sender_name = $_SESSION['company_name'];
            } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
                $data->company_id = 266770;
                $data->user_id = $_SESSION['u_id'];
                $sender_name = $userBean->name;
            }

            $data->senderName = $sender_name;
            //Ticket delay in seconds
            $delay = 0;
            // Ticket filters
            $filters = new stdClass();
            $filters->ticket_type = 'client';
            $filters->type_code = strtoupper($type_code);

            // Add (CA_OPERATION role_code) and (12 tender_id) filters
            // to the ticket if it  should be handled by a third party system
            if (strtoupper($type_code) === strtoupper("fuel_tender_order")) {
                $filters->tender_id = 12; // Fuel tender id
                $filters->role_code = "CA_OPERATION"; // in this case (JO petrol operation)

                // If the tender order due date is more than 24 hours
                // make the ticket be snoozed until 24 hrs before the order date
                $orderDate = strtotime($body->order_date);
                $currentTime = strtotime(DBConnection::getSystemDate());
                // diff in days (seconds-seconds)/seconds/day
                $diff = ($orderDate - $currentTime) / (24 * 60 * 60);
                if ($diff > 2) {
                    $delay = ($diff - 1) * (24 * 60 * 60);
                } elseif ($diff < 0) {
                    throw new Exception("موعد الطلبية بالماضي");
                }
            }

            // add queue_driver json to ticket
            if (strtoupper($type_code) === strtoupper("change_queue_driver")) {
                $dec_body = json_decode($data->body, true);
                $dec_body['queue_driver_list'] = $this->_request->queue_driver_list;
                $dec_body['queue_name'] = $this->_request->queue_name;

                foreach ($dec_body as $key => $value) {
                    if (!$dec_body[$key]) {
                        unset($dec_body[$key]);
                    }
                }
                $data->body = json_encode($dec_body, JSON_UNESCAPED_UNICODE);
            }

            // call to customer care system to create ticket
            $ticket = $this->_customerCare->createTicket($data, $filters, $delay);

            // if there is images create note to this ticket
            if ($attachments) {
                $id = $ticket['id'];
                $note = new stdClass();
                $note->body = "";
                $note->attachments = $attachments;
                $note->senderName = $sender_name;
                // call to customer care system to create ticket
                $note = $this->_customerCare->replyToTicket($id, $note);
                parent::response($ticket);
                return;
            }

            // send wall message and notification to ticket creaer
            $taskQueuesCore = new TaskQueuesCore();

            // prepare message data
            $sender_id = 266770;
            $sender_name =  "شركة مدارج للخدمات اللوجستية ";
            $writeOnWall = true;
            $title = "معاملة جديدة";
            $msg = ' تم تقديم معاملة رقم ' . $ticket['id'] . ' بنجاح ، المعاملة قيد المتابعة من قبل فريق عمل مدارج';
            $body = $this->_socialCore->createPostBody($title, $msg, null, $sender_id, $sender_name);
            $taskQueuesCore->createPostOnWallTask($_SESSION['u_id'], $body, $title, $writeOnWall);

            parent::response($ticket);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------- //
    // ----------------to get ticket activities----------------------// 
    // ------------------------------------------------------------- //
    public function getActivities()
    {

        $id = $this->_request->id;
        try {

            // call to customer care system to get ticket
            $ticket = $this->_customerCare->getTicket($id);

            //parsing the notes of ticket
            foreach ($ticket['activates'] as &$activity) {
                $activity['notes'] = json_decode(json_decode($activity['notes']));
            }

            parent::response($ticket['activates']);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------ //
    // ---------------- start Ticket ------------------------ //
    // ---------------- param: data, ticket_type, user_id, ticket_id ------------------------- //
    // ------------------------------------------------------------------------------ //
    public function startTicket()
    {

        $ticket_id = $this->_request->ticket_id;
        $ticket_type = $this->_request->ticket_type;
        $user_id = $this->_request->user_id;

        // get ticket bean
        $ticketBean = $this->_customerCare->getTicket($ticket_id);

        $ticketData = json_decode($ticketBean['request']['data']);
        $waybill_order_id = $ticketData->call_details->id;

        // change status of waybill_order to PENDING
        if ($waybill_order_id) {
            $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
            if ($waybillOrderBean && $waybillOrderBean->status != "PENDING") {
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'PENDING', 0);
            }
        }


        //return success
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------------------ //
    // ---------------- assignticket to a certain employee  ------------------------- //
    // ---------------- param: data, ticket_type, user_id, ticket_id ------------------------- //
    // ------------------------------------------------------------------------------ //
    public function assignTicket()
    {

        try {

            //parse the incoming param
            $ticketData = $this->_request->data;
            $ticket_type = $this->_request->ticket_type;
            $ticket_id = $this->_request->ticket_id;

            if (gettype($ticketData) == "string") {
                $ticketData = json_decode($ticketData);
            }
            $ticketData->ticket_id = $ticket_id;

            switch (strtoupper($ticket_type)) {
                case 'CLIENT':
                    // get the user UUID
                    $user_id = $this->_request->user_id;
                    $userCore = new UserCore();
                    $userHB = $userCore->getUserHeartBeatObject($user_id);
                    $UUID = $userHB->UUID;

                    //send websocket
                    $socialCore = new SocialCore();
                    $socialCore->sendWebSocket($UUID, "SYSTEM_TICKET", $ticketData);

                    break;

                case 'OBJECT':
                    // get the user UUID
                    $user_id = $this->_request->user_id;
                    $userCore = new UserCore();
                    $userHB = $userCore->getUserHeartBeatObject($user_id);
                    $UUID = $userHB->UUID;

                    //send websocket
                    $socialCore = new SocialCore();
                    $socialCore->sendWebSocket($UUID, "SYSTEM_TICKET", $ticketData);

                    break;

                case 'CALL':
                    // get the user UUID
                    $user_id = $this->_request->user_id;
                    $userCore = new UserCore();
                    $userHB = $userCore->getUserHeartBeatObject($user_id);
                    $UUID = $userHB->UUID;

                    //send websocket
                    $socialCore = new SocialCore();
                    $socialCore->sendWebSocket($UUID, "ASSIGN_CALL", $ticketData);

                    break;
                default:
                    throw new Exception("Invalid Ticket Type - type:" . $ticket_type);
                    break;
            }

            // return success
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION_" . $UUID;
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------- //
    // ----------------to change status of ticket ------------------ // 
    // ------------------------------------------------------------- //
    public function changeStatus()
    {

        // get user params
        $status = strtoupper($this->_request->status);
        $id = $this->_request->id;
        $result = $this->_request->result;

        try {
            // get the current ticket
            $ticketBean = $this->_customerCare->getTicket($id);
            if (gettype($ticketBean['request']['data']) == "string") {
                $ticketData = json_decode($ticketBean['request']['data']);
            } else {
                $ticketData = $ticketBean['request']['data'];
            }

            // get ticket body details  if exists                    
            if ($ticketData->body && is_string($ticketData->body)) {
                $ticket_details = json_decode($ticketData->body);
            } else if (gettype($ticketData) == "object" && $ticketData->body) {
                $ticket_details = $ticketData->body;
            } else if (gettype($ticketData) == "array" && $ticketData['body']) {
                $ticket_details = $ticketData['body'];
            } else {
                $ticket_details = $ticketData;
            }


            // create external waybill in case the type is external
            if ($status == "COMPLETED" && $ticketBean['type_code'] == "CREATE_EXTERNAL_WAYBILL") {

                // prepare externalWaybillBean
                $externalWaybillBean = new stdClass();
                $externalWaybillBean->tn = $ticket_details->tn;
                $externalWaybillBean->trn = $ticket_details->trn;
                $externalWaybillBean->nn = $ticket_details->nn;
                $externalWaybillBean->tender_id = 8;
                $externalWaybillBean->service_id = $this->_request->service_id;
                $externalWaybillBean->trucking_company_id = 327;  // ADEL
                $externalWaybillBean->ca_id = 1;  // dummy CA
                $externalWaybillBean->cargo_id = $ticket_details->cargo_id;
                $externalWaybillBean->origin_id = $ticket_details->entry_point_id;       // JORDAN
                $externalWaybillBean->destination_id = $ticket_details->exit_point_id;  // JORDAN
                $externalWaybillBean->payment_method = $this->_request->payment_method;

                $response = $this->_waybillCore->createExternalWaybill($externalWaybillBean, $_SESSION['user_id']);

                // change the status to ACTIVE
                $this->_waybillCore->changeStatus($response->id, 'ACTIVE', 0);

                // add new task to close the waybill after 12 hours
                $taskQueuesCore = new TaskQueuesCore();
                $taskQueuesCore->createCloseWaybillTask($response->id, 12, "اغلاق لتصريح الخارجي بسبب مرور 12 ساعة من وقت الإنشاء");
            }

            // change queue status to PENDING in case the type is DELAY_QUEUE_TRUCK
            else if ($status == "COMPLETED" && $ticketBean['type_code'] == "DELAY_QUEUE_TRUCK") {
                $trucks = $ticket_details->trucks;
                foreach ($trucks as $truck) {
                    $queue_id = $truck->id;
                    $this->_queueCore->changeStatus($queue_id, 'PENDING', $_SESSION['user_id']);

                    // add log
                    $this->_queueCore->logActivity(
                        $queue_id,
                        "اضافة منع",
                        "بناءا على طلب المندوب في المعاملة رقم " . $id,
                        "ADD_NOTES",
                        $_SESSION['user_id']
                    );

                    // update queue info
                    $duration = 1;
                    $updateBean = new stdClass();
                    $updateBean->id = $queue_id;
                    $updateBean->activation_date = date("Y-m-d", strtotime("+ " . $duration . " day"));
                    $updateBean->total_delay += $duration;
                    $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);
                }
            }

            // change queue status to ACTIVE in case the type is ACTIVE_QUEUE_TRUCK
            else if ($status == "COMPLETED" && $ticketBean['type_code'] == "ACTIVE_QUEUE_TRUCK") {
                $trucks = $ticket_details->trucks;
                foreach ($trucks as $truck) {
                    $queue_id = $truck->id;
                    $this->_queueCore->changeStatus($queue_id, 'ACTIVE', $_SESSION['user_id']);

                    // add log
                    $this->_queueCore->logActivity(
                        $queue_id,
                        "فك منع",
                        "بناءا على طلب المندوب في المعاملة رقم " . $id,
                        "ADD_NOTES",
                        $_SESSION['user_id']
                    );
                }
            }

            // Validate that the loading_date is not empty before closing the ticket
            elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "BULK_WAYBILL_LOADING_DELAY") {
                // loop on tickets data (waybills)
                if (gettype($result) == 'string') {
                    $result = json_decode($result, true);
                }

                $ticketNewData = [];
                $successful_set_weight = 0;

                foreach ($ticket_details as &$ticket_waybill) {
                    // extrat weight from result
                    foreach ($result as $result_waybill) {

                        if (!$result_waybill['loading_weight'] || $result_waybill['loading_weight'] == "-") {
                            throw new Exception("وزن التحميل للمستند رقم $ticket_waybill->wn غير موجود");
                        }

                        if ($result_waybill['wn'] == $ticket_waybill->wn) {
                            // save it in waybill
                            $waybillFilter = [['key' => 'wn', 'val' => $ticket_waybill->wn]];
                            $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, 0);
                            $waybillBean = $this->_waybillCore->getWaybillBasic($waybills->data[0]->id, $_SESSION['user_id']);

                            // save weight in case it is not exist
                            $cargoBean = $waybillBean->document->cargo[0];
                            if (!$cargoBean->weights->loading->net_weight) {
                                $cargoBean->weights->loading->net_weight = $result_waybill['loading_weight'];
                                $cargoBean->weights->loading->time_stamp = DBConnection::getSystemDate();
                                $waybillBean->document->cargo[0] = $cargoBean;

                                $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

                                // change status to closed
                                $this->_waybillCore->changeStatus($waybillBean->id, 'CLOSED', 0);

                                // add remarks
                                $message = "تثبيت وزن التحميل بواقع " . $result_waybill['loading_weight'] . " معاملة رقم " . $id;
                                $this->_waybillCore->logActivity($waybillBean->id, "إضافة شروحات", $message, "ADD_NOTES", $_SESSION['user_id']);

                                // save it in ticket
                                $ticket_waybill->loading_weight = $result_waybill['loading_weight'];
                                $successful_set_weight++;
                            }
                        }
                    }
                    $ticketNewData[] = $ticket_waybill;
                }

                $request = $ticketBean['request'];
                $request_data = json_decode($request['data']);
                $request_data->body = $ticketNewData;
                $ticketBean['request']['data'] = json_encode($request_data, JSON_UNESCAPED_UNICODE);
                $request = $ticketBean['request'];
                $ticket = $this->_customerCare->updateTicket($id, null, $request);

                // if ticket is new , change it to assigned
                if ($ticketBean['status'] == "NEW") {
                    $ticket = $this->_customerCare->changeStatus($id, 'ASSIGNED', $result);
                    $ticket = $this->_customerCare->changeStatus($id, 'IN_PROGRESS', $result);
                }
                if ($ticketBean['status'] == "ASSIGNED") {
                    $ticket = $this->_customerCare->changeStatus($id, 'IN_PROGRESS', $result);
                }

                if ($successful_set_weight != sizeof($ticket_details)) {
                    $Result['ERRORCODE'] = "0";
                    $Result['MESSAGE'] = "تم تثبيت الأوزان الصحيحة في المعاملة بواقع $successful_set_weight مستند ، يرجى اكمال الباقي";
                    parent::response($Result);
                    die;
                }
            }

            // Validate that the loading_date is not empty before closing the ticket
            elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "WAYBILL_LOADING_DELAY") {
                $waybillId = $ticket_details->waybill_id;
                $waybillStatus = "ACTIVE";
                // Run the validator on the waybill
                $hasLoadingDate = $this->_objectWatcherCore->validate("WAYBILL", $waybillId, $waybillStatus);
                if (!$hasLoadingDate) {
                    throw new Exception("لا يمكن إغلاق المعاملة بدون وزن تحميل");
                }
            }

            // close ticket of type CHANGE_QUEUE_DRIVER
            elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "CHANGE_QUEUE_DRIVER") {
                // loop of trucks in order to change  the driver id
                $data = json_decode($ticketBean['request']['data'], JSON_UNESCAPED_UNICODE);
                $body = json_decode($data['body']);
                $queue_driver_list = json_decode($body->queue_driver_list);

                foreach ($queue_driver_list as $raw) {
                    $queue_id = $raw->queue_id;

                    // update driver id
                    $updateBean = new stdClass();
                    $updateBean->id = $queue_id;
                    $updateBean->driver_id = $raw->driver_id;
                    $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);
                }
            }

            // Validate that the waybill status is not NEW
            elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "ADD_ROUTE_WAGE") {

                try {

                    DBConnection::startTransaction();

                    $origin_id = $this->_request->origin_id;
                    $destination_id = $this->_request->destination_id;
                    $tender_id = $this->_request->tender_id;
                    $start_date = $this->_request->start_date;
                    $end_date = $this->_request->end_date;
                    $cargo_id = $this->_request->cargo_id;
                    $wage_per_ton_indivisual = $this->_request->wage_per_ton_indivisual;
                    $wage_per_ton_company = $this->_request->wage_per_ton_company;
                    $tolerance_percentage = $this->_request->tolerance_percentage;
                    $loss_fine_per_kg = $this->_request->loss_fine_per_kg;

                    // create 2 route wages
                    $temp = new stdClass();
                    $temp->origin_id = $origin_id;
                    $temp->destination_id = $destination_id;
                    $temp->tender_id = $tender_id;
                    $temp->start_date = $start_date;
                    $temp->end_date = $end_date;
                    $temp->plan = 'PER_TON';
                    $temp->cargo_id = $cargo_id;
                    $temp->minimum_weight = 1;
                    $temp->wage_per_ton = $wage_per_ton_indivisual;
                    $temp->tolerance_percentage = $tolerance_percentage;
                    $temp->loss_fine_per_kg = $loss_fine_per_kg;
                    $temp->type = 'payable';
                    $routeWage1_id = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);

                    $temp = new stdClass();
                    $temp->origin_id = $origin_id;
                    $temp->destination_id = $destination_id;
                    $temp->tender_id = $tender_id;
                    $temp->start_date = $start_date;
                    $temp->end_date = $end_date;
                    $temp->plan = 'PER_TON';
                    $temp->cargo_id = $cargo_id;
                    $temp->minimum_weight = 1;
                    $temp->wage_per_ton = $wage_per_ton_company;
                    $temp->tolerance_percentage = $tolerance_percentage;
                    $temp->loss_fine_per_kg = $loss_fine_per_kg;
                    $temp->type = 'receivable';
                    $routeWage2_id = $this->_routeWageCore->createRouteWage($temp, $_SESSION['user_id']);

                    // check if there is auto action to be done by the system
                    $autoAction = getAutoAction('ROUTE_WAGE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
                    if ($autoAction) {
                        $this->_routeWageCore->changeStatus($routeWage1_id, $autoAction->object_new_status_code, $_SESSION['user_id']);
                        $this->_routeWageCore->changeStatus($routeWage2_id, $autoAction->object_new_status_code, $_SESSION['user_id']);
                    }

                    DBConnection::commitTransaction();
                } catch (Exception $e) {
                    DBConnection::rollBackTransaction();
                    throw new Exception("لم يتمكن النظام من إنشاء التسعيرات");
                }
            }

            // Validate that the waybill status is not NEW
            elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "WAYBILL_NO_ACTION") {
                $waybillId = $ticket_details->waybill_id;
                $waybillStatus = "NEW";
                // Run the validator on the waybill
                $hasActions = $this->_objectWatcherCore->validate("WAYBILL", $waybillId, $waybillStatus);
                if (!$hasActions) {
                    throw new Exception("لا يمكن إغلاق المعاملة بدون إتخاذ أي إجراء على المستند");
                }
            }

            // Validate ticket result when closing
            elseif ($status == "COMPLETED" && $result === null) {
                throw new Exception("- لا يمكن إغلاق المعاملة بدون نتيجة -" . $result);
            }

            // Update user bean with profile image
            elseif ($status == "COMPLETED"   && $ticketBean['type_code'] == "PERSONAL_DOCS") {
                if ($result && sizeof($result) > 0) {

                    if ($ticket_details->user_id) {
                        $user_id = $ticket_details->user_id;
                    } else {
                        $user_id = $ticketBean['remote_user_id'];
                    }

                    foreach ($result as $doc) {
                        $this->_userCore->updateUserPhoto($user_id, $doc->v, $doc->q);
                    }
                } else {
                    throw new Exception('لا يوجد صور لحفظها, الرجاء التأكد من المعلومات');
                }
            }

            // Update truck bean with profile image
            elseif ($status == "COMPLETED"   && $ticketBean['type_code'] == "TRUCK_DOCS") {
                if ($result && sizeof($result) > 0) {
                    $truck_id = $ticket_details->truck_id;
                    foreach ($result as $doc) {
                        $this->_truckCore->updateTruckPhoto($truck_id, $doc->v, $doc->q);
                    }
                } else {
                    throw new Exception('لا يوجد صور لحفظها, الرجاء التأكد من المعلومات');
                }
            } elseif ($status == "COMPLETED"   && $ticketBean['type_code'] == "FUEL_TENDER_ORDER") {
                /* Case 1: Ticket in the first stage will be handed to Jo petrol operation to be approved.
                | When the ticket type_code is FUEL_TENDER_ORDER and assigned to a CA_OPERATION slot
                | escalate the ticket to MINAGATE_OPERATION.
                */
                if (
                    isset($ticketBean["filters"]["role_code"])
                    && strtoupper($ticketBean["filters"]["role_code"]) == "CA_OPERATION"
                ) {
                    // Escalate to MINAGATE_OPERATION
                    $filters = $ticketBean["filters"];
                    $filters["role_code"] = "MINAGATE_OPERATION";

                    // reply to ticket
                    $note = [
                        "senderName" => isset($_SESSION["company_name"]) ? $_SESSION["company_name"] : $_SESSION["u_id"],
                        "title" => "تحديث وضع المعاملة",
                        "body" =>  "تمت الموافقة على المعاملة رقم $id"
                    ];
                    $this->_customerCare->esclateTicket($id, $note, $filters, 5);

                    // send notification
                    $ticket_user_id = $ticketBean['remote_user_id'];
                    $notification = new stdClass();
                    $notification->type = "set_notification";
                    $notification->id = rand(1, 1000);
                    $notification->title = "تمت الموافقة على المعاملة رقم $id" . " من قبل عمليات مصفاة البترول";
                    $payload = new stdClass();
                    $payload->type = "open_uri";
                    $payload->uri = "minagate://ticket/" . $id;
                    $result = $this->_notificationCore->sendDataMessage($ticket_user_id, $payload, $notification);

                    parent::response($ticketBean);
                    return;
                }

                /* Case 2: In the second stage will be handed to MINAGATE_OPERATION to be processed by creating a tender_order.
                | Validate that the provided tender_order_id is the required tender_order_id.
                */ else {
                    // Validate result
                    if (!is_numeric($result)) {
                        throw new Exception("رقم الطلبية غير صحيح");
                    }

                    // Get tender order bean
                    try {
                        $tenderOrderId = $result;
                        $tenderOrder = $this->_tenderCore->getTenderOrderBasic($tenderOrderId, $_SESSION["user_id"]);
                    } catch (Exception $e) {
                        throw new Exception("حدث خطأ أثناء البحث عن الطلبية رقم $tenderOrderId");
                    }
                    if (!$tenderOrder) {
                        throw new Exception("الرقم الطلبية المقدم غير موجود");
                    }
                    if ($tenderOrder->status != "ACTIVE") {
                        throw new Exception("الطلبية المدخلة غير فعالة");
                    }

                    // match the required tender order with the one provided by MG operation
                    if (
                        $tenderOrder->order_date == $ticket_details->order_date
                        && $tenderOrder->trucks == $ticket_details->num_of_trucks
                        && $this->_tenderCore->getTenderOrderDestinationId($tenderOrderId) == $ticket_details->destination_id
                    ) {
                        // Inject ticket id into tender order details
                        $orderNotes = $tenderOrder->order_notes;

                        if (is_string($orderNotes)) {
                            $orderNotes = json_decode($orderNotes);
                        }
                        $orderNotes->ticket_id = $id;
                        $tenderOrder->order_notes = json_encode($orderNotes, JSON_UNESCAPED_UNICODE);
                        $this->_tenderCore->updateTenderOrder($tenderOrder, $tenderOrderId, 0);

                        // reply to ticket
                        $note = [
                            "senderName" => 'مدارج للخدمات اللوجستية' . " - " . $_SESSION['u_id'],
                            "title" => "تحديث وضع المعاملة",
                            "body" => "تم إنشاء طلبية للمعاملة رقم $id"
                        ];
                        $this->_customerCare->replyToTicket($id, $note);
                    } else {
                        throw new Exception("الطلبية المقدمة غير مطابقة للطلبية المطلوبة في المعاملة");
                    }
                }
                // write the permit number on waybill and reply with this number to user
            } elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "SUBMIT_PERMIT_FOR_WAYBILL") {
                $this->closePermitTicket($id, $ticket_details, $result);

                // if the ticket status is still NEW , convert it to assigned
                if ($ticketBean['status'] == "NEW") {
                    $ticket = $this->_customerCare->changeStatus($id, 'ASSIGNED', $result);
                }
            } elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "REVOKE_QUEUE") {
                // VALIDATE TRUCK INFO
                $queue_tn = $ticket_details->tn;
                $q_id = $ticket_details->q_id;
                $tender_id =  $ticket_details->tender_id;
                // search if the truck has active crude oil queue
                $curdeOilFilter = [
                    ['key' => 'tn', 'val' => $queue_tn],
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'rank', 'val' => 'NULL', 'op' => 'is not null'],
                    ['key' => 'q_id', 'val' => $q_id]
                ];
                $oilQueueResult = $this->_queueCore->searchQueue($curdeOilFilter, 1, 0, $_SESSION['user_id']);
                // if there is no active queue end the validate
                if (sizeof($oilQueueResult->data) == 0) {
                    throw new Exception('لا يمكن اتمام العملية, لا يوجد دور فعال للشاحنة.');
                }

                $this->_queueCore->changeStatus($oilQueueResult->data[0]->id, 'INACTIVE', $_SESSION['user_id']);
            } elseif ($status == "COMPLETED" && $ticketBean['type_code'] == "container_waybill_order") {
                // VALIDATE TRUCK INFO
                $ticket_id = $ticketBean['id'];
                $body = json_decode($ticketBean['request']['data'])->body;
                $company_id = $ticketBean['request']['company_id'];

                $cargos = [];
                $cids = []; // store all the containre ids for search
                // create cargo  for each declaration on the ticket
                foreach ($body->containers as $container) {
                    $cids[] = $container->cid;
                    $cargoBean = new stdClass();
                    $cargoBean->name = $container->cid;
                    $cargoBean->container = $container->cid;
                    $cargoBean->tender_id = $body->tender_id;
                    $cargoBean->ct_id = 920100;
                    $cargoBean->ca_id = $container->ca_id;
                    $cargoBean->iso = $container->iso;
                    $cargoBean->waybill_template = "{}";

                    $this->_cargoCore->createCargo($cargoBean, $_SESSION['user_id']);
                }

                $cargoFilter = [
                    ['key' => 'name', 'val' => $cids, 'op' => 'in'],
                    ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                ];
                $cargoQuery = $this->_cargoCore->searchCargo($cargoFilter, 999, 0, 0);

                foreach ($cargoQuery->data as $carjo) {
                    $cargos[] = $carjo->id;
                }
                $tenderBean = new stdClass();

                $tenderBean->questionnaire = json_decode(json_encode($ticketBean['filters']['questionnaire']));
                $tenderBean->cargo = $cargos;
                $tenderBean->order_date = date('Y-m-d', strtotime(DBConnection::getSystemDate()));
                $tenderBean->tender_id = $ticketBean['filters']['tender_id'];
                $this->_tenderCore->createTenderOrder($tenderBean, $_SESSION['user_id']);
            }

            if ($status == "COMPLETED" && $ticketBean['type_code'] == 'REQUEST_DEMURRAGE') {

                $ticket_id = $ticketBean['id'];
                $body = json_decode($ticketBean['request']['data'])->body;
                $company_id = $ticketBean['request']['company_id'];
                $sms_user_id = $body->user_id;
                $claim = $this->_fpsClaimCore->approveDemurrageClaim($ticket_id, $body, $company_id, $result);
                $amount = json_decode($result)->obj->amount;
                $employeeRemark = json_decode($result)->empolyeeRemark;
                $replayData = new stdClass();
                $replayData->body = $employeeRemark;
                $replayData->senderName = $body->ca_name;
                $this->_customerCare->replyToTicket($ticket_id, $replayData);
                $msg = "تم قبول  طلب دفع اعطال للحاوية رقم : " . $body->cid . "و المبلغ : " . $amount;

                // $userBean = $this->_userCore->getUserBasic($sms_user_id, 0);
                // $user_phone = $userBean->phone_array[0]->phone;
                if ($ticketBean['status'] != $status) {
                    // call to customer care system to change status
                    $ticket = $this->_customerCare->changeStatus($id, $status, $result);
                    // sendSMS($user_phone,$msg);

                }
                parent::response(json_decode($result));
                die;
            }

            if ($ticketBean['status'] != $status) {
                // call to customer care system to change status
                $ticket = $this->_customerCare->changeStatus($id, $status, $result);
            }

            // if the ticket is completed , send notification to ticket creator
            if ($status == "COMPLETED") {
                $ticket_user_id = $ticketBean['remote_user_id'];;

                if ($ticket_user_id) {
                    // send notification
                    $notification = new stdClass();
                    $notification->type = "set_notification";
                    $notification->id = rand(1, 1000);
                    $notification->title = "معاملة رقم "  . $id;
                    $notification->message = "تم الانتهاء من المعاملة رقم " . $id . " بنجاح ";
                    $payload = new stdClass();
                    $payload->type = "open_uri";
                    $payload->uri = "minagate://ticket/" . $id;

                    $this->_notificationCore->sendDataMessage($ticket_user_id, $payload, $notification);
                }
            }

            parent::response($ticket);
        } catch (Exception $e) {

            if (strpos($e->getMessage(), "Invalid result, expected one numeric values")) {
                throw new Exception("لا تستطيع المتابعة ، يجب تحديد اجراء على المعاملة");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }


    // ------------------------------------------------------------- //
    // ----------------to change status of ticket ----------------------// 
    // ------------------------------------------------------------- //
    public function snoozTicket()
    {
        $id = $this->_request->id;
        $delay = $this->_request->delay;
        try {

            // call to customer care system to create ticket
            $ticket = $this->_customerCare->snoozTicket($id, $delay);
            parent::response($ticket);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------- //
    // ----------------to update  ticket ---------------------- //
    // -------------------------------------------------------- //
    // public function updateTicket(){
    //     $ticket_id = $this->_request->ticket_id;
    //     $filters = $this->_request->filters;
    //     $data = $this->_request->data;

    //     if(gettype($data) == "string"){
    //         $data=json_decode($data);
    //     }

    //     try{
    //         // call to customer care system to create ticket
    //         $ticket = $this->_customerCare->updateTicket($ticket_id,$filters,$data);

    //         parent::response($ticket);

    //     } catch(Exception $e){

    //         throw new Exception ($e->getMessage());
    //     }
    // }


    // ------------------------------------------------------------ //
    // ----------------to add note for ticket --------------------- // 
    // ------------------------------------------------------------ //
    public function replyToTicket()
    {
        $id = $this->_request->id;
        $note = new stdClass();
        $note->body = $this->_request->body;
        $note->attachments = $this->_request->images;

        // get ticket
        $ticketBean = $this->_customerCare->getTicket($id);

        // get the bean of the user who want to reply ticket
        $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);

        if ($_SESSION['employee_id'] && $_SESSION['employee_id'] < 119000) {
            $note->senderName = 'مدارج للخدمات اللوجستية' . '-' . $_SESSION['employee_id'];
        } else if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $note->senderName = $_SESSION['company_name'];
        } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
            $note->senderName = $userBean->name;
        }

        try {
            // call to customer care system to reply ticket
            $ticket = $this->_customerCare->replyToTicket($id, $note);


            // in case the ticket is CLIENT ticket , inform him
            if ($ticketBean['type'] == "CLIENT") {
                $sendNotification = true;
                // change status of ticket
                if ($ticketBean['status'] == 'IN_PROGRESS') {
                    if ($_SESSION['employee_id']) {   // Minagate employee
                        $this->_customerCare->changeStatus($id, 'WAITING_REPLY');
                    }
                }

                if ($ticketBean['status'] == 'WAITING_REPLY') {
                    $sendNotification = false;
                    if ($ticketBean['remote_user_id'] == $_SESSION['u_id']) {
                        $this->_customerCare->changeStatus($id, 'NEW');
                    }
                    if ($ticketBean['remote_company_id'] == $_SESSION['company_id']) {
                        $this->_customerCare->changeStatus($id, 'NEW');
                    }
                }

                // send notification to ticket owner
                if ($sendNotification) {
                    $ticket_user_id = $ticketBean['remote_user_id'];
                    $notification = new stdClass();
                    $notification->type = "set_notification";
                    $notification->id = rand(1, 1000);
                    $notification->title = "رد جديد على معاملة رقم " . $id;
                    $notification->message = $note;
                    $payload = new stdClass();
                    $payload->type = "open_uri";
                    $payload->uri = "minagate://ticket/" . $id;
                    $payload->message = $note;

                    $result = $this->_notificationCore->sendDataMessage($ticket_user_id, $payload, $notification);
                }
            }

            parent::response($ticket);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------- //
    // ----------------to add note for ticket ---------------------- // 
    // ------------------------------------------------------------- //
    public function esclateTicket()
    {

        // get params
        $id = $this->_request->id;
        $body = $this->_request->body;
        $images = $this->_request->images;
        $priority = $this->_request->priority;
        $role_code = $this->_request->role_code;    // to whom the ticket is esclated

        // get ticket old filter and add the new filter item
        $ticketBean = $this->_customerCare->getTicket($id);
        $filters = $ticketBean['filters'];
        $filters['role_code'] = $role_code;

        // fill notes bean
        $note = new stdClass();
        $note->body = $body;
        $note->attachments = $images;

        // get the bean of the user who want to create ticket
        $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);
        $note->senderName = $userBean->name;

        try {
            // call to customer care system to create ticket
            $ticket = $this->_customerCare->esclateTicket($id, $note, $filters, $priority);
            parent::response($ticket);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------- //
    // --------------- get the assigned ticket for the current user  ------------------- // 
    // --------------------------------------------------------------------------------- //
    public function checkTicket()
    {

        try {
            $user_id = $_SESSION['u_id'];
            if ($user_id)
                $ticketBean = $this->_customerCare->checkTicket($user_id);

            parent::response($ticketBean);
        } catch (Exception $e) {
            $ticketBean = new stdClass();
            parent::response($ticketBean);
        }
    }


    // ------------------------------------------------------------------------------- //
    // --------------- get list of all slots and its configuration ------------------- // 
    // ------------------------------------------------------------------------------- //
    public function searchSlots()
    {

        $filter = $this->_request->filter;
        $slots = $this->_customerCare->searchSlots($filter);

        if (gettype($slots) == 'array') {
            foreach ($slots as &$slot) {
                if ($slot['user_id']) {
                    $slot['user_name'] = $this->_userCore->getUserBasic($slot['user_id'], 0)->name;
                }
            }
        } else {
            $slots = json_decode($slots);
        }

        parent::response($slots);
    }

    // ------------------------------------------------------------------------------- //
    // --------------- get list of all roles for slots ------------------- //
    // ------------------------------------------------------------------------------- //
    public function getSlotRoles()
    {

        $slots = $this->_customerCare->getSlotRoles();
        parent::response($slots);
    }




    // -------------------------------------------------------------------- //
    // --------------- activate/deactivate certian slot ------------------- // 
    // -------------------------------------------------------------------- //
    public function changeSlotStatus()
    {

        $slot_id = $this->_request->slot_id;
        $new_status = $this->_request->new_status;
        $response = $this->_customerCare->changeSlotStatus($slot_id, $new_status);

        $this->_customerCare->assignAvailableSlots();

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // ------------------------------------------------------ //
    // --------------- update slot filter ------------------- // 
    // ------------------------------------------------------ //
    public function updateSlot()
    {

        // get params
        $slot_id = $this->_request->slot_id;
        $filter = $this->_request->filter;

        // validate filter
        $slots = $this->_customerCare->updateSlot($slot_id, $filter);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------------------ Methods to prepare ticket data ------------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------- //
    private function getAvailableTruckForTicket()
    {
        $result = new stdClass();
        // get trucks and trailers for the user 
        $userFleetFilter1 = [
            ['key' => 'cat', 'val' => ['TRUCK', 'TRUCK-SINGLE'], 'op' => 'in'],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['JOIN', 'OWN', 'AUTH'], 'op' => 'in']
        ];
        $truks_contract_qry = $this->_truckContractCore->searchTruckContracts($userFleetFilter1, 1000, 0, $_SESSION['user_id']);
        $truck_ids = [];
        $result->trucks = [];
        foreach ($truks_contract_qry->data as $contract) {
            if (!array_key_exists($contract->truck_id, $truck_ids)) {
                $truck_ids[$contract->truck_id] = $contract->truck_id;
                $result->trucks[] = ["id" => $contract->truck_id, "tn" => $contract->tn];
            }
        }
        return $result->trucks;
    }

    private function getAvailableTrailersForTicket()
    {
        $result = new stdClass();
        // search for trailer contract
        $userFleetFilter2 = [
            ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => 'in'],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['JOIN', 'OWN', 'AUTH'], 'op' => 'in']
        ];
        $trailers_contract_qry = $this->_truckContractCore->searchTruckContracts($userFleetFilter2, 1000, 0, $_SESSION['user_id']);
        $result->trailers = [];
        $trailers_ids = [];
        foreach ($trailers_contract_qry->data as $contract) {
            if (!array_key_exists($contract->truck_id, $trailers_ids)) {
                $trailers_ids[] = $contract->truck_id;
                $result->trailers[] = ["id" => $contract->truck_id, "tn" => $contract->tn];
            }
        }

        return $result->trailers;
    }

    private function getEntryPointsForTicket($type_code, $tender_code)
    {

        $type_code = strtoupper($type_code);
        switch ($type_code) {
            case 'CREATE_GRAINS_WAYBILL':
            case 'CREATE_VESSELS_WAYBILL':
            case 'CREATE_EXTERNAL_WAYBILL':
            case 'SUBMIT_PERMIT_FOR_WAYBILL':

                if ($tender_code == "VESSELS" || $tender_code == "GRAINS" || $tender_code == "EXTERNAL_WAYBILLS") {
                    $entry_points = [
                        ["id" => 91090024, "caption" => "وادي اليتم"],
                        ["id" => 91090025, "caption" => "وادي عربة"],
                        ["id" => 91090027, "caption" => "الساحة الجنوبية"]
                    ];
                }
                if ($tender_code == "JO_PETROL_FUEL") {
                    $entry_points = [["id" => 91030015, "caption" => "مصفاة البترول في الزرقاء"]];
                }
                break;

            case 'REVOKE_AND_PRINT_WAYBILL':
            case 'INSIDE_ZONE_WAYBILL':
                $entry_points = [
                    ["id" => 91090026, "caption" => "الساحة الرئيسية"],
                    ["id" => 91090027, "caption" => "الساحة الجنوبية"],
                    ["id" => 91090028, "caption" => "ساحة الرابية"]
                ];
                break;
        }
        return $entry_points;
    }

    private function getExitPointsForTicket()
    {
        $exit_points = [
            ["id" => 91090024, "caption" => "وادي اليتم"],
            ["id" => 91090025, "caption" => "وادي عربة"]
        ];
        return $exit_points;
    }

    private function getCargoForTicket()
    {
        $cargo = [
            ["id" => 1910000049, "caption" => "فوسفات"],
            ["id" => 1910000050, "caption" => "بضائع عامة"],
            ["id" => 2010000026, "caption" => "بوتاس"],
            ["id" => 2010000027, "caption" => "اخرى"]
        ];
        return $cargo;
    }

    private function getDischargeLocationsForTicket()
    {
        $discharge_locations = [
            ["id" => 91090005, "caption" => "الميناء الجنوبي"],
            ["id" => 91090019, "caption" => "المجمع الصناعي"],
            ["id" => 91090017, "caption" => "كاميرا"],
            ["id" => 91090020, "caption" => "الأسمدة اليابانية"],
            ["id" => 91090001, "caption" => "داخل المدينة"],
            ["id" => 91090029, "caption" => "المدينة الصناعية"],
            ["id" => 91090008, "caption" => "ميناء الفوسفات الجنوبي"],
            ["id" => 91090038, "caption" => "البوتاس"]
        ];
        return $discharge_locations;
    }

    private function getOperationTypes()
    {
        $operation_type = [
            ["id" => "import", "caption" => "استيراد"],
            ["id" => "export", "caption" => "تصدير"],
            ["id" => "import_export", "caption" => "استيراد و تصدير"]
        ];

        return $operation_type;
    }

    private function getAllowedTenderDestinations($tender_id, $ticket_type_code)
    {

        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);
        foreach ($tenderManifestJSON['tickets'] as $ticket) {
            if ($ticket['type'] == $ticket_type_code) {
                $companies = $ticket['companies'];
                foreach ($companies as $comp) {
                    // Minagate employee
                    if ($_SESSION['employee_id']) {
                        foreach ($tenderManifestJSON['questionnaire'] as $q) {
                            if ($q['question_type'] == "ROUTE:DISTINATION") {
                                $tender_destinations = $q['options'];
                            }
                        }
                        return $tender_destinations;
                    }

                    // for each company employee
                    else if ($comp['id'] == $_SESSION['company_id']) {
                        // * = return all locations                      
                        if ($comp['locations'] == "*") {
                            foreach ($tenderManifestJSON['questionnaire'] as $q) {
                                if ($q['question_type'] == "ROUTE:DISTINATION") {
                                    $tender_destinations = $q['options'];
                                }
                            }
                            return $tender_destinations;
                        } else {
                            return $comp['locations'];
                        }
                    }
                }
            }
        }
        return [];
    }

    private function getCargoOptions()
    {
        $cargo = [
            ["id" => 1910000049, "caption" => "فوسفات"],
            ["id" => 1910000050, "caption" => "بضائع عامة"],
            ["id" => 2010000026, "caption" => "بوتاس"],
            ["id" => 2010000027, "caption" => "اخرى"]
        ];

        return $cargo;
    }


    // ------------------------------------------------------------------------------------- //
    // ------- get the available params for certain user to create ticket ------------------ //
    // ------------------------------------------------------------------------------------- //
    public function getTicketCreateParams()
    {

        // get user params
        $type_code = strtoupper($this->_request->type_code);

        // temp solution
        switch (strtolower($type_code)) {
            case 'create_grains_waybill':
                $tender_id = 13;
                break;
            case 'create_vessels_waybill':
                $tender_id = 3;
                break;
            case 'create_external_waybill':
                $tender_id = 8;
                break;
            case 'revoke_and_print_waybill':
                $tender_id = 3;
                break;
            case 'inside_zone_waybill':
                $tender_id = 3;
                break;
            case 'fuel_tender_order':
                $tender_id = 12;
                break;
            case 'submit_permit_for_waybill':
                $tender_id = 3;
                break;
            default:
                $tender_id = $this->_request->tender_id;
        }

        if (!$tender_id) {
            return [];
        }

        // temp solution
        if (!$type_code) {
            $type_code = "SUBMIT_PERMIT_FOR_WAYBILL";
        }

        $result = new stdClass();
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $tender_code = $man['tender_code'];

        switch ($type_code) {
            case 'CREATE_GRAINS_WAYBILL':
            case 'CREATE_VESSELS_WAYBILL':
            case 'CREATE_EXTERNAL_WAYBILL':
            case 'REVOKE_AND_PRINT_WAYBILL':
            case 'INSIDE_ZONE_WAYBILL':
                $result->trucks = $this->getavailableTruckForTicket();
                $result->trailers = $this->getavailableTrailersForTicket();
                $result->entry_points = $this->getEntryPointsForTicket($type_code, $tender_code);
                $result->exit_points = $this->getExitPointsForTicket();
                $result->discharge_locations = $this->getDischargeLocationsForTicket();
                $result->operation_type = $this->getOperationTypes();
                $result->cargo = $this->getCargoOptions();
                break;

            case 'SUBMIT_PERMIT_FOR_WAYBILL':
                $result->entry_points = $this->getEntryPointsForTicket($type_code, $tender_code);
                $result->exit_points = $this->getExitPointsForTicket();
                $result->discharge_locations = $this->getDischargeLocationsForTicket();
                $result->cargo = $this->getCargoOptions();
                break;

            case 'FUEL_TENDER_ORDER':

                // get allowed destination for the user
                $result->tender_destinations = $this->getAllowedTenderDestinations(12, $type_code);

                // days options
                $days = [];
                for ($i = 1; $i <= 4; $i++) {
                    $day = new DateTime('now');
                    date_add($day, date_interval_create_from_date_string("$i days"));
                    $day = date_format($day, "Y-m-d");
                    $temp = new stdClass();
                    $temp->caption = $day;
                    $temp->value = $day;
                    $days[] = $temp;
                }
                $result->days = $days;
                $result->discharge_locations = $this->getDischargeLocationsForTicket();
                $result->getOperationTypes = $this->getOperationTypes();
        }


        parent::response($result);
    }


    // -------------------------------------------------------------------------- //
    // ------------------ Close call Ticket ------------------------------------- //
    // -------------------------------------------------------------------------- //
    public function closeTicket()
    {

        try {

            // prepare needed objects
            $addNoteCore = new Add_notes_core();
            $queueCore = new QueueCore();
            $socialCore = new SocialCore();

            // get params
            $ticket_id = $this->_request->ticket_id;
            $ticket_result = $this->_request->result;

            // get beans
            $ticketBean = $this->_customerCare->getTicket($ticket_id);
            $ticketData = json_decode($ticketBean['request']['data']);
            $waybill_order_id = $ticketData->call_details->id;
            $dony_by = 0;

            if ($waybill_order_id) {
                $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
                $tender_id = $waybillOrderBean->tc_details->tender_id;
            } else {
                $tender_id = $ticketData->body->tender_id;
            }
            // get supervisor id
            if ($tender_id) {
                $super_visor_user_id = $this->_tenderCore->getCallCenterSupervisorId($tender_id);
            } else {
                $super_visor_user_id = 2;
            }

            // try{
            //     if ( gettype($ticketBean) == 'array'){
            //         $notification_title="محاولة اغلاق معاملة";
            //         $notification_body= "ticket_id= $ticket_id , result= $ticket_result , type = " . strtoupper($ticketBean['type']) ;
            //         $socialCore->informSupervisor($notification_title,$notification_body,$notification_body , 2);
            //     }
            //     if ( gettype($ticketBean) == 'object' ) {
            //         $notification_title="محاولة اغلاق معاملة";
            //         $notification_body= "ticket_id= $ticket_id , result= $ticket_result , type=  " . strtoupper($ticketBean->type) ;
            //         $socialCore->informSupervisor($notification_title,$notification_body,$notification_body , 2);
            //     }
            // }catch(Exception $e){}

            $phone_number = $ticketData->body->phone_number;

            // handle each answer
            if ((gettype($ticketBean) == 'array' && strtoupper($ticketBean['type']) == 'CALL')  ||
                (gettype($ticketBean) == 'object' && strtoupper($ticketBean->type) == 'CALL')
            ) {

                switch (strtoupper($ticket_result)) {

                        // -------------------------- No Answer from user ------------------------------------------------------
                    case 'NO_ANSWER':
                        // Add note on waybill order and return it to WAITING
                        $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك لا يرد", $dony_by);
                        if ($waybillOrderBean->status != "WAITING")
                            $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                        break;

                        // -------------------------- Number is busy -----------------------------------------------------------
                    case 'BUSY':
                        // Add note on waybill order and return it to WAITING
                        $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك مشغول", $dony_by);
                        if ($waybillOrderBean->status != "WAITING")
                            $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                        break;

                        // -------------------------- Destination Unreachable ---------------------------------------------------
                    case 'UNREACHABLE':
                        // Add note on waybill order and return it to WAITING
                        $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك لا يمكن الاتصال به", $dony_by);
                        if ($waybillOrderBean->status != "WAITING")
                            $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                        break;

                        // -------------------------- Wrong Contact Number ------------------------------------------------------
                    case 'INVALID':
                        // Add note on waybill order and return it to WAITING
                        $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن الرقم غير مستعمل أو غير صحيح", $dony_by);
                        if ($waybillOrderBean->status != "WAITING")
                            $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);

                        // inform call center supervisor
                        $notification_title = "رقم جهة الإتصال غير صحيح";
                        $notification_body = "رقم جهة الإتصال لأمر الحركة  $waybillOrderBean->id غير صحيح";
                        $socialCore->informSupervisor($notification_title, $notification_body, $notification_body);

                        break;

                        // ----------------------------- number of retrials reachs 0 ---------------------------------------------
                    case 'NO_RETRY':
                        // get truck remaining delay options
                        $queueBean = $queueCore->getQueueBasic($waybillOrderBean->queue_id, 0);
                        $options = $queueCore->getQueueDelayOptions($waybillOrderBean->queue_id, $queueBean->tender_id, $queueBean->q_id, 0);

                        // if it has delay options, change status of queue to PENDING with dalay = 1
                        if (isset($options->delay_options)) {
                            $duration = 1;
                            $remarks = "تمت محاولة الإتصال بسائق/مالك الشاحنة على الرقم $phone_number لعدد كبير من المرات بدون الحصول على اجابة، وتم تأجيل الدور ليوم واحد";

                            // reject the waybill order
                            $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                        }
                        // in case the truck has no more delay options, inform the call center supervisor
                        else {

                            $notification_body = "لم يتمكن نظام الإتصال الإلي من الوصول للرقم $phone_number صاحب أمر الحركة $waybillOrderBean->id ولا يوجد للشاحنة تأجيلات متاحة";
                            $notification_title = "الرجاء متابعة امر الحركة رقم $waybillOrderBean->id";
                            $socialCore->informSupervisor($notification_title, $notification_body, $notification_body);

                            // return to waiting status
                            if ($waybillOrderBean->status != "WAITING")
                                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', 0);

                            // repush the waybill order to call center as manual mode
                            $this->_tenderCore->createCallTicket($waybill_order_id, true);
                        }

                        break;

                        // ------------------------------ Accept Waybill Order ----------------------------------------------------
                    case '0':
                    case 0:

                        $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $dony_by);
                        break;

                        // ------------------------------ Reject Waybill Order ----------------------------------------------------
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case '6':
                    case '7':
                    case '8':
                    case '9':
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case '10':
                    case '11':
                    case '12':
                    case '13':
                    case 10:
                    case 11:
                    case 12:
                    case 13:
                    case '14':
                    case '15':
                    case '16':
                    case '17':
                    case 14:
                    case 15:
                    case 16:
                    case 17:
                    case '18':
                    case '19':
                    case '20':
                    case '21':
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                    case '22':
                    case '23':
                    case '24':
                    case '25':
                    case 22:
                    case 23:
                    case 24:
                    case 25:
                    case '26':
                    case '27':
                    case '28':
                    case '29':
                    case 26:
                    case 27:
                    case 28:
                    case 29:
                    case '30':
                    case 30:


                        $duration = $this->_request->result;
                        $remarks = 'تم الإتصال بسائق/مالك الشاحنة عبر نظام الإتصال الالي';

                        // reject the waybill order
                        $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                        break;

                        // ----------------------------- Reject Waybill Order and return to end of queue --------------------------
                    case '-1':
                    case -1:
                        $duration = $this->_request->result;
                        $remarks = 'تم ارجاع الشاحنة لأخر الدور بسبب نفاذ خيارات التأجيل';

                        $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, "تم ارجاع الشاحنة لأخر الدور بسبب نفاذ خيارات التأجيل", $dony_by);

                        // reject the waybill order
                        $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                        break;

                    default:
                        $notification_title = "خطأ اثناء اغلاق معاملة";
                        $notification_body = "default case !!! , ticket_id= $ticket_id " . ", result= $ticket_result";
                        $socialCore->informSupervisor($notification_title, $notification_body, $notification_body, 2);
                        break;
                }
            }


            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            $notification_title = "خطأ اثناء اغلاق معاملة";
            $notification_body = $e->getMessage() . ", ticket_id= $ticket_id " . ", result= $ticket_result";
            $socialCore->informSupervisor($notification_title, $notification_body, $notification_body, 2);

            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------- validate if the truck can be added to delay queue ticket -------------------- //
    // ------------------------------------------------------------------------------------- //
    public function validateDelayQueue()
    {

        // get params
        $tn = $this->_request->tn;

        // search if the truck has active crude oil queue
        $curdeOilFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => 11], // curde oil
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $oilQueueResult = $this->_queueCore->searchQueue($curdeOilFilter, 100, 0, $_SESSION['user_id']);
        // if there is no active queue end the validate
        if (sizeof($oilQueueResult->data) == 0) {
            throw new Exception('لا يمكن تقديم معاملة للشاحنة لعدم وجود دور فعال لها على مشروع النفط الخام');
        }

        // search database for active Fuel queue for tn
        $fuelFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => 12], // fuel
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $fuelQueueResult = $this->_queueCore->searchQueue($fuelFilter, 100, 0, 0);
        if (sizeof($fuelQueueResult->data) == 0) {
            // in case no fuel queue, check if the truck has NEW fuel waybill
            $waybillFilter = [
                ['key' => 'tn', 'val' => $tn],
                ['key' => 'tender_id', 'val' => 12],
                ['key' => 'status', 'val' => ['NEW'], 'op' => "in"]
            ];
            $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, 0);
            if ($waybills->found_rows == 0) {
                throw new Exception(' لا يمكن تقديم معاملة للشاحنة لعدم وجود دور فيول او ارسالية فيول جديدة لها');
            }
        }
        parent::response($oilQueueResult);
    }



    // ------------------------------------------------------------------------------------- //
    // ------- validate if the truck can be added to activate queue ticket ----------------- //
    // ------------------------------------------------------------------------------------- //
    public function validateActiveQueue()
    {

        // user params
        $tn = $this->_request->tn;

        // search database for PENDING queue for tn on crudeOil
        $curdeOilFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => 11],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $oilQueueResult = $this->_queueCore->searchQueue($curdeOilFilter, 100, 0, 0);
        // if there is no pending queue end the validate
        if (sizeof($oilQueueResult->data) == 0) {
            throw new Exception('لا يمكن فك منع الشاحنة, لعدم وجود دور مؤجل على مشروع النفط الخام');
        }

        // search database for active queue for tn
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => 12],
            ['key' => 'status', 'val' => ['APPROVED', 'ACTIVE', 'ONROAD'], 'op' => "in"]
        ];
        $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, 0);
        // if there is no 'APPROVED', 'ACTIVE', 'ONROAD' waybill end the validate
        if (sizeof($waybills->data) == 0) {
            throw new Exception('لا يمكن فك منع الشاحنة, لعدم وجود ارسالية على مشروع الفيول');
        }

        parent::response($oilQueueResult);
    }

    public function getTicketTypes()
    {

        $user_roles = explode(",", $_SESSION['USER_ROLES']);
        $company_employee_roles = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $userRolesArray = array_merge($user_roles, $company_employee_roles);
        $json = '[
            {
                "label": "تموين",
                "value": "create_grains_waybill",
                "icon": "seedling",
                "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION"]
            },
            {
                "label": "بواخر",
                "value": "create_vessels_waybill",
                "icon": "ship",
                "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION"]
            },
            {
                "label": "تصريح خارجي",
                "value": "create_external_waybill",
                "icon": "external-link-square-alt",
                "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION"]
            },
            {
                "label": "الغاء وطباعة",
                "value": "revoke_and_print_waybill",
                "icon": "print",
                  "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION","CRUDE_OIL_DISPATCHER"]
            },
            {
                "label": "طلب تسهيلات",
                "value": "inside_zone_waybill",
                "icon": "globe-asia",
                "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION"]
            },
            {
                "label": "طلبية فيول",
                "value": "fuel_tender_order",
                "icon": "gas-pump",
                "roles": ["COMPANY_OPERATION","MINAGATE_OPERATION"]
            },
            {
                "label": "اضافة شاحنات على المنع",
                "value": "delay_queue_truck",
                "icon":  "fa-shield",
                "roles": ["CRUDE_OIL_DISPATCHER","MINAGATE_OPERATION"]
            },
            {
                "label": "فك منع شاحنات",
                "value": "active_queue_truck",
                "icon": "calendar-check",
                "roles": ["CRUDE_OIL_DISPATCHER","MINAGATE_OPERATION"]
            },
            {
                "label": "حذف دور",
                "value": "revoke_queue",
                "icon": "fa-minus-circle",
                "roles": ["MINAGATE_OPERATION"]
            },
            {
                "label": "تغيير معلومات سائق على الدور",
                "value": "change_queue_driver",
                "icon": "fa-minus-circle",
                "roles": ["MINAGATE_OPERATION"]
            },
            {
                "label": "طلبية تسريب",
                "value": "container_waybill_order",
                "icon": "fa-minus-circle",
                "roles": ["CA_MANAGER"]
            },
            {
                "label": "اخرى",
                "value": "other",
                "icon": "ticket-alt",
                "roles": ["DRIVER","TRUCK_OWNER","TC_MANAGER","MINAGATE_OPERATION,CRUDE_OIL_DISPATCHER"]
            }
        ]';
        $ticketTypes = json_decode($json);

        $result = [];
        foreach ($ticketTypes as $type) {
            foreach ($type->roles as $role) {
                if ($role == "*" || in_array($role, $userRolesArray)) {
                    if (!in_array($type, $result)) {
                        $result[] = $type;
                    }
                }
            }
        }

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------- //
    // ------- close tickets category  ----------------------------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function getTicketCategory()
    {
        $json = '[
            {
              "type": "CALL",
              "caption": "اتصال",
              "type_code": []
            },
            {
              "type": "TERMINAL",
              "caption": "بوابات",
              "type_code": []
            },
            {
              "type": "OBJECT",
              "caption": "النظام",
              "type_code": [
                {
                  "type_code": "BULK_WAYBILL_LOADING_DELAY",
                  "caption": "تأخر عن التحميل"
                },
                {
                  "type_code": "WAYBILL_NO_ACTION",
                  "caption": "مستند بحالة جديدة"
                },
                {
                    "type_code": "ADD_ROUTE_WAGE",
                    "caption": "انشاء تسعيرة نقل"
                }
              ]
            },
            {
              "type": "CLIENT",
              "caption": "عملاء",
              "type_code": [
                {
                  "type_code": "CREATE_GRAINS_WAYBILL",
                  "caption": "مستند تموين"
                },
                {
                  "type_code": "CREATE_VESSELS_WAYBILL",
                  "caption": "مستند بواخر"
                },
                {
                  "type_code": "INSIDE_ZONE_WAYBILL",
                  "caption": "طلب تسهيلات"
                },
                {
                  "type_code": "CREATE_EXTERNAL_WAYBILL",
                  "caption": "تصريح خارجي"
                },
                {
                  "type_code": "REVOKE_AND_PRINT_WAYBILL",
                  "caption": "الغاء وطباعة"
                },
                {
                  "type_code": "DELAY_QUEUE_TRUCK",
                  "caption": "اضافة شاحنات على المنع"
                },
                {
                  "type_code": "ACTIVE_QUEUE_TRUCK",
                  "caption": "فك منع الشاحنات"
                },
                {
                  "type_code": "FUEL_TENDER_ORDER",
                  "caption": "طلبية فيول"
                },
                {
                  "type_code": "PERSONAL_DOCS",
                  "caption": "تغير وثيقة شخصية"
                },
                {
                  "type_code": "TRUCK_DOCS",
                  "caption": "تغير وثيقة مركبة"
                },
                {
                  "type_code": "SUBMIT_PERMIT_FOR_WAYBILL",
                  "caption": "تسريب"
                },
                {
                  "type_code": "CHANGE_QUEUE_DRIVER",
                  "caption": "تغير سائق على الدور"
                },
                {
                  "type_code": "OTHER",
                  "caption": "اخرى"
                }
              ]
            }
          ]';

        $ticketTypes = json_decode($json);
        parent::response($ticketTypes);
    }


    // ------------------------------------------------------------------------------------- //
    // ------- close permit ticket --------------------------------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function closePermitTicket($id, $ticket_details, $result)
    {

        //validate current ticket to close
        $filter = array();
        $filter['type_code'] = 'SUBMIT_PERMIT_FOR_WAYBILL';
        $filter['status'] = ['NEW'];
        $tickets = $this->_customerCare->searchTickets($filter, null, null, null);

        //check if there is a ticket of type permit and created before the current ticket and is still new
        foreach ($tickets['data'] as $ticket) {
            if ($ticket['id'] < $id) {
                //throw new Exception("لا تستطيع المتابعة, يوجد معاملات بتاريخ أقدم في الانتظار");
            }
        }

        $waybill_id = $ticket_details->waybill_id;
        $tn = $ticket_details->tn;
        // write permit number on ticket
        if ($waybill_id) {
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
            // write permit number on waybill
            $integeration_details = $waybillBean->document->integeration_details;
            if (!$integeration_details) {
                $integeration_details = new stdClass();
                $integeration_details->nafith = new stdClass();
                $integeration_details->nafith->permit_number = $result;
                $waybillBean->document->integeration_details = $integeration_details;
            } else {
                $waybillBean->document->integeration_details->nafith = new stdClass();
                $waybillBean->document->integeration_details->nafith->permit_number = $result;
            }
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

            // close Itihad Queue
            $truck_queue_id = $ticket_details->truck_queue_id;
            if ($truck_queue_id) {
                $itihadQueue = $this->_queueCore->getQueueBasic($truck_queue_id, 0);
                if ($itihadQueue && $itihadQueue->status == 'ACTIVE') {
                    $this->_queueCore->changeStatus($truck_queue_id, 'CLOSED', 0);
                }
            }

            // reply to ticket
            $note = [
                "senderName" => 'مدارج للخدمات اللوجستية' . " - " . $_SESSION['u_id'],
                "title" => "تحديث وضع المعاملة",
                "body" => "تم إصدار تصريح رقم $result للشاحنة رقم $tn"
            ];
            $this->_customerCare->replyToTicket($id, $note);

            // post on driver wall
            try {
                $socialCore = new SocialCore();
                $driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
                $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
                $user_id = $driver_qry->data[0]->user_id;
                $title = "اصدار تصريح";
                $msg = "تم إصدار تصريح رقم $result للشاحنة رقم $tn";
                $socialCore->createWallEntry($user_id, $title, $msg);
            } catch (Exception $e) {
                //logHamzeh("error",$e->getMessage());
            }
        }
    }



    // ------------------------------------------------------------------------------------- //
    // ------- force clear tickets -------------------------------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function forceClearTickets()
    {

        $slot_id = $this->_request->slot_id;
        try {
            $this->_customerCare->forceClearTickets($slot_id);
            parent::response("تمت العملية بنجاح");
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------- //
    // ----------------to git list of tickets ---------------------- //
    // ------------------------------------------------------------- //
    public function searchReportTickets()
    {
        try {

            $tn  = $this->_request->tn;
            // call to customer care system to create ticket
            $filter = array();

            // get the company id
            $filter['remote_company_id'] = $_SESSION['company_id'];
            $filter['remote_user_id'] = null;

            if (!$filter['status']) {
                $filter['status'] = ['NEW'];
            }


            // append user custome filter
            $userFilter = json_decode($this->_request->filter);
            if ($userFilter) {
                foreach ($userFilter as $filter_key => $filter_object) {
                    $filter[$filter_key] = $filter_object;
                }
            }

            if ($filter['tender_id']) {
                $filter['data->body->tender_id'] = $filter['tender_id'];
                unset($filter['tender_id']);
            }

            $tickets = $this->_customerCare->searchTickets($filter, null, null, 'desc');


            if ($filter['type_code'] === 'SUBMIT_PERMIT_FOR_WAYBILL') {
                $truck_queue_ids = [];
                $result = array();
                // formating data
                foreach ($tickets['data'] as $ticket) {
                    $ticketData = json_decode($ticket['request']['data']);
                    $ticket_details = json_decode($ticketData->body);
                    if ($ticket_details->truck_queue_id) {
                        $temp = new stdClass();
                        $temp->id = $ticket['id'];
                        $temp->status = $ticket['status'];
                        $temp->created_at = $ticket['created_at'];
                        $temp->data = $ticketData;
                        $truck_queue_ids[] = $ticket_details->truck_queue_id;
                        $result[$ticket_details->truck_queue_id] = $temp;
                    }
                }


                $string_ids = join(',', $truck_queue_ids);
                $sqlQuery = "select * from queue where  id in ($string_ids);";
                $param = [];
                $queues = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
                foreach ($queues as $queue) {
                    $id = $queue->id;
                    if ($result[$id]) {
                        $result[$id]->queue_rank = $queue->rank;
                    }
                }
                parent::response($result);
            } else {
                parent::response([]);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------- //
    // ----------------to git list of tickets ---------------------- //
    // ------------------------------------------------------------- //
    public function assignTicketForSlot()
    {
        $ticket_id = $this->_request->ticket_id;
        $slot_id = $this->_request->slot_id;
        $slot_notes = $this->_request->slot_notes;
        try {
            if ($slot_notes) {
                $note = new stdClass();
                $note->body = $slot_notes;
                // get the bean of the user who want to reply ticket
                $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);
                if ($_SESSION['employee_id'] && $_SESSION['employee_id'] < 119000) {
                    $note->senderName = 'مدارج للخدمات اللوجستية' . '-' . $_SESSION['employee_id'];
                } else if (strtoupper($_SESSION['type']) == "CORPORATE") {
                    $note->senderName = $_SESSION['company_name'];
                } else if (strtoupper($_SESSION['type']) == "INDIVIDUAL") {
                    $note->senderName = $userBean->name;
                }
                // call to customer care system to reply ticket
                $this->_customerCare->replyToTicket($ticket_id, $note);
            }
            $this->_customerCare->assignTicketForSlot($ticket_id, $slot_id);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }




    // --------------------------------------------------- //
    // ------------Create new Poll for tips -------------- //
    // --------------------------------------------------- //
    public function createTipsPoll()
    {
        $title = $this->_request->title;
        $question_text = $this->_request->poll_text;
        $announcment_text = $this->_request->announcement_text;
        $expiry_date = $this->_request->expiry_date;

        $wallet_id = $this->_request->wallet_id;
        $recipients = $this->_request->recipients;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        if (gettype($recipients) == "string") {
            $recipients = json_decode($recipients);
        }
        $is_dismissible = false;
        $can_change_answer = false;
        $description = "";
        $priority = 3;

        if (!$announcment_text) {
            throw new Exception("نص التعميم غير موجود");
        }

        try {
            DBConnection::startTransaction();

            // Step 1: creating the ANNOUNCEMENT for the people who has active wallets
            $answers = [];
            $answer1 = new stdClass();
            $answer1->caption = "موافق";
            $answer1->next_question = null;
            $answer1->theme = "primary";
            $answer1->value = 1;
            $answers[] = $answer1;

            // TODO: get this from front end
            //$announcment_text = "تم اصدار أمر صرف اكراميات نفط خام عن الأشهر 10-11 بقيمة " . '_$_AMOUNT_$_' . " وتم تحويل المبلغ على محفظتك الإلكترونية المثبتة على الرقم " . '_$_MOBILE_$_';
            $question = [];
            $question['question_lable'] = $announcment_text;
            $question['question_type'] = "SINGLE";
            $question['question_attachment_url'] = "";
            $question['question_id'] = 0;
            $question['validation'] = ["method" => "none"];
            $question['answers'] = $answers;
            $poll_1['details']['questions'][] = $question;

            $poll_1['details']['attributes'] = [];
            $poll_1['details']['attributes']['title'] = $title;
            $poll_1['details']['attributes']['priority'] = 3;
            $poll_1['details']['attributes']['is_dismissible'] = $is_dismissible;
            $poll_1['details']['attributes']['scenario'] = "normalScenario";
            $poll_1['details']['attributes']['expiry_date'] = $expiry_date;
            $poll_1['details']['attributes']['can_change_answer'] = $can_change_answer;
            $poll_1['details']['attributes']['max_retries'] = "1";
            $poll_1['details']['attributes']['description'] = $description;
            $poll_1['details']['attributes']['callback'] = [];
            $poll_1['recipients'] = [];

            $rec = [];
            $rec['bind_params'] = json_encode([]);
            $userBean = $this->_userCore->getUserBasic(2, 0);
            $rec['user_id'] = 0;
            $rec['communication_channels'] = [];
            $poll_1['recipients'][] = $rec;

            // Step 2: create Poll for people who does have wallet
            $answers_poll = [];
            $answer1_poll = new stdClass();
            $answer1_poll->caption = "اقرار";
            $answer1_poll->next_question = null;
            $answer1_poll->theme = "primary";
            $answer1_poll->value = 1;
            $answers_poll[] = $answer1_poll;

            $answer2_poll = new stdClass();
            $answer2_poll->caption = "رقم الهاتف ليس لي";
            $answer2_poll->next_question = null;
            $answer2_poll->theme = "outline";
            $answer2_poll->value = 0;
            $answers_poll[] = $answer2_poll;

            $question_poll = [];
            $question_poll['question_lable'] = $question_text;
            $question_poll['question_type'] = "SINGLE";
            $question_poll['question_attachment_url'] = "";
            $question_poll['question_id'] = 0;
            $question_poll['validation'] = ["method" => "none"];
            $question_poll['answers'] = $answers_poll;
            $poll_2['details']['questions'][] = $question_poll;

            // attributes
            $poll_2['details']['attributes'] = [];
            $poll_2['details']['attributes']['title'] = $title;
            $poll_2['details']['attributes']['is_dismissible'] = $is_dismissible;
            $poll_2['details']['attributes']['priority'] = 3;
            $poll_2['details']['attributes']['expiry_date'] = $expiry_date;
            $poll_2['details']['attributes']['can_change_answer'] = $can_change_answer;
            $poll_2['details']['attributes']['max_retries'] = "1";
            $poll_2['details']['attributes']['description'] = $description;

            $from_account = "";
            $tender_id = "";

            if ($wallet_id == "fuel") {
                $callBack = new stdClass();
                $data = new stdClass();
                $from_account = "590000,19904";
                $data->from_account = $from_account;
                $data->method = "processPollAnswerToCreateVoucher";
                $data->payment_method = "ZAIN_CASH";
                $tender_id = 12;
                $data->tender_id = $tender_id;
                $data->voucher_label = $title;
                $data->voucher_type = "TIPS";
                $data->wallet_id = "fuel";
                $callBack->data = $data;
                $callBack->type = "answer";
                $callBack->url = "https://api.minagate.com/voucher_integration";
            } else if ($wallet_id == "crude_oil") {
                $callBack = new stdClass();

                $data = new stdClass();
                $from_account = "590000,19906";
                $data->from_account = $from_account;
                $data->method = "processPollAnswerToCreateVoucher";
                $data->payment_method = "ZAIN_CASH";
                $tender_id = 11;
                $data->tender_id = $tender_id;
                $data->voucher_label = $title;
                $data->voucher_type = "TIPS";
                $data->wallet_id = "crude_oil";
                $callBack->data = $data;
                $callBack->type = "answer";
                $callBack->url = "https://api.minagate.com/voucher_integration";
            } else {
                throw new Exception("Invalid Wallet id");
            }
            $poll_2['details']['attributes']['callback'] = [
                $callBack
            ];
            $poll_2['details']['attributes']['notification_title'] = $title;
            $poll_2['details']['attributes']['priority'] = 3;
            $poll_2['details']['attributes']['scenario'] = "normalScenario";
            $poll_2['details']['attributes']['type'] = "poll";
            $poll_2['recipients'][] = $rec;

            // insert into database
            $poll_id_1 = $this->_pollIntegration->createPoll($poll_1);   // التعميم (ANNOUNCMENT)
            $poll_id_2 = $this->_pollIntegration->createPoll($poll_2);   // الاستبيان (POLL)


            // create task to append recepient
            $taskQueuesCore = new TaskQueuesCore();
            if ($recipients) {
                foreach ($recipients as $temp_rec) {

                    $bind_params = [];
                    foreach ($temp_rec as $key => $value) {
                        $bind_params[$key] = $value;
                    }

                    // ToDo
                    $taskQueuesCore->createAppendRecipientToTipsTask(
                        $poll_id_1,
                        $poll_id_2,
                        $temp_rec->nn,
                        $from_account,
                        $temp_rec->amount,
                        $tender_id,
                        $wallet_id,
                        $title,
                        json_encode($bind_params)
                    );
                }
            }
            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------- //
    // ------------Create new Announcement Poll -------------- //
    // ------------------------------------------------------- //
    public function createAnnouncementPoll()
    {
        $title = $this->_request->title;
        $expiry_date = $this->_request->expiry_date;
        $announcement_text = $this->_request->announcement_text;
        $recipients = $this->_request->recipients;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        if (gettype($recipients) == "string") {
            $recipients = json_decode($recipients);
        }

        $is_dismissible = false;
        $can_change_answer = false;
        $description = "";
        $priority = 3;

        try {
            DBConnection::startTransaction();

            // Step 1: creating the ANNOUNCEMENT 
            $answers = [];
            $answer1 = new stdClass();
            $answer1->caption = "موافق";
            $answer1->next_question = null;
            $answer1->theme = "primary";
            $answer1->value = 1;
            $answers[] = $answer1;

            $question = [];
            $question['question_lable'] = $announcement_text;
            $question['question_type'] = "SINGLE";
            $question['question_attachment_url'] = "";
            $question['question_id'] = 0;
            $question['validation'] = ["method" => "none"];
            $question['answers'] = $answers;

            $poll_1 = [];
            $poll_1['details'] = [];
            $poll_1['details']['questions'][] = $question;

            $poll_1['details']['attributes'] = [];
            $poll_1['details']['attributes']['title'] = $title;
            $poll_1['details']['attributes']['priority'] = $priority;
            $poll_1['details']['attributes']['is_dismissible'] = $is_dismissible;
            $poll_1['details']['attributes']['scenario'] = "normalScenario";
            $poll_1['details']['attributes']['expiry_date'] = $expiry_date;
            $poll_1['details']['attributes']['can_change_answer'] = $can_change_answer;
            $poll_1['details']['attributes']['max_retries'] = "1";
            $poll_1['details']['attributes']['description'] = $description;
            $poll_1['details']['attributes']['callback'] = [];
            $poll_1['recipients'] = [];

            $rec = [];
            $rec['bind_params'] = json_encode([]);
            $rec['user_id'] = 0;
            $rec['communication_channels'] = [];
            $poll_1['recipients'][] = $rec;


            // insert into database
            $poll_id_1 = $this->_pollIntegration->createPoll($poll_1);

            // create task to append recepient
            $taskQueuesCore = new TaskQueuesCore();
            if ($recipients) {
                foreach ($recipients as $temp_rec) {

                    $bind_params = [];
                    foreach ($temp_rec as $key => $value) {
                        $bind_params[$key] = $value;
                    }

                    $taskQueuesCore->createAppendRecipientToPollTask(
                        $poll_id_1,
                        $temp_rec->nn,
                        json_encode($bind_params)
                    );
                }
            }
            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            $Result['POLL_ID'] = $poll_id_1;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }




    // ---------------------------------------------------------------------------------------------------------- //
    // ---------------- Start process TERMINAL ticket of type TRUCK_RECEPTION------------------------------------ //
    // ---------------- The system will try to search for waybill order or waybill for the truck ---------------- //
    // ---------------- if no info was found, the system will escilate it to operator --------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function startTermialTicket()
    {
        $tikcet_id = $this->_request->ticket_id;
        $ticketData = $this->_request->data;
        try {
            // search for apporved waybill order for the truck
            $filter = [
                ['key' => 'tn', 'val' => $ticketData->tn],
                ['key' => 'status', 'val' => 'APPROVED']
            ];
            $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($filter, 1, 0,  $_SESSION['user_id']);
            if ($waybillOrderSearchResult->found_rows > 0) {
                $result = $waybillOrderSearchResult->data[0];
                // clean the object
                $output = new stdClass();
                $output->waybill_order_id = $result->id;
                $output->tn = $result->tn;
                $output->trn = $result->trn;
                $output->driver_id = $result->driver_id;
                $output->driver_nn = $result->driver_nn;
                $output->driver_name = $result->driver_name;
                $output->driver_phone = $result->driver_phone;
                $output->tender_id = $result->tender_id;
            }
            // in case no waybill order is fonud try to look for NEW waybill
            else {
                $filter = [
                    ['key' => 'tn', 'val' => $ticketData->tn],
                    ['key' => 'status', 'val' => 'NEW']
                ];
                $waybillSearchResult = $this->_waybillCore->searchWaybills($filter, 1, 0,  $_SESSION['user_id']);
                if ($waybillSearchResult->found_rows > 0) {
                    $result = $waybillSearchResult->data[0];
                    $doc = json_decode($result->document);
                    /// clean the object
                    $output = new stdClass();
                    $output->waybill_id = $result->id;
                    $output->tn = $result->tn;
                    $output->trn = $doc->carrier[0]->trailer->tn;
                    $output->driver_nn = $doc->carrier[0]->driver->nn;
                    $output->driver_name = $doc->carrier[0]->driver->name;
                    $output->driver_phone = $doc->carrier[0]->driver->phone;
                    $output->driver_id = $doc->carrier[0]->driver->id;
                    $output->tender_id = $result->tender_id;
                }
            }

            // in case no waybill order or waybill is found throw exception
            if (!$output) {
                // reply to ticket
                $note = [
                    "senderName" => $_SESSION["u_id"],
                    "title" => "عدم القدرة على التحقق من معلومات الشاحنة",
                    "body" =>  "عدم القدرة على التحقق من معلومات الشاحنة رقم $ticketData->tn"
                ];
                $filters = ['role_code' => 'MINAGATE_OPERATION', "ticket_type" => "terminal"];
                $priority = 10;
                $this->_customerCare->esclateTicket($tikcet_id, $note, $filters, $priority);
                //return Success response
                $Result['CODE'] = 500;
                parent::response($Result);
                die;
            }
            //return Success response
            $Result['data'] = $output;
            $Result['CODE'] = 200;
            parent::response($Result);
        } catch (Exception $e) {
            // reply to ticket
            $note = [
                "senderName" => $_SESSION["u_id"],
                "title" => "عدم القدرة على التحقق من معلومات الشاحنة",
                "body" =>  "عدم القدرة على التحقق من معلومات الشاحنة رقم $ticketData->tn"
            ];
            $filters = ['call_mode' => 'manual', "ticket_type" => "terminal"];
            $priority = 10;
            $this->_customerCare->esclateTicket($tikcet_id, $note, $filters, $priority);
        }
    }


    // create tender order ticket
    public function createTenderOrderTicket()
    {

        // get data from user
        $declaration_number = $this->_request->declaration_table;
        $tender_id = $this->_request->tender_id;
        $ca_id = $_SESSION['ca_id'];
        $questionnaire = $this->_request->answers;

        // for testing
        // $questionnaire = '[{"label":"عام","value":"general","id":0},{"label":"40-45 قدم","value":"2TEU","id":1},{"label":"النبلاء للنقل البري","value":"900988","id":2}]';
        // $declaration_number = [
        //     ['declaration_num' => "19151/4/2022/220", 'count' => 1],
        //     ['declaration_num' => "19649/4/2022/220", 'count' => 6]
        // ];

        //search for tender ca
        $searchFilterTenderCa = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'ca_id', 'val' => $ca_id],
        ];

        $ca_response = $this->_clearingAgent->searchTenderClearingAgent($searchFilterTenderCa, 1, 0, $_SESSION['user_id']);
        if ($ca_response->found_rows == 0) {
            throw new Exception("المخلص غير مسجل على مشروع الحاويات");
        }
        $ca_name  = $ca_response->data[0]->ca_name;
       
        // save delcaration number to make 1 searchDeclaration
        $dec_numbers = [];
        $declaration_ids = [];

        if(gettype($declaration_number) == "string"){
            $declaration_number = json_decode($declaration_number);
        }
 
        foreach ($declaration_number as $key => $value) {
            $dec_numbers[] = $value->declaration_num;
        }


        $data = new stdClass();
        $data->filter = json_encode(['declaration_numbers' => $dec_numbers]);
        $declaration_array = $this->_con->searchDeclarations($data, $_SESSION['user_id'])['data'];

        // check if there is no declaration found
        if ($declaration_array === []) {
            throw new Exception('لم يتم العثور على بيان', 600);
        }


        // count number of items on each declration from database
        $all_count_items = 0;
        foreach ($declaration_array as $k => $dec) {
            $all_count_items += $dec['number_of_container'];

            $declaration_ids[] = $dec['id'];
            // make the decalration array associative for easier search in next function
            $declaration_array[$dec['num']] = $declaration_array[$k];
            unset($declaration_array[$k]);
        }


        // get containers to make the cargos
        $container_data = new stdClass();
        $container_data->filter = json_encode(['declaration_ids' => $declaration_ids]);
        $containers = $this->_con->searchLandTrip($container_data, $_SESSION['user_id'])['data'];

        // clean containers
        $containers_arr = [];
        foreach ($containers as $c) {
            $temp = new stdClass();
            $temp->id = $c['id'];
            $temp->cid = $c['cid'];
            $temp->serial = $c['serial'];
            $containers_arr[] = $temp;
        }

      

        // create the ticket
        $filter = new stdClass();
        $filter->tender_id = $tender_id;
        $filter->type_code = "CONTAINER_WAYBILL_ORDER";
        $filter->ticket_type = 'client';
        $filter->questionnaire = $questionnaire;
        $ticket = new stdClass();
        $ticket->title = "  طلبية شاحنات بعدد   " . $all_count_items;
        $ticket->senderName = $ca_name;
        $ticket->type_code = "CONTAINER_WAYBILL_ORDER";
        $ticket->priority = 3;
        $ticket->company_id = $_SESSION['company_id'];
        $ticket->type = "CLIENT";
        $ticket->body = [
            "tender_id" => $tender_id,
            "number_of_trucks" => $all_count_items,
            'declaration_numbers' => $dec_numbers,
            'declaration_data' => $declaration_array,
            'containers' => $containers_arr
        ];

        parent::response($this->_customerCare->createTicket($ticket, $filter));
    }
}

new CustomerCare_Interface();
