<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../waybill/waybill_core.php");

class Crude_oil_dispatcher_interface extends API{

    private $_request = array();

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_userCore = new UserCore();
        $this->_waybillCore = new WaybillCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();

    }

    // --------------------------------------------------------------------- //
    // ---------------- search for crude oil dispatcher -------------------- //
    // --------------------------------------------------------------------- //
    public function searchCrudeOilDispatchers(){

        $sql = "SELECT 
                    u.id, u.name,
                    CAST(u.photos AS CHAR CHARSET UTF8) photos,
                    u.phone, ur.status
                FROM
                    user u,
                    user_role ur
                WHERE
                    ur.user_id = u.id
                        AND ur.role_code = 'CRUDE_OIL_DISPATCHER' ";

        $result = DBConnection::runDatabaseQuery($sql);

        $Result=[];
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }

    // --------------------------------------------------------------------- //
    // ---------------- get certain crude oil dispatcher ------------------- //
    // --------------------------------------------------------------------- //
    public function getCrudeOilDispatcher(){

        $id = $this->_request->id;
        $sql = "SELECT 
                u.id,
                u.name,
                CAST(u.photos AS CHAR CHARSET UTF8) photos,
                u.phone,
                ur.status,
                u.nn,
                u.civil_record,
                u.nat_code,
                JSON_UNQUOTE(JSON_EXTRACT(u.phone_array, '$[0].email')) email
            FROM
                user u,
                user_role ur
            WHERE
                ur.user_id = u.id
                    AND ur.role_code = 'CRUDE_OIL_DISPATCHER'
                    AND u.id = ?";

        $result = DBConnection::runBindDatabaseQuery($sql , [$id]);

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------ //
    // ---------------- activate or deactivatre crude oil dispatcher role  ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function changeStatus(){

        // get params
        $id = $this->_request->id;
        $new_status = $this->_request->new_status;

        if(!$new_status){
            throw new Exception("new_status is required");
        }
        if(!$id){
            throw new Exception("id is required");
        }

        // search for the required userRole in user role table
        $searchFilter = [['key' => 'user_id', 'val' => $id],
                         ['key' => 'role_code', 'val' => "CRUDE_OIL_DISPATCHER"]];
        $searchUserResult = DBConnection::searchDB("user_role", $searchFilter, 1, 0, $_SESSION['user_id']);

        // change the status to ACTIVE
        $updateStruct = new stdClass();
        $updateStruct->id = $searchUserResult->data[0]->id;
        $updateStruct->status = $new_status;
        DBConnection::updateDB("user_role", $updateStruct, $_SESSION['user_id']);

        //return Success reponse
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
        
    }


    // ------------------------------------------------------------------------------ //
    // ----------------- Search for crude oil waybill ------------------------------- //
    // ------------------------------------------------------------------------------ //
    public function searchWaybills(){

        // get user params
        $tn = $this->_request->tn;

        // search for waybills
        $waybillFilter = [['key'=>'tender_id','val' => 11],
                          ['key'=>'status','val' => ['NEW'] , 'op'=>'in']
                        ];
        if($tn){
            $waybillFilter[] = ['key'=>'tn','val' => $tn ];
        }

        $order_by = " order by id desc ";
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 500, 0, 0, $order_by);

        foreach ($waybillResult->data as &$wbl) {
            $doc = json_decode($wbl->document);
            $wbl->trn = $doc->carrier[0]->trailer->tn;
            $wbl->driver_id = $doc->carrier[0]->driver->id;
            $wbl->driver_name = $doc->carrier[0]->driver->name;
            $wbl->driver_nn= $doc->carrier[0]->driver->nn;
            $wbl->trucking_company_id= $doc->carrier[0]->tc->id;
            $wbl->trucking_company_name= $doc->carrier[0]->tc->name;
            $wbl->action = 'print';
            unset($wbl->document);
            unset($wbl->search_index);
        }
        parent::response($waybillResult);
    }

}

new Crude_oil_dispatcher_interface();