<?php

require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../outgoing_integration/merchant.php");

class CouponInterface  extends API{

    private $_merchantIntegration;
    public function __construct(){

        DBConnection::getInstance();
        // call the super constructur
        $this->_request = parent::__construct();

        $this->_merchantIntegration = new MerchantIntegration();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ serch for coupons ----------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchCoupon(){

        $offset = $this->_request->offset;
        $limit = $this->_request->limit;
        $filter = $this->_request->filter;
        try{
            
            $data = new stdClass();
            $data->offset = $offset;
            $data->filter = $filter;
            $data->limit = $limit;
            $result = $this->_merchantIntegration->searchCoupon($data);

            parent::response($result);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
        
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ getCoupon ----------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getCoupon(){
        $id = $this->_request->id;
        try{

            $result = $this->_merchantIntegration->getCoupon($id);
            parent::response($result);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ createCoupon ----------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- /
    public function createCoupon() {
        $coupon_number = $this->_request->coupon_number;
        $amount = $this->_request->amount;
        $multi = $this->_request->multi;
        // coupon number start
        $from = $this->_request->from;
        // coupon number end
        $to = $this->_request->to;

        try{

            $result = $this->_merchantIntegration->createCoupon($coupon_number,$amount,$multi,$from,$to);

            $RESULT['CODE'] = 0;
            $RESULT['MESSAGE'] = 'SUCCESS';
            parent::response($RESULT);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ changeStatus ----------------------------------------------------- //
    // ------------------------------------------------------------------------------------------- /
    public function changeStatus() {
        $coupon_id= $this->_request->coupon_id;
        $new_status = $this->_request->new_status;

        try{

            $result = $this->_merchantIntegration->changeStatus($new_status,$coupon_id);
            parent::response($result);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
    }


    // ------------------------------------------------------------------------------------------------------------ //
    // ------------------ to use the coupon and change status ----------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------------//
    public function useCoupon() {
        $coupon_id= $this->_request->coupon_id;
        $details = $this->_request->details;
        try{

            $result = $this->_merchantIntegration->useCoupon($coupon_id,$details);
            parent::response($result);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // ------------------ to use the coupon and change status ----------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------------//
    public function validateCouponNumber() {
        $coupon_number= $this->_request->coupon_number;
        try{
            $result = $this->_merchantIntegration->validateCouponNumber($coupon_number);
            parent::response($result);

        } catch(Exception $e){
            throw new Exception($e->getMessage());
         }
    }
}


$coupon_interface = new CouponInterface();

