<?php
require_once dirname(__FILE__) . "/../API.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/container.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php";
require_once dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php";
require_once dirname(__FILE__) . "/../../core/tender/tender_core.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/ACT.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/mg_registrar.php";
require_once dirname(__FILE__) . "/../../core/outgoing_integration/poll.php";
require_once dirname(__FILE__) . "/../../core/user/user_core.php";
require_once dirname(__FILE__) . "/../../core/driver/driver_core.php";
require_once dirname(__FILE__) . "/../../core/cargo/cargo_core.php";

class Container_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_con;
    private $_fpsVoucherCore;
    private $_fps;
    private $_ca;
    private $_tenderCore;
    private $_cargoCore;
    private $_mg;
    private $_customerCare;
    private $_clearingAgentCore;
    private $_userCore;
    private $_driverCore;
    private $_pollIntegration;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // init the object
        $this->_con = new Container();
        $this->_fpsVoucherCore = new Fps_voucher_core();
        $this->_fps = new FPS();
        $this->_ca = new ClearingAgentCore();
        $this->_tenderCore = new TenderCore();
        $this->_ACTCore = new ACT();
        $this->_mg = new MG_registrar();
        $this->_customerCare = new CustomerCare();
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_userCore = new UserCore();
        $this->_driverCore = new DriverCore();
        $this->_pollIntegration = new Poll();
        $this->_cargoCore = new CargoCore();

        DBConnection::getInstance();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // -------------------------------------------------------------------- //
    // --------------------- get landTrip bean  --------------------------- //
    // -------------------------------------------------------------------- //
    public function getLandTrip()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $result = $this->_con->getLandTrip($data, $_SESSION['user_id']);

        // TODO search for vouchers from fps

        $filter = ['land_trip_id' => $this->_request->id, 'status_in' => ['NEW', 'COMPLETE']];
        $vou_data = new stdClass();
        $vou_data->filter = json_encode($filter);
        $vou_result = $this->_fps->searchVouchers($vou_data, $_SESSION['user_id']);

        // temp lay out for the voucher list
        $vouchers = [];
        $vouchers_paid_amount = 0;
        $voucher_not_paid = 0;
        foreach ($vou_result["data"] as $value) {
            $temper = [];
            $temper['id'] = $value["id"];
            $temper['payment_method'] = $value['payment_method_code'];
            $temper['status'] = $value['status'];
            $temper['amount'] = $value['amount'];
            $temper['create_date'] = $value['create_date'];
            if ($value['status'] === "COMPLETE") {
                $vouchers_paid_amount += intval($value['amount']);
            } elseif ($value['status'] === "NEW") {
                $voucher_not_paid += intval($value['amount']);
            }
            $vouchers[] = $temper;
        }
        foreach ($vouchers as &$value) {
            $fps = new FPS();
            $filter = ['voucher_id' => $value["id"], 'status' => 'NEW'];
            $data = new stdClass();
            $data->filter = json_encode($filter);
            $voucherItemsResult = $fps->searchVoucherItems($data, $_SESSION['user_id']);
            $value["items"] = $voucherItemsResult["data"];
        }

        if ($result["document"]["demurrage"]) {
            $dem_result = $result["document"]["demurrage"];
            $demurrage_net_amount = $result["document"]["demurrage"]["net_amount"];
        } else {
            $dem_data = new stdClass();
            $dem_data->container_number = $result["cid"];
            // calculate demurrage
            try {
                $dem_result = $this->_con->calculateContainerFreight($dem_data, $_SESSION['user_id']);
            } catch (Exception $e) {
                $dem_result = [];
            }

            // extract final demurrage amount
            $demurrage_net_amount = $dem_result["net_amount"];
        }

        $result["voucher"]["vouchers"] = $vouchers;
        $result["voucher"]["paid_amount"] = $vouchers_paid_amount;
        $result["demurrage"] = $dem_result;
        $result["extra_details"]["remaining_amount"] = intval($demurrage_net_amount) - intval($vouchers_paid_amount);

        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // --------------------- search landTrip bean  --------------------------- //
    // -------------------------------------------------------------------- //
    public function searchLandTrip()
    {
        $data = new stdClass();

        if ($this->_request->filter) {
            $userFilter = $this->_request->filter;
        } else {
            $userFilter = new stdClass();
        }

        if (gettype($userFilter) == "string") {
            $userFilter = json_decode($userFilter);
        }

        $data->filter = $userFilter;
        $data->limit = $this->_request->limit;
        $data->offset = $this->_request->offset;
        $result = $this->_con->searchLandTrip($data, $_SESSION['user_id']);

        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // --------------------- change landTrip status  ---------------------- //
    // -------------------------------------------------------------------- //
    public function changeLandTripStatus()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $data->new_status = $this->_request->new_status;

        $result = $this->_con->changeLandTripStatus($data, $_SESSION['user_id']);

        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // --------------------- update landTrip bean  ------------------------ //
    // -------------------------------------------------------------------- //
    public function updateLandTripBean()
    {
        $data = $this->_request;
        $result = $this->_con->updateLandTripBean($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // ----------- update landTrip shipping line detention   -------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripShippingLineDetention()
    {
        try {
            $data = new stdClass();
            $data->id = $this->_request->id;
            if ($this->_request->slab0_start) {
                $data->slab0_start = $this->_request->slab0_start;
            }
            if ($this->_request->slab0_end) {
                $data->slab0_end = $this->_request->slab0_end;
            }

            $result = $this->_con->updateLandTripShippingLineDetention($data, $_SESSION['user_id']);
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function calculateContainerFreight()
    {
        $data = new stdClass();
        $data->container_number = $this->_request->container_number;

        if (!$this->_request->container_number) {
            throw new Exception("رقم الحاوية غير صحيح");
        }

        $result = $this->_con->calculateContainerFreight($data, $_SESSION['user_id']);
        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // ------------ Gate In container into CTL Yard ----------------------- //
    // -------------------------------------------------------------------- //
    public function gateInContainer()
    {
        // prepare land trip get object
        $data = new stdClass();
        $data->id = $this->_request->id;

        // get land trip bean
        $result = $this->_con->getLandTrip($data, $_SESSION['user_id']);

        // prepare demurrage data for the calculation
        $dem_data = new stdClass();
        $dem_data->container_number = $result["cid"];
        // calculate demurrage
        $dem_result = $this->_con->calculateContainerFreight($dem_data, $_SESSION['user_id']);

        if (isset($dem_result["ERROR_MESSAGE"])) {
            throw new Exception($dem_result["ERROR_MESSAGE"]);
        }

        // extract final demurrage amount
        $demurrage_net_amount = $dem_result["net_amount"];

        // search for all paid vouchers for this land trip
        $filter = ['land_trip_id' => $this->_request->id, 'status_in' => ['COMPLETE']];
        $vou_data = new stdClass();
        $vou_data->filter = json_encode($filter);
        $vou_result = $this->_fps->searchVouchers($vou_data, $_SESSION['user_id']);

        // calculate paid vouchers  amount
        $vouchers_net_amount = 0;
        if ($vou_result["found_rows"] > 0) {
            foreach ($vou_result["data"] as $value) {
                $vouchers_net_amount += intval($value['amount']);
            }
        }
        if ($demurrage_net_amount > $vouchers_net_amount) {
            throw new Exception("الرجاء التاكد من دفع قيمة الاعطال لدخول الحاوية ");
        }

        //////////////////////////////////////////////////////

        // close land trip  by changing the status
        $_SESSION['location_id'] = 91010000; //TODO
        $sta_data = new stdClass();
        $sta_data->id = $this->_request->id;
        $sta_data->tn = $result->document->carrier[0]->truck->tn;
        $sta_data->destination_id = $_SESSION['location_id'];
        $sta_data->destination_name = getLocationName($_SESSION['location_id']);
        $sta_data->dem_result = $dem_result;

        $closereuslt = $this->_con->closeLandTrip($sta_data, $_SESSION['user_id']);

        //////////////////////////////////////////////////////

        if ($closereuslt['error_code'] == 0) {
            $title = "تسليم حاوية";
            $ma = "تم تسليم الحاوية " . $result["cid"] . "المبلغ المدفوع: " . $vouchers_net_amount;
            //$this->informClearingAgent($result['ca_id'], $title, $ma);
            parent::response("تمت العملية بنجاح ");
        } else {
            throw new Exception($closereuslt);
        }
    }

    // -------------------------------------------------------------------- //
    // ------------ Save truck and driver info in land trip --------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripCarrierInfo()
    {
        // get user inout
        $land_trip_id = $this->_request->id;
        $tn = $this->_request->tn;
        $driver_name = $this->_request->driver_name;
        $confirm_update = $this->_request->confirm_update;

        if (!$tn) {
            throw new Exception("tn is required", 1);
        }

        // compare it with origianl data stored on landtrip
        $data = new stdClass();
        $data->id = $land_trip_id;
        $landTripBean = $this->_con->getLandTrip($data, $_SESSION['user_id']);

        $original_tn = $landTripBean['document']['carrier'][0]['truck']['tn'];
        if ($original_tn && $original_tn != $tn && !$confirm_update) {
            throw new Exception("رقم الشاحنة المسجلة على الرحلة مختلف عن الرقم الجديد ، هل أنت  متأكد من المتابعة");
        }

        $upd_data = new stdClass();
        $upd_data->id = $this->_request->id;
        $upd_data->tn = $tn;
        $upd_data->driver_name = $driver_name;

        $response = $this->_con->updateLandTripBean($upd_data, $_SESSION['user_id']);

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result);
    }

    // ---------------------------------------------------------------------- //
    // --------------------- Update trucking info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    public function informClearingAgent($ca_id, $title, $message)
    {
        // init objects
        $companyEmployeeCore = new CompanyEmployeeCore();
        $userCore = new UserCore();
        $socialCore = new SocialCore();
        $taskQueuesCore = new TaskQueuesCore();
        $clearingAgentCore = new ClearingAgentCore();

        $companyFilter = [
            ['key' => 'id', 'val' => $ca_id],
        ];
        $companyResult = $clearingAgentCore->searchClearingAgent($companyFilter, 1, 0, $_SESSION['user_id']);

        // search company employee record
        $employeeSearchFilter = [
            ['key' => 'company_id', 'val' => $companyResult->data[0]->company_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
        ];
        $employeeInfo = $companyEmployeeCore->searchCompanyEmployee($employeeSearchFilter, 100, 0, 0);

        // search for TC_MANAGER
        foreach ($employeeInfo->data as $employee) {

            $employeeRoleSearchFilter = [
                ['key' => 'company_employee_id', 'val' => $employee->id],
                ['key' => 'status', 'val' => 'ACTIVE'],
            ];
            $rolesInfo = $companyEmployeeCore->searchCompanyEmployeeRoles($employeeRoleSearchFilter, 100, 0, 0);

            foreach ($rolesInfo->data as $role) {
                if ($role->role_code == 'CA_MANAGER') {
                    // get user phoneand cargo name
                    $user_id = $employee->user_id;
                    $userBean = $userCore->getUserBasic($user_id, 0);

                    // send SMS
                    $messageRecipient = $userBean->phone;
                    $messageRecipient = convertToInternational($messageRecipient);
                    $result = sendSMS($messageRecipient, $message);

                    // inform the user about this using app
                    $sender_id = 266770;
                    $sender_name = "شركة مدارج للخدمات اللوجستية ";
                    $body = $socialCore->createPostBody($title, $message, null, $sender_id, $sender_name);
                    $taskQueuesCore->createPostOnWallTask($user_id, $body, $title, true);
                }
            }
        }
    }

    // -------------------------------------------------------------------- //
    // --------------------- get landTrip bean  --------------------------- //
    // -------------------------------------------------------------------- //
    public function getShippingLine()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $result = $this->_con->getShippingLine($data, $_SESSION['user_id']);

        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // --------------------- search landTrip bean  --------------------------- //
    // -------------------------------------------------------------------- //
    public function searchShippingLines()
    {
        $data = new stdClass();
        $userFilter = $this->_request->filter;
        if (gettype($userFilter) == "string") {
            $userFilter = json_decode($userFilter);
        }

        $data->filter = $userFilter;
        $result = $this->_con->searchShippingLines($data, $_SESSION['user_id']);

        parent::response($result);
    }

    // -------------------------------------------------------------------- //
    // --------------------- update landTrip excel form ------------------- //
    // -------------------------------------------------------------------- //
    public function updateLandTripContainerExcelForm()
    {
        $data = new stdClass();
        $data->list_of_landTrips = $this->_request->list_of_land_trips;
        $result = $this->_con->updateLandTripContainerExcelForm($data, $_SESSION['user_id']);

        parent::response($result);
    }

    public function getLandTripTemplate()
    {
        try {
            $val = $this->_request->value;
            $selected_service = $this->_request->value;

            $data = new stdClass();
            $data->id = $val;
            $result = $this->_con->getLandTrip($data, $_SESSION['user_id']);

            $da = new stdClass();
            $da->container_number = $result["cid"];
            $da->selected_service = $selected_service;
            $demurrage = $this->_con->calculateContainerFreight($da, $_SESSION['user_id']);

            if ($demurrage["ERROR_MESSAGE"]) {
                throw new Exception($demurrage["ERROR_MESSAGE"]);
            }

            $str = '';
            foreach ($demurrage["freight"] as $value) {
                $replete = '<tr>
                <td style="font-weight: bold; padding: 5px; text-align: center">' . $value['label'] . '</td>
                <td style="font-weight: bold; padding: 5px; text-align: center">' . $value['value'] . '</td>
                </tr>';
                if ($value['details']) {
                    $table_header = '<tr>
                    <td colspan="2">
                        <table class="table table-bordered table-hover" style="width: 100%; max-width: 100%; font-size: x-small">
                            <thead>
                                <tr>
                                    <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">
                                        من تاريخ
                                    </th>
                                    <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">
                                        الى تاريخ
                                    </th>
                                    <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">
                                        عدد الايام
                                    </th>
                                    ​
                                    <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">القيمة</th>
                                </tr>
                            </thead>
                            <tbody>';
                    foreach ($value['details'] as $de) {
                        $inner_table = '<tr>
                        <td style="font-weight: bold; padding: 5px; text-align: center">' . $de['start'] . '</td>
                        <td style="font-weight: bold; padding: 5px; text-align: center">' . $de['end'] . '</td>
                        <td style="font-weight: bold; padding: 5px; text-align: center">' . $de['days'] . '</td>
                        <td style="font-weight: bold; padding: 5px; text-align: center">' . $de['amount'] . '</td>
                         </tr>';
                        $table_header = $table_header . $inner_table;
                    }
                    $table_header = $table_header . '</tbody>
                                                     </table>
                                                     </td>
                                                     </tr>';
                    $replete = $replete . $table_header;
                }
                $str = $str . $replete;
            }

            $template = '<!DOCTYPE html>
            <html lang="ar">
                ​
                <head>
                    <meta charset="UTF-8" />
                    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                    <meta name="viewport" content="no, initial-scale=no, maximum-scale=no" />
                    <title>Document</title>
                    <style>
                        .MinagateFont {
                            font-family: DroidArabicKufiRegular;
                            font-weight: lighter;
                            font-style: normal;
                            color: #807d7d;
                            font-size: 30px;
                            margin: 1%;
                            padding: 1%;
                        }
                        ​ .labelStyle {
                            text-align: right;
                            padding-right: 25px;
                        }
                        ​ .valueStyle {
                            text-align: right;
                            color: rgb(74, 163, 222);
                        }
                        ​ .divStyle {
                            padding: 4px;
                            padding-bottom: 5%;
                            border-bottom: solid 0.5px #ccc;
                        }
                        ​ .tableStyle {
                            width: 100%;
                            max-width: 100%;
                            margin-top: 2px;
                            margin-bottom: 2px;
                            text-align: center;
                        }
                        ​ .tdStyle {
                            padding: 5px;
                            font-size: 30px;
                            text-align: center;
                        }
                        ​ .thStyle {
                            text-align: center;
                            font-size: 30px;
                            font-weight: 100;
                            color: #3995d2;
                            width: 30%;
                        }
                    </style>
                    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css" />
                </head>
                ​
                <body dir="rtl">
                    <div class="MinagateFont">
                        <form>
                            <div class="form-group divStyle row col-sm-6 col-xs-6 col-md-6">
                                <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle"> ' . $result['cid'] . ' </label>
                                <label class="col-sm-5 col-xs-5 col-md-5 col-form-label labelStyle"> رقم الحاوية :</label>
                            </div>
                            <div class="form-group divStyle row col-sm-6 col-xs-6 col-md-6">
                                <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle"> ' . $result['status'] . '</label>
                                <label class="col-sm-5 col-md-5 col-xs-5 col-form-label labelStyle"> الحالة :</label>
                            </div>
                            <div class="form-group divStyle row col-sm-6 col-xs-6 col-md-6">
                                <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle"> ' . $result['iso'] . ' </label>
                                <label class="col-sm-5 col-md-5 col-xs-5 col-form-label labelStyle"> ISO :</label>
                            </div>
                            <div class="form-group divStyle row col-sm-6 col-xs-6 col-md-6">
                                <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle"> ' . ($result['tt_code'] == 'IMP' ? 'استيراد' : 'تصدير') . '</label>
                                <label class="col-sm-5 col-md-5 col-xs-5 col-form-label labelStyle"> العملية :</label>
                            </div>
                            <div class="form-group divStyle row col-sm-6 col-xs-6 col-md-6">
                                <label class="col-sm-7 col-xs-7 col-md-7 col-form-label valueStyle"> ' . $result['document']['shipping_line']['name'] . ' </label>
                                <label class="col-sm-5 col-md-5 col-xs-5 col-form-label labelStyle"> الخط الملاحي :</label>
                            </div>
                        </form>
                        <div class="col-md-12 col-lg-12">
                            <table class="table table-bordered table-hover">
                                <thead style="position: sticky; top: 0">
                                    <tr>
                                        <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">البيان</th>
                                        ​
                                        <th style="text-align: center; font-weight: 100; color: #3995d2; text-align: center">المبلغ بالدينار</th>
                                        ​
                                    </tr>
                                </thead>
                                <tbody>
                                    ' . $str . '
                                </tbody>
                            </table>
                        </div>

                        <div class="col-md-12 col-lg-12">

                            تستطيع دفع قيمة الأعطال المستحقة على الحاوية عبر خدمة
                            <a href="https://www.efawateercom.jo">eFAWATEERcom </a>

                        </div>
                        ​
                    </div>
                </body>
                ​
            </html>
            ';
            parent::response($template);
        } catch (Exception $e) {
            $result['ERROR_MESSAGE'] = $e->getMessage();
            parent::response($result);
        }
    }

    // ------------------------------------------------------------------------------- //
    // ---------------- Create voucher for land trip demurrage + fees) --------------- //
    // ------------------------------------------------------------------------------- //
    public function createLandTripVoucher()
    {

        // get user input
        $land_trip_id = $this->_request->land_trip_id;
        $payment_method_code = $this->_request->payment_method_code;
        $selected_service = $this->_request->selected_service;

        //validate input
        if (!$land_trip_id) {
            throw new Exception("land_trip_id is required");
        }

        if (!$payment_method_code) {
            throw new Exception("payment_method_code is required");
        }

        // get landtrip bean
        $data = new stdClass();
        $data->id = $land_trip_id;
        $landTripBean = $this->_con->getLandTrip($data, $_SESSION['user_id']);

        if (!$landTripBean) {
            throw new Exception("رحلة الحاوية غير صحيحة");
        }

        $container_number = $landTripBean['document']['container']['cid'];

        // calculate voucher amount
        $data = new stdClass();
        $data->container_number = $container_number;
        $data->selected_service = json_encode($selected_service, JSON_UNESCAPED_UNICODE);

        $result = $this->_con->calculateContainerFreight($data, $_SESSION['user_id']);
        $demurrage_net_amount = $result["demurrage_net_amount_jd"];

        $voucher_amount = $result['net_amount'];
        // get any completed voucher for this land trip and substract its value from voucher amount
        $fps = new FPS();
        $filter = ['land_trip_id' => $land_trip_id, 'status_in' => ['NEW', 'COMPLETE']];
        $data = new stdClass();
        $data->filter = json_encode($filter);
        $voucherResult = $fps->searchVouchers($data, $_SESSION['user_id']);

        foreach ($voucherResult["data"] as $This_voucher) {
            $filter = ['voucher_id' => $This_voucher["id"], 'status' => 'NEW'];
            $data = new stdClass();
            $data->filter = json_encode($filter);
            $voucherItemsResult = $fps->searchVoucherItems($data, $_SESSION['user_id']);
            foreach ($voucherItemsResult['data'] as $this_voucher_item) {
                $this_voucher_item_amount = json_decode($this_voucher_item['details'])->amount;
                if ($this_voucher_item['code'] === "demurrage") {
                    $demurrage_net_amount = $demurrage_net_amount - $this_voucher_item_amount;
                }
            }
        }

        $paid_amount = 0;
        foreach ($voucherResult['data'] as $v) {
            $paid_amount += $v['amount'];
        }

        // in case the amount is 0 or less, throw exception
        if ($voucher_amount - $paid_amount <= 0) {
            throw new Exception("لا يمكن انشاء سند قبض جديد للحاوية ، حيث أنها اما مسددة بالكامل أو لديها سند قبض جاهز للدفع");
        }
        $voucher_amount = $voucher_amount - $paid_amount;

        // prepare voucher data
        $recipient_company_id = $_SESSION['company_id'];
        if (strtoupper($payment_method_code) == "CASH") {
            $template_id = 1;
        }

        if (!$template_id) {
            throw new Exception("Invalid trx template for this operation");
        }

        // determine the debit_account and debit_amount
        foreach ($result['freight'] as &$f) {
            if ($f['code'] == "demurrage") {
                $debit_account = $f['target_account'];
                $f['isSelected'] = true;
            } else if ($f['code'] == "CODE_B") {
                $CODE_B = $f['value'];
            } else if ($f['code'] == "CODE_C") {
                $CODE_C = $f['value'];
            }
        }

        $generateFpsVoucherTrxData = new stdClass();
        $generateFpsVoucherTrxData->net_amount = $voucher_amount;
        $generateFpsVoucherTrxData->voucher_amount = $voucher_amount;
        $generateFpsVoucherTrxData->payment_method_code = $payment_method_code;
        $generateFpsVoucherTrxData->CODE_B = $CODE_B;
        $generateFpsVoucherTrxData->CODE_C = $CODE_C;
        $generateFpsVoucherTrxData->debit_account = $debit_account;
        $generateFpsVoucherTrxData->debit_amount = $voucher_amount - $CODE_B - $CODE_C;
        $generateFpsVoucherTrxData->land_trip_id = $landTripBean['id'];
        $generateFpsVoucherTrxData->origin_id = $landTripBean['document']['origin']['id'];
        $generateFpsVoucherTrxData->destination_id = $landTripBean['document']['destination']['id'];
        $generateFpsVoucherTrxData->container_number = $container_number;

        $voucher_id = $this->_fpsVoucherCore->generateFpsVoucherTrx(
            $template_id,
            $generateFpsVoucherTrxData,
            $recipient_company_id,
            " استلام رسوم وأعطال الحاوية " . $container_number
        );

        $fps = new FPS();
        foreach ($result['freight'] as $value) {
            if (!$value["isPaid"]) {
                if ($value['isSelected']) {
                    $data = new stdClass();
                    $data->voucher_id = $voucher_id;
                    $data->code = $value['code'];
                    $data->details = new stdClass();
                    $data->details->label = $value['label'];
                    $data->details->amount = $value['code'] === "demurrage" ? $demurrage_net_amount : $value['value'];
                    $fps->createVoucherItem($data, $_SESSION['user_id']);
                }
                if ($value['code'] !== "demurrage") {
                    $landTripServiceBean = new stdClass();
                    $landTripServiceBean->land_trip_id = $landTripBean['id'];
                    $landTripServiceBean->company_id = $_SESSION['company_id'];
                    $landTripServiceBean->company_service_id = $value['id'];
                    $landTripServiceBean->status = "ACTIVE";
                    $landTripServiceBean->valid_through = date('Y-m-d H:m:s', strtotime(DBConnection::getSystemDate() . "+" . $value["valid_through"]));
                    $landTripServiceBean->details = new stdClass();
                    $landTripServiceBean->details->label = $value['label'];
                    $landTripServiceBean->details->amount = $value['value'];
                    $this->_con->createLandTripService($landTripServiceBean, $_SESSION['user_id']);
                }
            }
        }

        // return success message
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        $Result['ID'] = $voucher_id;
        parent::response($Result, 200);
    }

    // -------------------------------------------------------------------- //
    // --------------------- search landTrip by trip end date   --------------------------- //
    // -------------------------------------------------------------------- //
    public function searchLandTripByTripEndDate()
    {
        $data = new stdClass();

        $userFilter = $this->_request->filter;
        if (gettype($userFilter) == "string") {
            $userFilter = json_decode($userFilter);
        }

        $data->filter = $userFilter;
        $data->limit = 10000;
        $data->offset = 0;
        $result = $this->_con->searchLandTrip($data, $_SESSION['user_id']);
        $arr = [];

        foreach ($result["data"] as $value) {
            $document = json_decode($value['document']);
            $obj = new stdClass();

            $obj->cid = $value['cid'];
            $obj->iso = $document->container->iso;
            $obj->tt_code = $value['tt_code'];
            $obj->shipping_line_code = $value['shipping_line_code'];
            $obj->origin_id = $value['origin_id'];
            $obj->destination_id = $value['destination_id'];
            $obj->trip_start = $value['trip_start'];
            $obj->trip_end = $value['trip_end'];
            $obj->slab0_start = $document->shipping_line->detention->slab0_start;
            $obj->slab0_end = $document->shipping_line->detention->slab0_end;
            $obj->status = $value['status'];

            $arr[] = $obj;
        }
        parent::response($arr);
    }

    // ---------------------------------------------------------------------  //
    // ---------------------search declaration by filter-------------------- //
    // -------------------------------------------------------------------- //
    public function searchDeclarations()
    {

        $data = new StdClass();

        $data->filter = $this->_request->filter;
        $data->limit = $this->_request->limit;
        $data->offset = $this->_request->offset;
        //get the declarations
        $declarations = $this->_con->searchDeclarations($data, $_SESSION['user_id']);
        parent::response($declarations, 200);
    }

    // public function getDeclarationItem()
    // {
    //     $data = new StdClass();
    //     $data->id = $this->_request->id;

    //     $declare_item = $this->_con->getDeclarationItem($data, $_SESSION['user_id']);

    //     return $declare_item;
    // }

    // 1 method to get all three information
    public function getDeclarationProfile()
    {
        $data = new StdClass();

        $data->id = $this->_request->id;
        $data->limit = 1000;
        $data->offset = 0;
        $declarationFilter = ['declaration_id' => $this->_request->id];
        $data->filter = $declarationFilter;

        $profile = $this->_con->getDeclarationProfile($data, $_SESSION['user_id']);

        // get the name from ca_id
        $companyFilter = [['key' => 'id', 'val' => $profile['basic']['ca_id']]];
        $ca_query = $this->_ca->searchClearingAgent($companyFilter, 1000, 0, $_SESSION['user_id']);
        $profile['basic']['ca_name'] = $ca_query->data[0]->name;

        $ca_id = $profile['basic']['ca_id'];
        $profile['basic']['e_bond_service_status'] = false;
        $profile['basic']['e_bond_service_message'] = "لا يوجد خدمة طباعة معرفة";
        $user_id = $_SESSION['u_id'];
        $user_bean = $this->_userCore->getUserBasic($user_id, 0);

        $profile['basic']['user_name'] = $user_bean->name;
        if ($ca_id) {
            $companyFilter = [
                ["key" => "tender_id", "val" => 21], // TO DOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO :)
                ["key" => "ca_id", "val" => $ca_id],
                ["key" => "status", "val" => "ACTIVE"],
            ];
            $companyResult = $this->_ca->searchTenderClearingAgent($companyFilter, 1, 0, $_SESSION['user_id']);

            $data = new stdClass();
            $data->ca_id = $ca_id;

            $electricIntegerationFlag = $this->_con->checkCaForElectronicIntegeration($data, $_SESSION['user_id']);
            $profile['basic']['electricIntegerationFlag'] = ($electricIntegerationFlag != '[]');
            if ($companyResult->found_rows > 0) {
                $ca_details  =  json_decode($companyResult->data[0]->details);
                $ca_services = $ca_details->services;
                if ($ca_services) {

                    foreach ($ca_services as $value) {
                        if (strtoupper($value->code) == "PRINT_BONED") {

                            if ($value->value == "e_bond" || $value->value == "e_boned") {
                                $profile['basic']['e_bond_service_status'] = true;
                                $profile['basic']['e_bond_service_message'] = "طباعة الكترونية";
                            }
                            if ($value->value == "manual_bond") {
                                $profile['basic']['e_bond_service_status'] = false;
                                $profile['basic']['e_bond_service_message'] = "الخزانة رقم " .  $value->details->notes;
                            }
                        }
                    }

                    if (isset($ca_details->remarksTemplate)) {
                        if ($ca_details->remarksTemplate && $profile['basic']['action']['remarks_template']['value'] == "true") {
                            $profile['basic']['remarks'] = $ca_details->remarksTemplate;
                        }
                    }
                }

                // check if the ca has black list the print to show the message
                if (
                    $profile['basic']['action'] && $profile['basic']['action']['print_black_list'] &&
                    $profile['basic']['action']['print_black_list']['value'] != "false" &&
                    ($profile['basic']['action']['print_black_list']['value'] == "true" || $profile['basic']['action']['print_black_list']['value'] == true)
                ) {
                    $profile['basic']['e_bond_service_message'] = "تم ايقاف الطباعة من قبل المخلص على هذا البيان";
                }
            }
            parent::response($profile, 200);
        }
    }

    public function updateDeclaration()
    {

        $data = new stdClass();
        $data->id = $this->_request->id; //declaration Id

        $data->consignee_text = $this->_request->consignee_text;
        $data->consignee_phone = $this->_request->consignee_phone;
        $data->remarks = $this->_request->remarks;
        $data->weight = $this->_request->weight;
        $data->policy_number = $this->_request->policy_number;
        $data->jcd_reference = $this->_request->jcd_reference;
        $data->ca_cargo_description = $this->_request->ca_cargo_description;
        $data->discharge_location = $this->_request->discharge_location;
        $data->disable_print = $this->_request->disable_print;
        $data->policy_number = $this->_request->policy_number;
        $data->weight = $this->_request->weight;
        $data->use_remarks_template = $this->_request->use_remarks_template;
        $update = $this->_con->updateDeclaration($data, $_SESSION['user_id']);
        parent::response($update, 200);
    }
    public function searchJCDs()
    {

        $data = new stdClass();
        $data->filter = $this->_request->filter;
        $data->limit = $this->_request->limit;
        $data->offset = $this->_request->offset;

        $jcds = $this->_con->searchJCDs($data, $_SESSION['user_id']);
        parent::response($jcds, 200);
    }

    public function getJCDPermitBarcode()
    {
        $data = new stdClass();
        $data->id = $this->_request->id;
        $data->land_trip_id = $this->_request->land_trip_id;

        $jcds = $this->_con->getJCDPermitBarcode($data, $_SESSION['user_id']);
        parent::response($jcds, 200);
    }
    public function searchCompanyService()
    {
        $data = new stdClass();
        $data->filter = $this->_request->filter;
        $service = $this->_con->searchCompanyService($data, $_SESSION['user_id']);
        parent::response($service, 200);
    }
    public function availableService()
    {
        // search in container system for availabel services provided by SA
        if ($_SESSION['sa_id']) {
            $data = new stdClass();
            $data->land_trip_id = $this->_request->land_trip_id;
            $serviceResult = $this->_con->availableService($data, $_SESSION['user_id']);
        }

        // in case the session is CA , search for available services that can be requested
        if ($_SESSION['ca_id']) {

            $serviceFilter = [
                ['key' => 'status', 'val' => "ACTIVE"],
                ['key' => 'ca_id', 'val' => $_SESSION['ca_id']],
            ];
            $tenderCaQry = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 1, 0, $_SESSION['user_id']);

            $data = new stdClass();
            $data->id = $this->_request->land_trip_id;
            $landTripBean = $this->_con->getLandTrip($data, $_SESSION['user_id']);

            $serviceResult = new stdClass();

            foreach ($tenderCaQry->data as $tenderCaBean) {
                $details = json_decode($tenderCaBean->details);
                $services = $details->services;

                foreach ($services as $service) {
                    if ($service->code == "REQUEST_DEMURRAGE") {
                        $service->description = $service->caption;
                        $service->code = strtoupper($service->code);
                        $service->create_date = null;
                        $service->done_by = null;
                        $service->land_trip_service_date = null;


                        // search if the CID has ticket
                        $filter = array();
                        $filter['type_code'] = 'REQUEST_DEMURRAGE';
                        $filter['status'] = ['NEW', 'COMPLETE'];
                        $filter['data->body->ca_id'] = $_SESSION['ca_id'];
                        $filter['data->body->cid'] = $landTripBean['cid'];
                        $tickets = $this->_customerCare->searchTickets($filter, null, null, null);
                        if (sizeof($tickets['data'])) {
                            $service->create_date = $tickets['data'][0]['created_at'];
                            $service->done_by = $_SESSION['ca_id'];
                            $service->land_trip_service_date = $tickets['data'][0]['created_at'];
                            $service->update_date = $tickets['data'][0]['updated_at'];
                            $service->ticket_id = $tickets['data'][0]['id'];
                        }

                        $serviceResult->filteredServices[] = $service;
                    }
                }
            }
        }

        parent::response($serviceResult, 200);
    }
    public function addServiceToLandTrip()
    {

        // get user params
        $source_account_obj = $this->_request->source_account;
        $source_account_id  = explode('-', $source_account_obj)[0];
        $source_account_sub_id = explode('-', $source_account_obj)[1];
        $revinue_account = $this->_request->target_account;

        // get sourceAccountBean
        $sourceAccountBean = $this->_fps->getAccountBasic($source_account_id . "-" . $source_account_sub_id, $_SESSION["user_id"]);

        // get service details
        $companyServiceData = new stdClass();
        $companyServiceData->code = $this->_request->service_code;
        $serviceBean = $this->_con->getCompanyServiceByCode($companyServiceData, $_SESSION['user_id']);
        $service_amount = json_decode($serviceBean['data'][0]['details'])->amount;

        // get landtrip bean
        $data = new stdClass();
        $data->id = $this->_request->land_trip_id;
        $landTripBean = $this->_con->getLandTrip($data, $_SESSION['user_id']);
        $trx_notes = "تسليم بون للحاوية رقم " . $landTripBean['cid'];

        // if the service is already assigned to cid, throw exception
        $data = new stdClass();
        $serviceFilter = ['land_trip_id' => $this->_request->land_trip_id, 'code' => $this->_request->service_code];
        $data->filter  = $serviceFilter;
        $data->method = "searchLandTripService";
        $end_point = '/landtrip_service';
        $service_res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        if ($service_res['found_rows'] > 0) {
            throw new Exception("الخدمة مضافة مسبقا");
            die;
        } else {



            // add service to land trip
            $data = new stdClass();
            $data->service_code   = $this->_request->service_code;
            $data->land_trip_id   = $this->_request->land_trip_id;
            $data->tn             = $this->_request->tn;
            $data->trn            = $this->_request->trn;
            $data->driver_name    = $this->_request->driver_name;
            $data->nn             = $this->_request->nn;
            $data->driver_phone   = $this->_request->driver_phone;
            $data->driver_id      = $this->_request->driver_id;
            $data->seal_number    = $this->_request->seal_number;
            $data->boned_authorized = $this->_request->boned_authorized;

            try {
                $service = $this->_con->addServiceToLandTrip($data, $_SESSION['user_id']);

                if ($this->_request->service_code == "BOND_DELIVERY" && $this->_request->nn) {
                    //$this->createContainerDischargePoll($landTripBean);
                }

                // if the source account is cash
                if (strtoupper($sourceAccountBean['type'] == "CASH")) {

                    // make sure the cash box is OPEN
                    $cashBoxLogBean = new stdClass();
                    $cashBoxLogBean->filter = ["account_id" => $source_account_id, "sub_id" => $source_account_sub_id];
                    $cashBoxLogBean->limit = 1;
                    $cashBoxLogBean->offset = 0;
                    $cashBoxResult = $this->_fps->getCashBoxLogDetails($cashBoxLogBean, $_SESSION['user_id']);
                    if (
                        $cashBoxResult && $cashBoxResult != "[]" && sizeof($cashBoxResult) &&
                        isset($cashBoxResult[0]['status']) && $cashBoxResult[0]['status'] == "NEW"
                    ) {
                        // allow to continue
                    } else {
                        throw new Exception("لا تستطيع المتابعة ، الصندوق مغلق");
                    }

                    // add the trx
                    if ($this->_request->service_code == "BOND_DELIVERY") {
                        $trx_notes = "تسليم بون للحاوية رقم " . $landTripBean['cid'];
                    }
                    $trxData = new stdClass();
                    $trxData->id = 1;
                    $trxData->source = $source_account_id . "-" . $source_account_sub_id;
                    $trxData->amount = $service_amount;
                    $trxData->target = $revinue_account;
                    $trxData->notes = $landTripBean['cid'];
                    $template = $this->_fps->generateVoucherTrx($trxData, $_SESSION['user_id']);

                    $voucherData = new stdClass();
                    $voucherData->amount  = $trxData->amount;
                    $voucherData->source_account_id = $source_account_id;
                    $voucherData->source_sub_id = $source_account_sub_id;
                    $voucherData->details = new stdClass();
                    $voucherData->voucher_type_code = 'RECEIPT';
                    $voucherData->payment_method_code = 'CASH';
                    $voucherData->jv_template = $template;
                    $voucherData->notes = $trx_notes;
                    $voucherData->due_date = null;
                    $voucherData->integration_details = null;

                    $fields = new stdClass();
                    $fields->voucherData = $voucherData;
                    $fields->proccess_flag = true;
                    $voucher_id = $this->_fps->insertVoucher($fields, $_SESSION['user_id']);
                } else {

                    // create the new trx
                    $trx = [];
                    $ledger_account_id = $source_account_id;
                    $temp = new stdClass();
                    $temp->amount =  $service_amount;
                    $temp->account = $source_account_id . "-" . $source_account_sub_id;
                    $temp->op = 'D';
                    $temp->notes =  $trx_notes;
                    $trx[] = $temp;

                    $temp2 = new stdClass();
                    $temp2->amount =  $service_amount;
                    $temp2->account = $revinue_account;
                    $temp2->op = 'C';
                    $temp2->notes =  $trx_notes;
                    $trx[] = $temp2;
                    $data = new stdClass();
                    $data->ledger_account_id = $ledger_account_id;
                    $data->jv_date = DBConnection::getSystemDate();
                    $data->remarks =  $trx_notes;
                    $data->trx = $trx;

                    $this->_fps->createTrx($data, $_SESSION['user_id']);
                }


                $ca_id = $landTripBean['document']['declaration']['ca']['id'];
                $tender_id = 21;
                $cid = $landTripBean['cid'];
                $trigger = "BOND_DELIVERY";
                $this->_clearingAgentCore->notifyCa($cid, $ca_id, $tender_id, $trigger);

                $result = new stdClass();
                $result->voucher_id = $voucher_id;
                $result->message = 'تمت العملية بنجاح';
                parent::response($result);
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }
    }


    private function createContainerDischargePoll($landTripBean)
    {
        // search for driver user
        $driverFilter = [['key' => 'nn', 'val' => $this->_request->nn], ['key' => 'status', 'val' => "ACTIVE"]];
        $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
        if ($driver_qry->found_rows > 0) {

            //makePullForDischargeReport
            $mainQuestion = "هل أتممت عملية تسليم الحاوية رقم cid ، رقم البون : land_trip_num";
            $pollCargoBean = new stdClass();
            $pollCargoBean->name = $landTripBean['cid'];
            $poll_id =  $this->_cargoCore->makePullForDischargeReport($mainQuestion, $pollCargoBean, "createContainerDischargeReport");

            // activate the poll
            if ($poll_id) {
                $this->_pollIntegration->publishPoll($poll_id);
            }

            // get user and driver bean
            $driverBean = $driver_qry->data[0];
            $userBean = $this->_userCore->getUserBasic($driverBean->user_id, 0);
            $bind_params = [];
            $bind_params['cid'] = $landTripBean['cid'];
            $bind_params['land_trip_num'] = $landTripBean['serial'];
            $bind_params['land_trip_id'] = $landTripBean['id'];

            // append user to poll
            $recipients = [];
            $rec['user_id'] = $driverBean->user_id;
            $rec['bind_params'] = json_encode($bind_params);
            $rec['communication_channels'] = [
                ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1]
            ];
            $recipients[] = $rec;
            $this->_pollIntegration->appendRecipientToPoll($poll_id, $recipients);
        }
    }



    public function deleteServiceFromLandTrip()
    {

        throw new Exception("تم إيقاف هذه الخدمة مؤقتا");

        $data = new stdClass();
        $data->service_code = $this->_request->service_code;
        $data->land_trip_id = $this->_request->land_trip_id;

        $service = $this->_con->deleteServiceFromLandTrip($data, $_SESSION['user_id']);

        parent::response($service);
    }
    public function countDeclarations()
    {
        $data = new stdClass();
        $data->date_from = $this->_request->date_from;
        $data->date_to = $this->_request->date_to;

        $countDeclarations = $this->_con->countDeclarations($data, $_SESSION['user_id']);
        parent::response($countDeclarations);
    }

    public function countContainers()
    {
        $data = new stdClass();
        $data->date_from = $this->_request->date_from;
        $data->date_to = $this->_request->date_to;

        $countContainers = $this->_con->countContainers($data, $_SESSION['user_id']);

        parent::response($countContainers);
    }

    public function clearingAgentsDeclaration()
    {
        $data = new StdClass();
        $clearingAgentsData = [];
        $data->filter = $this->_request->filter;
        $data->limit = 1000;
        $data->offset = $this->_request->offset;
        //get the declarations
        $declarationFilter = [];
        $ca_query = $this->_ca->searchClearingAgent($declarationFilter, 1000, 0, $_SESSION['user_id']);
        foreach ($ca_query->data as  $value) {
            $temp = new stdClass();
            $temp->id = $value->id;
            $temp->name = $value->name;
            $temp->count = 0;
            $clearingAgentsData[] = $temp;
        }
        $declarations = $this->_con->searchDeclarations($data, $_SESSION['user_id']);

        if ($declarations) {

            //save all the id's in new array
            $ca_ids = [];
            foreach ($declarations['data'] as $declaration) {
                $ca_ids[] = $declaration['ca_id'];
            }
            //put the id's in the filter

            //merge the declarations with the names from ca_query
            foreach ($declarations['data'] as &$declaration) {
                foreach ($ca_query->data as $ca) {
                    if ($declaration['ca_id'] == $ca->id) {
                        $declaration['ca_name'] = $ca->name;
                    }
                }
            }
        }
        parent::response($clearingAgentsData);
    }

    public function getChartList()
    {
        $data = new stdClass();
        $list = $this->_con->getChartList($data, $_SESSION['user_id']);
        parent::Response($list);
    }
    public function countServices()
    {
        $data =  new stdClass();
        $data->days = $this->_request->days;
        $list = $this->_con->countServices($data, $_SESSION['user_id']);

        parent::response($list, 200);
    }

    // ---------------------------- Get full information to print Bond --------------------------- //
    public function printBoned()
    {
        $data = new stdClass();
        $data->declaration_id = $this->_request->declaration_id;
        $data->land_trip_id = $this->_request->land_trip_id;


        // get landTripService
        $landTripServiceData = new stdClass();
        $serviceFilter = ['land_trip_id' => $this->_request->land_trip_id, 'code' => "BOND_DELIVERY"];
        $landTripServiceData->filter  = $serviceFilter;
        $landTripServiceData->method = "searchLandTripService";
        $end_point = '/landtrip_service';
        $service_res = $this->_con->callContainer($end_point, $landTripServiceData, $_SESSION['user_id']);

        //if the service has been added for more than 30 mins, throw exception
        if ($service_res['found_rows'] > 0) {
            
            $to_time = strtotime(DBConnection::getSystemDate());
            $from_time = strtotime($service_res['data'][0]['create_date']);
            $print_diff =  round(abs($to_time - $from_time) / 60, 2);

            if ($print_diff > 30) {
                $companyUserRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
                $allow = false;
                foreach ($companyUserRolesArray as $role) {
                    if ($role == 'SA_MANAGER') {
                        $allow = true;
                    }
                }
                if ($allow) {
                    throw new Exception("لا تستطيع طباعة البون بعد مرور 30 دقيقة على تسليمه");
                }
            }
        }


        $landTripInformation = $this->_con->printBoned($data, $_SESSION['user_id']);

        $declarationFilter = [
            ["key" => 'id', "val" => $landTripInformation['ca_id']],
        ];
        $ca_query = $this->_ca->searchClearingAgent($declarationFilter, 1000, 0, $_SESSION['user_id']);
        if ($ca_query->found_rows > 0) {
            $landTripInformation['ca_name'] = $ca_query->data[0]->name;

            $photos = json_decode($ca_query->data[0]->photos);
            $ca_logo = "";
            if ($photos) {
                foreach ($photos as $photo) {
                    if ($photo->type == "logo") {
                        $ca_logo = $photo->url;
                        $landTripInformation['ca_logo'] = $ca_logo;
                    }
                }
            }
        }

        $allTenders = $this->_tenderCore->searchTender([], 1000, 0, 0);
        $tenderIds = [];
        foreach ($allTenders->data as $value) {
            if (json_decode($value->manifest)->tender_code == "CONTAINER_SERVICES") {
                $tenderIds[] = $value->id;
            }
        }

        $companyFilter = [
            ["key" => "tender_id", "val" => $tenderIds, 'op' => 'in'], // TO DOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO :)
            ["key" => "ca_id", "val" => $landTripInformation['ca_id']],
            ["key" => "status", "val" => "ACTIVE"],
        ];
        $companyResult = $this->_ca->searchTenderClearingAgent($companyFilter, 1, 0, $_SESSION['user_id']);


        if ($companyResult->found_rows > 0) {
            $ca_details = json_decode($companyResult->data[0]->details);
            $ca_services = $ca_details->services;

            $has_eboned_service = false;
            if ($ca_services) {
                foreach ($ca_services as $value) {
                    if ($value->code == "PRINT_BONED" &&  ($value->value == "e_bond" || $value->value == "e_boned")) {
                        $has_eboned_service = true;
                    }
                }
            }

            if (!$has_eboned_service) {
                throw new Exception("لا توجد خدمة طباعة الكترونية معرفة لشركة التخليص");
            }

            if ($landTripInformation['remarks_template'] && $ca_details && $ca_details->remarksTemplate) {
                $landTripInformation['remarks'] = $ca_details->remarksTemplate;
                $landTripInformation['remarks'] = str_replace("\n", " ", $landTripInformation['remarks']);
            }

            if ($ca_details && $ca_details->bonedName) {
                $landTripInformation['bonedName'] = $ca_details->bonedName;
            }
        }


        parent::response($landTripInformation, 200);
    }
    public function updateCargoDischargeDetails()
    {
        $data = new stdClass();
        $data->land_trip_id = $this->_request->land_trip_id;
        $data->destination_name = $this->_request->destination_name;
        $data->cargo_phone = $this->_request->cargo_phone;

        $res = $this->_con->updateCargoDischargeDetails($data, $_SESSION['user_id']);
        parent::response($res, 200);
    }

    public function printDeclarationsLandTrip()
    {
        $data = new stdClass();
        $data->declaration_id = $this->_request->declaration_id;
        $res = $this->_con->printDeclarationsLandTrip($data, $_SESSION['user_id']);
        parent::response($res, 200);
    }

    public function updateCargoDestination()
    {
        $data =  new stdClass();
        $data->land_trip_id = $this->_request->land_trip_id;
        $data->destination_name = $this->_request->destination_name;
        $res = $this->_con->updateCargoDestination($data, $_SESSION['user_id']);
        parent::response($res, 200);
    }

    public function getCustomsCenters()
    {
        $data =  new stdClass();
        $cc = [];
        $res = $this->_con->getCustomsCenters($data, $_SESSION['user_id']);
        foreach ($res as  $value) {
            $cc[] = ['value' => $value['id'], 'label' => $value['name']];
        }

        parent::response($cc, 200);
    }


    // get list of land trips charts
    public function getLandTripsCharts()
    {

        // based on session role, return the correct
        $result = [
            ["code" => "IncomeByService", "width" => "4"],
            ["code" => "ServiceComparasionDate", "width" => "4"],
            ["code" => "ServicesByCa", "width" => "4"],
            ["code" => "CashFlow", "width" => "8"],
            ["code" => "ServiceSummery", "width" => "4"],
            ["code" => "NumberOfDeclerations", "width" => "6"],
            ["code" => "NumberOfContainers", "width" => "6"],
        ];

        parent::response($result);
    }

    // get list of land trips charts
    public function getLandTripsCharts2()
    {

        // based on session role, return the correct
        $result = [
            ["code" => "IncomeByService", "width" => "4"],
            ["code" => "ServiceComparasionDate", "width" => "8"],
            ["code" => "ServicesByCa", "width" => "4"],
            //  ["code" => "CashFlow", "width" => "8"],
            //  ["code" => "ServiceSummery", "width" => "4"],
            ["code" => "NumberOfDeclerations", "width" => "4"],
            ["code" => "NumberOfContainers", "width" => "4"],
        ];

        parent::response($result);
    }
    public function fix_land_trip_service()
    {
        $data = new stdClass();

        $res = $this->_con->fix_land_trip_service($data, $_SESSION['user_id']);
        parent::response($res);
    }

    public function addLandTripFromManualAdd()
    {
        $data = new stdClass();
        $data->cid  = $this->_request->cid;
        $data->declaration_number = $this->_request->declaration_number;
        $data->bl = $this->_request->bl;
        $data->method = "addLandTripFromManualAdd";

        $end_point = '/declaration';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }

    public function searchLandTripsForManualAdd()
    {
        $data = new stdClass();
        $data->cid  = $this->_request->cid;
        $data->declaration_number = $this->_request->declaration_number;
        $data->bl = $this->_request->bl;
        $data->method = "searchLandTripsForManualAdd";
        $end_point = '/declaration';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }

    public function countServicesWeekly()
    {
        $data = new stdClass();
        $data->date_from = $this->_request->date_from;
        $data->date_to   = $this->_request->date_to;
        $data->interval  =  $this->_request->interval;
        $data->method    = "countServicesWeekly";
        $end_point = '/landtrip_service';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }
    public function bonedServiceByCa()
    {
        $data = new stdClass();
        $data->days = $this->_request->days;
        $data->limit  = $this->_request->limit;
        $data->ca_id = $_SESSION['ca_id'];
        $data->method    = "bonedServiceByCa";
        $end_point = '/landtrip_service';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }
    public function updateBonedInfo()
    {
        $data = new stdClass();
        $data->land_trip_id = $this->_request->land_trip_id;
        $data->driver_name   = $this->_request->driver_name;
        $data->driver_nn   = $this->_request->nn;
        $data->driver_phone   = $this->_request->driver_phone;
        $data->method    = "updateBonedInfo";
        $end_point = '/landtrip';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }

    public function getGrnsBulkWbls()
    {
        $res = $this->_mg->getGrnsBulkWbls('new');
        parent::response($res);
    }

    public function sendEmail()
    {
        $data = new stdClass();
        $data->date_from = $this->_request->date_from;
        $data->date_to   = $this->_request->date_to;
        $data->method = "sendEmail";
        $end_point = '/landtrip_service';
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }
    public function autoCompleteCa()
    {
        $data = new stdClass();
        $data->num = $this->_request->num;
        $data->method = "autoCompleteCa";
        $end_point =  "/declaration";

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }


    public function stackChartApprovedServices()
    {
        $data = new stdClass();
        $data->days = $this->_request->days;
        $data->limit = $this->_request->limit;
        $data->method = "stackChartApprovedServices";
        $end_point =  "/landtrip_service";
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }
    public function getRawJcdActCaInfo()
    {
        $data = new stdClass();
        $data->ca_id = $this->_request->ca_id;
        $data->method = "getRawJcdActCaInfo";
        $end_point =  "/jcd";
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }
    // get containers with clearing agents to send email
    public function getCaContainersWithEmail()
    {

        $data = new stdClass();
        $data->date_from = $this->_request->date_from;
        $data->date_to = $this->_request->date_to;
        $data->method = "getCaContainersWithEmail";
        $end_point =  "/landtrip_service";
        $land_trips_services = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        $ca_query = $this->_ca->searchClearingAgent(
            [
                ['key' => 'id', 'val' => $land_trips_services['ca_ids'], 'op' => 'in']
            ],
            1000,
            0,
            $_SESSION['user_id']
        );
        foreach ($ca_query->data as  $value) {
            $temp = new stdClass();

            $temp->id    = $value->id;
            $temp->name  = $value->name;
            $temp->email = $value->email;
            foreach ($land_trips_services['containers'] as  &$container) {
                if ($temp->id == $container['ca_id']) {
                    $container['ca_name']  = $temp->name;
                    $container['email'] = $temp->email;
                }
            }
        }
        parent::response($land_trips_services);
        die;
    }

    /**
     * getContainerRawData
     *
     * @return container raw data
     */
    public function getContainerRawData()
    {
        $search  = $this->_request->search;


        $data = new stdClass();
        $data->search = $search;
        $data->method = "getContainerRawData";
        $end_point =  "/declaration";
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        $ca_info = $res['ca'];
        $searchFilterCa = [];
        if (strpos($ca_info, '-') > 1) {
            $searchFilterCa[] = ['key' => 'reference_number', 'val' => $ca_info];
        } else
            $searchFilterCa[] = ['key' => 'id', 'val' => $ca_info];

        $ca = $this->_ca->searchClearingAgent($searchFilterCa, 10, 0, $_SESSION['user_id']);
        if ($ca) {


            $ca_data = new stdClass();
            $ca_data->id = $ca->data[0]->id;
            $ca_data->name = $ca->data[0]->name;
            $ca_data->reference_number = $ca->data[0]->reference_number;
            if ($res['ca_raw']) {
                $ca_data->jcd_id = $res['ca_raw'][0]['jcd_id'];
                $ca_data->jcd_code = $res['ca_raw'][0]['jcd_code'];
            }

            $res['ca'] = $ca_data;
        } else {
            $res['ca'] = ['الحالة ' => 'لم نتمكن من العثور على مخلص '];
            $res['ca_raw'] = ['الحالة ' => 'لم نتمكن من العثور على مخلص '];
        }
        parent::response($res);
    }


    //  التعليمات المخلص
    public function storeActions()
    {
        $data = new stdClass();
        $data->declaration_id = $this->_request->declaration_id;

        // black list
        $print_black_list_value = $this->_request->print_black_list_value;

        // print and handle
        $print_and_handle_value = $this->_request->print_and_handle_value;
        $other_attachment_value = $this->_request->other_attachment_value;
        $other_attachment_url = $this->_request->other_attachment_url;
        $remarks_template = $this->_request->use_remark_template;
        if (!$print_and_handle_value) {
            $print_and_handle_value = "false";
        }
        if (!$other_attachment_value) {
            $other_attachment_value = "false";
        }


        $data->action_array = [
            'print_black_list' => [
                "code"   => 'print_black_list',
                'caption' => 'منع طباعة البون من قبل المخلص',
                'value'  => $print_black_list_value,
                'details' => null
            ],
            'print_and_handle' => [
                "code"   => 'print_and_handle',
                'caption' => 'تسليم السائق النسخة الورقية من البيان',
                'value'  => $print_and_handle_value,
                'details' => [
                    'agrrement'  => [
                        "has_agreement" => "true",
                        "has_agreement_message" => "أُقر بتسلم البيان الورقي للسائق",
                    ]
                ]
            ],
            'other_attachment' => [
                "code"   => 'other_attachment',
                'caption' => 'تسليم السائق نسخة مطبوعة من المرفقات',
                'value'  => $other_attachment_value,
                'details' => [
                    'attachment_url' => $other_attachment_url,
                    'agrrement'  => [
                        "has_agreement" => "true",
                        "has_agreement_message" => "أُقر بتسلم نسخة مطبوعة من المرفقات",
                    ]
                ]
            ],
            'remarks_template' => [
                'code' => "remarks_template",
                'caption' => "استخدام نموذج الملاحظات",
                'value' => $remarks_template,
                'details' => null
            ]
        ];

        $data->method = "storeActions";
        $end_point =  "/declaration";
        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = "تمت اضافة التعليمات بنجاح";
        parent::response($Result);
    }


    public function getDeclarationActions()
    {
        $data = new stdClass();

        // get declaration
        $data = new stdClass();
        $data->declaration_id = $this->_request->declaration_id;
        $data->method = "getDeclarationBean";
        $end_point =  "/declaration";

        $dec = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        $actions = $dec['details']['actions'];

        // get tender ca
        $serviceFilter = [
            ['key' => 'tender_id', 'val' => "21"],
            ['key' => 'status', 'val' => "ACTIVE"],
            ['key' => 'ca_id', 'val' => $dec['ca_id']],
        ];

        $tenderCaQry = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderCaQry->data[0]) {
            $detailsJSON = $tenderCaQry->data[0]->details;
            $details = json_decode($detailsJSON);

            if ($details && $details->services) {
                foreach ($details->services as $ser) {
                    if (strtoupper($ser->code) == "PRINT_BONED" && ($ser->value == "e_bond" || $ser->value == "e_boned")) {

                        $newAction = [];
                        $newAction['code'] = 'e_bond';
                        $newAction['value'] = 'true';
                        $newAction['caption'] = 'تسليم السائق نسخة ورقية من البون الإلكتروني';
                        $newAction['details']['agrrement'] = [
                            "has_agreement" => "true",
                            "has_agreement_message" => 'تسليم السائق نسخة ورقية من البون الإلكتروني'
                        ];
                        $actions[] = $newAction;
                    }
                }
            }
        }

        parent::response($actions);
    }
    // -------------------------------------------------------------------------- //
    // ----------- Create New ticket for request demurrage by ca  --------------- //
    // -------------------------------------------------------------------------- //
    public function createRequestDemurrageTicket()
    {
        $cid   = $this->_request->cid;
        $ca_id = $this->_request->ca_id;
        $ca_name = $this->_request->ca_name;
        $sl_name = $this->_request->sl_name;
        $declaration_number = $this->_request->declaration_number;
        $actions = $this->_request->actions;
        $remarks = $this->_request->remarks;
        $land_trip_id = $this->_request->land_trip_id;
        $attachments = $this->_request->attachments;
        $tender_id = "21";

        $sessionObj = parent::getSession($_SESSION['user_id']);
        $sessionObj = json_decode(json_encode($sessionObj), true);
        $details = json_decode($sessionObj['details']);

        $user_id = $details->id;

        $ticket = new stdClass();
        $ticket->title = "طلب دفع اعطال";
        $ticket->senderName = "مدارج للخدمات اللوجستية";
        $ticket->type_code = "REQUEST_DEMURRAGE";
        $ticket->priority = 3;
        $ticket->company_id = $_SESSION['company_id'];
        $ticket->type = "CLIENT";
        $ticket->body = [
            "cid" => $cid,
            "ca_id" => $ca_id,
            "ca_name" => $ca_name,
            "sl_name" => $sl_name,
            "declaration_number" => $declaration_number,
            "actions" => $actions,
            "remarks" => $remarks,
            "land_trip_id" => $land_trip_id,
            "attachments" => $attachments,
            "tender_id" => $tender_id,
            "user_id" => $user_id
        ];

        $res = $this->_customerCare->createTicket($ticket);
        // dump($res);die;
        // $msg = "تم تقديم طلب دفع أعطال للحاوية رقم ".$cid . " ,رقم المعاملة ".$res['id'];
        // $userBean = $this->_userCore->getUserBasic($user_id, 0);
        // $user_phone = $userBean->phone_array[0]->phone;

        // sendSMS($user_phone,' : '.$msg);
        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = "تم انشاء طلب دفع اعطال للحاوية رقم $cid بنجاح";
        parent::response($Result);
    }

    /**
     *  This funciton for saving landtrip coordinates
     *  params: latt,long  radius is nullable default is 2km
     */
    public function updateLandTripDeliveryCoordinate()
    {
        // get data from user
        $long   = $this->_request->long;
        $latt   = $this->_request->latt;
        $radius = $this->_request->radius;
        $land_trip_id = $this->_request->land_trip_id;
        $declaration_id = $this->_request->declaration_id;
        // calll container
        $data = new stdClass();
        $data->long   = $long;
        $data->latt   = $latt;
        $data->radius = $radius;
        $data->land_trip_id = $land_trip_id;
        $data->declaration_id = $declaration_id;
        $data->method = 'updateLandTripDeliveryCoordinate';
        $end_point = '/landtrip';

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }


    public function getLandTripDeliveryCoordinate()
    {

        $land_trip_id   = $this->_request->land_trip_id;
        $declaration_id = $this->_request->declaration_id;

        // calll container
        $data = new stdClass();

        $data->land_trip_id   = $land_trip_id;
        $data->declaration_id = $declaration_id;
        $data->method = 'getLandTripDeliveryCoordinate';
        $end_point = '/landtrip';

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }

    public function getLandTripDeliveryReport()
    {
        $land_trip_id = $this->_request->land_trip_id;
        $declaration_id = $this->_request->declaration_id;
        // calll container
        $data = new stdClass();

        $data->land_trip_id   = $land_trip_id;
        $data->declaration_id = $declaration_id;
        $data->method = 'getLandTripDeliveryReport';
        $end_point = '/landtrip';

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }
    public function setLandTripDeliveryReport()
    {
        $land_trip_id    = $this->_request->land_trip_id;
        $location_name   = $this->_request->location_name;
        $delivery_images = $this->_request->delivery_images;
        $discharge_date  = $this->_request->discharge_date;

        $long  = $this->_request->long;
        $latt   = $this->_request->latt;
        // calll container
        $data = new stdClass();

        $data->land_trip_id    = $land_trip_id;
        $data->location_name   = $location_name;
        $data->location_point  = ['long' => $long, 'latt' => $latt];
        $data->discharge_date  = $discharge_date;
        $data->delivery_images = $delivery_images;

        $data->method = 'setLandTripDeliveryReport';
        $end_point = '/landtrip';

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

        parent::response($res);
    }
    public function resetDeclarationLandTrip()
    {
        $land_trip_id = $this->_request->land_trip_id;
        $data = new stdClass();

        $data->land_trip_id = $land_trip_id;

        $data->method = 'resetDeclarationLandTrip';
        $end_point = '/landtrip';

        $res = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);
        parent::response($res);
    }
}

new Container_interface();
