<?php
error_reporting(E_ERROR | E_ALL);

// import required classes
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/company_employee_core.php");


class Company_employee_interface extends API
{

    // the request of each call
    private $_request = array();

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();
        DBConnection::getInstance();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        //init obj
        $this->_userCore = new UserCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();

        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest()
    {
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int)method_exists($this, $func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found', 404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // ---------------------------------------------------------------------------------- //
    // -------------------Create company Employee bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------------- //
    public function getCompanyEmployee()
    {

        // get the company employee info
        $employeeBean = $this->_companyEmployeeCore->getCompanyEmployee($this->_request->id, $_SESSION['user_id']);
        $employeeBean = json_decode($employeeBean);

        // get roles
        $searchFilter = [
            ['key' => 'company_employee_id', 'val' => $employeeBean->id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $roles = $this->_companyEmployeeCore->searchCompanyEmployeeRoles($searchFilter, 100, 0, 0);

        $employeeBean->roles = $roles->data;

        // get user info
        $userBeanRaw = $this->_userCore->getUserBasic($employeeBean->user_id, 0);
        $userBean = new stdClass();
        $userBean->phone = $userBeanRaw->phone;
        $userBean->photo = null;
        if ($userBeanRaw->photos) {
            foreach ($userBeanRaw->photos as $photo) {
                if ($photo->type == "personal_photo") {
                    $userBean->photo = $photo->url;
                }
            }
        }
        $result = [];
        $result['employeeBean'] = $employeeBean;
        $result['userBean'] = $userBean;
        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------- search for a all employees for a certain company  ------------------------ //
    // ---------------------------------------------------------------------------------------- //
    public function searchCompanyEmployee()
    {

        // call the core search
        $searchFilter = $this->prepareFilter();
        $searchFilter[] = ['key' => 'status', 'val' => 'ACTIVE'];

        $users_qry = $this->_companyEmployeeCore->searchCompanyEmployee(
            $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // get more info about each employee
        $result = [];
        foreach ($users_qry->data as $user) {
            $userBeanRaw =  $this->_userCore->getUserBasic($user->user_id, 0);
            $userBean = new stdClass();
            $userBean->id = $user->id;
            $userBean->name = $userBeanRaw->name;
            $userBean->phone = $userBeanRaw->phone;
            $userBean->email = $userBeanRaw->phone_array[0]->email;
            $userBean->account_ids = json_decode($user->account_ids);
            if ($userBeanRaw->photos) {
                foreach ($userBeanRaw->photos as $photo) {
                    if ($photo->type == "personal_photo") {
                        $userBean->photo = $photo->url;
                    }
                }
            }
            $userBean->nn = $userBeanRaw->nn;
            array_push($result, $userBean);
        }

        $finalResult = new stdClass();
        $finalResult->data = $result;
        parent::response($finalResult);
    }
    // prepare any json filter 
    private function prepareFilter()
    {
        $searchFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == 'name' || $key == 'role') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => "LIKE"];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($searchFilter, $tempArr);
            }
        }
        return $searchFilter;
    }


    // ------------------------------------------------------------------------------------------------ //
    // ------------- search for a certain user in order to add him to company  ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function createCompanyEmployeeAndRoles()
    {

        if (!$this->_request->user_id) {
            throw new Exception("user_id is required");
        }
        if (!$this->_request->company_id) {
            throw new Exception("company_id is required");
        }
        if (!$this->_request->name) {
            throw new Exception("name is required");
        }

        if (!$this->_request->roles) {
            throw new Exception("role_code is required");
        }

        $companyEmployeeBean = new stdClass();
        $companyEmployeeBean->user_id = $this->_request->user_id;
        $companyEmployeeBean->company_id = $this->_request->company_id;
        $companyEmployeeBean->name = $this->_request->name;
        if (gettype($this->_request->roles) == "string") {
            $companyEmployeeBean->roles = json_decode($this->_request->roles);
        } else {
            $companyEmployeeBean->roles = $this->_request->roles;
        }


        $new_employee = $this->_companyEmployeeCore->createCompanyEmployeeAndRoles($companyEmployeeBean, $_SESSION['user_id']);

        // $userInfo = $this->_userCore->searchUser($searchFilter,1,0,0);
        parent::response($new_employee);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------- search for a certain user in order to add him to company  ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function autoCompleteCompanyEmployee()
    {

        $nn = $this->_request->nn;
        $phone = $this->_request->phone;
        $phone = convertToInternational($phone);

        $searchFilter = [
            ['key' => 'phone', 'val' => $phone],
            ['key' => 'nn', 'val' => $nn],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];

        $userInfo = $this->_userCore->searchUser($searchFilter, 1, 0, 0);
        parent::response($userInfo);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------- get a list of all company employee roles  ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function getCompanyEmployeeRoles()
    {
        $roles =  ['TC_MANAGER', 'TC_DATA_ENTRY', 'PA_MANAGER', 'PA_ACCOUNTANT', 'PA_AUDITOR', 'PA_TELLER'];

        parent::response($roles);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------- change status of  company employee role ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function changeRoleStatus()
    {
        if (!$this->_request->id) {
            throw new Exception("id is required");
        }
        if (!$this->_request->new_status) {
            throw new Exception("new status is required");
        }
        // to validate who is doing that
        $roleSearchFilter = [
            ['key' => 'id', 'val' => $this->_request->id],
        ];
        $role = $this->_companyEmployeeCore->searchCompanyEmployeeRoles($roleSearchFilter, 1000, 0, $_SESSION['user_id']);
        $company_employee_id = $role->data[0]->company_employee_id;
        $user = $this->_companyEmployeeCore->getCompanyEmployee($company_employee_id, $_SESSION['user_id']);
        $user_id = json_decode($user)->user_id;

        if ((int) $_SESSION['u_id'] ==  $user_id) {
            throw new Exception("لا يمكنك القيام بهذه العملية");
        }

        try {
            $id = $this->_request->id;
            $new_status = $this->_request->new_status;
            $this->_companyEmployeeCore->changeRoleStatus($id, $new_status, $_SESSION['user_id']);
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "COMPANY.EMPLOYEE.ROLE.SUCCESS_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw $e;
        }
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------- change status of company employee------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function changeEmployeeStatus()
    {
        if (!$this->_request->id) {
            throw new Exception("id is required");
        }
        if (!$this->_request->new_status) {
            throw new Exception("new status is required");
        }
        try {
            $id = $this->_request->id;
            $new_status = $this->_request->new_status;
            $this->_companyEmployeeCore->changeEmployeeStatus($id, $new_status, $_SESSION['user_id']);
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "COMPANY.EMPLOYEE.SUCCESS_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw $e;
        }
    }

    // ------------------------------------------------------------------------------------------------ //
    // ------------- change status of company employee------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function createCompanyEmployeeRole()
    {
        try {
            $company_employee_bean = new stdClass();
            $company_employee_id = $this->_request->company_employee_id;
            $role_code = $this->_request->role_code;

            $create_date = DBConnection::getSystemDate();
            $company_employee_bean->company_employee_id = $company_employee_id;
            $company_employee_bean->role_code = $role_code;
            $company_employee_bean->create_date = $create_date;
            $companyEmployeeId = $this->_companyEmployeeCore->createCompanyEmployeeRole($company_employee_bean, $_SESSION['user_id']);
            $Result['ERRORCODE'] = "0";
            $Result['COMPANY_EMPLOYEE_ID'] = $companyEmployeeId;
            $Result['MESSAGE'] = "COMPANY.EMPLOYEE.ROLE.SUCCESS_CREATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw $e;
        }
    }


    // ------------------------------------------------------------------------------------------------ //
    // ------------- change status of company employee------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function saveAccountAuthForEmployee()
    {
        try {
            $company_employee_ids = $this->_request->company_employee_ids;
            $account_id = $this->_request->account_id;
            $this->_companyEmployeeCore->saveAccountAuthForEmployee($company_employee_ids, $account_id, $_SESSION['user_id']);
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "COMPANY.EMPLOYEE.UPDATE.SUCCESS";
            parent::response($Result);
        } catch (Exception $e) {
            throw $e;
        }
    }


    // ------------------------------------------------------------------------------------------------ //
    // -------------  get list of company roles Hierarchy ----------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getCompanyEmployeeRoleHierarchy()
    {

        $first2Char = substr($_SESSION['COMPANY_EMPLOYEE_ROLES'], 0, 2);
        $first5Char = substr($_SESSION['COMPANY_EMPLOYEE_ROLES'], 0, 5);
 
        // if the role is SA
        if ($first2Char == "SA") {
            $result = [
                ["label" => "محاسب", "code" => "SA_ACCOUNTANT"],
                ["label" => "مسؤول موقع", "code" => "SA_SUPERVISOR"],
                ["label" => "مدخل بيانات", "code" => "SA_TELLER"]
            ];
        }

        // if the role is CA
        if ($first2Char == "CA") {
            $result = [
                ["label" => "مدير", "code" => "CA_MANAGER"],
                ["label" => "موظف عمليات", "code" => "CA_OPERATION"],
                ["label" => "مدقق", "code" => "CA_AUDITOR"]
            ];
        }

        if ($first5Char == "PA_FPS") {
            $result = [
                ["label" => "مدقق", "code" => "PA_FPS_AUDITOR"],
                ["label" => "مدير مكتب", "code" => "PA_FPS_MANAGER"],
                ["label" => "موظف صرف", "code" => "PA_FPS_TELLER"]
            ];
        }

        // if the role is PA
        if ($first2Char == "PA" && $first5Char != "PA_FPS") {
            $result = [
                ["label" => "محاسب", "code" => "PA_ACCOUNTANT"],
                ["label" => "مدخل بيانات", "code" => "PA_TELLER"]
            ];
        }

        parent::response($result);
    }
}



new Company_employee_interface();
