<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . '/../../includes/util.php');
require_once(dirname(__FILE__) . '/../../core/user/user_core.php');
require_once(dirname(__FILE__) . '/../../core/service_agent/service_agent_core.php');
require_once(dirname(__FILE__) . '/../../core/cargo_agent/cargo_agent_core.php');

class CompanyEmployeeCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }


    // ---------------------------------------------------------------------------------- //
    // -------------------Create company Employee bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------------- //
    public function getCompanyEmployee($id, $user_id)
    {

        $companyEmployeeInfo = DBConnection::getObjectBean("company_employee", $id, $user_id);
        if ($companyEmployeeInfo == null) {
            throw new Exception("USER.NOT_EXIST", 0);
        }
        return $companyEmployeeInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create User bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getCompanyEmployeeBasic($id, $user_id)
    {

        $companyEmployeeBean = DBConnection::getBasicObjectBean("company_employee", $id, $user_id);
        return $companyEmployeeBean;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for users using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchCompanyEmployee($searchFilter, $limit, $offset, $user_id)
    {

        $searchCompanyEmployeeResult = DBConnection::searchDB("company_employee", $searchFilter, $limit, $offset, $user_id);
        return $searchCompanyEmployeeResult;
    }

    // --------------------------------------------------------------------------------------- //
    // -------------------search for certain employee roles using any search filter ---------- //
    // --------------------------------------------------------------------------------------- //
    public function searchCompanyEmployeeRoles($searchFilter, $limit, $offset, $user_id)
    {

        $searchCompanyEmployeeResult = DBConnection::searchDB("company_employee_role", $searchFilter, $limit, $offset, $user_id);
        return $searchCompanyEmployeeResult;
    }


    // ----------------------------------------------------------------------------------- //
    // ------------- search the company EMployee profile info , roles, beans and wf --------------------- //
    // ----------------------------------------------------------------------------------- //
    public function searchCompanyEmployeeProfile($company_id, $u_id, $user_id)
    {

        // init objects
        $userCore = new UserCore();
        $truckOwnerCore = new TruckOwnerCore();
        $clearingAgentCore = new ClearingAgentCore();
        $paymentAgentCore = new PaymentAgentCore();
        $serviceAgentCore = new ServiceAgentCore();
        $truckingCompanyCore = new TruckingCompanyCore();
        $cargoAgentCore = new CargoAgentCore();

        // search company employee record        
        $searchFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'user_id', 'val' => $u_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];

        $employeeInfo = $this->searchCompanyEmployee($searchFilter, 1, 0, 0);
        if ($employeeInfo->found_rows == 0) {
            throw new Exception("searchCompanyEmployeeProfile user is not an employee of the company");
        }

        // get company employee roles
        $roleSearchFilter = [
            ['key' => 'company_employee_id', 'val' => $employeeInfo->data[0]->id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $rolesRaw = $this->searchCompanyEmployeeRoles($roleSearchFilter, 1000, 0, 0);
        $roles = [];
        foreach ($rolesRaw->data as $r) {
            $roles[] = $r->role_code;
        }
        $roles = implode(",", $roles);

        // get user Bean       
        $u_id = DBConnection::getUserIdFromSession($user_id);
        $userBean = $userCore->getUserBasic($u_id, $user_id);

        // get truck_owner info
        $truck_ownerFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];

        $truckOwnerQuery = $truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0);
        $truck_owner_info = $truckOwnerQuery->data[0];

        // get ca info
        $caFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $truckOwnerQuery = $clearingAgentCore->searchClearingAgent($caFilter, 1, 0, 0);
        $ca_info = $truckOwnerQuery->data[0];

        // get pa info
        $paFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $paQuery = $paymentAgentCore->searchPaymentAgents($paFilter, 1, 0, 0);
        $pa_info = $paQuery->data[0];

        // get sa info
        $saFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $saQuery = $serviceAgentCore->searchServiceAgents($saFilter, 1, 0, 0);
        $sa_info = $saQuery->data[0];

        // get tc info
        $tcFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $tcQuery = $truckingCompanyCore->searchTruckingCompany($tcFilter, 1, 0, 0);
        $tc_info = $tcQuery->data[0];


        // get co info (Cargo Owner)
        $coFilter = [
            ['key' => 'company_id', 'val' => $company_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $coQuery = $cargoAgentCore->searchCargoAgent($coFilter, 1, 0, 0);
        $co_info = $coQuery->data[0];

        // format data
        $Result = [];
        $Result['company_employee_role'] = $roles;
        $Result['company_employee_info'] = $employeeInfo->data[0];
        $Result['truck_owner_info'] = $truck_owner_info;
        $Result['ca_info'] = $ca_info;
        $Result['pa_info'] = $pa_info;
        $Result['sa_info'] = $sa_info;
        $Result['tc_info'] = $tc_info;
        $Result['co_info'] = $co_info;
        $Result['user_info'] = $userBean;

        return $Result;
    }

    // ----------------------------------------------------------------------------------- //
    // ------------- get the company EMployee profile info , roles, beans and wf --------------------- //
    // ----------------------------------------------------------------------------------- //
    public function getCompanyEmployeeProfile($company_employee_id, $user_id)
    {

        // search company employee record        
        $employeeInfo = $this->getCompanyEmployeeBasic($company_employee_id, 0); // FIX THIS
        if (!$employeeInfo) {
            throw new Exception("user is not an employee of the company");
        }

        // get company employee roles
        $roleSearchFilter = [
            ['key' => 'company_employee_id', 'val' => $employeeInfo->id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $rolesRaw = $this->searchCompanyEmployeeRoles($roleSearchFilter, 1000, 0, 0);
        $roles = [];

        foreach ($rolesRaw->data as $r) {
            $roles[] = $r->role_code;
        }
        $roles = implode(",", $roles);

        $userCore = new UserCore();
        $u_id = $employeeInfo->user_id;
        $userBean = $userCore->getUserBasic($u_id, 0);

        // get corporate WF
        $wf_result = DBConnection::getCompanyEmployeeWF($company_employee_id);
        $companyProfile = $this->searchCompanyEmployeeProfile($employeeInfo->company_id, $employeeInfo->user_id, $user_id);

        $Result = [];
        $Result['company_employee_role'] = $roles;
        $Result['company_employee_info'] = json_encode($employeeInfo, JSON_UNESCAPED_UNICODE);
        $Result['truck_owner_info'] = null;         // TODO
        $Result['ca_info'] = $companyProfile['ca_info'] ? json_encode($companyProfile['ca_info'], JSON_UNESCAPED_UNICODE) : null;
        $Result['sa_info'] = $companyProfile['sa_info'] ? json_encode($companyProfile['sa_info'], JSON_UNESCAPED_UNICODE) : null;                  // TODO
        $Result['USER_BEAN'] = json_encode($userBean, JSON_UNESCAPED_UNICODE);
        $Result['WF'] = $wf_result;
        $Result['USER_ROLES'] = $roles;

        return $Result;
    }


    // --------------------------------------------------------------------------------- //
    // ------------- create new company employee for a certain user and roles--------------------- //
    // --------------------------------------------------------------------------------- //
    public function createCompanyEmployeeAndRoles($companyEmployeeBean, $user_id)
    {

        try {


            // inject the account_ids to be * in case he has auth to create account
            foreach ($companyEmployeeBean->roles as $role) {
                if (hasAuth('ACCOUNT', 'CREATE', 'NEW', 'NEW', $role)) {
                    $account_ids = ['*'];
                }
            }

            $create_date = DBConnection::getSystemDate();
            // first create the employee
            $employee = new stdClass();
            $employee->company_id = $companyEmployeeBean->company_id;
            $employee->user_id = $companyEmployeeBean->user_id;
            $employee->name = $companyEmployeeBean->name;
            $employee->create_date = $create_date;
            $employee->account_ids = $account_ids;
            $company_employee_id = $this->createCompanyEmployee($employee, $user_id);

            // to create roles for the created employee
            foreach ($companyEmployeeBean->roles as $role) {
                $createdEmployee = new stdClass();
                $createdEmployee->company_employee_id = $company_employee_id;
                $createdEmployee->role_code = $role;
                $createdEmployee->create_date = $create_date;
                $roles = $this->createCompanyEmployeeRole($createdEmployee, $user_id);
            }

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "COMPANY.EMPLOYEE.SUCCESS_CREATE";
            return  $Result;
        } catch (Exception $e) {
            throw $e;
        }
    }


    // --------------------------------------------------------------------------------- //
    // ------------- create new company employee for a certain user--------------------- //
    // --------------------------------------------------------------------------------- //
    public function createCompanyEmployee($companyEmployeeBean, $user_id)
    {

        //validate companyEmployeeBean
        $this->validatecompanyEmployeeBeanForCreate($companyEmployeeBean, $user_id);

        // create the company_employee
        $createCompanyEmployeeResult = DBConnection::insertDB("company_employee", $companyEmployeeBean, $user_id);
        $company_employee_id =  $createCompanyEmployeeResult[0]['@id'];
        // check for authority to change status
        $autoAction = getAutoAction('COMPANY_EMPLOYEE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->changeEmployeeStatus($company_employee_id, 'ACTIVE', $_SESSION['user_id']);
        }
        return $company_employee_id;
    }

    // ---------------------------------------------------------------------------- //
    // ------------- validate adding new company employee record ------------------ //
    // ---------------------------------------------------------------------------- //
    public function validatecompanyEmployeeBeanForCreate($companyEmployeeBean, $user_id)
    {

        $searchFilter = [
            ['key' => 'company_id', 'val' => $companyEmployeeBean->company_id],
            ['key' => 'user_id', 'val' => $companyEmployeeBean->user_id],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
        ];
        $employees = $this->searchCompanyEmployee($searchFilter, 10000, 0, 0);

        if (sizeof($employees->data) > 0) {
            throw new Exception("الموظف مسجل مسبقا");
        }
    }



    // -------------------------------------------------------------------------------------- //
    // ------------- create new company employee role for a certain user--------------------- //
    // -------------------------------------------------------------------------------------- //
    public function createCompanyEmployeeRole($companyEmployeeRoleBean, $user_id)
    {
        //validate companyEmployeeRoleBean
        $this->validatecompanyEmployeeRoleBeanForCreate($companyEmployeeRoleBean, $user_id);

        // validate if the role created before
        $is_role_exist = $this->validatecompanyEmployeeRoleBeanIfExist($companyEmployeeRoleBean, $user_id);

        if (sizeof($is_role_exist) > 0) {
            $this->changeRoleStatus($is_role_exist[0]->id, 'ACTIVE', $_SESSION['user_id']);
            return;
        }
        // create the company_employee
        $createCompanyEmployeeRoleResult = DBConnection::insertDB("company_employee_role", $companyEmployeeRoleBean, $user_id);
        $company_employee_role_id =  $createCompanyEmployeeRoleResult[0]['@id'];
        // check for authority to change status
        $autoAction = getAutoAction('COMPANY_EMPLOYEE_ROLE', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->changeRoleStatus($company_employee_role_id, 'ACTIVE', $_SESSION['user_id']);
        }

        return $company_employee_role_id;
    }

    // --------------------------------------------------------------------------------- //
    // ------------- validate adding new company employee role record ------------------ //
    // --------------------------------------------------------------------------------- //
    public function validatecompanyEmployeeRoleBeanForCreate($companyEmployeeBean, $user_id)
    {
        $searchFilter = [
            ['key' => 'company_employee_id', 'val' => $companyEmployeeBean->company_employee_id],
            ['key' => 'role_code', 'val' => $companyEmployeeBean->role_code],
            ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
        ];

        $roles = $this->searchCompanyEmployeeRoles($searchFilter, 10000, 0, $user_id);

        if (sizeof($roles->data) > 0) {
            throw new Exception("الصلاحية مضافة مسبقا");
        }
    }

    // --------------------------------------------------------------------------------- //
    // ------------- validate if company employee role record exist ------------------ //
    // --------------------------------------------------------------------------------- //
    public function validatecompanyEmployeeRoleBeanIfExist($companyEmployeeBean, $user_id)
    {
        $searchFilter = [
            ['key' => 'company_employee_id', 'val' => $companyEmployeeBean->company_employee_id],
            ['key' => 'role_code', 'val' => $companyEmployeeBean->role_code],
            ['key' => 'status', 'val' => 'INACTIVE']
        ];

        $roles = $this->searchCompanyEmployeeRoles($searchFilter, 10000, 0, 0);
        return $roles->data;
    }

    // ------------------------------------------------------------------------- //
    // ------------------- change status of company employee ------------------- //
    // ------------------------------------------------------------------------- //
    public function changeEmployeeStatus($companyEmployeeId, $new_status, $user_id)
    {
        // change status
        $updateStruct = new stdClass();
        $updateStruct->id =  $companyEmployeeId;
        $updateStruct->status = $new_status;
        DBConnection::updateDB("company_employee", $updateStruct, $user_id);
    }

    // ------------------------------------------------------------------------- //
    // ------------------- change status of company employee role -------------- //
    // ------------------------------------------------------------------------- //
    public function changeRoleStatus($companyEmployeeRoleId, $new_status, $user_id)
    {
        // change status

        $updateStruct = new stdClass();
        $updateStruct->id =  $companyEmployeeRoleId;
        $updateStruct->status = $new_status;
        DBConnection::updateDB("company_employee_role", $updateStruct, $user_id);
    }


    // ------------------------------------------------------------------------- //
    // ------------------- Save account auth for an employee  -------------- //
    // ------------------------------------------------------------------------- //
    public function saveAccountAuthForEmployee($companyEmployeeIds, $account_id, $user_id)
    {

        foreach ($companyEmployeeIds as $id) {
            $employee = $this->getCompanyEmployeeBasic($id, $user_id);
            if ($employee->account_ids) {
                if (!in_array($account_id, $employee->account_ids)) {
                    $employee->account_ids[] = $account_id;
                }
            } else {
                $employee->account_ids = [$account_id];
            }
            DBConnection::updateDB("company_employee", $employee, $user_id);
        }
    }
}
