<?php

// import required classes
require_once (dirname(__FILE__)."/trucking_company_core.php");
require_once (dirname(__FILE__)."/../company_core.php");
require_once (dirname(__FILE__)."/../../user/user_core.php");
require_once (dirname(__FILE__)."/../../account/account_core.php");

require_once (dirname(__FILE__)."/../../API.php");
require_once (dirname(__FILE__)."/../../../includes/util.php");


class Trucking_company_interface extends API{
    
    // the request of each call
    private $_request = array();
    private $_truckingCompanyCore;
    private $_companyCore;
    private $_userCore;
    private $_accountCore;

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();
        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }
        // init the object
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_companyCore = new CompanyCore();
        $this->_userCore = new UserCore();
        $this->_accountCore = new AccountCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter 
    private function prepareFilter(){
        $truckingCompanyFilter = [];

        if($this->_request->filter){

            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($key == 'name'){
                    $tempArr = ['key'=>$key,'val' => $value , 'op' => "LIKE"];
                }else{
                    $tempArr = ['key'=>$key,'val' => $value ];
                }
                array_push($truckingCompanyFilter,$tempArr);
            }


        }
        return $truckingCompanyFilter;
    }
    
    
    // ------------------------------------------------------------------------------------------- //
    // --------------------- get list of trucking companies based on search filter --------------- //
    // ------------------------------------------------------------------------------------------- //
    public function searchTruckingCompany(){
 

        $companyFilter = $this->prepareFilter();
        $companyResult = $this->_truckingCompanyCore->searchTruckingCompany($companyFilter,
                                                            $this->_request->limit,
                                                            $this->_request->offset,
                                                            $_SESSION['user_id']);

        parent::response($companyResult);
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for trucking company ----------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTruckingCompany(){    
 
        $truckingCompanyBean = $this->_truckingCompanyCore->getTruckingCompany($this->_request->id,0);
    
        $truckingCompanyBean_JSON = json_decode($truckingCompanyBean);
        $companyBean= $this->_companyCore->getCompany($truckingCompanyBean_JSON->company_id,0);

        $result = new stdClass();
        $result->companyBean = $companyBean;
        $result->truckingCompanyBean = $truckingCompanyBean;

        parent::response($result);
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- create new trucking comapny ------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function createTruckingCompany(){
 
        $truckingCompanyBean = $this->_request;
       
        $id = $this->_truckingCompanyCore->createTruckingCompany($truckingCompanyBean,$_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('TRUCKING_COMPANY','NEW','ACTIVE',$_SESSION['user_id'],$_SESSION['u_id']);
        if($autoAction){
            $this->_truckingCompanyCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        // create account
        $accountBean = new stdClass();
        $accountBean->name = $truckingCompanyBean->dvld_name;
        $accountBean->user_id = null;
        $accountBean->company_id = $truckingCompanyBean->company_id;
        $accountBean->minimum_balance = 0;

        $accountId = $this->_accountCore->createAccount($accountBean,"company", 0);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCKING_COMPANY.SUCCESS_CREATE";
        $Result['ID'] = $id;
        parent::response($Result,200); 
    }
   
 


    // ---------------------------------------------------------------------- //
    // -------------------- change trucking company status ------------------ //
    // ---------------------------------------------------------------------- //
    public function changeStatus(){
    
        // change tender truck status
        $this->_truckingCompanyCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCKING_COMPANY.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }


    // --------------------------------------------------------------------------- //
    // --------------------- update trucking company info ------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateInfo(){
        
        $truckingCompanyBean = $this->_request;
        $truckingCompanyBean->photos = json_decode($this->_request->photos);
        $truckingCompanyBean->specs = json_decode($this->_request->specs);
  
        $this->_truckingCompanyCore->updateInfo($truckingCompanyBean,
                                                $this->_request->trucking_company_id,
                                                $_SESSION['user_id']);
        
        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCKING_COMPANY.SUCCESSFUL_UPDATE";
        parent::response($Result);

    }

    // ----------------------------------------------------------------------------------------------------------------------- //
    // --------------- search for certain user using his mobile number in order to add him to the company users -------------- //
    // ----------------------------------------------------------------------------------------------------------------------- //
    public function searchTruckingCompanyUser(){

        $searchValue = $this->_request->search_value;

        if(substr( $searchValue, 0, 3 ) === "962") {
            $searchValue = str_replace_first("962","0",$searchValue);
        }
        else if(substr( $searchValue, 0, 4 ) === "+962"){
            $searchValue = str_replace_first("+962","0",$searchValue);
        }

        $searchValue = convertToInternational($searchValue);

        // ------search if he  is a user in system -------------------
        $searchFilter = [['key'=>'phone','val' => $searchValue ],['key'=>'status','val' => 'ACTIVE']];
        $userInfo = $this->_userCore->searchUser($searchFilter,1,0,0);
        if($userInfo->found_rows == 0){
            throw new Exception('رقم الهاتف غير صحيح');
        }
        $userData= $userInfo->data[0];
        // ------search if the user is already in "logged-in user" company--------------
        //get user data
        $userLoggedInBean = $this->_userCore->getUserBasic($_SESSION['user_id'], $_SESSION['user_id']);
        $searchFilter = [['key' => 'user_id', 'val' => $userData->id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'company_id', 'val' => $userLoggedInBean->company_id]];
        $userRoleResult= $this->_userCore->searchUserRoles($searchFilter,1,0,$_SESSION['user_id']);
        if($userRoleResult->found_rows > 0){
            throw new Exception('المستخدم موجود مسبقا في الشركة');
        }

        // search if the user is employee in another company
        $searchFilter = [
            ['key'=>'user_id','val' => $userData->id ],
            ['key'=>'status','val'=>'ACTIVE'],
            ['key'=>'company_id','val' => [$userLoggedInBean->company_id],"op"=>"not in"]];
        $userRoleResult= $this->_userCore->searchUserRoles($searchFilter,100,0,0);

        if($userRoleResult->found_rows > 0){
            throw new Exception('المستخدم موجود مسبقا في شركة أخرى');
        }

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['USER_NAME'] = $userInfo->data[0]->name;
        $Result['USER_ID'] = $userInfo->data[0]->id;
        parent::response($Result);


    }



}


$trucking_company_interface = new Trucking_company_interface();