<?php

// import objects
require_once(dirname(__FILE__) . "/../../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../../includes/util.php");
require_once(dirname(__FILE__) . "/../../../core/company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/../../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../../core/social/social_core.php");
require_once(dirname(__FILE__) . "/../../../core/taskQueues/taskQueues_core.php");

class TruckingCompanyCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }


    // ---------------------------------------------------------------------------------- //
    // -------------------Create trucking company bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------------- //
    public function getTruckingCompany($id, $user_id)
    {

        $companyInfo = DBConnection::getObjectBean("trucking_company", $id, $user_id);
        return $companyInfo;
    }

    // ---------------------------------------------------------------------------------- //
    // -------------------Create trucking company bean and fill it from DB  ------------- //
    // ---------------------------------------------------------------------------------- //
    public function getTruckingCompanyBasic($id, $user_id)
    {

        $companyInfo = DBConnection::getBasicObjectBean("trucking_company", $id, $user_id);
        return $companyInfo;
    }


    // ----------------------------------------------------------------------------------- //
    // -------------------search for trucking companies using any search filter ---------- //
    // ----------------------------------------------------------------------------------- //
    public function searchTruckingCompany($searchFilter, $limit, $offset, $user_id)
    {

        $searchCompanyResult = DBConnection::searchDB("trucking_company", $searchFilter, $limit, $offset, $user_id);
        return $searchCompanyResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------create new trucking company ------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTruckingCompany($truckingCompanyBean,  $user_id)
    {

        //validate tenderBean
        $this->validateTruckingCompanyForCreate($truckingCompanyBean, $user_id);

        $createTruckingCompanyResult = DBConnection::insertDB("trucking_company", $truckingCompanyBean, $user_id);
        $truckingCompany_id =  $createTruckingCompanyResult[0]['@id'];

        return $truckingCompany_id;
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------ Validate trucking company bean in order to be inserted----------------- //
    // ------------------------------------------------------------------------------------------ //
    private function validateTruckingCompanyForCreate($truckingCompanyBean,  $user_id)
    {

        // validate the truck bean for company_id , 
        if (!$truckingCompanyBean->company_id) {
            throw new Exception("TRUCKING_COMPANY.MISSING_COMPANY_ID");
        }

        // validate the specs are array of object,  and each object contains id
        $specsJSON = json_decode($truckingCompanyBean->specs);
        if ($specsJSON == null) {
            throw new Exception("TRUCKING_COMPANY.INVALID_SPECS_JSON");
        }

        foreach ($specsJSON as $spec) {
            if (!$spec->id) {
                throw new Exception("TRUCKING_COMPANY.INVALID_SPEC");
            }
        }

        // validate SCAC (id)
        if (!$truckingCompanyBean->id) {
            throw new Exception("TRUCKING_COMPANY.MISSING_SCAC");
        }
    }


    // ---------------------------------------------------------------------- //
    // -------------------- change trucking company status ------------------ //
    // ---------------------------------------------------------------------- //
    public function changeStatus($trucking_company_id, $new_status, $user_id)
    {

        $updateStruct = new stdClass();
        $updateStruct->id = $trucking_company_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("trucking_company", $updateStruct, $user_id);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update trucking info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function updateInfo($truckingCompanyBean, $trucking_company_id, $updated_by)
    {

        // fill update struct and set the target user id
        $truckingCompanyBean->id = $trucking_company_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("trucking_company", $trucking_company_id, $updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if (compareObject($truckingCompanyBean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $truckingCompanyBean = mapBeanToDBBean($truckingCompanyBean, $DB_Bean);

            //re-validate the user input 
            //$this->validateForEdit($driverBean);

            // fill update struct and set the target user id
            DBConnection::updateDB("trucking_company", $truckingCompanyBean, $updated_by);
        }
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update trucking info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function informComapanyEmployee($trucking_company_id, $title, $message)
    {

        // init objects
        $companyEmployeeCore = new CompanyEmployeeCore();
        $truckingCompanyCore = new TruckingCompanyCore();
        $notificationCore = new NotificationCore();
        $userCore = new UserCore();
        $cargoCore = new CargoCore();
        $socialCore = new SocialCore();
        $taskQueuesCore = new TaskQueuesCore();

        // get company id
        $companyInfo = $truckingCompanyCore->getTruckingCompanyBasic($trucking_company_id, 0);

        // search company employee record        
        $employeeSearchFilter = [
            ['key' => 'company_id', 'val' => $companyInfo->company_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $employeeInfo = $companyEmployeeCore->searchCompanyEmployee($employeeSearchFilter, 100, 0, 0);

        // search for TC_MANAGER
        foreach ($employeeInfo->data as $employee) {

            $employeeRoleSearchFilter = [
                ['key' => 'company_employee_id', 'val' => $employee->id],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $rolesInfo = $companyEmployeeCore->searchCompanyEmployeeRoles($employeeRoleSearchFilter, 100, 0, 0);

            foreach ($rolesInfo->data as $role) {
                if ($role->role_code == 'TC_MANAGER') {
                    /// get user phoneand cargo name
                    $user_id = $employee->user_id;
                    $userBean = $userCore->getUserBasic($user_id, 0);

                    // send SMS
                    $messageRecipient = $userBean->phone;
                    $messageRecipient = convertToInternational($messageRecipient);
                    $result = sendSMS($messageRecipient, $message);

                    // inform the user about this using app
                    $sender_id = 266770;
                    $sender_name =  "شركة مدارج للخدمات اللوجستية ";
                    $body = $socialCore->createPostBody($title, $message,  null, $sender_id, $sender_name);
                    $taskQueuesCore->createPostOnWallTask($user_id, $body, $title, true);
                }
            }
        }
    }
}
