<?php

// import required classes
require_once (dirname(__FILE__)."/company_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/trucking_company/trucking_company_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../company_employee/company_employee_core.php");


class Company_interface extends API{
    
    // the request of each call
    private $_request = array();
    private $_companyCore;
    private $_truckingCompanyCore;
    private $_userObj;
    private $_companyEmployeeCore;

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();
        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }
        // init the object
        $this->_companyCore = new CompanyCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_userObj = new UserCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter 
    private function prepareFilter(){
        $companyFilter = [];
        
        if($this->_request->filter){

            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($key == 'name'){
                    $tempArr = ['key'=>$key,'val' => $value , 'op' => "LIKE"];
                }else{
                    $tempArr = ['key'=>$key,'val' => $value ];
                }
                array_push($companyFilter,$tempArr);
            }
        }
        return $companyFilter;
    }
    
    
    // ---------------------------------------------------------------------------------- //
    // --------------------- get list of companies based on search filter --------------- //
    // ---------------------------------------------------------------------------------- //
    public function searchCompany(){

        $companyFilter = $this->prepareFilter();
 
        $companyResult = $this->_companyCore->searchCompany($companyFilter,
                                                            $this->_request->limit,
                                                            $this->_request->offset,
                                                            $_SESSION['user_id']);

        parent::response($companyResult);
    }


    // ----------------------------------------------------------------------- //
    // -------------------- get bean for company ----------------------------- //
    // ----------------------------------------------------------------------- //
    public function getCompany(){    
        
        $companyBean = $this->_companyCore->getCompany($this->_request->id,$_SESSION['user_id']);
        parent::response($companyBean);
    }

    // ------------------------------------------------------------------------------------------- //
    // -------------------- create new company record -------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function createCompany(){

        // get input params
        $nn = $this->_request->nn;
        $company_name = $this->_request->company_name;
        $company_number = $this->_request->company_number;
        $i_dont_have_nn = $this->_request->i_dont_have_nn;

        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if($role == 'OPERATION_MANAGER'){
                $allow=true;
            }
        }
        if(!$allow){
            throw new Exception("لا يوجد لديك صلاحية كافية");            
        }

        // validate company if exists
        $companyFilter = [];
        $companyFilter[] = ['key'=>"nn",'val' => $nn ];
        $companyFilter[] = ['key'=>"status",'val' => ['NEW','ACTIVE'] , 'op'=>'like'];
        $companyResult = $this->_companyCore->searchCompany($companyFilter,1,0,0);
        if($companyResult->found_rows > 0){
            throw new Exception("الرقم الوطني مضاف مسبقا");
        }

        if($i_dont_have_nn){
            $nn_sql = "select nn+1 as nn from company where nn != 201904301912 order by convert(nn,SIGNED) desc limit 1";
            $result = DBConnection::runDatabaseQuery($nn_sql);
            $nn = $result[0]->nn;
        }

        $id_sql = "select id+1 as id from company where id != 999999 order by id desc limit 1";
        $id_result = DBConnection::runDatabaseQuery($id_sql);
        $id = $id_result[0]->id;
    
        //prepare sql
        $sql = "INSERT INTO `waybill`.`company` (`id`, `name`, `type`, `company_number`, `company_status`, `nn`, `sefat`, `registration_date`, `initial_capital`, `current_capital`, `city`, `share_holders`, `aims`, `status`, `update_by`) 
                                        VALUES  (?   , ?     , ?     , ?               , ?               , ?   , ?      ,  ?                 ,  ?               , ?                ,  ?    ,  ?             , ?     , ?       ,  ?         )";

        $param = [$id, $company_name,"ذات مسؤولية محدودة",$company_number,"قائمة",$nn,"اعتيادية",date("Y-m-d"), 100000,100000,'AMMAN','[]','[]','NEW',0];
        $result = DBConnection::runBindDatabaseQuery($sql,$param);

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'USER.SUCCESS_OPERATION';
        $Result['NN'] = $nn;
        parent::response($Result);

    }

    // ------------------------------------------------------------------------------------------- //
    // -------------------- validate nn,company_id and tc_id if match together ------------------- //
    // -------------------- when match , assign the trucking company to the employee ------------- //
    // --------------------- and assign TC_MANAGER role to the user ------------------------------ //
    // ------------------------------------------------------------------------------------------- //
    public function assignTruckingCompanyToEmployee(){

        //parse incoming params
        $nn = $this->_request->nn;
        $company_number = $this->_request->company_number;
        $tc_id = $this->_request->tc_id;
        $user_id = $_SESSION['u_id'];

        // validate input params
        $companyInfo = $this->validateAssignTruckingCompanyToEmployee($nn,$company_number,$tc_id);

        // start the assign process, the user has correct info about his comapny
        try{           
            DBConnection::startTransaction();

                // get user bean
                $userBean = $this->_userObj->getUserBasic($user_id,$_SESSION['user_id']);

                // create new record in company_employee table
                $companyEmployeeBean = new stdClass();
                $companyEmployeeBean->name = $userBean->name;
                $companyEmployeeBean->user_id = $user_id;
                $companyEmployeeBean->status = "NEW";
                $companyEmployeeBean->create_date = DBConnection::getSystemDate();
                $companyEmployeeBean->company_id = $companyInfo->data[0]->id;
                $companyEmployeeId = $this->_companyEmployeeCore->createCompanyEmployee($companyEmployeeBean,0);            

                // activate the record
                $this->_companyEmployeeCore->changeEmployeeStatus($companyEmployeeId, 'ACTIVE', 0);
 
                //create new record in company_employee_role
                $companyEmployeeRoleBean = new stdClass();
                $companyEmployeeRoleBean->company_employee_id = $companyEmployeeId;
                $companyEmployeeRoleBean->role_code = "TC_MANAGER";
                $companyEmployeeRoleBean->status = "NEW";
                $companyEmployeeRoleBean->create_date = DBConnection::getSystemDate();
                $companyEmployeeRoleId = $this->_companyEmployeeCore->createCompanyEmployeeRole($companyEmployeeRoleBean,0);

                // activate the record
                $this->_companyEmployeeCore->changeRoleStatus($companyEmployeeRoleId, 'ACTIVE', 0);
                

            DBConnection::commitTransaction();

            $Result=[];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'USER.SUCCESS_OPERATION';
            parent::response($Result);

        }catch(Exception $e){
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }        
    }


    // ------------------------------------------------------------------------------------------- //
    // -------------------- validate nn,company_id and tc_id if match together ------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function searchAssignCompany(){
        //parse incoming params
        $nn = $this->_request->nn;
        $company_number = $this->_request->company_number;
        $tc_id = $this->_request->tc_id;


        // validate input params
        $company_info = $this->validateAssignTruckingCompanyToEmployee($nn,$company_number,$tc_id);

        // return reasult
        $company_name = $company_info->data[0]->name;
        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['COMPANY'] = $company_info->data[0]->name;
        $Result['DISCLAIMER'] = "أتعهد بأنني المالك أو المخول لشركة '$company_name'  وعليه أتحمل كامل المسؤولية القانونية تجاهها ، واتعهد أن المعلومات المقدمة هي معلومات صحيحة وأملك كامل الصلاحية لإستخدامها. ";
        parent::response($Result);

    }


    // ------------------------------------------------------------------------------------------- //
    // -------------------- validate nn,company_id and tc_id if match together ------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function validateAssignTruckingCompanyToEmployee($nn,$company_number,$tc_id){
        // search for company
        $searchFilter = [['key'=>'company_number','val' => $company_number],
                         ['key'=>'nn','val' => $nn]];

        $companyInfo = $this->_companyCore->searchCompany($searchFilter,1,0,0);
        if($companyInfo->found_rows == 0){
            throw new Exception("يبدو أن المعلومات المدخلة غير صحيحة ، الرجاء التأكد منها مرة اخرى");
        }

        // search for trucking_company id
        $tc_searchFilter = [['key'=>'id','val' => $tc_id]];
        $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, 2);

        if($tc_qry->found_rows == 0){
            throw new Exception("يبدو أن المعلومات المدخلة غير صحيحة ، الرجاء التأكد منها مرة اخرى");
        }
        if($tc_qry->data[0]->id != $tc_id){
            throw new Exception("يبدو أن المعلومات المدخلة غير صحيحة ، الرجاء التأكد منها مرة اخرى");
        }

        return $companyInfo;
    }



}


$company_interface = new Company_interface();