<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");


class CompanyCore {

    public function __construct(){
        DBConnection::getInstance();
    }


    // ------------------------------------------------------------------------ //
    // -------------------Create company bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getCompany($id,$user_id){
        
        $companyInfo = DBConnection::getObjectBean("company",$id,$user_id);
        return $companyInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create company bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getCompanyBasic($id,$user_id){

        $companyBean = DBConnection::getBasicObjectBean("company",$id,$user_id);
        return $companyBean;
    }

    // -------------------------------------------------------------------------- //
    // -------------------search for companies using any search filter ---------- //
    // -------------------------------------------------------------------------- //
    public function searchCompany($searchFilter, $limit, $offset,$user_id){
        
        $searchCompanyResult = DBConnection::searchDB("company",$searchFilter,$limit,$offset,$user_id);
        return $searchCompanyResult;
    }
}