<?php

// import required classes
require_once dirname(__FILE__) . "/clearing_agent_core.php";
require_once dirname(__FILE__) . "/../company_core.php";
require_once dirname(__FILE__) . "/../../API.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
require_once dirname(__FILE__) . "/../../account/account_core.php";
require_once dirname(__FILE__) . "/../../cargo/cargo_core.php";
require_once dirname(__FILE__) . "/../../user/user_core.php";
require_once dirname(__FILE__) . "/../../company_employee/company_employee_core.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/container.php";

class Clearing_agent_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_clearingAgentCore;
    private $_companyCore;
    private $_accountCore;
    private $_cargoCore;
    private $_userCore;
    private $_companyEmployeeCore;

    private $_con;
    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }
        // init the object
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_companyCore = new CompanyCore();
        $this->_accountCore = new AccountCore();
        $this->_cargoCore = new CargoCore();
        $this->_userCore = new UserCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();
        $this->_con = new Container();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter
    private function prepareFilter()
    {
        $clearingAgentFilter = [];

        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {

                if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => '='];
                }

                array_push($clearingAgentFilter, $tempArr);
            }
        }
        return $clearingAgentFilter;
    }

    // ------------------------------------------------------------------------------------------------ //
    // --------------------- get list of claring agent companies based on search filter --------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchClearingAgent()
    {

        $companyFilter = $this->prepareFilter();
        $companyResult = $this->_clearingAgentCore->searchClearingAgent(
            $companyFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        parent::response($companyResult);
    }

    // ------------------------------------------------------------------------------------------------ //
    // --------------------- get list of claring agent companies based on search filter --------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchClearingAgentForClaim()
    {

        // get cargo for selected tender_id
        $cargoFilter = [];
        $cargoFilter[] = ['key' => "status", 'val' => 'ACTIVE'];
        $cargoFilter[] = ['key' => "tender_id", 'val' => $this->_request->tender_id];
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 100, 0, $_SESSION['user_id']);

        $ca_ids = [];
        foreach ($cargoResult->data as $cargo) {
            $ca_ids[] = $cargo->ca_id;
        }

        $caFilter = [];
        $caFilter[] = ['key' => "id", 'val' => $ca_ids, 'op' => 'in'];
        $companyResult = $this->_clearingAgentCore->searchClearingAgent(
            $caFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        parent::response($companyResult);
    }

    // -------------------------------------------------------------------------------------- //
    // -------------------- get bean for clearing agent company ----------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function getClearingAgent()
    {

        $clearingAgentBean = $this->_clearingAgentCore->getClearingAgent($this->_request->id, $_SESSION['user_id']);
        $clearingAgentBean_JSON = json_decode($clearingAgentBean);

        $companyBean = $this->_companyCore->getCompany($clearingAgentBean_JSON->company_id, $_SESSION['user_id']);

        $data = new stdClass();
        $data->ca_id = $this->_request->id;
        $electricIntegerationFlag = $this->_con->checkCaForElectronicIntegeration($data, $_SESSION['user_id']);
        $result = new stdClass();
        $result->companyBean = $companyBean;
        $result->clearingAgentBean = $clearingAgentBean;
        $result->electricIntegerationFlag = ($electricIntegerationFlag != '[]');

        parent::response($result);
    }

    // -------------------------------------------------------------------------------------- //
    // -------------------- create new clearing agent comapny ------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function createClearingAgent()
    {

        $clearingAgentBean = $this->_request;

        $id = $this->_clearingAgentCore->createClearingAgent($clearingAgentBean, $_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('CLEARING_AGENT', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->_clearingAgentCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        // create account
        $accountBean = new stdClass();
        $accountBean->name = $this->_request->name;
        $accountBean->user_id = null;
        $accountBean->company_id = $this->_request->company_id;
        $accountBean->minimum_balance = 0;
        $accountId = $this->_accountCore->createAccount($accountBean, "ca", 0); // owners are clearing agents

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESS_CREATE";
        $Result['ID'] = $id;
        parent::response($Result, 200);
    }

    // ---------------------------------------------------------------------------- //
    // -------------------- change clearing agent company status ------------------ //
    // ---------------------------------------------------------------------------- //
    public function changeStatus()
    {

        // change tender truck status
        $this->_clearingAgentCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }

    // --------------------------------------------------------------------------- //
    // --------------------- update clearing agent company info ------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateInfo()
    {

        $clearingAgentBean = $this->_request;
        $photos = json_decode($this->_request->photos);
        $clearingAgentBean->details = new stdClass();
        $this->_request->ca_info = str_replace(array("\r\n", "\n", "\r"), ' ', $this->_request->ca_info);
        $clearingAgentBean->details->ca_info = $this->_request->ca_info;

        // get clearing agent logo in case it is not exist
        $clearingAgentBean = $this->_clearingAgentCore->getClearingAgentBasic($this->_request->clearing_agent_id, $_SESSION['user_id']);
        if ($photos[0]->type == "logo" && $photos[0]->url == "") {
            $photos[0]->url =   $clearingAgentBean->photos[0]->url;
            $clearingAgentBean->photos = $photos;
        }
 
        // $clearingAgentBean->details->ca_info = json_encode($clearingAgentBean->details->ca_info,JSON_UNESCAPED_UNICODE);
        $this->_clearingAgentCore->updateInfo(
            $clearingAgentBean,
            $this->_request->clearing_agent_id,
            $_SESSION['user_id']
        );

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // --------------------- get list of tender claring agent companies based on search filter --------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchTenderClearingAgent()
    {

        $companyFilter = $this->prepareFilter();
        $companyResult = $this->_clearingAgentCore->searchTenderClearingAgent(
            $companyFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        parent::response($companyResult);
    }

    // ----------------------------------------------------------------------------------- //
    // ------------------get the available payment method for a certain ca --------------- //
    // ----------------------------------------------------------------------------------- //
    public function getTenderCaPaymentMethod()
    {

        // get user params
        $ca_id = $this->_request->ca_id;

        // prepare filter
        $searchFilter = [];
        $searchFilter[] = ['key' => "ca_id", 'val' => $ca_id, 'op' => '='];
        $tenderCaResult = $this->_clearingAgentCore->searchTenderClearingAgent($searchFilter, 100, 0, $_SESSION['user_id']);

        // extract AP account_id
        $AP_account = null;
        foreach ($tenderCaResult->data as $tender_ca) {
            $accounts = json_decode($tender_ca->accounts);
            foreach ($accounts as $key => $acc) {
                if ($key == "AP") {
                    $AP_account = $acc->AP;
                }
            }
        }

        // get the account Bean
        $accountBean = $this->_accountCore->getAccountBasic($AP_account, 0);

        // get the payment channel
        $result = [];
        $payment_channel = $accountBean->payment_channel;
        $result[] = ["label" => "كاش", "code" => "cash"];
        foreach ($payment_channel as $chnl) {
            if ($chnl == "check") {
                $result[] = ["label" => "ذمة", "code" => "check"];
            }
        }

        parent::response($result);
    }

    // ------------------------------------------------------ //
    // ------------- Create new tender_ca ------------------- //
    // ------------------------------------------------------ //
    public function createTenderClearingAgent()
    {
        // get user params
        $ca_id = $this->_request->ca_id;
        $tender_id = $this->_request->tender_id;

        try {

            DBConnection::startTransaction();
            // validate the ca is not already regisered
            $companyFilter = [
                ["key" => "tender_id", "val" => $tender_id],
                ["key" => "ca_id", "val" => $ca_id],
                ["key" => "status", "val" => "ACTIVE"],
            ];
            $companyResult = $this->_clearingAgentCore->searchTenderClearingAgent($companyFilter, 1, 0, $_SESSION['user_id']);
            if ($companyResult->found_rows > 0) {
                throw new Exception("شركة التخليص مسجلة مسبقا على المشروع");
            }

            // create new tender_ca record
            $tenderCaBean = new stdClass();
            $tenderCaBean->ca_id = $ca_id;
            $tenderCaBean->tender_id = $tender_id;
            $tender_ca_id = $this->_clearingAgentCore->createTenderClearingAgent($tenderCaBean, $_SESSION['user_id']);

            // activate it
            $this->_clearingAgentCore->changeTenderCaStatus($tender_ca_id, "ACTIVE", $_SESSION['user_id']);

            DBConnection::commitTransaction();

            //return Success reponse
            $Result = [];
            $Result['tender_ca_id'] = $tender_ca_id;
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESSFUL_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------ //
    // ------------- inactive new tender_ca ------------------- //
    // ------------------------------------------------------ //
    public function changeTenderCaStatus()
    {
        // get user params
        $tender_ca_id = $this->_request->tender_ca_id;
        $new_status = $this->_request->new_status;

        $this->_clearingAgentCore->changeTenderCaStatus($tender_ca_id, $new_status, $_SESSION['user_id']);

        $Result = [];
        $Result['tender_ca_id'] = $tender_ca_id;
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // ------------------------------------------------------ //
    // ------------- Create new tender_ca user ------------------- //
    // ------------------------------------------------------ //
    public function createClearingAgentUser()
    {
        // get user params
        $phone_number = $this->_request->phone_number;
        $nn = $this->_request->nn;
        $name = $this->_request->name;
        $email = $this->_request->email;
        $ca_id = $this->_request->ca_id;

        try {
            DBConnection::startTransaction();
            // get ca_bean
            $clearingAgentBean = $this->_clearingAgentCore->getClearingAgentBasic($ca_id, $_SESSION['user_id']);

            // search for user id
            $searchFilter = [
                ['key' => 'phone', 'val' => convertToInternational($phone_number)],
                ['key' => 'status', 'val' => "ACTIVE"],
            ];
            $userInfo = $this->_userCore->searchUser($searchFilter, 1, 0, 0);
           
            if ($userInfo->found_rows > 0) {
                $user_id = $userInfo->data[0]->id;
            } else {
                // create user
                $userBean = new stdClass();

                // prepare the phone info array
                $phone_array = [];
                $phone_info = new stdClass();
                $phone_info->sim = 0;
                $phone_info->email = $email;
                $phone_info->phone = convertToInternational($phone_number);
                $phone_info->imei = 0;
                $phone_info->brand = null;
                $phone_info->verification_method = 'NONE';
                $phone_array[0] = $phone_info;
                $userBean->phone_array = json_decode(json_encode($phone_array));
                $userBean->nn = $nn;
                $userBean->name = $name;
                $user_id = $this->_userCore->registerNewUser($userBean, $_SESSION['user_id']);
            }

            // search for company employee
            $searchFilter = [];
            $searchFilter[] = ['key' => 'company_id', 'val' => $clearingAgentBean->company_id];
            $searchFilter[] = ['key' => 'user_id', 'val' => $user_id];
            $searchFilter[] = ['key' => 'status', 'val' => 'ACTIVE'];

            $companyEmployeeqry = $this->_companyEmployeeCore->searchCompanyEmployee($searchFilter, 1, 0, 0);
            if ($companyEmployeeqry->found_rows > 0) {
                throw new Exception("الموظف معرف مسبقا في الشركة");
            }

            // create company employee
            $companyEmployeeBean = new stdClass();
            $companyEmployeeBean->name = $name;
            $companyEmployeeBean->user_id = $user_id;
            $companyEmployeeBean->account_ids = ["*"];
            $companyEmployeeBean->status = "NEW";
            $companyEmployeeBean->create_date = DBConnection::getSystemDate();
            $companyEmployeeBean->company_id = $clearingAgentBean->company_id;
            $companyEmployeeId = $this->_companyEmployeeCore->createCompanyEmployee($companyEmployeeBean, $_SESSION['user_id']);
           
            // activate company employee
            $this->_companyEmployeeCore->changeEmployeeStatus($companyEmployeeId, 'ACTIVE', $_SESSION['user_id']);
 
            //create new record in company_employee_role
            $companyEmployeeRoleBean = new stdClass();
            $companyEmployeeRoleBean->company_employee_id = $companyEmployeeId;
            $companyEmployeeRoleBean->role_code = "CA_MANAGER";
            $companyEmployeeRoleBean->status = "NEW";
            $companyEmployeeRoleBean->create_date = DBConnection::getSystemDate();
            $companyEmployeeRoleId = $this->_companyEmployeeCore->createCompanyEmployeeRole($companyEmployeeRoleBean, $_SESSION['user_id']);

            // activate the company_employee_role record
            $this->_companyEmployeeCore->changeRoleStatus($companyEmployeeRoleId, 'ACTIVE', 0);

            DBConnection::commitTransaction();

            //return Success reponse
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "CLEARING.AGENT.SUCCESSFUL_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------- //
    // -------------  get summary of number of users for each ca on certain project --------------- //
    // -------------------------------------------------------------------------------------------- //
    public function getTenderCaEmployeeSummary()
    {

        $allow = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية");
        }

        // get user params
        $tender_id = $this->_request->tender_id;

        // run database query
        $sqlQuery = " SELECT
                ca_name, COUNT(e.id) AS cnt
            FROM
                tender_ca_view c
                    LEFT JOIN
                company_employee e ON (e.company_id = c.company_id and e.status = 'ACTIVE')
            WHERE
                tender_id = ?
            GROUP BY ca_name
            ORDER BY cnt desc";

        $param = [$tender_id];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $result = [];
        $result['data'] = $data;
        $result['found_rows'] = sizeof($data);
        parent::response($result);
    }

    //@params tender_id, ca_id
    //@return list of selected services
    public function getServices()
    {
        $allow = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'MINAGATE_OPERATION') {
                $allow = true;
            }
        }
        if (!$allow) {
            parent::response(null);
            die;
        }

        $ca_id = $this->_request->ca_id;
        $tender_id = $this->_request->tender_id;

        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
        ];
        $service = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        $selectedService = json_decode($service->data[0]->details);
        parent::response($selectedService->services);
    }

    // ------------------- TEMP method: Update service on tenderCa ------------------------ //
    public function updateRequestDemurrageService()
    {

        $ca_id = $this->_request->ca_id;
        $tender_id = $this->_request->tender_id;
        $allow_request =  $this->_request->allow_request;

        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
        ];
        $tenderCaQry = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        if (!$tenderCaQry) {
            throw new Exception("شركة التخليص غير مضافة على المشروع ");
        }

        $tenderCaBean = $tenderCaQry->data[0];
        $details = json_decode($tenderCaBean->details);
        $services = $details->services;

        $request_demurrage_update = false;
        foreach ($services as $service) {
            if ($service->code == "request_demurrage") {
                $request_demurrage_update = true;
                $service->allow = $allow_request;

                if ($allow_request) {
                    $stat = "تمت اضافة خدمة طلب دفع اعطال عن الحاويات بتاريخ " .  DBConnection::getSystemDate() . " من قبل  " . $_SESSION['u_id'];
                } else {
                    $stat = "تم حذف خدمة طلب دفع اعطال عن الحاويات بتاريخ " .  DBConnection::getSystemDate() . " من قبل  " . $_SESSION['u_id'];
                }
                $service->history[] = $stat;
                break;
            }
        }
        if (!$request_demurrage_update) {
            $newService = new stdClass();
            $newService->code = "request_demurrage";
            $newService->caption = "طلب دفع أعطال عن الحاوية";
            $newService->allow = $allow_request;
            $stat = "تمت اضافة خدمة طلب دفع اعطال عن الحاويات بتاريخ " .  DBConnection::getSystemDate() . " من قبل  " . $_SESSION['u_id'];
            $newService->history[] = $stat;

            $services[] = $newService;
        }

        $details->services = $services;
        $tenderCaBean->details = json_encode($details->services, JSON_UNESCAPED_UNICODE);
        $update = $this->_clearingAgentCore->updateTenderService($tenderCaBean, $_SESSION['user_id']);
    }

    // ------------------- Update service on tenderCa ------------------------ //
    public function updateService()
    {

        $ca_id = $this->_request->ca_id;
        $tender_id = $this->_request->tender_id;
        $notes = $this->_request->notes;
        $services = $this->_request->selected_service;
        $allow = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'MINAGATE_OPERATION') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية");
        }

        // the ca has to be already on the tender in order to update the service
        $tenderCaFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
        ];
        $tenderCaQuery = $this->_clearingAgentCore->searchTenderClearingAgent($tenderCaFilter, 100, 0, $_SESSION['user_id']);
        if (!$tenderCaQuery || !$tenderCaQuery) {
            throw new Exception("شركة التخليص غير مضافة على المشروع ");
        }

        // take the first bean and check if it has details
        $tenderCaBean = $tenderCaQuery->data[0];
        $details = json_decode($tenderCaBean->details);
        if (!$details) {
            $tenderCaBean->details = new stdClass();
            $details = new stdClass();
        }
        $prevHistory = $details->history;
        $prevServices = $details->services;
        if (!is_array($prevHistory)) {
            $prevHistory = [];
        }

        // search for the service code and change it
        foreach ($services as $new) {
            $change = true;
            if ($prevServices) {
                foreach ($prevServices as $old) {
                    if ($new->code == $old->code) {
                        if ($new->value == $old->value) {
                            $change = false;
                        }
                    }
                }
                $history = [
                    'code' => $new->code,
                    'value' => $new->value,
                    'update_date' => DBConnection::getSystemDate(),
                    'update_by' => $_SESSION['u_id']
                ];
                if ($change) {
                    $prevHistory[] = $history;
                }
            }
        }

        $tempDetails = new stdClass();
        $tempDetails->services = $services;
        $tempDetails->history  = $prevHistory;
        if ($details->notificationSettings) {
            $tempDetails->notificationSettings = $details->notificationSettings;
        }

        $tenderCaBean->details = $tempDetails;

        $update = $this->_clearingAgentCore->updateTenderService($tenderCaBean, $_SESSION['user_id']);

        parent::response("تمت العملية بنجاح");
    }

    /**
     * update clearing agent notification settings
     */
    public function updateNotificationSettings()
    {

        //collect data
        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21
        $settings  = $this->_request->notification;
        $remarks   = $this->_request->remarks_template;
        $remarks   = preg_replace('/\r|\n/','\n',trim($remarks));
        //search for the record
        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $service = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        if (!$service) {
            throw new Exception("شركة التخليص غير مضافة على المشروع ", 600);
        }

        $serviceBean = $service->data[0];
        $details = json_decode($serviceBean->details);
        if (!$details) {
            $serviceBean->details = new stdClass();
            $details = new stdClass();
        }


        //save the notificvations settings
        if ($settings != []) {
            $details->notificationSettings = $settings;
        }else
            $details->notificationSettings = null;

        // save the remarks temaplate
        $details->remarksTemplate = $remarks;

        $serviceBean->details = $details;
        $update = $this->_clearingAgentCore->updateTenderService($serviceBean, $_SESSION['user_id']);

        parent::response($serviceBean, 200);
    }

    public function getNotificationSettings()
    {
        //collect data
        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21

        //search for the record
        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $service = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        if (!$service) {
            throw new Exception("شركة التخليص غير مضافة على المشروع ");
        }

        $serviceBean = $service->data[0];
        $details = json_decode($serviceBean->details);

        parent::response($details->notificationSettings);
    }

    public function getRemarksTemplate(){
        //collect data
        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21

        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $service = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        if (!$service) {
            throw new Exception("شركة التخليص غير مضافة على المشروع ");
        }

        $serviceBean = $service->data[0];
        $details = json_decode($serviceBean->details);
        parent::response($details->remarksTemplate);
    }


    public function notifyCa(){

        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21
        $cid = $this->_request->cid; //21
        $trigger = "BOND_DELIVERY";
        $this->_clearingAgentCore->notifyCa($cid,$ca_id, $tender_id, $trigger);
    }

    /**
     * This method is for containers tender where the CA can save a remark template
     * and use it on specific declarations
     */
    // public function saveRemarkTemplate(){
    //     $remark = $this->_request->remark;
    //     $ca_id  = $this->_request->ca_id;
    //     $tender_id = $this->_request->tender_id;

    //     $searchFilter=[
    //         ['key'=>'ca_id','val'=>$ca_id],
    //         ['key'=>'tender_id','val'=>$tender_id],
    //         ['key'=>'status','val'=>['INACTIVE']]
    //     ];
    //     $this->_clearingAgentCore->searchTenderClearingAgent($searchFilter,1,0,$_SESSION['user_id']);
    // }

    public function updateBonedNameForCa(){
        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21
        $bonedName = $this->_request->boned_name;
        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $tender_ca_qry = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);

        if ($tender_ca_qry->found_rows = 0) {
            throw new Exception("المخلص غير معرف على المشروع ");
        }
        $tender_ca = $tender_ca_qry->data[0];
        $details = json_decode($tender_ca->details);
        if (!$details) {
            $details = new stdClass();
        }
        $details->bonedName = $bonedName;
        $details->remarksTemplate = preg_replace('/\r|\n/','\n',trim($details->remarksTemplate));
        $tender_ca->details = json_encode($details,JSON_UNESCAPED_UNICODE);

        $msg = "تم التعديل $bonedName";
        $update = $this->_clearingAgentCore->updateTenderService($tender_ca, $_SESSION['user_id']);
        parent::response($update);
    }

    public function getBonedNameForCa(){
        $ca_id = $this->_request->ca_id; //63
        $tender_id = $this->_request->tender_id; //21

        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $tender_ca_qry = $this->_clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, $_SESSION['user_id']);
        if ($tender_ca_qry->found_rows = 0) {
            throw new Exception("المخلص غير معرف على المشروع ");
        }
        $tender_ca = $tender_ca_qry->data[0];
        $bonedName= json_decode($tender_ca->details)->bonedName;

        parent::response($bonedName);
    }

}

$clearing_agent_interface = new Clearing_agent_interface();
