<?php 

// import objects
require_once (dirname(__FILE__)."/../../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../../includes/util.php");


class ClearingAgentCore {

    public function __construct(){
        DBConnection::getInstance();
    }
 

    // -------------------------------------------------------------------------------------- //
    // -------------------- get bean for clearing agent company ----------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function getClearingAgent($id,$user_id){
        
        $clearingAgentInfo = DBConnection::getObjectBean("ca",$id,$user_id);
        return $clearingAgentInfo;
    }

     // -------------------------------------------------------------------------------------- //
    // -------------------- get bean for clearing agent company ----------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function getClearingAgentBasic($id,$user_id){

        $clearingAgentInfo = DBConnection::getBasicObjectBean("ca",$id,$user_id);
        return $clearingAgentInfo;
    }


    // ----------------------------------------------------------------------------------------- //
    // -------------------search for clearing agent companies using any search filter ---------- //
    // ----------------------------------------------------------------------------------------- //
    public function searchClearingAgent($searchFilter, $limit, $offset,$user_id){
        
        $searchCompanyResult = DBConnection::searchDB("ca",$searchFilter,$limit,$offset,$user_id);
        return $searchCompanyResult;
    }

    // ----------------------------------------------------------------------------------------- //
    // -------------------search for clearing agent companies using any search filter ---------- //
    // ----------------------------------------------------------------------------------------- //
    public function searchTenderClearingAgent($searchFilter, $limit, $offset,$user_id){

        $searchCompanyResult = DBConnection::searchDB("tender_ca",$searchFilter,$limit,$offset,$user_id);
        return $searchCompanyResult;
    }


    // -------------------------------------------------------------------------------------- //
    // -------------------- create new clearing agent comapny ------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function createClearingAgent($clearingAgentBean,  $user_id){
        
        //validate clearing agnet bean 
        $this->validateClearingAgentForCreate($clearingAgentBean,$user_id);

        $createclearingAgentResult = DBConnection::insertDB("ca",$clearingAgentBean,$user_id);
        $clearing_agent_id =  $createclearingAgentResult[0]['@id'];

        return $clearing_agent_id;
    }

    // ------------------------------------------------------ //
    // ------------- Create new tender_ca ------------------- //
    // ------------------------------------------------------ //
    public function createTenderClearingAgent($clearingAgentBean,  $user_id){

        $createclearingAgentResult = DBConnection::insertDB("tender_ca",$clearingAgentBean,$user_id);
        $clearing_agent_id =  $createclearingAgentResult[0]['@id'];

        return $clearing_agent_id;
    }


    // ------------------------------------------------------------------------------------------------ //
    // ------------------ Validate clearing agent company bean in order to be inserted----------------- //
    // ------------------------------------------------------------------------------------------------ //
    private function validateClearingAgentForCreate($clearingAgentBean,  $user_id){
       
        // validate the clearing agent bean for company_id , 
        if(!$clearingAgentBean->company_id){
            throw new Exception("CLEARING_AGENT.MISSING_COMPANY_ID");
        }

        // validate SCAC (id)
        if(!$clearingAgentBean->id){
            throw new Exception("CLEARING_AGENT.MISSING_SCAC");
        }

    }


    // ---------------------------------------------------------------------------- //
    // -------------------- change clearing agent company status ------------------ //
    // ---------------------------------------------------------------------------- //
    public function changeStatus($clearing_agent_id,$new_status,$user_id){
        
        $updateStruct = new stdClass();
        $updateStruct->id = $clearing_agent_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("ca",$updateStruct,$user_id);
    }

     // ---------------------------------------------------------------------------- //
    // -------------------- change tender ca  status ------------------ //
    // ---------------------------------------------------------------------------- //
    public function changeTenderCaStatus($tender_ca_id,$new_status,$user_id){

        $updateStruct = new stdClass();
        $updateStruct->id = $tender_ca_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("tender_ca",$updateStruct,$user_id);
    }


    // ------------------------------------------------------------------------------ //
    // --------------------- Update clearing agent info in DB------------------------ //
    // ------------------------------------------------------------------------------ //
    function updateInfo($clearingAgentBean,$clearing_agent_id, $updated_by){
        
        // fill update struct and set the target user id
        $clearingAgentBean->id = $clearing_agent_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("ca",$clearing_agent_id,$updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if(compareObject($clearingAgentBean,$DB_Bean) == false) {
            
            // map all the new values into the DB_bean
            $clearingAgentBean = mapBeanToDBBean($clearingAgentBean,$DB_Bean);

            //re-validate the user input 
            //$this->validateForEdit($driverBean);
 
            // fill update struct and set the target user id
            DBConnection::updateDB("ca",$clearingAgentBean,$updated_by);
        }
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update trucking info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function informClearingAgentEmployee($ca_id, $title, $message)
    {

        // init objects
        $companyEmployeeCore = new CompanyEmployeeCore();
        $notificationCore = new NotificationCore();
        $userCore = new UserCore();
        $cargoCore = new CargoCore();
        $socialCore = new SocialCore();
        $taskQueuesCore = new TaskQueuesCore();

        // get company id
        $companyInfo = $this->getClearingAgentBasic($ca_id, 0);

        // search company employee record
        $employeeSearchFilter = [
            ['key' => 'company_id', 'val' => $companyInfo->company_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $employeeInfo = $companyEmployeeCore->searchCompanyEmployee($employeeSearchFilter, 100, 0, 0);

        // search for TC_MANAGER
        foreach ($employeeInfo->data as $employee) {

            $employeeRoleSearchFilter = [
                ['key' => 'company_employee_id', 'val' => $employee->id],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $rolesInfo = $companyEmployeeCore->searchCompanyEmployeeRoles($employeeRoleSearchFilter, 100, 0, 0);

            foreach ($rolesInfo->data as $role) {
                if ($role->role_code == 'CA_MANAGER_DEMO') {
                    /// get user phoneand cargo name
                    $user_id = $employee->user_id;
                    $userBean = $userCore->getUserBasic($user_id, 0);

                    // send SMS
                    $messageRecipient = $userBean->phone;
                    $messageRecipient = convertToInternational($messageRecipient);
                    $result = sendSMS($messageRecipient, $message);

                    // inform the user about this using app
                    $sender_id = 266770;
                    $sender_name =  "شركة مدارج للخدمات اللوجستية ";
                    $body = $socialCore->createPostBody($title, $message,  null, $sender_id, $sender_name);
                    $taskQueuesCore->createPostOnWallTask($user_id, $body, $title, true);
                }
            }
        }
    }
    public function updateTenderService($tender_ca_bean,$user_id){

        $result=  DBConnection::updateDB("tender_ca",$tender_ca_bean,$user_id);
        return $result;
    }


    /* get check notification settings for clearing agent to whether send
       email, sms or phone notification */
    public function notifyCa($cid , $ca_id, $tender_id, $trigger)
    {

        // push this error on queue
        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->createNotifiCaTask($cid , $ca_id, $tender_id, $trigger);
    }
}