<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__)."/../notification/notification_core.php");
require_once (dirname(__FILE__)."/../truck_owner/truck_owner_core.php");


class Communication_interface extends API{

    private $_request = array();
    private $_waybill_order;
    private $_truckOwnerCore;


    public function __construct(){
        
        // call the super constructur
        $this->_request = parent::__construct();
        $this->_waybill_order = new WaybillOrderCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        DBConnection::getInstance();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // --------------------- update is_app_reachable for all certain waybill orders for a certain user  ------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function appIsReachable(){
    
        // get all waybill orders for a certain user
        $truckOwnerFilter = [['key'=>"user_id",'val' => $this->_request->user_id]];
        $truckOwnerQuery = $this->_truckOwnerCore->searchTruckOwner($truckOwnerFilter,1,0,0);
        $truck_owner_id = $truckOwnerQuery->data[0]->id;

        $searchFilter = [['key'=>'truck_owner_id','val' => $truck_owner_id],
                         ['key'=>'status','val' => 'NEW']];
        $newWaybillOrders = $this->_waybill_order->searchWaybillOrder($searchFilter,10,0,0);


        foreach ($newWaybillOrders->data as $order) {

            try{
                // get the bean of waybill order
                $waybill_order_id = $order->id;
                $waybillOrderBean = $this->_waybill_order->getWaybillOrderBasic($waybill_order_id,$this->_request->user_id);

                // update waybill order bean
                $updatedBean = new stdClass();
                $updatedBean->id = $waybill_order_id;
                $updatedBean->is_app_reachable = $waybillOrderBean->is_app_reachable?$waybillOrderBean->is_app_reachable++:1;
                $updatedBean->app_reach_date = DBConnection::getSystemDate();

                // update DB record
                DBConnection::updateDB("waybill_order",$updatedBean,0);

                // add Note
                $addNoteCore = new Add_notes_core();
                if($this->_request->beeb){
                    $addNoteCore->addNotes('waybill_order', $waybill_order_id, 'تم ارسال تنبيه صوتي للمالك عبر التطبيق للموافقة على أمر الحركة' , 0 );
                }else{
                    $addNoteCore->addNotes('waybill_order', $waybill_order_id, 'تم عرض أمر الحركة على شاشة التطبيق' , 0 );
                }
            }catch(Exception $e){}

        }

        $Result['MESSAGE'] = "APP_IS_REACHABLE";
        parent::response($Result,200);

    }

    // ----------------------------------------------------------------------------------- //
    // ---------------- send data notification regarding waybill order  ------------------- //
    // ------------------------------------------------------------------------------------ //
    public function sendWaybillOrderNotification(){

        $waybill_order_id = $this->_request->waybill_order_id;
        $type = $this->_request->type;

        $this->_waybill_order->sendWaybillOrderNotification($waybill_order_id, $type);

    }


}

$Communication_interface = new Communication_interface();