<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/cargo_type_core.php");


class cargo_type_interface  extends API
{
    private $_request = array();
    private $_cargoTypeCore;
    public function __construct()
    {
        $this->_request = parent::__construct();
        // validate the session
        session_start();
        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }
        $this->_cargoTypeCore = new CargoTypeCore();
        // process the incoming request
        $this->processRequest();

    }
    // call the correnponding method based on what the request call
    private function processRequest(){
        $func = $this->_request->method;
        unset($this->_request->method);
        if((int)method_exists($this,$func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found',404);   // If the method not exist with in this class, response would be "Page not found".
    }
    private function prepareFilter()
    {
        $cargoTypeFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($value){
                    if($key=='name') {
                        $tempArr = [key => $key, 'val' => $value, 'op' => 'like'];
                        array_push($employeeFilter,$tempArr);

                    }else{
                        $tempArr = ['key'=>$key,'val' => $value, 'op' => '='];
                        array_push($employeeFilter,$tempArr);
                    }
                }
            }
        }
        return $cargoTypeFilter;
    }

    // -------------------------------------------------------------- //
    // --------------------- get cargo type------------------------- //
    // -------------------------------------------------------------- //
    public function getCargoType(){

        $cargoTypeBean = $this->_cargoTypeCore->getCargoType($this->_request->id, $_SESSION['user_id']);
        //return Success reponse
        parent::response($cargoTypeBean);
    }
    // ------------------------------------------------------------------------ //
    // -------------------search for cargo type using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchCargoType(){

        // call the core search
        $searchFilter = $this->prepareFilter();

        $cargo_type_qry = $this->_cargoTypeCore->searchCargoType(  $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            0
        );


        parent::response($cargo_type_qry);
    }


}
$cargo_type_interface= new cargo_type_interface();
