<?php
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");


class CargoTypeCore
{
    public function __construct()
    {
        DBConnection::getInstance();
    }


    // ------------------------------------------------------------------------ //
    // -------------------get  cargo type bean  from DB  ---------------------------- //
    // ------------------------------------------------------------------------ //
    public function getCargoType($id, $user_id)
    {

        $cargoBean = DBConnection::getObjectBean("ct", $id, $user_id);
        if ($cargoBean == null) {
            throw new Exception("CARGO_TYPE.NOT_EXIST", 0);
        }
        return $cargoBean;
    }


    // -------------------------------------------------------------- //
    // -------------------- get  cargo type bean  from DB ----------- //
    // -------------------------------------------------------------- //
    public function getCargoTypeBasic($id,$user_id){

        $cargoTypeBean = DBConnection::getBasicObjectBean("ct",$id,$user_id);
        return $cargoTypeBean;
    }

    // -------------------------------------------------------------------------- //
    // -------------------search for cargo type using any search filter ---------- //
    // -------------------------------------------------------------------------- //
    public function searchCargoType($searchFilter, $limit, $offset, $user_id)
    {

        $searchCargoTypeResult = DBConnection::searchDB("ct", $searchFilter, $limit, $offset, $user_id);
        return $searchCargoTypeResult;
    }


}