<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__).'/../../includes/util.php');
require_once (dirname(__FILE__).'/../../core/user/user_core.php');

class CargoAgentCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

 
    // ------------------------------------------------------------- //
    // ------------------- Get Cargo Agent from Database------------ //
    // ------------------------------------------------------------- //
    public function getCargoAgent($id, $user_id)
    {
        $cargoAgentInfo = DBConnection::getObjectBean("cargo_agent",$id,$user_id);       
        return $cargoAgentInfo;
    }

    // --------------------------------------------------------------- //
    // ------------------- search Cargo Agent from Database ------------- //
    // --------------------------------------------------------------- //
    public function getCargoAgentBasic($id, $user_id)
    {
        $cargoAgentBean = DBConnection::getBasicObjectBean("cargo_agent",$id,$user_id);
        return $cargoAgentBean;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for cargo agent using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchCargoAgent($searchFilter, $limit, $offset, $user_id)
    {
        $searchCompanyEmployeeResult = DBConnection::searchDB("cargo_agent",$searchFilter, $limit, $offset, $user_id);
        return $searchCompanyEmployeeResult;
    }

}
