<?php

// import required classes
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/cargo_core.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../location/location_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../policy/policy_core.php");
require_once(dirname(__FILE__) . "/../company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/ACT.php");
require_once(dirname(__FILE__) . "/../waybill_draft/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/mg_registrar.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/poll.php");
ini_set('max_input_vars', '10000');
require_once(dirname(__FILE__) . '/../cargo_agent/cargo_agent_core.php');
require_once(dirname(__FILE__) . '/../driver/driver_core.php');

class Cargo_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_cargoCore;
    private $_waybillCore;
    private $_clearingAgentCore;
    private $_locationCore;
    private $_tenderCore;
    private $_ACTCore;
    private $_waybillDraft;
    private $_mg_registrar;
    private $_userCore;
    private $_con;
    private $_fps;
    private $_poll;
    private $_cargoAgentCore;
    private $_driverCore;
    public function __construct()
    {
        DBConnection::getInstance();
        //MongodbConnection::getInstance();

        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();

        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        // init the DriverCore object
        $this->_cargoCore = new CargoCore();
        $this->_locationCore = new LocationCore();
        $this->_tenderCore = new TenderCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_policyCore = new Policy_Core();
        $this->_ACTCore = new ACT();
        $this->_waybillDraft = new WaybillDraftCore();
        $this->_waybillCore = new WaybillCore();
        $this->_mg_registrar = new MG_registrar();
        $this->_userCore = new UserCore();
        $this->_con = new Container();
        $this->_fps = new FPS();
        $this->_poll = new Poll();
        $this->_cargoAgentCore = new CargoAgentCore();
        $this->_driverCore = new DriverCore();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // -------------------------------------------------------------- //
    // --------------------- get info for a certian cargo ----------- //
    // -------------------------------------------------------------- //
    public function getCargo()
    {

        $cargoBean = $this->_cargoCore->getCargo($this->_request->id, $_SESSION['user_id']);

        $cargoBean = json_decode($cargoBean);
        if ($cargoBean->location_id) {
            $locationBean = $this->_locationCore->getLocation($cargoBean->location_id, $_SESSION['user_id']);
            $locationBean = json_decode($locationBean);

            if ($locationBean) {
                $cargoBean->location_name = $locationBean->name;
            } else {
                $cargoBean->location_name = "-";
            }
        }

        //return Success reponse
        parent::response($cargoBean);
    }

    // ---------------------------------------------------------------------- //
    // -------------------search for cargo using any search filter ---------- //
    // ---------------------------------------------------------------------- //
    public function searchCargo()
    {

        // call the core search
        $filter = $this->prepareFilter();

        $cargo_qry = $this->_cargoCore->searchCargo(
            $filter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //add cargo weight in case the cargo is not container
        foreach ($cargo_qry->data as &$cargo) {
            if (!$cargo->container) {

                if (!$cargo->weight_booked) {
                    $cargo->weight_booked = "N/A";
                }
                if (!$cargo->weight_reserved) {
                    $cargo->weight_reserved =  "N/A";
                }
            }
        }

        parent::response($cargo_qry);
    }

    // ---------------------------------------------------------------------- //
    // -------------------search for cargo agent using any search filter ---------- //
    // ---------------------------------------------------------------------- //
    public function searchCargoAgent()
    {

        // call the core search
        $filter = $this->prepareFilter();

        $cargo_agent_qry = $this->_cargoAgentCore->searchCargoAgent(
            $filter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        $result = [];
        $temp = new stdClass();
        $temp->value = null;
        $temp->label = "الرجاء الإختيار";
        $result[] = $temp;

        foreach ($cargo_agent_qry->data as $cargoAgent) {
            $temp = new stdClass();
            $temp->value = $cargoAgent->id;
            $temp->label = $cargoAgent->name;

            $result[] = $temp;
        }

        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------------------- //
    // --------------- Generate email body to be sent to ca of cpmpleted cargos in certain policy -------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function generateCargoPolicyCaReport()
    {

        $declaration_number = $this->_request->declaration_number;

        // search for declaration info
        $filter = [];
        $filter[] = ['key' => 'declaration_number', 'val' => $declaration_number];
        $cargo_container_qry = $this->_cargoCore->searchCargoContainer($filter, 1000, 0, $_SESSION['user_id']);

        // get the service id of CONTAINER_BOND
        $waybillDraftFilter = [['key' => "name", 'val' => "CONTAINER_BOND"]];
        $tenderServices = $this->_waybillCore->searchWaybillServices($waybillDraftFilter, 1, 0, $_SESSION['user_id']);
        $container_bond_service_id = $tenderServices->data[0]->id;

        //filter the cargo which has bond service
        $cargos = [];
        foreach ($cargo_container_qry->data as $cargo) {
            if (!$this->_cargoCore->isContianer($cargo)) {
                $cargo->container_bond_service_id = $container_bond_service_id;

                // search if the cargo is in waybill_draft
                $filter = ["document->>'$.cargo[0].cargo.id'" =>  $cargo->cargo_id, "status not in" => "INACTIVE"];
                $searchWaybillResults = $this->_waybillDraft->searchWaybillDraft($filter, null, 50, 0);

                if (sizeof($searchWaybillResults) > 0) {
                    $doc = json_decode($searchWaybillResults[0]->document);

                    foreach ($doc->services as $service) {
                        if (strtoupper($service->service_code) == "CONTAINER_BOND") {
                            $cargos[] = $cargo->name;
                            break;
                        }
                    }
                }
            }
        }

        $details = json_decode($cargo_container_qry->data[0]->details);
        $ca_id = $details->company_name;

        $caFilter = [['key' => 'id', 'val' => $ca_id]];
        $clearingAgent = $this->_clearingAgentCore->searchClearingAgent($caFilter, 100000, 0, 0);
        $ca_bean = $clearingAgent->data[0];

        // prepare data
        $Result = [];
        $Result['title'] = "انجاز حاويات";
        $Result['email'] = $ca_bean->email;
        $body  = "السادة شركة $ca_bean->name المحترمون" . "\n";
        $body  .= "تحية طيبة وبعد" . "\n";
        $body  .= "تم تسليم بون التحميل للحاويات التالية في البيان رقم $declaration_number:" . "\n";
        foreach ($cargos as $container) {
            $body  .= $container . "\n";
        }
        $body  .= "مع الاحترام ،،" . "\n";

        $Result['body'] = $body;
        if (sizeof($cargos) > 0) {
            $Result['has_containers'] = true;
        } else {
            $Result['has_containers'] = false;
        }

        parent::response($Result);
    }

    // ---------------------------------------------------------------------- //
    // -------------------search for cargo policy using any search filter ---------- //
    // ---------------------------------------------------------------------- //
    public function searchCargoPolicy()
    {

        // call the core search
        $filter = $this->prepareFilter();

        $cargo_qry = $this->_cargoCore->searchCargoContainer(
            $filter,
            500,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // get the service id of CONTAINER_BOND
        $waybillDraftFilter = [['key' => "name", 'val' => "CONTAINER_BOND"]];
        $tenderServices = $this->_waybillCore->searchWaybillServices($waybillDraftFilter, 1, 0, $_SESSION['user_id']);
        $container_bond_service_id = $tenderServices->data[0]->id;

        //add cargo weight in case the cargo is not container
        foreach ($cargo_qry->data as &$cargo) {

            if (!$this->_cargoCore->isContianer($cargo)) {
                $cargo->container_bond_service_id = $container_bond_service_id;

                // search if the cargo is in waybill_draft
                $filter = ["document->>'$.cargo[0].cargo.id'" =>  $cargo->cargo_id, "status not in" => "INACTIVE"];
                $searchWaybillResults = $this->_waybillDraft->searchWaybillDraft($filter, null, 50, 0);
                $cargo->driver_name = $searchWaybillResults[0]->driver_name;
                $cargo->driver_phone = $searchWaybillResults[0]->driver_nn;
                $cargo->tn = $searchWaybillResults[0]->tn;

                if (sizeof($searchWaybillResults) > 0) {
                    $doc = json_decode($searchWaybillResults[0]->document);

                    foreach ($doc->services as $service) {
                        if (strtoupper($service->service_code) == "CONTAINER_BOND") {
                            $cargo->has_container_bond = true;
                            break;
                        }
                    }
                }

                if (!$cargo->weight_booked) {
                    $cargo->weight_booked = "N/A";
                }
                if (!$cargo->weight_reserved) {
                    $cargo->weight_reserved =  "N/A";
                }
            }
        }

        parent::response($cargo_qry);
    }

    // ---------------------------------------------------------------------- //
    // -------------------search for cargo container using any search filter ---------- //
    // ---------------------------------------------------------------------- //
    public function searchCargoContainer()
    {

        // parse filter in case it is string
        if (gettype($this->_request->filter)  == "string") {
            $cargo_container_filter = json_decode($this->_request->filter, true);
        } else {
            $cargo_container_filter = $this->_request->filter;
        }

        // if the user wants to search for container number
        if ($cargo_container_filter['container']) {

            $_cargoFilter = ["container" => $cargo_container_filter['container']];
            $cargo_filter = $this->prepareFilter($_cargoFilter);
            $cargo_container_qry = $this->_cargoCore->searchCargoContainer($cargo_filter, $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);

            unset($cargo_container_filter["container"]);
            $cargo_container_filter["declaration_number"] = $cargo_container_qry->data[0]->declaration_number;
        }

        // call the core search
        $view_filter = $this->prepareFilter($cargo_container_filter);
        $limit = $this->_request->limit;
        $offset = $this->_request->offset;
        $trx_qry = DBConnection::searchReport("cargo_policy", "02", $view_filter, $limit, $offset, $_SESSION['user_id'], ' order by p_create_date desc ');


        $Result = [];
        $Result['data'] = $trx_qry->data;
        $Result['found_rows'] = sizeof($trx_qry->data);
        parent::response($Result);
    }

    // ---------------------------------------------------------------------- //
    // --------------------- create new  policy ----------------------------- //
    // ---------------------------------------------------------------------- //
    public function createPolicy()
    {

        throw new Exception("هذه الخدمة موقوفة مؤقتا");

        // make sure the declaration number is not already exist
        $declaration_number = $this->_request->declaration_number;
        $policyFilter = [['key' => 'declaration_number', 'val' => $declaration_number]];
        $policyResult = $this->_policyCore->searchPolicies($policyFilter, 1000, 0, $_SESSION['user_id']);
        if ($policyResult->found_rows > 0) {
            throw new Exception("لا تستطيع المتابعة، رقم البيان الجمركي مدخل مسبقا");
        }

        if (!$this->_request->ca_id) {
            throw new Exception("المخلص غير موجود");
        }

        // prepare policyBean
        $policyBean = new stdClass();
        $policyBean->policy_number = $this->_request->policy_number;
        $policyBean->shipping_line_id = $this->_request->shipping_line->id;
        $policyBean->ca_id = $this->_request->ca_id;
        $policyBean->customs_permit_number = $this->_request->customs_permit_number;
        $policyBean->declaration_number = $this->_request->declaration_number;

        $details = new stdClass();
        $details->cargo_description = $this->_request->cargo_description;
        $details->owner_name = $this->_request->ownerName;
        $details->owner_phone = $this->_request->phoneNumber;
        $details->sign_number = $this->_request->signNumber;
        $details->policy_create_date = $this->_request->start_date;
        $details->weight_per_ton = $this->_request->weight_per_ton;
        $details->shipping_line_name = $this->_request->shipping_line->name;
        $details->discharge_location = $this->_request->discharge_location;
        $activity = $this->_cargoCore->generatePolicyActivity("create", $_SESSION['u_id'], "");

        $details->activity = [];
        $details->activity[] = $activity;
        $policyBean->details = $details;

        // insert into db policy table
        $inserted_policy_id = $this->_cargoCore->createPolicy($policyBean,  $_SESSION['user_id']);

        parent::response($inserted_policy_id);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- create new  policy ----------------------------- //
    // ---------------------------------------------------------------------- //
    public function updatePolicy()
    {

        try {
            // prepare policyBean
            $policyBean = $this->_policyCore->getPolicy($this->_request->id, $_SESSION['user_id']);

            $policyBean->policy_number = $this->_request->policy_number;
            $policyBean->shipping_line_id = $this->_request->shipping_line_id;
            $policyBean->ca_id = $this->_request->ca_id;
            $policyBean->customs_permit_number = $this->_request->customs_permit_number;
            $policyBean->declaration_number = $this->_request->declaration_number;

            $details = new stdClass();
            $details->cargo_description = $this->_request->cargo_description;
            $details->owner_name = $this->_request->owner_name;
            $details->owner_phone = $this->_request->owner_phone;
            $details->sign_number = $this->_request->sign_number;
            $details->policy_create_date = $this->_request->policy_create_date;
            $details->weight_per_ton = $this->_request->weight_per_ton;
            $details->shipping_line_name = $this->_request->shipping_line_name;
            $details->discharge_location = $this->_request->discharge_location;
            $remarks = preg_replace("/\r\n|\n\r|\r|\n/", "\\n", $this->_request->remarks);
            $details->remarks = $remarks;

            $policyBean->details = $details;

            // insert into db policy table
            $policy_id = $this->_cargoCore->updatePolicy($policyBean,  $_SESSION['user_id']);

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "تمت العملية بنجاح";
            $Result['ID'] = $policy_id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    private function prepareFilter($customFilter = null)
    {

        if ($customFilter) {
            $this->_request->filter = $customFilter;
        }
        $cargoFilter = [];
        if ($this->_request->filter) {
            if (gettype($this->_request->filter)  == "string") {
                $filter = json_decode($this->_request->filter, true);
            } else {
                $filter = $this->_request->filter;
            }
            foreach ($filter as $key => $value) {

                if ($key == 'ct_id' || $key == 'location_id') {
                    $tempArr = ['key' => $key, 'val' => explode(",", $value), 'op' => 'in'];
                } else if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'LIKE'];
                } else if ($key == 'container' && $value == '^') {
                } else if ($key == 'container') {
                    $tempArr = ['key' => $key, 'val' => $value];
                } else if ($key == "update_date") {
                    $tempArr = ['key' => $key, 'val' => $value . "00:00:00", 'op' => 'date greater than'];
                    array_push($cargoFilter, $tempArr);
                    $tempArr = ['key' => $key, 'val' => $value . "23:59:59", 'op' => 'date less than'];
                    array_push($cargoFilter, $tempArr);
                    continue;
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }

                array_push($cargoFilter, $tempArr);
            }
        }
        return $cargoFilter;
    }

    // ------------------------------------------------------------------ //
    // --------------------- create new Container cargo  ---------------- //
    // ------------------------------------------------------------------- //
    public function createCargoPolicy()
    {

        throw new Exception("هذه الخدمة موقوفة مؤقتا");

        // get user params
        $container = $this->_request->container;
        $containers = $this->_request->listOfContainers;
        $declaration_number = $this->_request->declaration_number;

        if ($container && !$containers) {
            $data = $this->_ACTCore->getActContainerInfo($container);

            if (sizeof($data["ContainerAvailabilityResults"]) == 0) {
                throw new Exception("رقم الحاوية $container  غير صحيح أو لا توجد له معلومات في النظام");
            }

            foreach ($data["ContainerAvailabilityResults"] as $act_c) {
                $newContainer = new stdClass();
                $newContainer->name = $act_c["ContainerId"];
                $size_type_height = str_split($act_c["SizeTypeHeight"], 2);

                $size = $size_type_height[0];
                $type = $size_type_height[1];
                $iso_qry = "select * from iso where type like '%" . $type . "%' and status != 'INACTIVE' and length = " . $size . " limit 1";
                $container_details = DBConnection::runBindDatabaseQuery($iso_qry, []);
                $newContainer->iso = $container_details[0]->ISO;
                $newContainer->size_type_height = str_split($act_c["SizeTypeHeight"], 2);
                $containers[] = $newContainer;
            }
        }

        // prepare needed info
        $tender_id = 21;    // TODO

        // get policy_id
        $policyFilter = [['key' => 'declaration_number', 'val' => $declaration_number]];
        $policyResult = $this->_policyCore->searchPolicies($policyFilter, 1000, 0, $_SESSION['user_id']);
        if ($policyResult->found_rows == 0) {
            throw new Exception("رقم البيان الجمركي غير صحيح");
        }
        $policy_id = $policyResult->data[0]->id;
        $ca_id = $policyResult->data[0]->ca_id;
        if (!$ca_id) {
            throw new Exception("لا يوجد مخلص للبيان الجمركي");
        }

        // loop on each container to append it
        foreach ($containers as $con) {

            // if the cargo does not exist, create it
            $cargoFilter = [];
            $cargoFilter[] = ['key' => 'status', 'val' => ["ACTIVE", 'NEW'], "op" => 'in'];
            $cargoFilter[] = ['key' => 'name', 'val' => $con->name];
            $cargo_qry = $this->_cargoCore->searchCargo($cargoFilter, 1, 0, 0);

            if ($cargo_qry->found_rows > 0) {
                $cargo_id = $cargo_qry->data[0]->id;
            } else {
                // create cargo Bean
                $cargoBean = new stdClass();
                $cargoBean->name = $con->name;
                $cargoBean->container = $con->name;
                $cargoBean->tender_id = $tender_id;
                $cargoBean->ct_id = 920100; // حاوية
                $cargoBean->ca_id = $ca_id;
                $cargoBean->status = "NEW";
                $cargoBean->iso = $con->iso;
                $cargoBean->waybill_template = '{}';
                $cargoBean->vessel_name = $con->vessel_name;

                // fill iso details
                $cargoBean->size = $con->size_type_height[0];
                $cargoBean->type = $con->size_type_height[1];
                $cargoBean->height = $con->size_type_height[2];

                $cargo_id = $this->_cargoCore->createCargo($cargoBean, $_SESSION['user_id']);
            }


            // create cargo policy
            if ($cargo_id) {

                // validate the cargo_id is not already on policy
                $searchFilter = [
                    ['key' => 'policy_id', 'val' => $policy_id],
                    ['key' => 'status', 'val' => ["INACTIVE"], "op" => "not in"],
                    ['key' => 'cargo_id', 'val' => $cargo_id]
                ];
                $cargo_qry = $this->_cargoCore->searchCargoContainer($searchFilter, 1, 0, $_SESSION['user_id']);
                if ($cargo_qry->found_rows > 0) {
                    throw new Exception("الحاوية مضافة مسبقا على البيان");
                }
                $cargoPolicyBean = new stdClass();
                $cargoPolicyBean->policy_id  = $policy_id;
                $cargoPolicyBean->cargo_id  = $cargo_id;
                $this->_cargoCore->createCargoPolicy($cargoPolicyBean, 0);

                // log activity
                $this->_cargoCore->logPolicyActivity($policy_id, 'create_cargo_policy', $con->name, $_SESSION['u_id'], $_SESSION['user_id']);
            }
        }

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تمت عملية الإضافة بنجاح';
        parent::response($Result);
    }



    // ------------------------------------------------------------------------- //
    // -------------------change cargo status  --------------------------------- //
    // ------------------------------------------------------------------------- //
    public function changePolicyStatus()
    {
        // get policy bean
        $policyBean = $this->_policyCore->getPolicy($this->_request->id, $_SESSION['user_id']);
        if (!$policyBean) {
            throw new Exception("رقم البيان غير صحيح");
        }

        // change policy status
        $this->_cargoCore->changePolicyStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        // loop on cargo_policy items and change its policy
        $searchFilter = [['key' => 'policy_id', 'val' => $this->_request->id]];
        $searchRes = $this->_cargoCore->searchCargoContainer($searchFilter, 1000, 0, $_SESSION['user_id']);
        foreach ($searchRes->data as &$item) {
            $this->_cargoCore->changeCargoPolicyStatus($item->id, $this->_request->new_status,  $_SESSION['user_id']);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تمت العملية بنجاح ";
        parent::response($Result);
    }




    // changePolicyStatus
    // changeCargoPolicyStatus
    // ------------------------------------------------------------------ //
    // --------------------- create new Container cargo  ---------------- //
    // ------------------------------------------------------------------- //
    public function createContainerCargo()
    {

        // create cargo Bean
        $cargoBean = new stdClass();
        $cargoBean->name = $this->_request->container;
        $cargoBean->tender_id = $this->_request->tender_id;
        $cargoBean->q_id = $this->_request->q_id;
        $cargoBean->container = $this->_request->container;
        $cargoBean->weight_total = $this->_request->weight_total;
        $cargoBean->weight_units = "kg";
        $cargoBean->waybill_template =  $this->_request->waybill_template;
        $cargoBean->vessel_name = $this->_request->vessel_name;
        // create cargo in DB
        $id = $this->_cargoCore->createCargo($cargoBean, $_SESSION['user_id']);

        // attempt to auto activate container by integeration with ACT
        //$this->validateACTContainer($id, $this->_request->tender_id,$this->_request->container);

        // reuturn result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CARGO.SUCCESSFUL_CREATE";
        $Result['ID'] = $id;

        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- validate container from ACT term view  ------------------ //
    // ------------------------------------------------------------------------------- //
    private function validateACTContainer($id, $tender_id, $container)
    {

        //        $content = getPage("https://termview.apmterminals.com/Public/ContainerInquiry.aspx?TerminalCode=ACT&EquipmentNumber=".$container);
        //
        //        if (strpos($content, 'Could not resolve host') !== false) {
        //            return false;
        //        }
        //
        //        if (strpos($content, "Container " . $container . " not found at terminal ACT") !== false) {
        //            return false;
        //        }
        //
        //        $dom = new DOMDocument;
        //        $dom->loadHTML($content);
        //        $xpath = new DOMXPath($dom);
        //        $results = $xpath->query("//*[@class='DetailCellValue']");
        //
        //        $container = $results->item(0)->nodeValue;
        //        $iso = $results->item(1)->nodeValue;
        //        $sizeArr = str_split(trim($iso), 2);
        //        $result = new stdClass();
        //        $result->error_code = "CARGO.SUCCESSFUL";
        //        $result->container = $container;
        //        $result->iso = trim($iso);
        //        $result->size = $sizeArr[0];
        //        $result->type = $sizeArr[1];
        //        $result->height = $sizeArr[2];
        //
        //        return $result;
        //        $cargoBean->iso = $ACT_info->iso;
        //        $cargoBean->size = $ACT_info->size;
        //        $cargoBean->type = $ACT_info->type;
        //        $cargoBean->height = $ACT_info->height;
        //        $this->_cargoCore->updateCargo($cargoBean, $id,0);  // update by system
        // check if there is auto action to be done by the system
        //        $this->activateContainer($id, $tender_id,'920102');

    }


    // ---------------------------------------------------------------- //
    // --------------------- activate Container cargo  ---------------- //
    // ---------------------------------------------------------------- //
    private function activateContainer($id, $tender_id, $ct_id)
    {

        // change status of cargo
        $this->_cargoCore->activateCargo($id, null, 0);

        // push the activated contyainer into task queue to be distributed
        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->pushContainerToTenderOrder($id, $tender_id, $ct_id);
    }


    // ------------------------------------------------------------------------------------------------------ //
    // ------------ activate Container manually in case the integration method is not working---------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function activateContainerManually()
    {

        // get the bean stored in database
        $cargoBean = $this->_cargoCore->getCargoBasic($this->_request->id,  $_SESSION['user_id']);

        // fill the new values
        $cargoBean->iso = $this->_request->iso;
        $cargoBean->size = $this->_request->size;
        $cargoBean->type = $this->_request->type;
        $cargoBean->ct_id = $this->_request->ct_id;
        $cargoBean->location_id = $this->_request->location_id;
        $cargoBean->height = $this->_request->height;

        // update the cargoBean in database
        $this->_cargoCore->updateCargo($cargoBean, $this->_request->id, 0);  // update by system

        // activate container
        $this->activateContainer($this->_request->id,  $this->_request->tender_id, $this->_request->ct_id);

        // return result to user
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CARGO.SUCCESSFUL_ACTIVATE";
        $Result['ID'] =  $this->_request->id;
        parent::response($Result, 200);
    }




    // ------------------------------------------------------------------ //
    // --------------------- create new General cargo  ------------------ //
    // ------------------------------------------------------------------ //
    public function createGeneralCargo()
    {

        // create cargo Bean
        $cargoBean = new stdClass();
        $cargoBean->name = $this->_request->name;
        $cargoBean->tender_id = $this->_request->tender_id;
        $cargoBean->q_id = $this->_request->q_id;
        $cargoBean->weight_total = $this->_request->weight_total;
        $cargoBean->weight_units = "kg";
        $cargoBean->ct_id    =  $this->_request->ct_id;
        $cargoBean->ca_id    =  $this->_request->ca_id;
        $cargoBean->location_id = $this->_request->location_id;
        $cargoBean->vessel_name = $this->_request->vessel_name;
        $discharge_report_flag = $this->_request->discharge_report_flag;
        $cargoBean->agent_id = $this->_request->agent_id;
        $cargoBean->vessel_visit_id = $this->_request->vessel_visit_id;
        $company_quota = $this->_request->company_quota;
        // $cargoBean->vessel_visit_id =1;

        $waybill_template = json_decode($this->_request->waybill_template);

        // save the service prices from tender manifest
        $man = $this->_tenderCore->getTenderManifest($this->_request->tender_id, 0);
        $service_price = $man['freight']['service_price'];
        $waybill_template->negotiable_instructios->freight->service_price = $service_price;
        $waybill_template->cargo[0]->company_quota = $company_quota;

        // check if discharge report flag
        // add poll id
        if ($discharge_report_flag) {
            $mainQuestion = "هل أتممت عملية تفريغ وتسليم البضاعة للشاحنة رقم tn ال مستند رقم wn و حمولة cargo_name";
            $poll_id =  $this->_cargoCore->makePullForDischargeReport($mainQuestion, $cargoBean , "createDischargeReport");

            

            if ($poll_id) {
                $waybill_template->discharge_report = new stdClass();
                $waybill_template->discharge_report->poll_id = $poll_id;
            }
        }

        $cargoBean->waybill_template = json_encode($waybill_template, JSON_UNESCAPED_UNICODE);



        // call core create
        $id = $this->_cargoCore->createCargo($cargoBean, $_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('CARGO', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction) {
            $this->_cargoCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        // in case the tender has the feature of informing the clearing agent, send him a message
        // todo: this has to be dynamic from tender manifest
        if ($this->_request->tender_id == 22) {
            // send SMS to CA_MANAGER
            $message = "تم انشاء حمولة " . $this->_request->name . " من القرية اللوجستية";

            $messageRecipient = "0791233491";
            $messageRecipient = convertToInternational($messageRecipient);
            sendSMS($messageRecipient, $message);

            $messageRecipient = "0798667755";
            $messageRecipient = convertToInternational($messageRecipient);
            sendSMS($messageRecipient, $message);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CARGO.SUCCESSFUL_CREATE";
        $Result['ID'] = $id;
        parent::response($Result, 200);
    }

    public function makePullForDischargeReport($discharge_report_flag, $cargoBean)
    {
        $questions = [
            [
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "نعم",
                        "next_question" => 1
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 0,
                "question_type" => "single",
                "question_lable" => "هل أتممت عملية تفريغ وتسليم البضاعة للشاحنة رقم tn ال مستند رقم wn و حمولة cargo_name",
                "question_attachment_url" => ""
            ],
            [
                "layout" => "CARD",
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "متابعة",
                        "next_question" => 2
                    ]
                ],
                "doc_type" => "delivering_cargo_signature",
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 1,
                "question_type" => "file",
                "question_lable" => "الرجاء تصوير توقيع استلام البضاعة من المالك",
                "question_attachment_url" => null
            ],
            [
                "layout" => "CARD",
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "متابعة",
                        "next_question" => 3
                    ]
                ],
                "doc_type" => "delivering_cargo",
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 2,
                "question_type" => "file",
                "question_lable" => "تصوير البضاعة",
                "question_attachment_url" => null
            ],
            [
                "answers" => [
                    [
                        "value" => "",
                        "caption" => "تأكيد",
                        "next_question" => 4
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 3,
                "question_type" => "FREE_TEXT",
                "question_lable" => "ملاحظات",
                "question_attachment_url" => null
            ],
            [
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "إرسال تقرير التسليم",
                        "next_question" => null
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 4,
                "question_type" => "single",
                "question_lable" => "أقر بتسليم البضاعة حسب ما تم الإتفاق عليه وأتحمل كامل المسؤولية عن ذلك",
                "question_attachment_url" => null
            ]
        ];

        if ($discharge_report_flag) {

            // system is default recipient
            $rec = [];
            $rec['bind_params'] = [];
            $rec['user_id'] = 0;
            $rec['communication_channels'] = [];

            $poll_1 = [];
            $poll_1['details'] = [];
            $poll_1['details']['questions'] =  $questions;
            $poll_1['title'] = " تقرير تسليم بضاعة $cargoBean->name";
            $poll_1['details']['attributes'] = [];
            $poll_1['details']['attributes']['title'] = " تقرير تسليم بضاعة $cargoBean->name";
            $poll_1['details']['attributes']['priority'] = 5;
            $poll_1['details']['attributes']['is_dismissible'] = true;
            $poll_1['details']['attributes']['scenario'] = "normalScenario";
            $poll_1['details']['attributes']['expiry_date'] = date('Y-m-d h:i:s', strtotime(DBConnection::getSystemDate() . "+1 year"));
            $poll_1['details']['attributes']['can_change_answer'] = false;
            $poll_1['details']['attributes']['max_retries'] = "1";
            $poll_1['details']['attributes']['description'] = "تقييم البضاعة المستلمة ";
            $poll_1['details']['attributes']['callback'] = [[
                "url" => "API.MINAGATE.COM",
                'data' => ['method' => "createDischargeReport"],
                "type" => "answer",
            ]];
            $poll_1['details']['attributes']['sub_type'] = "feedback";
            $poll_1['recipients'] = [$rec];

            $poll_id =  $this->_poll->createPoll($poll_1);

            return $poll_id;
        }
        return null;
    }

    public function updateDischargeReportCargo()
    {
        // $cargo_id = $this->_request->cargo_id;

        // $waybills =$this->_waybillCore->searchWaybills([
        //     ['key' => 'document', 'val' => "$pa_project_id", 'op' => 'json unquote', 'node' => '$.pa_project_id']
        // ],500,0,$_SESSION['user_id']);

        // parent::response($waybills);
    }

    // ------------------------------------------------------------------------- //
    // -------------------change cargo status  --------------------------------- //
    // ------------------------------------------------------------------------- //
    public function changeStatus()
    {
        $this->_cargoCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        if ($this->_request->new_status == "INACTIVE") {
            // search for all cargo policies of the container
            $searchFilter = [['key' => 'cargo_id', 'val' => $this->_request->id]];
            $searchRes = $this->_cargoCore->searchCargoContainer(
                $searchFilter,
                1000,
                0,
                $_SESSION['user_id']
            );

            if ($searchRes->found_rows > 0) {
                // change status of cargo policy
                $cargo_policy_id = $searchRes->data[0]->id;

                $cargoPolicyBean = $this->_policyCore->getCargoPolicy($cargo_policy_id, $_SESSION['user_id']);
                $cargoBean = $this->_cargoCore->getCargoBasic($cargoPolicyBean->cargo_id, 0);
                $this->_cargoCore->logPolicyActivity($cargoPolicyBean->policy_id, 'delete_cargo_policy', $cargoBean->name, $_SESSION['u_id'], $_SESSION['user_id']);
                $this->_cargoCore->changeCargoPolicyStatus($cargo_policy_id, $this->_request->new_status,  $_SESSION['user_id']);
            }
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم حذف الحاوية بنجاح";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------- //
    // -------------------update cargo info  ----------------------------------- //
    // ------------------------------------------------------------------------- //
    public function updateCargo()
    {
        $discharge_report_flag = $this->_request->discharge_report_flag;
        $company_quota = $this->_request->company_quota;
        unset($this->_request->discharge_report_flag);
        $this->_request->waybill_template->cargo[0]->company_quota = $company_quota;
        if ($discharge_report_flag === 'true' || $discharge_report_flag === true) {
            // check if discharge report flag
            // add poll id
            $poll_id =  $this->makePullForDischargeReport($discharge_report_flag, $this->_request);
            $this->_poll->publishPoll($poll_id);

            if ($poll_id) {
                $this->_request->waybill_template->discharge_report = new stdClass();
                $this->_request->waybill_template->discharge_report->poll_id = $poll_id;
            }

        }
        $this->_request->waybill_template = json_encode($this->_request->waybill_template, JSON_UNESCAPED_UNICODE);
        $this->_cargoCore->updateCargo($this->_request, $this->_request->id, $_SESSION['user_id']);
        $res = $this->_waybillCore->searchWaybills([
            ['key' => 'document', 'val' => $this->_request->id, 'op' => 'json unquote', 'node' => '$.cargo[0].cargo_id'],
            ['key' => 'status'  , 'val' => 'ONROAD']
        ],500,0,$_SESSION['user_id']);

        foreach ($res->data as $waybillBean) {

            $driver_id = $waybillBean->driver_id;
            $driverBean = $this->_driverCore->getDriver($driver_id,$_SESSION['user_id']);
            $user_id = json_decode($driverBean)->user_id;
            $userBean = $this->_userCore->getUser($user_id,$_SESSION['user_id']);

            if ($userBean) {
                $userBean = json_decode($userBean);
                $recipients = [];
                $rec['user_id'] = $userBean->id;
                $rec['bind_params'] = json_encode(array('wn'=>$waybillBean->wn,'cargo_name'=>$this->_request->name,'tn'=>$waybillBean->tn,'waybill_id'=>$waybillBean->id));
                $rec['communication_channels'] = [
                    ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
                    // ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2]
                ];
                $recipients[] = $rec;
                $this->_poll->appendRecipientToPoll($poll_id, $recipients);

            }
        }
        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CARGO.SUCCESS_UPDATE";
        parent::response($Result);
    }
    public function  subscribeCargo()
    {
        // $cargos = $this->_request->cargos;
        // foreach ($cargos as $cargo) {
        //     $result = MongodbConnection::getDocument(
        //         ["object_id" => $cargo->id, "user_id" => $_SESSION['user_id'] ]);
        //     if (count($result) == 0) {
        //         //------ not inserted ---------
        //         $document = [
        //             "_id" => new MongoDB\BSON\ObjectId,
        //             "object" => "CARGO",
        //             "object_id" => $cargo->id,
        //             "user_id" =>  $_SESSION['user_id'] ,
        //             "action_filter" => $cargo->action_filter,
        //             "channel" => $cargo->channel,
        //             "status" =>"SUBSCRIBED"
        //         ];
        //         MongodbConnection::insertDocument( $document);
        //     } else if (count($result) == 1) {
        //         //---------inserted -----------------
        //         if ($result[0]->status == 'UNSUBSCRIBED') {
        //             MongodbConnection::updateDocument(
        //                 ["_id" => $result[0]->_id],
        //                 ['$set' => ['status' => "SUBSCRIBED"]],
        //                 ['multi' => false, 'upsert' => false]);
        //         }
        //     }
        // }
        // //return Success reponse
        // $Result['ERRORCODE'] = "0";
        // $Result['MESSAGE'] = "CARGO.SUCCESSFUL_SUBSCRIBED";
        // parent::response($Result,200);
    }
    public function  unsubscribeCargo()
    {
        // $cargos = $this->_request->cargos;

        // foreach ($cargos as $cargo) {

        //     $result = MongodbConnection::getDocument(
        //         ["object_id" => $cargo->id, "user_id" => $_SESSION['user_id'] ]);

        //     if (count($result) == 1) {
        //         //---------inserted -----------------
        //         if ($result[0]->status == 'SUBSCRIBED') {
        //             MongodbConnection::updateDocument(
        //                 ["_id" => $result[0]->_id],
        //                 ['$set' => ['status' => "UNSUBSCRIBED"]],
        //                 ['multi' => false, 'upsert' => false]);
        //         }
        //     }else{
        //         //------ not inserted ---------
        //         $document = [
        //             "_id" => new MongoDB\BSON\ObjectId,
        //             "object" => "CARGO",
        //             "object_id" => $cargo->id,
        //             "user_id" =>  $_SESSION['user_id'] ,
        //             "action_filter" => $cargo->action_filter,
        //             "channel" => $cargo->channel,
        //             "status" =>"UNSUBSCRIBED"
        //         ];
        //         MongodbConnection::insertDocument( $document);
        //     }

        // }
        // //return Success reponse
        // $Result['ERRORCODE'] = "0";
        // $Result['MESSAGE'] = "CARGO.SUCCESSFUL_SUBSCRIBED";
        // parent::response($Result,200);

    }
    public function getActiveCargos()
    {

        $cargoFilter[] = ['key' => 'status', 'val' => "ACTIVE"];
        $cargoFilter[] = ['key' => 'container', 'val' => NULL, "op" => 'is null'];
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 5, 0, $_SESSION['user_id']);

        parent::response($cargoResult);
    }

    // ------------------------------------------------------------------------- //
    // -------------------change cargo status  --------------------------------- //
    // ------------------------------------------------------------------------- //
    public function addVessleName()
    {

        // // get cargo list
        //  $sqlQuery = " SELECT
        //                 id, name
        //                FROM
        //                  cargo
        //                WHERE
        //                 status = ?";

        //  $param[] = "CLOSED";
        //  $cargo_result = DBConnection::runBindDatabaseQuery($sqlQuery,$param);


        //  foreach($cargo_result as $cargo){
        //      preg_match_all('([a-zA-Z]+(?: [a-zA-Z]+)*)', $cargo->name, $result, PREG_PATTERN_ORDER);
        //      $result = $result[0][0];

        //      $sqlQueryup = " UPDATE
        //                  cargo
        //                SET
        //                vessel_name = '$result' , update_by = 2
        //                WHERE
        //                 id = $cargo->id";

        //  $param_cargo=[];
        //  $cargo_update=  DBConnection::runBindDatabaseQuery($sqlQueryup,$param_cargo);
        //  }
    }

    public function getContainers()
    {
        $searchFilter = [['key' => 'container', 'op' => 'is not null', 'val' => '']];
        $containersList = $this->_cargoCore->fetchContainers($searchFilter, 100, 0, $_SESSION['user_id']);
        parent::response($containersList);
    }
    public function searchContainers()
    {
        $searchFilter = json_decode($this->_request->filter);
        $containersList = $this->_cargoCore->searchByName($searchFilter, 100, 0, $_SESSION['user_id']);
        parent::response($containersList);
    }


    // ------------------------------------------------------------------------- //
    // ---------------- Auto complete container info  ----------------------- //
    // ------------------------------------------------------------------------- //
    public function containerAutoComplete()
    {
        // get user param
        $container_number = strtoupper($this->_request->container_number);

        // search in cargo policy view
        $filter = [];
        $filter[] = ['key' => 'status', 'val' => ['CLOSED', 'INACTIVE'], 'op' => 'not in'];
        $filter[] = ['key' => 'container', 'val' => $container_number];

        $cargo_qry = $this->_cargoCore->searchCargoContainer($filter, 1, 0, $_SESSION['user_id']);
        foreach ($cargo_qry->data as &$raw) {
            $raw->details = json_decode($raw->details);
        }


        parent::response($cargo_qry->data[0]);
    }
    // ------------------------------------------------------------------------- //
    // ---------------- Auto complete actContainer info  ----------------------- //
    // ------------------------------------------------------------------------- //
    public function actContainerAutoComplete()
    {

        $container_ids = $this->_request->ids;
        $data = $this->_ACTCore->getActContainerInfo($container_ids);

        $list = [];
        $list_of_container_ids = [];
        if ($data == 'no data') {
            $Result = [];
            $Result['ERRORCODE'] = '500';
            $Result['MESSAGE'] = 'لا يوجد معلومات';
            parent::response($Result);
        } else {

            foreach ($data["ContainerAvailabilityResults"] as $value) {
                $cargoBean = new stdClass();
                $cargoBean->name = $value["ContainerId"];
                $filter = [];
                $cargoBean->tender_id = $this->_tenderCore->searchTender($filter, 1000, 0, 0)->data[0]->id;
                $cargoBean->container = $value["ContainerId"];
                $cargoBean->ct_id = 920100;
                $cargoBean->status = "NEW";
                $cargoBean->size_type_height = str_split($value["SizeTypeHeight"], 2);

                $cargoBean->height = $cargoBean->size_type_height[2];
                if ($cargoBean->height == 86) {
                    $cargoBean->height = 8.5;
                }
                $cargoBean->size = $cargoBean->size_type_height[0];
                $cargoBean->type = $cargoBean->size_type_height[1];
                $iso_qry = "select * from iso where type like '%" . $cargoBean->type . "%' and status != 'INACTIVE' and length = " . $cargoBean->size . " limit 1";
                $container_details = DBConnection::runBindDatabaseQuery($iso_qry, []);
                if (sizeof($container_details) > 1) {
                    $list_of_iso = [];
                    foreach ($container_details as $isoValue) {
                        $list_of_iso[] = $isoValue->ISO;
                    }
                    $cargoBean->iso = $list_of_iso;
                } else {
                    $cargoBean->iso = $container_details[0]->ISO;
                }

                $cargoBean->waybill_template = '{}';
                $cargoBean->bill_of_lading = $value["BillOfLading"][0];
                $cargoBean->weight_total = $value["GrossWeight"];
                $cargoBean->gate_out_date = $value["GateOutDate"];
                $cargoBean->vessel_name = $value["VesselName"];
                $cargoBean->ready_for_delivery = $value["ReadyForDelivery"];
                $cargoBean->shipping_line = $value["LineId"];
                $list[] = $cargoBean;
                $list_of_container_ids[] = "'" . $value["ContainerId"] . "'";
            }
            $cargo_qry = "select container from cargo where container in (" . implode(",", $list_of_container_ids) . ") and status != 'INACTIVE'";
            $already = DBConnection::runBindDatabaseQuery($cargo_qry, []);
            $i = [];
            foreach ($already as $Inner_value) {
                $i[] = $Inner_value->container;
            }
            $finalList = [];
            foreach ($list as $value) {
                // if (!in_array($value->container, $i)) {
                $finalList[] = $value;
                // }
            }
            parent::response($finalList);
        }
    }
    // ------------------------------------------------------------------------------------------ //
    // ---------------- Release a group of containers and send emails to ca --------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function releaseContainer()
    {

        // get user input
        $data = $this->_request->data;
        $emailText = $this->_request->emailText;

        // loop on each container
        foreach ($data as $container) {
            $ca_email = $container->email;
            $containers = $container->containers;
            $clearance_ref_no = $container->clearance_ref_no;
            $releasedContainers = [];

            // loop on containers and change status
            foreach ($containers as $c) {

                // get cargo id
                $searchFilter = [
                    ['key' => 'container', 'val' => $c],
                    ['key' => 'status', 'val' => 'PENDING']
                ];
                $cargoResult = $this->_cargoCore->searchCargo($searchFilter, 1, 0, $_SESSION['user_id']);
                $cargo_id = $cargoResult->data[0]->id;

                // change status from PENDING to ACTIVE
                $this->_cargoCore->changeStatus($cargo_id, 'APPROVED', $_SESSION['user_id']);
                $releasedContainers[] = $c;
            }

            // get the ca
            $caFilter = [
                ['key' => 'reference_number', 'val' => $clearance_ref_no],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $clearingAgent = $this->_clearingAgentCore->searchClearingAgent($caFilter, 1, 0, 0);
            $company_name = $clearingAgent->data[0]->name;

            // send email to ca
            $containers = implode('<br/>', array_unique($releasedContainers));
            $Body = "<b>السادة $company_name المحترمون</b>";
            $Body .= '<br>';
            $Body .= $emailText;
            $Body .= '<br>';
            $Body .= $containers;
            $Body .= '<br/>';
            $Body .= '______________________________';
            $Body .= '<br/>';
            $Body .= 'شركة النصر للخدمات اللوجستية';

            $taskQueuesCore = new TaskQueuesCore();
            $taskQueuesCore->createSendEmailTask("فك حجز حاويات", $Body, $ca_email);
        }

        // return response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CARGO.SUCCESS_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------------------ //
    // ---------------- Release a group of containers and send emails to ca --------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function getContainerTypeOptions()
    {
        $result = [];
        $result[] = ['code' => 'GP', 'caption' => 'نقل عام'];
        $result[] = ['code' => 'R', 'caption' => 'مبرد'];
        $result[] = ['code' => 'OT', 'caption' => 'مفتوحة من الأعلى'];
        $result[] = ['code' => 'FLAT', 'caption' => 'فلات'];
        $result[] = ['code' => 'TANK', 'caption' => 'خزان'];

        $iso_qry = "select distinct(type) as type from iso where type not in ('GP','OT','R','FLAT','TANK') ";
        $iso_details =  DBConnection::runBindDatabaseQuery($iso_qry, []);

        foreach ($iso_details as $iso) {
            $result[] = ['code' => $iso->type, 'caption' => $iso->type];
        }

        parent::response($result);
    }

    // ------------------------------------------------------------------------- //
    // ---------------- auto complete base on truck number  ----------------------- //
    // ------------------------------------------------------------------------- //
    public function autoCompleteTruckInfoForSA()
    {
        try {

            // if the user want the autocomplete by land_trip_id
            if ($this->_request->land_trip_id) {
                $land_trip_id = $this->_request->land_trip_id;

                $data = new stdClass();
                $data->id = $land_trip_id;
                $landTripBean = $this->_con->getLandTrip($data, $_SESSION['user_id']);
                $landTripResult = $this->_mg_registrar->autoCompleteFromNafContainer($land_trip_id, $landTripBean['cid'], $_SESSION['user_id']);

                $result = [];
                $result['tn'] = $landTripResult->TN ? $landTripResult->TN : "";
                $result['driver_name'] = $landTripResult->TN ? $landTripResult->DRIVER_NAME : "";
                $result['trn'] = $landTripResult->TN ? $landTripResult->TRN : "";
                $result['nn'] = $landTripResult->DRIVER_NN ? $landTripResult->DRIVER_NN : "";
            }

            // if the search in TN
            else if ($this->_request->tn) {
                $tn = $this->_request->tn;

                // search in last land trip for this tn
                $data = new stdClass();
                $data->limit = 1;
                $data->filter = [];
                $data->filter[] = ['key' => 'tn', 'val' => $tn];
                $data->method = "searchLastLandTrip";
                $end_point = '/landtrip';
                $landTripResult = $this->_con->callContainer($end_point, $data, $_SESSION['user_id']);

                // if the tn has older trip
                if ($landTripResult && $landTripResult['found_rows'] > 0) {
                    $result = [];
                    $result['tn'] = $landTripResult['data'][0]['tn'];
                    $result['driver_name'] = $landTripResult['data'][0]['driver_name'];
                    $result['trn'] = $landTripResult['data'][0]['trn'];
                    $result['nn'] = $landTripResult['data'][0]['nn'];
                    $result['driver_phone'] = $landTripResult['data'][0]['driver_phone'];
                } else {
                    // in case this is the first land trip search in registration system
                    $result = $this->_mg_registrar->autoCompleteTruckInfoForSA($tn, $_SESSION['user_id']);
                }
            } else {
                throw new Exception("الرجاء قم بإدخال رقم الشاحنة من اجل البحث");
            }

            // ------ in case the result does not have driver phone -------------------
            if (!$result["driver_phone"]) {
                $searchFilter = [['key' => 'nn', 'val' => $result["nn"]], ['key' => 'status', 'val' => 'ACTIVE']];
                $userInfo = $this->_userCore->searchUser($searchFilter, 1, 0, 0);
                if ($userInfo->found_rows > 0) {
                    $result["driver_id"] = $userInfo->data[0]->driver_id;
                    $result["driver_phone"] = $userInfo->data[0]->phone;
                }
            }

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------- get the current status of cash box -----------------------
    public function getCurrentCashBoxLog()
    {

        $account_id = $this->_request->account_id;
        $tempArr = ['key' => $key, 'val' => $value];

        $cash_box_log_filter =  $this->prepareFilter();
        $filter = [];
        foreach ($cash_box_log_filter as $key =>  &$value) {
            if ($value["key"] == "create_date" && $value["val"] == "") {
                unset($cash_box_log_filter[$key]);
            }
        }
        $searchCashBoxLog_qry = $this->_accountCore->searchCashBoxLog($cash_box_log_filter,  $limit, $offset, $_SESSION['user_id'], "order by id desc");
        parent::response($searchCashBoxLog_qry->data);
    }

    // ---------------------- get the current status of cash box -----------------------
    public function openCashBoxLog()
    {
    }

    // ---------------------- get the current status of cash box -----------------------
    public function closeCashBoxLog()
    {
    }


    // search vissle name distinct
    public function searchVessle()
    {
        $vessle_names = [];
        $vessles = $this->_cargoCore->searchVessle([
            ['key' => 'tender_id', 'val' => '3'],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'IN']
        ], 40, 0, $_SESSION['user_id']);

        foreach ($vessles->data as $vessle) {
            if (!in_array($vessle->vessel_name, $vessle_names)) {
                $vessle_names[] = $vessle->vessel_name;
            }
        }
        parent::response($vessle_names);
    }

    public function getVesseleData()
    {

        // get user input
        $vessel_name = $this->_request->vessel_name;
        $cargo_id = $this->_request->cargo_id;

        // init var
        $big_table = []; // to save the cargo data and parent responsed it
        $summary = 0;
        $all_cargo_individuals = 0;
        $all_loading_weight = 0;
        $all_discharge_weight = 0;
        $all_cargo_company = 0;
        $all_indivisual_waybill = 0;
        $all_company_waybill = 0;

        // if user send cargo_id search with it if not search with vessile_name
        if ($cargo_id && $cargo_id != "null") {
            $cargo_filter = [
                ['key' => 'id', 'val' => $cargo_id]
            ];
        } else {
            $cargo_filter = [
                ['key' => 'tender_id', 'val' => '3'],
                ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'IN'],
                ['key' => 'vessel_name', 'val' => $vessel_name]
            ];
        }

        //search for vissels in cargo table
        $cargo = $this->_cargoCore->searchVessle($cargo_filter, 40, 0, $_SESSION['user_id']);

        // loop on each cargo
        foreach ($cargo->data as $go) {
            $table = []; // template for each cargo

            //search for waybills with cargo id
            $waybillFilter = [
                ['key' => 'tender_id', 'val' => 3],
                ['key' => 'cargo_id', 'val' => $go->id],
                ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in']
            ];
            $waybillSearchResult = DBConnection::searchReport("waybill", "01", $waybillFilter, 10000, 0, $_SESSION['user_id']);

            // init some variables
            $weight = 0;
            $no_of_weight = 0;
            $table['cargo_id'] = $go->id;
            $waybill_numbers = [];
            $individual = 0; // number for individuals
            $company = 0;
            $all = 0; // number for all waybills  used to calcualte percentage

            foreach ($waybillSearchResult->data as  $wb) {
                $waybill_numbers[] = $wb->wn;

                // net weight
                $w = $wb->loading_weight;

                // tc
                $tc = $wb->tc_id;

                // individual has 395 tc
                if ($tc == "395") {
                    $individual++;
                    $all_cargo_individuals++;
                } else {
                    $company++;
                    $all_cargo_company++;
                }


                if ($w &&  intval($w) > 0) {
                    $weight += intval($w); // total of loading  weight
                    $no_of_weight++; // number of loading weight
                    $all_loading_weight += intval($w);
                }
                $all++;
            }


            // get the discharge weight from the claim_items in fps
            try {

                $total_fps = [];
                // split array to multi arrays each 500 at max
                $chunk_wbl_array = array_chunk($waybill_numbers, 500);

                foreach ($chunk_wbl_array as $temp_waybill_numbers) {

                    $fps_data = new stdClass();
                    $fps_data->filter = ['wn_in' => $temp_waybill_numbers];
                    $fps_data->limit = 1000;
                    $fps = $this->_fps->searchClaimItems($fps_data, $_SESSION['user_id']);

                    if (sizeof($fps['data']) > 0) {
                        foreach ($fps['data'] as $temp) {
                            $total_fps['data'][] = $temp;
                        }
                    }
                }
            } catch (Exception $e) {
            }


            // init for discharge weight variables
            $dis_weight = 0;
            $no_of_dis_weight = 0;

            if ($total_fps['data']) {

                foreach ($total_fps['data'] as $value) {
                    $dis = json_decode($value['requested'])->discharge->weight;
                    if ($dis) {
                        $dis_weight += $dis; //total of discharge weight
                        $no_of_dis_weight++;
                        $all_discharge_weight += intval($dis);
                    }
                }
            }


            $table['name'] = $go->name;
            $table['loading_weight'] = $weight / 1000;
            $table['loading_weight_number'] = $no_of_weight;
            $table['discharge_weight'] = $dis_weight / 1000;
            $table['discharge_weight_number'] = $no_of_dis_weight;
            if($all > 0){
                $indi_percent = number_format((doubleval($individual) / doubleval($all)) * 100, 1);
            }else{
                $indi_percent = 0;
            }
            $summary += $indi_percent;
            $table['individual_count'] = $individual;
            $table['company_count'] = $company;
            $table['indi_percentage'] = $indi_percent . '%';
            $table['waybill_company_count'] = $company;
            $table['company_percentage'] = number_format(100 - doubleval($indi_percent), 1) . '%';
            $big_table['cargo'][] = $table;
        }


        if ($cargo->found_rows > 0) {

            // start calcuklating vessel summary performance
            $big_table['summary']['total_individual_count'] = $all_cargo_individuals;
            $big_table['summary']['total_company_count'] = $all_cargo_company;

            $big_table['summary']['all_waybills'] = $all_cargo_individuals + $all_cargo_company;
            if($all_cargo_individuals + $all_cargo_company > 0){
                $big_table['summary']['individual_percent_for_all_cargo'] = doubleval($all_cargo_individuals / ($all_cargo_individuals + $all_cargo_company)) * 100;
            }else{
                $big_table['summary']['individual_percent_for_all_cargo'] = 0;
            }
            $big_table['summary']['company_percent_for_all_cargo'] =   number_format(doubleval(100 - $big_table['summary']['individual_percent_for_all_cargo']), 1);

            $big_table['summary']['individual_percent_for_all_cargo'] = number_format($big_table['summary']['individual_percent_for_all_cargo'], 1);


            $big_table['summary']['all_discharge_weight'] = $all_discharge_weight / 1000;
            $big_table['summary']['all_loading_weight'] = $all_loading_weight / 1000;
        } else {
            $big_table['summary']['individual_percent_for_all_cargo'] = "قسمة على صفر ";
        }
        parent::response($big_table);
    }


    public function informCompaniesForUpcomingVessel()
        {

            if (strlen($this->_request->message) > 140) {

                throw new Exception("تخطيت طول الرسالة المسموح به");
            }
            $msg = $this->_request->message;
            $companys_ids = [];

            $tenderCompanyFilter = [
                ['key' => 'tender_id', 'val' => '3'],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in'],
            ];
            $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1000, 0, $_SESSION['user_id']);

            foreach ($tenderCompaniesReuslt->data as $value) {
                array_push($companys_ids, $value->company_id);
            }

            $searchFilter = [['key' => 'company_id', 'val' => $companys_ids, 'op' => 'in'],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']];
            $companyEmployee = $this->_companyEmployeeCore->searchCompanyEmployee($searchFilter, 100, 0, 0);

            $employees_user_ids = array_map(function ($ele) {return $ele->user_id;}, $companyEmployee->data);

            $phone_numbers = $this->_userCore->searchUser([
                ['key' => 'id', 'val' => $employees_user_ids, 'op' => 'in'],
            ], 500, 0, 0);

            $phone_numbers = array_map(function ($ele) {return $ele->phone;}, $phone_numbers->data);

            foreach ($phone_numbers as $value) {
                sendSMS($value, $msg);
            }
            parent::response("تمت العملية بنجاح");

        }
}


$cargo_interface = new Cargo_interface();
