<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . '/../outgoing_integration/poll.php');

class CargoCore
{

    private $_tenderCore;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_tenderCore = new TenderCore();
    }


    // -------------------------------------------------------------- //
    // --------------------- get info for a certian cargo ----------- //
    // -------------------------------------------------------------- //
    public function getCargo($id, $user_id)
    {

        $cargoInfo = DBConnection::getObjectBean("cargo", $id, $user_id);
        return $cargoInfo;
    }

    // -------------------------------------------------------------- //
    // --------------------- get info for a certian cargo ----------- //
    // -------------------------------------------------------------- //
    public function getCargoBasic($id, $user_id)
    {

        $cargoInfo = DBConnection::getBasicObjectBean("cargo", $id, $user_id);
        return $cargoInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchCargo($searchFilter, $limit, $offset, $user_id)
    {

        $searchCargoResult = DBConnection::searchDB("cargo", $searchFilter, $limit, $offset, $user_id, ' order by id desc ');
        return $searchCargoResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchCargoContainer($searchFilter, $limit, $offset, $user_id)
    {

        $searchCargoResult = DBConnection::searchDB("cargo_policy", $searchFilter, $limit, $offset, $user_id, ' order by id desc ');
        return $searchCargoResult;
    }

    // ------------------------------------------------------------------------ //
    // ------------------- create new cargopolicy  ----------- //
    // ------------------------------------------------------------------------ //
    public function createCargoPolicy($cargoPolicyBean, $user_id)
    {

        $createPolicyResult =  DBConnection::insertDB("cargo_policy", $cargoPolicyBean, $user_id);
        $cargo_policy_id =  $createPolicyResult[0]['@id'];

        return $cargo_policy_id;
    }

    // ------------------------------------------------------------------------ //
    // ------------------- create new policy  ----------- //
    // ------------------------------------------------------------------------ //
    public function createPolicy($policyBean, $user_id)
    {

        $createPolicyResult =  DBConnection::insertDB("policy", $policyBean, $user_id);
        $policy_ID =  $createPolicyResult[0]['@id'];

        return $policy_ID;
    }


    // ------------------------------------------------------------------------ //
    // ------------------- update current policy  ----------- //
    // ------------------------------------------------------------------------ //
    public function updatePolicy($policyBean, $updated_by)
    {
        $createPolicyResult =  DBConnection::updateDB("policy", $policyBean, $updated_by);
        return $createPolicyResult;
    }





    // ------------------------------------------------------------------------ //
    // -------------------change status of policy ------------------------------ //
    // ------------------------------------------------------------------------ //
    public function changePolicyStatus($policy_id, $new_status, $user_id)
    {

        $updateBean = new stdClass();
        $updateBean->id = $policy_id;
        $updateBean->status = $new_status;

        DBConnection::updateDB("policy", $updateBean, $user_id);
    }

    // ------------------------------------------------------------------------ //
    // -------------------change status of cargoPolicy ------------------------------ //
    // ------------------------------------------------------------------------ //
    public function changeCargoPolicyStatus($cargo_policy_id, $new_status, $user_id)
    {

        $updateBean = new stdClass();
        $updateBean->id = $cargo_policy_id;
        $updateBean->status = $new_status;

        DBConnection::updateDB("cargo_policy", $updateBean, $user_id);
    }
    // ------------------------------------------------- //
    // ------------------- Create New  Cargo ----------- //
    // ------------------------------------------------- //
    public function createCargo($cargoBean, $user_id)
    {

        //validate if the container is already exist on the system     
        if ($cargoBean->container) {
            $searchFilter = [
                ['key' => 'container', 'val' => $cargoBean->container],
                ['key' => 'status', 'val' => ['INACTIVE', 'CLOSED'], 'op' => "not in"]
            ];
            $searchCargoResult = $this->searchCargo($searchFilter, 1, 0, $user_id);
            if ($searchCargoResult->found_rows > 0) {
                //throw new Exception("الحاوية رقم $cargoBean->container مضافة مسبقا وما زالت فعالة");
                return null;
            }
        }

        //validate if the bean is correct
        if (!$cargoBean->tender_id) {
            throw new Exception("CARGO.INVALID_ARGUMENT_IN_BEAN");
        }

        // TODO: validate the waybill template is valid
        $waybill_template_json = json_decode($cargoBean->waybill_template);
        if ($waybill_template_json == null) {
            throw new Exception("CARGO.INVALID_WAYBILL_TEMPLATE");
        }

        // Create DB Record
        $createCargoResult = DBConnection::insertDB("cargo", $cargoBean, $user_id);
        $cargo_ID =  $createCargoResult[0]['@id'];

        return $cargo_ID;
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update cargo info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function updateCargo($cargoBean, $cargo_id, $updated_by)
    {

        // fill update struct and set the target user id
        $cargoBean->id = $cargo_id;

        // validate cargo financial
        $this->validateCargoForEdit($cargoBean);

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("cargo", $cargo_id, $updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if (compareObject($cargoBean, $DB_Bean) == false) {

            // TODO: validate the waybill template is valid
            $waybill_template_json = json_decode(json_encode($cargoBean->waybill_template));

            if ($waybill_template_json == null) {
                throw new Exception("CARGO.INVALID_WAYBILL_TEMPLATE");
            }

            // remove any data that munst not be updated
            unset($cargoBean->tender_id);
            unset($cargoBean->q_id);
            unset($cargoBean->container);
            unset($cargoBean->status);

            // fill update struct and set the target user id
            DBConnection::updateDB("cargo", $cargoBean, $updated_by);
        }
    }

    // ---------------------------------------------------------------------- //
    // --------------------- Validate Cargo financial info ------------------ //
    // ---------------------------------------------------------------------- //
    public function validateCargoForEdit($cargoBean)
    {

        // validate if the waybill_template is valid JSON
        try {
            $waybillTemplateJSON = json_decode($cargoBean->waybill_template);
            if ($waybillTemplateJSON == null) {
                throw new Exception("Illegal waybill_template! waybill_template must be a valid JSON document.");
            }
        } catch (Exception $e) {
            $waybillTemplateJSON = $cargoBean->waybill_template;
        }

        // validate if the freight->deductions is array of objects
        $deductions = $waybillTemplateJSON->negotiable_instructios->freight->deductions;
        if ($deductions && isArrayOfType($deductions, 'object') != true) {
            throw new Exception("Illegal waybill_template! waybill_template->deduction must be array of objects! ");
        }

        // validate each freight->deductions object contains target_account
        // if($deductions){
        //     foreach ($deductions as $deduction) {
        //         if(!isset($deduction->target_account)){
        //             throw new Exception("Illegal waybill_template! deduction must have target account! ");
        //         }
        //     }
        // }

        // validate if the freight->advance_payment is array of objects
        $advance_payment = $waybillTemplateJSON->negotiable_instructios->freight->advance_payment;
        if ($advance_payment && isArrayOfType($advance_payment, 'object') != true) {
            throw new Exception("Illegal waybill_template! waybill_template->advance_payment must be array of objects! ");
        }

        // validate each freight->deductions object contains target_account
        if ($advance_payment) {
            foreach ($advance_payment as $advPayment) {
                if (!isset($advPayment->target_account)) {
                    //throw new Exception("Illegal waybill_template! advance_payment must have target account! ");
                }
            }
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------change status of cargo ------------------------------ //
    // ------------------------------------------------------------------------ //
    public function changeStatus($cargo_id, $new_status, $user_id)
    {

        $updateBean = new stdClass();
        $updateBean->id = $cargo_id;
        $updateBean->status = $new_status;

        DBConnection::updateDB("cargo", $updateBean, $user_id);
    }
    // ---------------------------------------------------------------------------------- //
    // -------------------check if given cargo is Contianer ----------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function isContianer($cargo, $tenderManafist = null)
    {

        if ($tenderManafist) {
            return $tenderManafist->manifest->allowMultiTruckForCargo == FALSE;
        } else {
            $tender_id = $cargo->tender_id;
            $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
            return $tenderBean->manifest->allowMultiTruckForCargo == FALSE;
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------------ Activate Cargo wheather by ACT integeration or Manually------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function activateCargo($cargo, $tenderManafist = null, $user_id)
    {

        // to enhance performace, convert the id to object or use it as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, $user_id);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, $user_id);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // validate mandatory fields in case the cargo is Container
        if ($isContianer) {
            if (
                is_null($cargoBean->size) || is_null($cargoBean->type) ||
                is_null($cargoBean->ct_id) || is_null($cargoBean->location_id)
            ) {

                throw new Exception("CARGO.CANT_ACTIVATE_CARGO_MISSING_FIELDS");
            }

            //fill the origin in waybill template
            $waybill_template = $cargoBean->waybill_template;
            $waybill_template->negotiable_instructios->route->origin = $cargoBean->location_id;
            $cargoBean->waybill_template = json_encode($waybill_template, JSON_UNESCAPED_UNICODE);
            DBConnection::updateDB("cargo", $cargoBean, $user_id);
        }

        $this->changeStatus($cargoBean->id, 'ACTIVE', 0);
    }
    // ---------------------------------------------------------------------------------------------------- //
    // -------- change the status of the cargo when the system starts the cargo asssign process ----------- //
    // ---------------------------------------------------------------------------------------------------- //
    public function startCargoAssign($cargo, $tenderManafist = null)
    {

        // to enhance the performance, convert all ids to objects or use them as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, 0);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, 0);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // in case the cargo is "Container"
        if ($isContianer) {
            if ($cargoBean->status != 'PENDING') {
                // change cargo status to PENDING
                $this->changeStatus($cargoBean->id, 'PENDING', 0);
            }
        }

        // if cargo is not container do nothind
    }

    // ------------------------------------------------------------------------------------- //
    // -----------change cargo status when user accep the waybill order -------------------- //
    // ------------------------------------------------------------------------------------- //
    public function approveCargo($cargo, $tenderManafist = null)
    {

        // to enhance performace, convert the id to object or use it as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, 0);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, 0);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // if cargo is container based, just change the status
        if ($isContianer) {
            if ($cargoBean->status != 'APPROVED') {
                $this->changeStatus($cargoBean->id, 'APPROVED', 0);
            }
        }

        // if the cargo is "Cargo" do nothing
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------ When the truck arrive for visual inspection-------------------- //
    // ---------------------------------------------------------------------------------- //
    public function arrivedCargoTruck($cargo, $tenderManafist = null)
    {

        // to enhance performace, convert the id to object or use it as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, 0);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, 0);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // if cargo is container based, just change the status
        if ($isContianer) {
            if ($cargoBean->status != 'ARRIVED') {
                $this->changeStatus($cargoBean->id, 'ARRIVED', 0);
            }
        }

        // if the cargo is "Cargo" do nothing

    }

    // --------------------------------------------------------------------------- //
    // ---------------------- When cargo is loaded on a truck -------------------- //
    // --------------------------------------------------------------------------- //
    public function loadCargo($cargo, $tenderManafist = null)
    {

        // to enhance performace, convert the id to object or use it as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, 0);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, 0);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // if cargo is container based, just change the status
        if ($isContianer) {
            if ($cargoBean->status != 'ONROAD') {
                $this->changeStatus($cargoBean->id, 'ONROAD', 0);
            }
        }
        // if the cargo is "Cargo" do nothing
    }


    // ------------------------------------------------------------------------ //
    // ----------------- When cargo is discharged from a truck----------------- //
    // ------------------------------------------------------------------------ //
    public function dischargeCargo($cargo, $tenderManafist = null)
    {

        // to enhance performace, convert the id to object or use it as it is
        if (is_numeric($cargo)) {
            $cargoBean = $this->getCargoBasic($cargo, 0);
        } else {
            $cargoBean = $cargo;
        }
        if (!is_null($tenderManafist)) {
            $isContianer = $this->isContianer($cargo, $tenderManafist);
        } else {
            $tenderBean = $this->_tenderCore->getTenderBasic($cargoBean->tender_id, 0);
            $isContianer = $this->isContianer($cargo, $tenderBean);
        }

        // if cargo is container based, just change the status
        if ($isContianer) {
            if ($cargoBean->status != 'COMPLETE') {
                $this->changeStatus($cargoBean->id, 'COMPLETE', 0);
            }
        }
        // if the cargo is "Cargo" do nothing

    }

    // -------------------------------------------------------------------------------------------------------------- //
    // ------------- save the reserved weight in the cargo bean ----------------------------------------------------- //
    // ------------- $weight_value: loading or discharge weight ----------------------------------------------------- //
    // ------------- $weight_typeL load or discharge  --------------------------------------------------------------- //
    // ------------- $cargo_id  ------------------------------------------------------------------------------------- //
    // ------------- $old_weight_value: in case this is a re-weight, send the old weight in order to overwrite it --- //
    // -------------------------------------------------------------------------------------------------------------- //
    public function recordWeightInCargo($weight_value, $weight_type, $cargo_id, $old_weight_value = null)
    {

        $cargoCore = new CargoCore();
        $cargoObjectBean = $this->getCargoBasic($cargo_id, 0);

        if ($weight_type == 'loading') {
            // if this is the first weight in the cargo, init the weight to 0
            if (!$cargoObjectBean->weight_reserved) {
                $cargoObjectBean->weight_reserved = 0;
            }

            // in case this is first weight
            if (!$old_weight_value) {
                $cargoObjectBean->weight_reserved += $weight_value;
            }
            // in case this re-weight, delete the old weight and record the new one
            else {
                $cargoObjectBean->weight_reserved = ($cargoObjectBean->weight_reserved - abs($old_weight_value))
                    + abs($weight_value);
            }
        } else if ($weight_type == 'discharge') {
            // if this is the first weight in the cargo, init the weight to 0
            if (!$cargoObjectBean->weight_done) {
                $cargoObjectBean->weight_done = 0;
            }
            // in case this is first weight
            if (!$old_weight_value) {
                $cargoObjectBean->weight_done += $weight_value;
            }
            // in case this re-weight, delete the old weight and record the new one
            else {
                $cargoObjectBean->weight_done = ($cargoObjectBean->weight_done - abs($old_weight_value))
                    + abs($weight_value);
            }
        }

        // update the cargo
        $this->updateCargo($cargoObjectBean, $cargoObjectBean->id, 0);
    }

    public function fetchContainers($searchFilter, $limit, $offset, $user_id)
    {
        //        return DBConnection::searchDB("cargo",$searchFilter, $limit, $offset,$user_id , null);
        $sqlQuery = "select * from cargo where container is not null";
        $param = [];
        return DBConnection::runBindDatabaseQuery($sqlQuery, $param);
    }

    public function searchByName($searchFilter, $user_id)
    {
        $name = $searchFilter->name;
        $query = "select * from cargo where name like '%" . $name . "%'";
        $param = [];
        return DBConnection::runBindDatabaseQuery($query, $param);
    }

    // --------------------------------------------------------------------- //
    // -------------------- Log activity to policy ------------------------- //
    // --------------------------------------------------------------------- //
    public function logPolicyActivity($policy_id, $action_code, $details, $u_id,  $user_id)
    {
        // init
        $policyCore = new Policy_Core();

        // generate activity node
        $activity = $this->generatePolicyActivity($action_code, $u_id, $details);

        // get the policy details
        $policyBean = $policyCore->getPolicy($policy_id, $user_id);

        if (!$policyBean->details->activity) {
            $policyBean->details->activity = [];
        }

        // update activity
        $policyBean->details->activity[] = $activity;
        $this->updatePolicy($policyBean,  $user_id);
    }

    // --------------------------------------------------------------------------------------------- //
    // -------------------- Generate Policy and policy cargo activity node ------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function generatePolicyActivity($action_code, $u_id, $details)
    {
        switch ($action_code) {
            case 'create':
                $activity = [
                    "action" => 'create',
                    "title" => "إنشاء بيان جمركي",
                    "details" => $details,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "done_by" =>  $u_id
                ];
                break;

            case 'create_cargo_policy':
                $activity = [
                    "action" => 'create_cargo_policy',
                    "title" => "اضافة حاوية",
                    "details" => $details,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "done_by" =>  $u_id
                ];
                break;

            case 'delete_cargo_policy':
                $activity = [
                    "action" => 'delete_cargo_policy',
                    "title" => "حذف حاوية",
                    "details" => $details,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "done_by" =>  $u_id
                ];
                break;

            default:
                # code...
                break;
        }


        return $activity;
    }

    // search vissle name distinct
    public function searchVessle($searchFilter, $limit, $offset, $user_id)
    {
        $vissle = DBConnection::searchDB('cargo', $searchFilter, $limit, $offset, $user_id, 'order by id desc');
        return $vissle;
    }



    public function makePullForDischargeReport($mainQuestion, $cargoBean , $callback)
    {

        $poll = new Poll();

        $questions = [
            [
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "نعم",
                        "next_question" => 1
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 0,
                "question_type" => "single",
                "question_lable" => $mainQuestion,
                "question_attachment_url" => ""
            ],
            [
                "layout" => "CARD",
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "متابعة",
                        "next_question" => 2
                    ]
                ],
                "doc_type" => "delivering_cargo_signature",
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 1,
                "question_type" => "file",
                "question_lable" => "الرجاء تصوير توقيع استلام البضاعة من المالك",
                "question_attachment_url" => null
            ],
            [
                "layout" => "CARD",
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "متابعة",
                        "next_question" => 3
                    ]
                ],
                "doc_type" => "delivering_cargo",
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 2,
                "question_type" => "file",
                "question_lable" => "تصوير البضاعة",
                "question_attachment_url" => null
            ],
            [
                "answers" => [
                    [
                        "value" => "",
                        "caption" => "تأكيد",
                        "next_question" => 4
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 3,
                "question_type" => "FREE_TEXT",
                "question_lable" => "ملاحظات",
                "question_attachment_url" => null
            ],
            [
                "answers" => [
                    [
                        "value" => 0,
                        "caption" => "إرسال تقرير التسليم",
                        "next_question" => null
                    ]
                ],
                "validation" => [
                    "method" => "none"
                ],
                "question_id" => 4,
                "question_type" => "single",
                "question_lable" => "أقر بتسليم البضاعة حسب ما تم الإتفاق عليه وأتحمل كامل المسؤولية عن ذلك",
                "question_attachment_url" => null
            ]
        ];

        // system is default recipient
        $rec = [];
        $rec['bind_params'] = [];
        $rec['user_id'] = 0;
        $rec['communication_channels'] = [];

        $poll_1 = [];
        $poll_1['details'] = [];
        $poll_1['details']['questions'] =  $questions;
        $poll_1['title'] = " تقرير تسليم بضاعة $cargoBean->name";
        $poll_1['details']['attributes'] = [];
        $poll_1['details']['attributes']['title'] = " تقرير تسليم بضاعة $cargoBean->name";
        $poll_1['details']['attributes']['priority'] = 5;
        $poll_1['details']['attributes']['is_dismissible'] = true;
        $poll_1['details']['attributes']['scenario'] = "normalScenario";
        $poll_1['details']['attributes']['expiry_date'] = date('Y-m-d h:i:s', strtotime(DBConnection::getSystemDate() . "+1 year"));
        $poll_1['details']['attributes']['can_change_answer'] = false;
        $poll_1['details']['attributes']['max_retries'] = "1";
        $poll_1['details']['attributes']['description'] = "تقييم البضاعة المستلمة ";
        $poll_1['details']['attributes']['callback'] = [
            "url" => "hhtps://api.minagate.com",
            'data' => ['method' => $callback],
            "type" => "answer",
        ];
        $poll_1['details']['attributes']['sub_type'] = "feedback";
        $poll_1['recipients'] = [$rec];

        $poll_id =  $poll->createPoll($poll_1);

        return $poll_id;
    }
}
