<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/assign_cargo_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");


class Assign_cargo_interface extends API{

    private $_assignCargoCore;

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_assignCargoCore = new AssignCargoCore();
        $this->_tenderCore = new TenderCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter 
    private function prepareFilter(){
        $assignFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {                
                    $tempArr = ['key'=>$key,'val' => $value,'op'=>'like'];
                array_push($assignFilter,$tempArr);
            }
        }
        return $assignFilter;
    }


    // ------------------------------------------------------------------------------ //
    // --------------- change status of a certain assign cargo ---------------------- //
    // ------------------------------------------------------------------------------ //
    public function changeStatus(){

        // get params
        $assign_cargo_id = $this->_request->id;
        $new_status = $this->_request->new_status;
 
        if($new_status == "CLOSED"){

            try {
                //code...
            
                DBConnection::startTransaction();

                    // get assign order bean to extract orders
                    $assignCargoBean = $this->_assignCargoCore->getAssignCargoBasic($assign_cargo_id , $_SESSION['user_id']);
                    $orders = $assignCargoBean->details->orders;
                    $tender_id = $assignCargoBean->details->info->tender_id;
                    $queue_id = $assignCargoBean->details->info->queue_id;
                    
                    $tender_order_ids = [];
                    foreach ($orders as $O) {
                        $tender_order_ids[] = $O->id;
                    }

                    // change status of assign_cargo to complete
                    $this->_assignCargoCore->changeStatus($assign_cargo_id , 'CLOSED' , 0);
                    $assignCargoBean = $this->_assignCargoCore->getAssignCargoBasic($assign_cargo_id , $_SESSION['user_id']);
                    if($assignCargoBean->status != 'CLOSED'){
                        $this->_assignCargoCore->changeStatus($assignCargoBean->id , 'CLOSED' , 0);
                    }

                    // call the indivisual distribute
                    $serveTenderResult = $this->_tenderCore->distribute($tender_id,$queue_id,$_SESSION['user_id'],$tender_order_ids);

                    $queue_assign = $this->_assignCargoCore->generateAssignQueueNode($serveTenderResult);
                    $assignCargoBean->queue_assign = $queue_assign;
                    $this->_assignCargoCore->updateAssignCargo($assignCargoBean, $assign_cargo_id, 0);

                DBConnection::commitTransaction();

                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "TENDER.SUCCESS_OPERATION";
                $Result['serveTenderResult'] = $serveTenderResult;
                parent::response($Result,200);


                } catch (Exception $e) {
                    DBConnection::rollBackTransaction();
                    throw new Exception($e->getMessage());
                }
        }
        if($new_status == "PENDING"){
            $this->_assignCargoCore->changeStatus($assign_cargo_id , $new_status , 0);

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER.SUCCESS_OPERATION";
            $Result['serveTenderResult'] = $serveTenderResult;
            parent::response($Result,200);

        }else{
            throw new Exception("unsupported operation");
        }
       

    }

    // --------------------------------------------------------------------------------- //
    // ------------------------- Search for assign cargo ------------------------------- //
    // --------------------------------------------------------------------------------- //
    public function searchAssignCargo(){
       
        $assignFilter = $this->prepareFilter();

        $assignResult = $this->_assignCargoCore->searchAssignCargo($assignFilter,
                                                                    $this->_request->limit,
                                                                    $this->_request->offset,
                                                                    $_SESSION['user_id'],
                                                                    ' order by id desc '
                                                                  );
       
        foreach ($assignResult->data  as &$assignCargo) {
            $assignCargo->details = json_decode($assignCargo->details);
            $assignCargo->company_assign = json_decode($assignCargo->company_assign);
            $assignCargo->queue_assign = json_decode($assignCargo->queue_assign);
            $assignCargo->list_of_waybills = json_decode($assignCargo->list_of_waybills);
        }
 
        parent::response($assignResult);
    }
     

    // --------------------------------------------------------------------------------- //
    // ------------------------- get certain assign cargo ------------------------------- //
    // --------------------------------------------------------------------------------- //
    public function getAssignCargo(){
        $id = $this->_request->id;

        $assignCargoBean = $this->_assignCargoCore->getAssignCargo($this->_request->id,$_SESSION['user_id']);
        $assignCargoBean = json_decode($assignCargoBean);
        parent::response($assignCargoBean);

    }

    




}

new Assign_cargo_interface();